@extends('layouts.app') 

@section('title') Add Token Receipt @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Add Receipt</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <form method="POST" action="{{route('insert.token.receipt')}}" class="form-horizontal"  id=""> 
        {{csrf_field()}}
        <div class="row">
            <div class="col-lg-12 col-sm-12 col-xs-12"> 
                @if($errors->any())
                <div class="white-box">
                    <h2>Errors</h2>
                    <ul> {!! implode('', $errors->all('
                        <li><span class="help-block"><strong>:message</strong></span></li>')) !!} 
                    </ul>
                </div>
                @endif
                <div class="white-box1">
                    <h3 class="box-title">Payment Information</h3>
                    <hr>
                    
                    <input type="hidden" name="is_approved" value="0">
        
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-4">Select Unit <span style="color: red">*</span></label>
                            <div class="col-md-8">
                                <select id="unit_id" name='unit_id' class="form-control chosen-select" onchange="updateProperty(this.value)">
                                <option  value="0">None</option>
                                    @foreach($unitNumbers as $p)
                                    @if(old('unit_id') == $p ? $p->id:'')
                                    <option selected="" value="{{$p->inventory->id}}">{{$p->unit_number}}</option>
                                    @else
                                    <option value="{{$p->id}}">{{$p->unit_number}}</option>
                                    @endif
                                    @endforeach
                               </select> 

                                @if ($errors->has('unit_id')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('unit_id') }}</strong>
                                </span> 
                                @endif

                            </div>
                        </div>
                    </div>
                    <div class="clearfix"></div>

                    <div class="col-md-12" id='property'> </div>
                    <div class="clearfix"></div>

                    <div class="col-md-6" id='cheque' style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4">Cheque Number</label>
                            <div class="col-md-8">
                                
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix"></div>
                    
                    <div class="col-md-6">        
                        <div class="form-group">
                            <label class="control-label col-md-4">Payment Head <span style="color: red">*</span></label>
                            <div class="col-md-8">
                                <select class="form-control chosen-select" name="payment_head" id="payment_head" onchange="getAmount(this)" > 

                                   
                                    <option selected="" value="{{\App\Receipt::token_amount}}">Token Amount</option>
                                  


                                </select> 
                                
                                @if ($errors->has('payment_head')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('payment_head') }}</strong>
                                </span> 
                                @endif 

                            </div>
                        </div>
                        </div>
                     
                      <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">   
                            <span id="payment_head_label">Token Amount</span>
                            </label>
                                   <div class="col-md-8">
                                        <input readonly type="text" value="" name='token_amount' id="token_amount" class="form-control" > 
                                    </div>
                            </div>
                        </div>
                    
                  

                            <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount Received</label>
                                <div class="col-md-8">
                                   <select class="form-control select2" name="tax_payment_received" id="tax_option">
                                       <option value="0"> NO</option>
                                   </select>

                                </div>
                            </div>
                            </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-4">Payment Method <span style="color: red">*</span></label>
                            <div class="col-md-8">
                                <select class="form-control chosen-select" id="payment_method" name='payment_method' onchange="changeFunc(this.value)" >

                                    @if(old('payment_method') == \App\Receipt::cash)
                                    <option selected value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::bank)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option selected value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::cheque)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option selected value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::adjustment)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option selected value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @else
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>
                                    @endif

                                </select> 
                                @if ($errors->has('payment_method')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('payment_method') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id='bank' style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4">Depositor Bank Name <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <select name="bank_name" class="form-control chosen-select">
                                    <option value="" selected="">None</option> 

                                    @foreach($banks as $bank) 

                                    @if(old('bank_name') == $bank->id)
                                    <option selected="" value="{{$bank->id}}">{{$bank->name}}</option> @else
                                    <option value="{{$bank->id}}">{{$bank->name}}</option> 
                                    @endif 

                                    @endforeach 
                                </select> 

                                @if ($errors->has('bank_name')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('bank_name') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id='company-bank' style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4">Company Account <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <select name="company_account" class="form-control chosen-select">
                                    <option value="" selected="">None</option> 
                                    
                                    @foreach($cBanks as $bank) 
                                    
                                    @if(old('company_account') == $bank->id)
                                    <option selected="" value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                    @else
                                    <option value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                    @endif 
                                    @endforeach 

                                </select> 

                                @if ($errors->has('company_account')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('company_account') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>
                        
                    <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4"> Drawn Date <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <input type="date" class="form-control" name='drawn_date' value="" id="exampleInputEmail1" placeholder="Enter Receipt Date" > 
                                @if ($errors->has('drawn_date')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('drawn_date') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                        <div class="form-group">
                            <label class="control-label col-md-4"> Instrument No <span style="color:red;">*</span></label>
                            <div class="col-md-8">
                                <input type="text" name='cheque_number' value="" class="form-control" id="exampleInputEmail1" placeholder="Enter Instrument Number"> 
                                @if ($errors->has('cheque_number')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('cheque_number') }}</strong>
                                </span> 
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div id='adjustment' style="display: none;">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Adjustment Type <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" onchange="checkAdjustmentType(this)" name='adjustment_type' id='adjustment_type'> 

                                        @if(old('adjustment_type') == \App\Receipt::property)
                                        <option value="{{\App\Receipt::property}}" selected="">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}">Rebate</option>
                                         <option value="{{\App\Receipt::vendor}}">Vendor</option>
                                        <option value="{{\App\Receipt::others}}">Other</option> 

                                        @elseif(old('adjustment_type') == \App\Receipt::vehicle)
                                        <option value="{{\App\Receipt::property}}">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}" selected="">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}">Rebate</option>
                                         <option value="{{\App\Receipt::vendor}}">Vendor</option>
                                        <option value="{{\App\Receipt::others}}">Others</option> 

                                        @elseif(old('adjustment_type') == \App\Receipt::rebate)
                                        <option value="{{\App\Receipt::property}}">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}" selected="">Rebate</option>
                                         <option value="{{\App\Receipt::vendor}}">Vendor</option>
                                        <option value="{{\App\Receipt::others}}">Others</option>

                                        @elseif(old('adjustment_type') == \App\Receipt::vendor)
                                        <option value="{{\App\Receipt::property}}">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}" >Rebate</option>
                                         <option value="{{\App\Receipt::vendor}}" selected="">Vendor</option>
                                        <option value="{{\App\Receipt::others}}">Others</option> 

                                        @elseif(old('adjustment_type') == \App\Receipt::others)
                                        <option value="{{\App\Receipt::property}}">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}">Rebate</option>
                                        <option value="{{\App\Receipt::vendor}}">Vendor</option>
                                        <option value="{{\App\Receipt::others}}" selected="">Others</option> 

                                        @else
                                        <option selected='' value="{{\App\Receipt::property}}" selected="">Property</option>
                                        <option value="{{\App\Receipt::vehicle}}">Vehicle</option>
                                        <option value="{{\App\Receipt::rebate}}">Rebate</option>
                                        <option value="{{\App\Receipt::vendor}}">Vendor</option>
                                        <option value="{{\App\Receipt::others}}">Others</option> 
                                        @endif 
                                    </select> 

                                    @if ($errors->has('adjustment_type')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('adjustment_type') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>


                         <div class="col-md-6" style="display:none;" id="procuremnt_bills">
                            <div class="form-group">
                                <label class="control-label col-md-4"> Vendor Pending Bill </label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" name="vendor_purchase_order_id" id="vendor_purchase_order_id" onchange="return getPoPayment(this)">
                                        <option value="">None</option> 
                                        @foreach($vendor_pos as $b)
                                        <optgroup label="Vendor Purchase Orders"> 
                                            @foreach($b->receipts as $list )
                                            <option value="{{$list->purchase_order_id}}">PO-{{ucfirst($list->purchase_order_id)}}</option> 
                                            @endforeach 
                                        </optgroup> 
                                        @endforeach 
                                    </select>
                                    @if ($errors->has('vendor_purchase_order_id')) <span class="help-block">
                                        <strong>{{ $errors->first('vendor_purchase_order_id') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Adjustment Detail <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <textarea name="adjustment_detail" class="form-control"></textarea> @if ($errors->has('adjustment_detail')) <span class="help-block">
                                        <strong>{{ $errors->first('adjustment_detail') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"  style="display:none;" id="dealers_rebarts" > 
                            <div class="form-group">
                                <label class="control-label col-md-4"> Dealer Payable Rebates </label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" name="dealer_adjustment_unit_id">
                                        <option value="">None</option> 
                                        @foreach($dealersRecord as $d)
                                        <optgroup label="{{$d['info']->name}}"> 
                                            @foreach($d['rebate'] as $key => $val)
                                            <option value="{{$key}}">{{$val}}</option> 
                                            @endforeach 
                                        </optgroup> 
                                        @endforeach 
                                    </select>
                                    @if ($errors->has('dealer_adjustment_unit_id')) <span class="help-block">
                                        <strong>{{ $errors->first('dealer_adjustment_unit_id') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="clearfix"></div>
                    <hr>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-4">Receipt Number <span style="color: red">*</span></label>
                            <div class="col-md-8"> 
                               
                                <input type="text" class="form-control" name='receipt_no' value="{{rand('00000' , '999999')}}" id="exampleInputEmail1" placeholder="Enter Receipt Number"> 
                               
                                @if ($errors->has('receipt_no')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('receipt_no') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-4">Receipt Date <span style="color: red">*</span></label>
                            <div class="col-md-8">
                                <input type="date" class="form-control" name='receipt_date' value="{{old('receipt_date')}}" id="exampleInputEmail1" placeholder="Enter Receipt Date"> 
                                @if ($errors->has('receipt_date')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('receipt_date') }}</strong>
                                </span> 
                                @endif 
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-4">Notes</label>
                            <div class="col-md-8">
                                <textarea class="form-control" name="notes"></textarea> @if ($errors->has('notes')) <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span> @endif </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <input type="checkbox" name="notify_sms" value="1"> Sms Notification
                        <br>
                        <input type="checkbox" name="notify_email" value="1"> Email Notification </div>
                    <div class="col-md-4">
                        <div class="form-group m-b-0 pull-right">
                            <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@stop

@section('js')
<script>

function getAmount(self) 
{
     $('#token_amount').val($('input[name=unit_id]:checked').data("amount"));
}

function validateAmount(argument) 
{

    if ( $('#adjustment_type').val() == '{{\App\Receipt::vendor}}' ) 
    {
        var data_1 = {'vendor_purchase_order_id':$('#vendor_purchase_order_id').val() , 'entered_amount':$('#amount').val() };

        $.get('/validate/purchase-order/amount', data_1, function (data_2) 
        {
            if (data_2.response == 'invalid') 
            {
                $('#invalid_amount').html('<strong>Invalid Amount!</strong> <span>valid amount of '+data_2.amount+'</span>');
                $('#invalid_amount').show()
                return false;
            }
            else
            {
                $('#invalid_amount').html('');
                $('#invalid_amount').hide()
                $('#receipt_form').submit()
            }

        }, 'json');

    }
    else
    {
         $('#receipt_form').submit()
    }
  
return false;
}
function getPoPayment(self) 
{

var po = $(self).val();

var data = {'purchase_order':po };

$.get('/purchase-order/payment', data, function (data) 
{

  $('#amount').val(data.response);
}, 'json');

    return false;
}


function checkAdjustmentType(self) 
{
   
   if ($(self).val() == '{{\App\Receipt::rebate}}')
    {
        $('#dealers_rebarts').show()
        $('#procuremnt_bills').hide()
    }
    else if($(self).val() == '{{\App\Receipt::vendor}}')
    {
         $('#dealers_rebarts').hide()
        $('#procuremnt_bills').show()
    }
    else
    {
        $('#dealers_rebarts').hide()
        $('#procuremnt_bills').hide()
    }
}


function changeTaxOption(self) 
{
    if ($(self).val() == "{{\App\Receipt::company}}") 
    {
        $('#tax_option').html('<option value="1"> YES</option>');
    }
    else if ($(self).val() == "{{\App\Receipt::customer}}") 
    {
        $('#tax_option').html('<option value="0"> NO</option>');
    }
    else
    {
        $('#tax_option').html('<option value="1"> YES</option><option value="0"> NO</option>');
    }
}

function toWords(self){
var total_amount = inWords($(self).val()) 
$('#total_amount').text(total_amount)

let property_id = $('input[name=customer_property_id]:checked').val();
let unit_id = $('input[name=unit_id]:checked').val();

let entered_amount = $(self).val();
let payment_head = $('#payment_head').val();

var data = {'property_id':property_id , 'entered_amount':entered_amount , 'payment_head':payment_head};

$.get('/validate/receipt/amount', data, function (data) {

   if (data.response == '1') 
   {
        $('#invalid_amount').html('Invalid Amount!');
        $('#invalid_amount').show()

        $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(data.remaining)
        $('#saveBtn').prop('disabled' , true)
   }
   else
   {
        $('#invalid_amount').html('');
        $('#invalid_amount').hide()
         $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(data.remaining)
        $('#saveBtn').prop('disabled' , false)
   }

}, 'json');

}


var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];

function inWords (num) 
{
   
    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
  return 'Rupees '+str+' Only';
}



  function changeFunc(a){
    if(a == {{\App\Receipt::cash}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'none');
      $('#cheque-dd-po-drawn-date').css('display', 'none');
      $('#cheque-dd-po-instrument-no').css('display', 'none');
    }
    else if(a == {{\App\Receipt::bank}})
    {
      $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
    }
    else if(a == {{\App\Receipt::cheque}})
    {
        $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#cheque').css('display', 'none');
        $('#adjustment').css('display', 'none');
        $('#cheque-dd-po-drawn-date').css('display', 'block');
        $('#cheque-dd-po-instrument-no').css('display', 'block');
      
    }
    else if(a == {{\App\Receipt::adjustment}})
    {
      $('#bank').css('display', 'none');
      $('#company-bank').css('display', 'none');
      $('#cheque').css('display', 'none');
      $('#adjustment').css('display', 'block');
      $('#cheque-dd-po-drawn-date').css('display', 'none');
      $('#cheque-dd-po-instrument-no').css('display', 'none');
    }
  }

function updateProperty(){
    
    $('.preloader').fadeIn();

    var unit_id = $('#unit_id').val();

    var data = {'unit_id':unit_id};

    $.get('/add/token/receipt/update-properties', data, function (data) {

        document.getElementById('property').innerHTML = data;
        
        $('#myTable').DataTable({
            "paging":   false,
            "ordering": false,
            "info":     false
        });
    });

    //  $('#wait').hide();
    $('.preloader').fadeOut();

}


function changeTotalRemaining() 
{

      amount = parseInt($('#amount').val());

  if(amount){
  property = $('input[name="customer_property_id"]:checked').val();

  id = "#rem" + property;

  remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount - amount);


  isFiler = parseInt($('#is_filer').val());

  if(isFiler == 1)
    $('#tax_amount').val(amount * 0.01);
else
    $('#tax_amount').val(amount * 0.02);

  }
  else {
      property = $('input[name="customer_property_id"]:checked').val();

      id = "#rem" + property;
      remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount);
  }

}

$('#amount').keyup(function(){

  amount = parseInt($('#amount').val());

  if(amount){
  property = $('input[name="customer_property_id"]:checked').val();

  id = "#rem" + property;

  remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount - amount);


  isFiler = parseInt($('#is_filer').val());

  if(isFiler == 1)
    $('#tax_amount').val(amount * 0.01);
else
    $('#tax_amount').val(amount * 0.02);

  }
  else {
      property = $('input[name="customer_property_id"]:checked').val();

      id = "#rem" + property;
      remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount);
  }



});

</script>

@stop

@if($errors->any())

<script>
    window.onload = function () { 

        updateProperty('{{old("unit_id")}}');

        var payment_method = $('#payment_method').val();
        changeFunc(payment_method)
    }
    
</script>
@endif