@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
 .span-border {
        display: inline-block; 
        padding: 0px 20px; 
        text-align:center; 
        border-bottom: 1px solid black;
    }
 .payment{
     
     color:#282f32;
 }    
    
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Token Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
        <div class="row no-print">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">

                        <div class="row">
                            <div class="col-sm-6" style="margin-top: 1rem;">
                                  <span> Token Receipt Information</span>
                            </div>

                            <div class="col-sm-6">
                                <form class="d-flex" style="padding-left: 15rem;" method="post" onsubmit="return upload_receipt_docs(this , '{{$tokenreceipt->id}}')">
                                    <div class="row">
                                        <div class="col-sm-8">
                                            <span id="error_message" style="color: red;display: none;"></span>

                                             <span id="success_message" style="color: green;display: none;"></span>

                                            <label>Upload Multiple docx <small>(image, pdf, word)</small></label>
                                            <input name="files[]" id="files" class="form-control me-2" multiple type="file"  aria-label="Search">
                                        </div>

                                        <div class="col-sm-4" style="margin-top: 3.5rem;">
                                            <button id="upload_btn" class="btn btn-outline-success" type="submit">Upload</button>
                                        </div>
                                    </div> 
                                    
                                    
                                </form>
                            </div>
                        </div>
                         
                    </h3>
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Receipt #</td>
                                    <td>{{$tokenreceipt->receipt_number}}</td>
                                </tr>
                                <tr>
                                    <td>Date</td>
                                    <td>{{date('d-m-Y',strtotime($tokenreceipt->receipt_date))}}</td>
                                </tr>
                               
                                <tr>
                                    <td>Unit No.</td>
                                    <td> {{$tokenreceipt->inventory ? $tokenreceipt->inventory->unit_number : ''}} </td>
                                </tr>
                                <tr>
                                    <td>Payment Head</td>
                                    <td>
                                        
                                        @if($tokenreceipt->payment_head == 9) 
                                        Token Amount
                                        @endif
                                      
                                    </td>
                                </tr>
                                <tr>
                                    <td>Payment Mode</td> 

                                    <td>
                                        @if($tokenreceipt->payment_method == \App\Receipt::cash) Cash 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::bank) Bank 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 

                                        @else 
                                        Adjustment 

                                        @endif 
                                    </td>
                                </tr>

                                 @if($tokenreceipt->instrument_no)
                                <tr>
                                    <td>Instrument No.</td>
                                    <td> {{$tokenreceipt->instrument_no}} </td>
                                </tr>
                                @endif
                                

                              
                                <tr>
                                   
                                </tr>

                              


                                <tr>
                                <td>Token Amount</td>
                                <td>{{number_format($tokenreceipt->token_amount)}}</td>
                                </tr>
                                @if($tokenreceipt->drawn_date)
                                <tr>
                                <td>Drawn Date</td>
                                <td>
                                
                                {{date('d-m-Y',strtotime($tokenreceipt->drawn_date))}}
                                </td>
                                </tr>
                                @endif

                                              

                                              
                                </tr>
                                 @if( $tokenreceipt->notes)                   
                                <tr>
                                    <td>Notes</td>
                                    <td>{{$tokenreceipt->notes}}</td>
                                </tr> 
                                @endif

                           

                            </tbody>
                        
                        </table> 

                        
                       

                       
                    

                    </div>
            
                </div>
            
            </div>
        </div>
                
        <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Office Copy</span> 
                    </div>
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-3 col-sm-3" style="float: right;"> 
                                <span class="pull-left">REF.NO.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;&nbsp;</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$tokenreceipt->receipt_number}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($tokenreceipt->receipt_date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Unit No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$tokenreceipt->inventory ? $tokenreceipt->inventory->unit_number : ''}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Head</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> 
                                   @if($tokenreceipt->payment_head == 9) 
                                        Token Amount
                                        @endif
                                  </span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">
                                       @if($tokenreceipt->payment_method == \App\Receipt::cash) Cash 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::bank) Bank 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 

                                        @else 
                                        Adjustment 

                                        @endif 
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Token Amount PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 45rem;">{{number_format($tokenreceipt->token_amount)}}</span>
                                  
                                </div>
                            </div>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Amount in words (PKR)</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 35rem;" class="AoumtInWords">&nbsp;</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                           
                            <div class="clearfix" style="margin-bottom: 50px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                            
                  
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

 <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Accounts Copy</span> 
                    </div>
                            
                     <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                           <div class="col-xs-3 col-sm-3" style="float: right;"> 
                                <span class="pull-left">REF.NO.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;&nbsp;</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$tokenreceipt->receipt_number}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($tokenreceipt->receipt_date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Unit No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$tokenreceipt->inventory ? $tokenreceipt->inventory->unit_number : ''}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Head</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> 
                                   @if($tokenreceipt->payment_head == 9) 
                                        Token Amount
                                        @endif
                                  </span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">
                                       @if($tokenreceipt->payment_method == \App\Receipt::cash) Cash 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::bank) Bank 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 

                                        @else 
                                        Adjustment 

                                        @endif 
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Token Amount PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 50rem;">{{number_format($tokenreceipt->token_amount)}}</span>
                                  
                                </div>
                            </div>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Amount in words (PKR)</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 35rem;" class="AoumtInWords">&nbsp;</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                           
                            <div class="clearfix" style="margin-bottom: 50px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

 <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Client Copy</span> 
                    </div>
                            
                     <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-3 col-sm-3" style="float: right;"> 
                                <span class="pull-left">REF.NO.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">&nbsp;&nbsp;</span>
                                  
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-3"> 
                                <span class="pull-left">Receipt No.</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left:5rem;">{{$tokenreceipt->receipt_number}}</span>
                                  
                                </div>
                            </div>
                          
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4" style="float: right;">
                               
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    {{date('d-m-Y',strtotime($tokenreceipt->receipt_date))}}
                                </div>
                            </div>

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Unit No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 20rem;">{{$tokenreceipt->inventory ? $tokenreceipt->inventory->unit_number : ''}}</span>
                                    
                                </div>
                            </div>


                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Head</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 30rem;"> 
                                   @if($tokenreceipt->payment_head == 9) 
                                        Token Amount
                                        @endif
                                  </span>
                                    
                                </div>
                            </div>
                            
                            
                          
                             <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Payment Method:&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 40rem;">
                                       @if($tokenreceipt->payment_method == \App\Receipt::cash) Cash 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::bank) Bank 

                                        @elseif($tokenreceipt->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 

                                        @else 
                                        Adjustment 

                                        @endif 
                                   </span>
                                </div>
                            </div>

                            

                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Token Amount PKR</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 50rem;">{{number_format($tokenreceipt->token_amount)}}</span>
                                  
                                </div>
                            </div>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                        
                            <div class="col-xs-12 col-sm-12"> 
                                <span class="pull-left">Amount in words (PKR)</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                   <span style="margin-left: 35rem;" class="AoumtInWords">&nbsp;</span>
                                  
                                </div>
                            </div>
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                           
                            <div class="clearfix" style="margin-bottom: 50px"></div>
                            
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>

                           <div class="col-sm-4 col-xs-4" style="text-align:center;"> 
                                <b style="border-top: 1px solid;">Accountant</b> 
                            </div>

                            <div class="col-sm-4 col-xs-4" style="text-align:right;"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>

<script type="text/javascript">

$( document ).ready(function() {

    var inWordAmount =  inWords('{{round($tokenreceipt->token_amount)}}')
    $('.AoumtInWords').html(inWordAmount)
    });

var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];
function inWords (num) {
   
    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
  return ' '+str+'Rupees Only';
}

</script>



@stop