@extends('layouts.app')

@section('title')
All Receipts 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
.popover.top {
    margin-top: 3rem;
}
</style>

@stop

@section('content')


            <div class="container-fluid">

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Receipt</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                
                                              

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Receipt No</label>
                                                        <select id="receipt_no" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                            
                                                        @foreach($receiptNo as $r)
                                                        <option value="{{$r->id}}">{{$r->receipt_number}}</option>
                                                        @endforeach
                                                        
                                                        </select> </div>
                                                </div>
                                                <!--/span-->

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Payment Mode</label>
                                                        <select id="payment_mode" class="form-control chosen-select">

                                                            <option value="all">All</option>
                                                        @if(old('payment_method') == \App\Receipt::cash)
                                    <option selected value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::bank)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option selected value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::cheque)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option selected value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @elseif(old('payment_method') == \App\Receipt::adjustment)
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option selected value="{{\App\Receipt::adjustment}}">Adjustment</option>

                                    @else
                                    <option value="{{\App\Receipt::cash}}">Cash</option>
                                    <option value="{{\App\Receipt::bank}}">Bank Transfer (IBFT)</option>
                                    <option value="{{\App\Receipt::cheque}}">Cheque/ DD/ PO</option>
                                    <option value="{{\App\Receipt::adjustment}}">Adjustment</option>
                                    @endif
                                                        </select> 
                                                    </div>
                                                </div>
                                                <!--/span-->

                                              

                                                <div class="col-md-3">
                                                    <div class="form-actions" style="margin-top: 26px">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>
                                            
                                        </div>
                                                </div>
                                            </div>
                                            
                                            
                                        </div>
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->

                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                            
                            <h3 class="box-title">All Receipts ({{number_format($totalAmount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Unit No. </th>
                                            <th>Payment Mode</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @permission('print-receipt')
                                            <?php $print_receipt = true;?>
                                        @else
                                            <?php $print_receipt = false;?>
                                        @endpermission

                                        @permission('view-receipt')
                                            <?php $view_receipt = true;?>
                                        @else
                                            <?php $view_receipt = false;?>
                                        @endpermission

                                        @permission('edit-receipt')
                                            <?php $edit_receipt = true;?>
                                        @else
                                            <?php $edit_receipt = false;?>
                                        @endpermission

                                        @permission('download-receipt')
                                            <?php $download_receipt = true;?>
                                        @else
                                            <?php $download_receipt = false;?>
                                        @endpermission

                                        @permission('delete-receipt')
                                            <?php $delete_receipt = true;?>
                                        @else
                                            <?php $delete_receipt = false;?>
                                        @endpermission

                                        @foreach($receipts as $receipt)
                                        <tr>
                                           <td>{{$receipt->receipt_number}}</td>
                                           
                                           <td>{{$receipt ? $receipt->inventory ? $receipt->inventory->unit_number : '' : ''}}</td>
                                             



                                             @if($receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                            @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank</td>
                                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                            @else
                                            <td></td>
                                            @endif


                                            @if($receipt->payment_head == 9)
                                            <td>Token Amount</td>
                                           
                                            @endif

                                          
                                            <td>{{number_format($receipt->token_amount)}} PKR</td>
                                         
                                             <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                            <td class="text-nowrap">
                                                
                                              

                                                @if($view_receipt)
                                                <a href="{{route('token.receipt.detail',['id'=>$receipt->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
                                                @endif

                                              
                                                
                                                @if($delete_receipt)
                                                <a href="{{route('token.receipt.delete',['id'=>$receipt->id])}}" style="    margin-top: 3rem;" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                                <br>
                                <br>
                                <br>
                                <br>
                                <div style="float: right;">{{$receipts->links()}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if( payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'payment_mode':payment_mode,'receipt_no':receipt_no};
            $.get('/token/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true,
                    'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
@stop