@extends('layouts.app')

@section('title')
All Receipts 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
      </ol>
@stop

@section('content')


            <div class="container-fluid">


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <div class="pull-right">


                                <a href="{{route('all.tokenreceipt.approved')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Approve All 
                                </a>
                            </div>
                            
                            <h3 class="box-title">All Pending Receipts ({{number_format($totalAmount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                

                                        @foreach($receipts as $receipt)
                                        <tr>
                                           <td>{{$receipt->receipt_number}}</td>
                                           
                                           
                                             <td>{{ $receipt->inventory->unit_number}}</td>
                                             

                                          


                                             @if($receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                            @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank</td>
                                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                            @else
                                            <td></td>
                                            @endif


                                            @if($receipt->payment_head == 9)
                                            <td>Token Amount</td>
                                           
                                            @endif
                                            
                                            <td>{{number_format($receipt->token_amount)}} PKR</td>
                                            
                                             <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                            <td class="text-nowrap">

                                                <a href="{{route('token.receipt.detail',['id'=>$receipt->id])}}" class="btn btn-default">View</a>

                                             
                                                <a  href="{{route('token.receipt.approved',[$receipt->id])}}" class="btn btn-primary"> Approve </a>
                                                
                                        
                                                <a href="{{route('token.receipt.delete',['id'=>$receipt->id])}}" class="btn btn-danger" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" >Delete </a>

                                                
                                            </td>
                                        </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if(plot == 0  && customer== 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'plot':plot,'customer':customer,'dealer':dealer,'payment_mode':payment_mode,'payment_head':payment_head,'receipt_no':receipt_no};
            $.get('/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
@stop