@extends('layouts.app')

@section('title')
All Refund Statements 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Cancel Statements</li>
      </ol>
@stop
@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}

 .badge {
    text-transform: none !important; 
    font-weight: 500 !important;
    padding: 7px 7px !important;
    font-size: 13px !important;
    margin-top: 4px !important;

  }    
</style>

@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->

                

                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                @permission('list-membership')
                                <a href="{{route('token.refend.add')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add New Refund
                                </a>
                                @endpermission
                            </div>
                        	
                            <h3 class="box-title">Refund Tokens</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                           
                                            
                                            <th>Unit #</th>
                                            <th>Size</th>
                                            <th>Payment Mode</th>
                                            <th>Payment Head</th>
                                            <th>Received Token Amount </th>
                                            <th>Booking Date</th>
                                            <th>Status</th>
                                            <th >Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                    

                                        @foreach($receipts as $receipt)
                                        <tr >
                                            <td>{{$count++}}</td>
                                           
                                           
                                            <td>{{$receipt->inventory->unit_number}}</td>
                                              <td>
                                                 @if($receipt->inventory)
                                              
                                                @if($receipt->inventory->size)
                                                
                                                {{$receipt->inventory->size->name}} {{env('SIZE')}}
                                                @endif
                                                @endif
                                            </td>
                                           
                                             @if($receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                            @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank</td>
                                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                            @else
                                            <td></td>
                                            @endif
                                            
                                            
                                            @if($receipt->payment_head == 9)
                                            <td>Token Amount</td>
                                            @endif
                                            
                                            <td>{{number_format($receipt->token_amount)}} PKR</td>
                                         
                                            <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
 
                                            <td> 
                                            @if($receipt->is_approved == 2)
                                            <li id="refend" class="badge badge-success">Refund </a>
                                            </li>
                                            @endif
                                            </td>

                                            <td>
                                                <a href="{{route('token.receipt.detail',['id'=>$receipt->id])}}" target="_blank"  class="btn btn-default"> View </a>
                                            </td>
                                            

                                        </tr>

                                        @endforeach

                                    </tbody>
                                </table>
                                <!--<div style="float: right;"></div>-->
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->


@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

    </script>
@stop