@extends('layouts.app')

@section('title')
Adjustment Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-customer-adjustment')
        <li ><a href="{{route('adjustment.all')}}">Adjustments</a></li>
        @endpermission
        <li class="active">Adjustment Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Adjustment Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt No</td>
                                                    <td>{{$adjustment->receipt_no}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Customer Name</td>
                                                    <td> {{$adjustment->receipt->customer? $adjustment->receipt->customer->name: ''}} </td>
                                                </tr>

                                               <tr>
                                                    <td>Unit</td>
                                                    <td>{{$adjustment->receipt->property ? $adjustment->receipt->property->inventory->unit_number : ''}}</td>

                                                </tr>
                                                <tr>
                                                    <td>Adjustment Type</td>


                                                @if($adjustment->type == \App\Receipt::property) 
                                                <td>  Property  </td>

                                                @elseif($adjustment->type == \App\Receipt::vehicle) 
                                                <td> Vehicle  </td>

                                                @elseif($adjustment->type == \App\Receipt::rebate) 
                                                <td>Rebate </td>

                                                @elseif($adjustment->type == \App\Receipt::vendor) 
                                                <td>Vendor bill </td>

                                                @elseif($adjustment->type == \App\Receipt::others) 
                                                <td>Others </td>
                                                @else
                                                <td></td>
                                                @endif


                                                </tr>
                                                <tr>
                                                    <td>Description</td>
                                                    <td> {{$adjustment->description}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Merge Amount</td>
                                                    <td>{{$adjustment->merge_amount}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Sold Amt</td>
                                                    <td> {{$adjustment->sold_amount}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Status</td>
                                                     @if($adjustment->status == true)
                                            <td><span class="label label-success">Open</span></td>
                                            @else
                                            <td><span class="label label-danger">Sold</span></td>
                                            @endif
                                                </tr>

                                                 <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$adjustment->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$adjustment->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop