@extends('layouts.app')

@section('title')
Edit Adjustment 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-customer-adjustment')
        <li ><a href="{{route('adjustment.all')}}">Adjustments</a></li>
        @endpermission
        <li class="active">Edit Adjustment</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Edit Adjustment</h3>
                            <p class="text-muted m-b-30 font-13"> Update the information </p>
                            <form class="form-horizontal" action="{{route('adjustment.update')}}" method="post" enctype="multipart/form-data">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$adjustment->id}}">

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Receipt No </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                            <input readonly="" type="text" class="form-control" name="name" value="{{$adjustment->receipt_id}}" id="exampleInputuname" placeholder="Enter Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Unit</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                            <input readonly="" type="text" class="form-control" name="father_name" value="{{$adjustment->receipt->property ? $adjustment->receipt->property->inventory->unit_number : ''}}" id="exampleInputuname" >

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Type</label>
                                    <div class="col-sm-10">
                                    <div class="input-group">
                                    <div class="input-group-addon"></div>
                                    @if($adjustment->type == \App\Receipt::property) 
                                    <input readonly="" type="text" class="form-control" value="Property"  >

                                    @elseif($adjustment->type == \App\Receipt::vehicle) 
                                    <input readonly="" type="text" class="form-control" value="Vehicle"  >

                                    @elseif($adjustment->type == \App\Receipt::rebate) 


                                    <input readonly="" type="text" class="form-control" value="Rebate"  >
                                    @elseif($adjustment->type == \App\Receipt::vendor) 

                                    <input readonly="" type="text" class="form-control" value="Vendor bill "  >
                                    @elseif($adjustment->type == \App\Receipt::others) 
                                    <input readonly="" type="text" class="form-control" value="Others"  >
                                    @else
                                    <input readonly="" type="text" class="form-control" value=""  >
                                    @endif


                                    </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                            <textarea class="form-control" name="description">{{$adjustment->description}}</textarea>

                                        @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Merger Amount </label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                             <input readonly="" type="text" class="form-control"  value="{{$adjustment->merge_amount}}"  placeholder="Enter Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Sold Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                             <input  class="form-control"  type='number' name="sold_amount" value="{{$adjustment->sold_amount}}"  >
                                        @if ($errors->has('sold_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sold_amount') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>


                               <div class="form-group">
                                    <label for="inputPassword3" class="col-sm-2 control-label">Status <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <div class="input-group-addon"></div>
                                            <select class="form-control" name="status">
                                                @if($adjustment->status == true)
                                                <option value="1" selected="">Open</option>
                                                <option value="0">Sold</option>
                                                @else
                                                <option value="1" >Open</option>
                                                <option value="0" selected="">Sold</option>
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')

@stop