@extends('layouts.app')

@section('title')
All Customer Adjustments 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Customer Adjustments</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <h3 class="box-title">All Adjustments</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Receipt #</th>

                                            <th>Customer </th>
                                            <th>Unit</th>
                                            <th>Type</th>
                                            <!-- <th>Description</th> -->
                                            <th>Merge Amt</th>
                                            <th>Sold Amt</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($adjustments as $adj)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$adj->receipt_id}}</td>
                                            <td>{{$adj->receipt ? $adj->receipt->customer->name: '' }}</td>
                                            <td>{{$adj->receipt ? $adj->receipt->property->inventory->unit_number : ''}}</td>



                                        

                                            @if($adj->type == \App\Receipt::property) 
                                  <td>  Property  </td>

                                    @elseif($adj->type == \App\Receipt::vehicle) 
                                   <td> Vehicle  </td>

                                    @elseif($adj->type == \App\Receipt::rebate) 
                                    <td>Rebate </td>

                                    @elseif($adj->type == \App\Receipt::vendor) 
                                    <td>Vendor bill </td>

                                    @elseif($adj->type == \App\Receipt::others) 
                                    <td>Others </td>
                                    @else
                                    <td></td>
                                    @endif





                                            <!-- <td>{{$adj->description}}</td> -->

                                            <td>{{$adj->merge_amount}}</td>
                                            <td>{{$adj->sold_amount}}</td>
                                            @if($adj->status == true)
                                            <td><span class="label label-success">Open</span></td>
                                            @else
                                            <td><span class="label label-danger">Sold</span></td>
                                            @endif

                                               <td>{{date('d-m-Y', strtotime($adj->created_at)) }}</td>
                                            <td class="text-nowrap">
                                                @permission('view-customer-adjustment')
                                                <a href="{{route('adjustment.detail',['id'=>$adj->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('edit-customer-adjustment')
                                                <a href="{{route('adjustment.editView',['id'=>$adj->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop