@extends('layouts.app')

@section('title')
New Account 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-bank-account')
        <li ><a href="{{route('bank.all')}}">Bank Accounts</a></li>
        @endpermission
        <li class="active">Add Account</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> New Account</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('bank.insert')}}" method="post">
                               {{csrf_field()}}

                               <input type="hidden" name="project_id" value="{{env('PROJECT_ID')}}">
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input type="text" class="form-control" value="{{old('name')}}" name="name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Account Number <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="account_number" value="{{old('account_number')}}" id="exampleInputuname" placeholder="Account Number">
                                        @if ($errors->has('account_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Account Title <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="account_title" value="{{old('account_title')}}" id="exampleInputuname" placeholder="Account Title">
                                        @if ($errors->has('account_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_title') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                                            <input  type="hidden" class="form-control" name="opening_balance" value="0" id="exampleInputuname" >
                                   

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bank Address </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="address" value="{{old('address')}}" id="exampleInputuname" placeholder="Bank Address">
                                        @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Phone Number</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="phone_number" value="{{old('phone_number')}}" id="exampleInputuname" placeholder="Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="description" value="{{old('description')}}" id="exampleInputuname" placeholder="Description">
                                        @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                            

                                            <input type="hidden" name="status" value="1">

                                        
                                <div class=" col-sm-4">&nbsp;</div>
                                    <div class=" col-sm-4">
                                <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop