@extends('layouts.app')

@section('title')
Account Detail 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-bank-account')
        <li ><a href="{{route('bank.all')}}">Bank Accounts</a></li>
        @endpermission
        <li class="active">Detail Account</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Account Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                
                                                <tr>
                                                    <td>Name</td>
                                                    <td> {{$bank->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Bank Address</td>
                                                    <td> {{$bank->address}} </td>
                                                </tr>
                                                
                                                <tr>
                                                    <td>Account Title</td>
                                                    <td> {{$bank->account_title}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Account Number</td>
                                                    <td> {{$bank->account_number}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Bank Phone Number</td>
                                                    <td> {{$bank->phone_number }} </td>
                                                </tr>
                                                <tr>
                                                    <td>Description</td>
                                                    <td> {{$bank->description}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$bank->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$bank->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->

                   <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Account Ledger</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table table-bordered" >
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Category</th>
                                            <th>Memo</th>
                                            
                                            <th>Amount</th>
                                            <th>Balance</th>
                                        </tr>
                                        
                                    </thead>
                                    <tbody>

                                        <?php $balance = $bank->opening_balance; $debit = 0; $credit = 0;?>

                                        <tr>
                                            <td colspan="4" style="text-align: center;"><b>Opening Balance</b></td>
                                            <td><b>{{number_format($balance)}}</b></td>
                                        </tr>

                                        @foreach($records as $r)
                                        <tr>
                                            <td>{{date('d-m-Y',strtotime($r['date']))}}</td> 
                                            <td>{{$r['category']}}</td>
                                            
                                             <td>{{$r['memo']}}</td>

                                             
                                             
                                             
                                             <td>{{number_format($r['amount'])}}</td>
                                             <?php $balance += $r['amount'];
                                             $debit += $r['amount'];?>

                                             

                                             <td>{{number_format($balance)}}</td>
                                        </tr>
                                        @endforeach

                                        <tr>
                                            <td colspan="3" style="text-align: center;"><b>Total</b></td>
                                            <td><b>{{number_format($debit)}}</b></td>
                                            
                                            <td><b>{{number_format($balance)}}</b></td>
                                        </tr>

                                        <tr>
                                            <td colspan="4" style="text-align: center;"><b>Closing Balance</b></td>
                                            <td><b>{{number_format($balance)}}</b></td>
                                        </tr>

                                    </tbody>
                                </table>
                                    </div>

                        </div>
                    </div>
                </div>
              </div>
            <!-- /.container-fluid -->

@stop