@extends('layouts.app')

@section('title')
Edit Account 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-bank-account')
        <li ><a href="{{route('bank.all')}}">Bank Accounts</a></li>
        @endpermission
        <li class="active">Edit Account</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Account</h3>
                            <p class="text-muted m-b-30 font-13"> Update  Information </p>
                            <form class="form-horizontal" action="{{route('bank.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$bank->id}}">
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input type="text" class="form-control" value="{{$bank->name}}" name="name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Account Number <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="account_number" value="{{$bank->account_number}}" id="exampleInputuname" placeholder="Account Number">
                                        @if ($errors->has('account_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Account Title <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="account_title" value="{{$bank->account_title}}" id="exampleInputuname" placeholder="Account Title">
                                        @if ($errors->has('account_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_title') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Opening Balance <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="opening_balance" value="{{$bank->opening_balance}}" id="exampleInputuname" placeholder="Opening Balance">
                                        @if ($errors->has('opening_balance'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('opening_balance') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bank Address </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="address" value="{{$bank->address}}" id="exampleInputuname" placeholder="Bank Address">
                                        @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Phone Number</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="phone_number" value="{{$bank->phone_number}}" id="exampleInputuname" placeholder="Phone Number">
                                        @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="description" value="{{$bank->description}}" id="exampleInputuname" placeholder="Description">
                                        @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group" >
                                    <label for="inputPassword3" class="col-sm-2 control-label">Status<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <select class="form-control" style="width:300px" name="status">
                                                @if($bank->status)
                                                @if($bank->status == true)
                                                <option value='1' selected="">Active</option>
                                                <option value="0">InActive</option>
                                                @else
                                                <option value='1' >Active</option>
                                                <option value="0"selected="">InActive</option>
                                                @endif
                                                @else
                                               <option value='1' selected="">Active</option>
                                                <option value="0">InActive</option>
                                                @endif

                                            </select>

                                        @if ($errors->has('status'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('status') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               

                               

                               



                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop