@extends('layouts.app') 

@section('title') Add New Rebate @stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer-rebate')
    <li><a href="{{route('rebate.package.all')}}">Paid Package Rebates</a></li> 
    @endpermission
    <li class="active">Pay Package Rebate</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <!--.row-->
    <div class="row">
        <div class="col-md-12">
            <div class="white-box">
                <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Pay Package Rebate
                   </h3>
                <p class="text-muted m-b-30 font-13"> Add Information </p>
                <form class="form-horizontal" action="{{route('rebate.package.insert')}}" method="post"> {{csrf_field()}}
                    

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-4 control-label"> Dealer Name <span style="color: red">*</span></label>
                            <div class="col-sm-8">
                                
                                <select name="dealer_id" id='dealer_id' class="form-control chosen-select" onchange="updateAmount(this.value)">
                                    <option value="" selected="" disabled="">None</option> 

                                    @foreach($dealers as $dealer)
                                    <option value="{{$dealer->id}}">{{$dealer->name}}</option> @endforeach 

                                </select> 

                                @if ($errors->has('dealer_id')) 
                                <span class="help-block">
                                    <strong>{{ $errors->first('dealer') }}</strong>
                                </span> 
                                @endif 
                                
                                
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix"></div>
                    
                    <div class="col-md-12" id="amount" style="display: none; margin-bottom: 15px;"></div>

                    <div class="clearfix"></div>
                    
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Pay Amount </label>
                                <div class="col-sm-8">
                                    
                                    <input type="numeric" class="form-control" name="amount" value="{{old('amount')}}" id="ramount" onkeypress="return event.charCode >= 48 && event.charCode <= 57" onpaste="return false" onkeyup="checkCheckBox()" placeholder="Enter Amount"> 
                                    @if ($errors->has('amount')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span> 
                                    @endif 
                                    
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Date <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    
                                    <input type="date" class="form-control" name="date" value="{{old('date')}}" id="exampleInputuname" placeholder="Date"> 

                                    @if ($errors->has('date')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span> 
                                    @endif 

                                   
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Payment Method <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <select class="form-control chosen-select" id="payment_method" name="payment_method" onchange="changeFunc(this.value)">

                                        @if(old('payment_method') == \App\ExpensePayment::CASH)
                                        <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>
                                        <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                        <option value="{{\App\ExpensePayment::CHEQUE}}">Cheque/ DD/ PO</option>

                                        @elseif(old('payment_method') == \App\ExpensePayment::BANK_TRANSFER)
                                        <option value="{{\App\ExpensePayment::CASH}}">Cash</option>
                                        <option selected="" value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                        <option value="{{\App\ExpensePayment::CHEQUE}}">Cheque/ DD/ PO</option>

                                        @elseif(old('payment_method') == \App\ExpensePayment::CHEQUE)
                                        <option value="{{\App\ExpensePayment::CASH}}">Cash</option>
                                        <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                        <option selected="" value="{{\App\ExpensePayment::CHEQUE}}">Cheque/ DD/ PO</option>

                                        @else
                                        <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>
                                        <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                        <option value="{{\App\ExpensePayment::CHEQUE}}">Cheque/ DD/ PO</option>
                                        @endif

                                    </select> 

                                    @if ($errors->has('payment_method')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_method') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6" id='bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Depositor Bank Name <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <select name="bank_name" class="form-control chosen-select">
                                        <option value="" selected="">None</option> 

                                        @foreach($banks as $bank) 

                                        @if(old('bank_name') == $bank->id)
                                        <option selected="" value="{{$bank->id}}">{{$bank->name}}</option> @else
                                        <option value="{{$bank->id}}">{{$bank->name}}</option> 
                                        @endif 

                                        @endforeach 
                                    </select> 

                                    @if ($errors->has('bank_name')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id='company-bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Company Account <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <select name="company_account" class="form-control chosen-select">
                                        <option value="" selected="">None</option> 
                                        
                                        @foreach($cBanks as $bank) 
                                        
                                        @if(old('company_account') == $bank->id)
                                        <option selected="" value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                        @else
                                        <option value="{{$bank->id}}">{{$bank->name}} - {{$bank->account_number}}</option> 
                                        @endif 
                                        @endforeach 

                                    </select> 

                                    @if ($errors->has('company_account')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('company_account') }}</strong>
                                    </span> 
                                    @endif 
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="drawn-date" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Drawn Date <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <input type="date" class="form-control" name='drawn_date' value="{{old('drawn_date')}}" id="exampleInputEmail1" placeholder="Enter Receipt Date" > 
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6" id="cheque-instrument-no" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Instrument No <span style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" name='cheque_number' value="" class="form-control" id="exampleInputEmail1" placeholder="Enter Instrument Number"> 
                                    @if ($errors->has('cheque_number')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cheque_number') }}</strong>
                                    </span> 
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Description</label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" rows="5" name="notes" placeholder="Enter Description">{{old('notes')}}</textarea> 

                                    @if ($errors->has('notes')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span> 
                                    @endif 
                                
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-sm-4">With Holding Tax ? </label>
                                <div class="col-sm-8">
                                    <input style="margin-left: -200px;   height: 22px !important;" type="checkbox" class="form-control" value="1" name="w_h_tax" > 
                                   
                                    @if ($errors->has('w_h_tax')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('w_h_tax') }}</strong>
                                    </span> 
                                    @endif 
                                
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="taxDiv" style="display:none">
                            <div class="form-group">
                                <label class="control-label col-sm-4">Tax Amount</label>
                                <div class="col-sm-8">
                                    <input readonly="" class="form-control" type="number" value="" name="tax_amount" id="tax_amount"> 

                                    @if ($errors->has('tax_amount')) 
                                    <span class="help-block">
                                        <strong>{{ $errors->first('tax_amount') }}</strong>
                                    </span> 
                                    @endif 
                                
                                </div>
                            </div>
                        </div>
                    
                    <div class="clearfix"></div>


                    <div class="col-sm-4"> &nbsp;</div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--./row-->
</div>
<!-- /.container-fluid -->

<input type="hidden" name="is_filer" id="is_filer" value="{{$dealer->is_filer ? 1 : 0}}">

@stop 

@section('js')

<script type="text/javascript">

function changeFunc(a){
    if(a == {{\App\ExpensePayment::CASH}})
    {
        $('#bank').css('display', 'none');
        $('#company-bank').css('display', 'none');
        $('#drawn-date').css('display', 'none');
        $('#cheque-instrument-no').css('display', 'none');
    }
    else if(a == {{\App\ExpensePayment::BANK_TRANSFER}})
    {
        $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#drawn-date').css('display', 'none');
        $('#cheque-instrument-no').css('display', 'none');
    }
    else if(a == {{\App\ExpensePayment::CHEQUE}})
    {
        $('#bank').css('display', 'block');
        $('#company-bank').css('display', 'block');
        $('#drawn-date').css('display', 'block');
        $('#cheque-instrument-no').css('display', 'block');
    }
}

function updateAmount(){

    $('.preloader').fadeIn();

    var dealer_id = $('#dealer_id').val();


    var data = {'dealer_id':dealer_id};

    $.get('/dealer-package-rebate/update-amount', data, function (data) {

        document.getElementById('amount').innerHTML = data;

        document.getElementById('amount').style.display = 'block';

    });

    //  $('#wait').hide();
    $('.preloader').fadeOut();

}

 window.onload = function () { 

    var payment_method = $('#payment_method').val();
    changeFunc(payment_method)
}



function getAmount(self) {

    $('#remaining_amount:disabled').val($(self).data("amount"))
}

function checkCheckBox()
{ 
    if ($('#ramount').val() == '') 
    {
        $('#w_h_tax').prop('checked', false);
         $('#taxDiv').hide()
    }
    else
    {
          amount = parseInt($('#ramount').val());

        isFiler = parseInt($('#is_filer').val());
        if(isFiler == 1)
            $('#tax_amount').val(parseInt( amount * 0.12));
        else
            $('#tax_amount').val(parseInt(amount * 0.24));
    }
}

$('#w_h_tax').click(function(){


    if ($('#ramount').val() == '') 
    {
        $('#w_h_tax').prop('checked', false);
        $('#taxDiv').hide()
    }


    if($("#w_h_tax").prop('checked') == true){

        document.getElementById('taxDiv').style.display = 'block';

        amount = parseInt($('#ramount').val());

        isFiler = parseInt($('#is_filer').val());
        if(isFiler == 1)
            $('#tax_amount').val(parseInt( amount * 0.12));
        else
            $('#tax_amount').val(parseInt(amount * 0.24));
    }

    else if($("#w_h_tax").prop('checked') == false) {
        document.getElementById('taxDiv').style.display = 'none';

        $('#tax_amount').val(parseInt(0));
    }
    
});

</script>

@stop
