@extends('layouts.app')

@section('title')
All Paid Rebates
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Paid Package Rebates</li>
      </ol>
@stop


@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('create-dealer-rebate')
								<a href="{{route('rebate.package.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Pay Rebate
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">All Paid Package Rebates ({{number_format($totalPaidRebate)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Dealer Name</th>
                                            <th>Package Name</th>
                                            <th>Net amount</th>
                                            <th>Tax</th>
                                            <th>Payment Method</th>
                                            <th>Description</th>

                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allRebates as $rebate)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$rebate->dealer? $rebate->dealer->name : ''}}</td>
                                            <td>@if($rebate->dealerPackage)
                                                
                                                {{$rebate->dealerPackage->package->name}}
                                          
                                        @endif</td>

                                              <td>{{number_format($rebate->amount)}}</td>
                                              <td>{{number_format($rebate->tax_amount)}}</td>
                                              
                                          <td>@if($rebate->payment_method)
                                          @if($rebate->payment_method == 1)
                                      CASH @else
                                  BANK TRANSFER
                              @endif

                          @endif</td>
                          <td>{{$rebate->description}}</td>
                                               <td>{{date('d-m-Y', strtotime($rebate->date)) }}</td>
                                            <td class="text-nowrap">
<!--                                                <a href="{{route('rebate.detail',['id'=>$rebate->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>-->
                                                <!-- @permission('edit-dealer-rebate')
                                                <a href="{{route('rebate.editView',['id'=>$rebate->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission -->
                                                <!-- show-dealer-rebate -->
                                                @permission('delete-dealer-rebate')
                                                <a href="{{route('rebate.package.detail',['id'=>$rebate->id])}}" data-toggle="tooltip" data-original-title="Show"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endpermission
                                                @permission('delete-dealer-rebate')
                                                {{-- <a href="{{route('rebate.delete',['id'=>$rebate->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a> --}}
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop