@extends(  'layouts.app' )

@section('title')
Purchase Detail 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('purchase.all')}}">Purchases</a></li>
        <li class="active">Detail Purchase</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Purchase Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Date</td>
                                                    <td> {{date('d-m-Y', strtotime($purchase->date)) }} </td>
                                                </tr>
                                                <tr>
                                                    <td>Product</td>
                                                    <td> {{$purchase->product}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Supplier</td>
                                                    <td> {{$purchase->supplier}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Rate</td>
                                                    <td> {{number_format($purchase->rate)}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Quantity</td>
                                                    <td> {{$purchase->qty}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Total Amount</td>
                                                    <td> {{number_format($purchase->total)}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Tax</td>
                                                    <td> {{number_format(($purchase->tax / 100) * $purchase->total)}} [{{$purchase->tax}}%] </td>
                                                </tr>
                                                <tr>
                                                    <td>Net Amount</td>
                                                    <td> {{number_format($purchase->net)}} </td>
                                                </tr>


                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$purchase->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$purchase->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop