@extends( 'layouts.app' )

@section('title')
Update Purchase 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('purchase.all')}}">Purchases</a></li>
        <li class="active">Edit Purchase</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i>Edit Purchase</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('purchase.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$purchase->id}}">
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bill No </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="bill_no" value="{{$purchase->bill_no}}" id="exampleInputuname" placeholder="Bill Number">
                                        @if ($errors->has('bill_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bill_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Product <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="product" value="{{$purchase->product}}" id="exampleInputuname" placeholder="Product">
                                        @if ($errors->has('product'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('product') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Supplier <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="supplier" value="{{$purchase->supplier}}" id="exampleInputuname" placeholder="Supplier Name">
                                        @if ($errors->has('supplier'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('supplier') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Rate <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="rate" value="{{$purchase->rate}}" id="exampleInputuname" placeholder="Rate">
                                        @if ($errors->has('rate'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('rate') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Quantity <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="integer" class="form-control" name="qty" value="{{$purchase->qty}}" id="exampleInputuname" placeholder="Quantity">
                                        @if ($errors->has('qty'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('qty') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Tax </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="tax" value="{{$purchase->tax}}" id="exampleInputuname" placeholder="Tax">
                                        @if ($errors->has('tax'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('tax') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Payment mode <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select name='payment_mode' class="form-control chosen-select" onchange='updateForm(this.value)'>
                                                <option value=""  selected="">Select Payment Mode</option>
                                                @if($purchase->payment_mode == \App\Purchase::cash)
                                                <option value="{{\App\Purchase::cash}}" selected="">Cash</option>
                                                <option value="{{\App\Purchase::bank}}" >Bank</option>
                                                @elseif($purchase->payment_mode == \App\Purchase::cash)
                                                <option value="{{\App\Purchase::cash}}" >Cash</option>
                                                <option value="{{\App\Purchase::bank}}" selected="">Bank</option>

                                                @endif
                                            </select>
                                        @if ($errors->has('payment_mode'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_mode') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                            @if($purchase->payment_mode == \App\Purchase::bank)
<div class="form-group" id='bank' >
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bank name(optional)</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="bank_name" value="{{$purchase->bank_name}}" id="exampleInputuname" placeholder="Bank Name">
                                        @if ($errors->has('bank_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                            @else
                            <div class="form-group" id='bank' style="display: none;">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bank name</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="bank_name" value="{{$purchase->bank_name}}" id="exampleInputuname" placeholder="Bank Name">
                                        @if ($errors->has('bank_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                            @endif

                                    <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Date</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="date" value="{{$purchase->date}}" id="exampleInputuname" placeholder="Date of purchase">
                                        @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>



                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script>

    function updateForm(val) {

        if(val == {{\App\Purchase::bank}}) {
            document.getElementById('bank').style.display='block';
        }
        else{
            document.getElementById('bank').style.display='none';
        }
    }

    </script>


@stop