@extends('layouts.app')

@section('title')
Edit Paid Rebate
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-dealer-rebate')
        <li ><a href="{{route('rebate.all')}}">Paid Rebates</a></li>
        @endpermission
        <li class="active">Edit Paid Rebate</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Paid Rebate</h3>
                            <p class="text-muted m-b-30 font-13"> Update  Information </p>
                            <form class="form-horizontal" action="{{route('rebate.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$rebate->id}}">
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Dealer Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select name="dealer_id" id='dealer_id' class="form-control chosen-select" onchange="updateAmount(this.value)">

                                                <option value="" selected="" disabled="">None</option>

                                                @foreach($dealers as $dealer)
                                                @if($dealer->id == $rebate->dealer->id)
                                                <option value="{{$dealer->id}}" selected="">{{$dealer->name}}</option>
                                                @else
                                                <option value="{{$dealer->id}}">{{$dealer->name}}</option>
                                                @endif
                                                 @endforeach
                                            </select>

                                        @if ($errors->has('dealer_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('dealer') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group" id="amount" >
                                   <label for="exampleInputuname" class="col-sm-2 control-label"> Remaining Rebate </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" disabled="" class="form-control"  value="{{number_format($rebate->dealer->total_rebate - $rebate->dealer->total_paid_amount)}}" id="exampleInputuname" >

                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Pay Amount </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="amount" value="{{$rebate->amount}}" id="exampleInputuname" placeholder="Enter Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>


                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="date" value="{{$rebate->date}}" id="exampleInputuname" placeholder="Date">
                                        @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                           <label class="control-label col-sm-2">Account<span style="color: red">*</span></label>
                                                        <div class="col-sm-10" style="width:330px">
                                                            <select class="form-control chosen-select" name="account_id">
                                                                <option>None</option>

                                                                @foreach($accounts as $account)
                                                                @if($rebate->account_id == $account->id)
                                                                <option selected="" value="{{$account->id}}">{{$account->name}}
                                                                </option>
                                                                @else
                                                                <option value="{{$account->id}}">{{$account->name}}
                                                                </option>
                                                                @endif
                                                                @endforeach
                                                              
                                                            </select>
                                                            @if ($errors->has('account_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            
                            <div class="form-group">
                           <label class="control-label col-sm-2">Payment Method <span style="color: red">*</span></label>
                                                        <div class="col-sm-10" style="width:330px">
                                                            <select class="form-control chosen-select" name='payment_method' >
                                                                @if($rebate->payment_method == \App\ExpensePaymeent::BANK_TRANSFER)
                                                                <option  value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option selected="" value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                                                @else
                                                                <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>


                                                                @endif
                                                                
                                                            </select>
                                                            @if ($errors->has('payment_method'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_method') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>

                                                       
                    <div class="form-group">
                        <label class="control-label col-sm-2">Description</label>
                    <div class="col-sm-10" style="width:330px">
                        <textarea class="form-control" rows="5" name="notes" placeholder="Enter Description">{{$rebate->description}}</textarea>
                    @if ($errors->has('notes'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>



                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    function updateAmount(){
    $('.preloader').fadeIn();

    var dealer_id = $('#dealer_id').val();


    var data = {'dealer_id':dealer_id};

    $.get('/dealer-rebate/update-amount', data, function (data) {

        document.getElementById('amount').innerHTML = data;

        document.getElementById('amount').style.display = 'block';

    });

  //  $('#wait').hide();
   $('.preloader').fadeOut();
}
    </script>
@stop
