@extends('layouts.app')

@section('title')
Reconcilations
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Reconcilations</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('manage-reconciliation')
								<a href="{{route('reconcile.new')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add New
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">Reconciliation</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Account</th>
                                            <th>Period</th>
                                            
                                            
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allReconciliations as $reconcile)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{date('d M Y',strtotime($reconcile->created_at))}}</td>
                                            <td>{{$reconcile->account->name}}</td>
                                            <td>{{date('d M Y',strtotime($reconcile->started_at))}} - {{date('d M Y',strtotime($reconcile->ended_at))}}</td>
                                                
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop