@extends('layouts.app')

@section('title')
New Reconciliation
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-company-account')
        <li ><a href="{{route('reconcile.all')}}">Reconcilations</a></li>
        @endpermission
        <li class="active">New Reconciliation</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> New Reconciliation</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('reconcile.new.show')}}" method="post">
                               {{csrf_field()}}

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Start Date<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="start_date" value="{{old('start_date')}}" id="exampleInputuname" placeholder="Date">
                                        @if ($errors->has('start_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('start_date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">End Date<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="end_date" value="{{old('end_date')}}" id="exampleInputuname" placeholder="Date">
                                        @if ($errors->has('end_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('end_date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                


                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Account <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="account">
                                                @foreach($accounts as $acc)
                                                @if(old('account') == $acc->id)
                                                <option value="{{$acc->id}}" selected="">{{$acc->number}} - {{$acc->name}}</option>
                                                @else
                                                <option value="{{$acc->id}}">{{$acc->number}} - {{$acc->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                            
                                        @if ($errors->has('account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                    <div class="form-group ">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Transactions</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop