@extends('layouts.app')

@section('title')
Show Reconcilations
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-company-account')
        <li ><a href="{{route('reconcile.all')}}">Reconcilations</a></li>
        @endpermission
        <li class="active">New Reconciliation</li>
      </ol>
@stop

@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	
                            <h3 class="box-title">Transactions</h3>

                            <form  action="{{route('reconcile.add')}}" method="post">
                               {{csrf_field()}}

                               <input type="hidden" name="account" value="{{$account}}">
                               <input type="hidden" name="start_date" value="{{$start_date}}">
                               <input type="hidden" name="end_date" value="{{$end_date}}">

                            <div class="table-responsive">
                                <table  class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Voucher #</th>
                                            <th>Description</th>
                                            <th>Name</th>
                                            <!-- <th>Closing Balance</th> -->
                                            <th>Deposit</th>
                                            <th>WithDraw</th>
                                            <th>Clear</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                        <?php $count = 1;$totalAmount = 0;$uncleared = 0;?>

                                        @foreach($entries as $e)
                                        <tr>

                                        <td>{{$count++}}</td>
                                        <td>{{date('d-m-Y',strtotime($e->date))}}</td>
                                        @if($e->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td>CRV-{{$e->voucher_no}}</td>
                                            @elseif($e->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td>BRV-{{$e->voucher_no}}</td>
                                            @elseif($e->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td>CPV-{{$e->voucher_no}}</td>
                                            @elseif($e->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td>BPV-{{$e->voucher_no}}</td>
                                            @elseif($e->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td>JV-{{$e->voucher_no}}</td>
                                            @else
                                            <td></td>
                                            @endif
                                        <td>{{$e->memo}}</td>
                                        <td>{{$e->controlAccount ? $e->controlAccount->name : ''}}</td>
                                        <td>{{$e->amount > 0 ? number_format($e->amount) : ''}}</td>
                                        <td>{{$e->amount < 0 ? number_format(abs($e->amount)) : ''}}</td>

                                        @if($e->is_cleared)
                                        <td><input type="checkbox" disabled=""></td>
                                        @else
                                        <td><input type="checkbox" name="e_ids[]" value="{{$e->id}}"></td>
                                        <?php $uncleared += $e->amount;?>
                                        @endif

                                        </tr>
                                        <?php $totalAmount += $e->amount;?>
                                        @endforeach

                                         



                                    </tbody>
                                </table>

                                <div class="col-md-3 pull-right"><b>Total Balance : {{number_format($totalAmount)}}</b></div><br>
                                <div class="clearfix"></div>

                                <div class="col-md-3 pull-right"><b>Uncleared Transaction : {{number_format($uncleared)}}</b></div><br>
                                <div class="clearfix"></div>

                                <div class="col-md-3 pull-right"><b>Difference : {{number_format($totalAmount - $uncleared)}}</b></div>
                                <div class="clearfix"></div>

                                <br>


                                <div class="form-group  col-sm-2" style="float: right;">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Reconcile</button>
                                    </div>
                            </div>

                        </form>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop