@extends('layouts.app')

@section('title')
New Transfer 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-company-account')
        <li ><a href="{{route('account.transfer.all')}}">All transfers</a></li>
        @endpermission
        <li class="active">Add Transfer</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> New Transfer</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('account.transfer.insert')}}" method="post">
                               {{csrf_field()}}
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> From Account <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="from_account">
                                                @foreach($accounts as $acc)
                                                @if(old('from_account') == $acc->id)
                                                <option value="{{$acc->id}}" selected="">{{$acc->name}}</option>
                                                @else
                                                <option value="{{$acc->id}}">{{$acc->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                            
                                        @if ($errors->has('from_account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('from_account') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> To Account <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="to_account">
                                                @foreach($accounts as $acc)
                                                @if(old('to_account') == $acc->id)
                                                <option value="{{$acc->id}}" selected="">{{$acc->name}}</option>
                                                @else
                                                <option value="{{$acc->id}}">{{$acc->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                            
                                        @if ($errors->has('to_account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('to_account') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="amount" value="{{old('amount')}}" id="exampleInputuname" placeholder="Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Date<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="date" value="{{old('date')}}" id="exampleInputuname" placeholder="Date">
                                        @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea name="memo" class="form-control" rows="5">{{old('memo')}}</textarea>

                                           
                                        @if ($errors->has('memo'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('memo') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                    <div class="form-group ">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop