@extends('layouts.app')

@section('title')
Edit Transfer 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-company-account')
        <li ><a href="{{route('account.transfer.all')}}">All transfers</a></li>
        @endpermission
        <li class="active">Edit Transfer</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Transfer</h3>
                            <p class="text-muted m-b-30 font-13"> Update  Information </p>
                            <form class="form-horizontal" action="{{route('account.transfer.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$transfer->id}}">
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> From Account <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="from_account">
                                                @foreach($accounts as $acc)
                                                @if($transfer->from_account == $acc->id)
                                                <option value="{{$acc->id}}" selected="">{{$acc->name}}</option>
                                                @else
                                                <option value="{{$acc->id}}">{{$acc->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                            
                                        @if ($errors->has('from_account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('from_account') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> To Account <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="to_account">
                                                @foreach($accounts as $acc)
                                                @if($transfer->to_account == $acc->id)
                                                <option value="{{$acc->id}}" selected="">{{$acc->name}}</option>
                                                @else
                                                <option value="{{$acc->id}}">{{$acc->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                            
                                        @if ($errors->has('to_account'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('to_account') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="amount" value="{{$transfer->amount}}" id="exampleInputuname" placeholder="Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Date<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="date" value="{{$transfer->date}}" id="exampleInputuname" placeholder="Date">
                                        @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea name="memo" class="form-control" rows="5">{{$transfer->memo}}</textarea>

                                           
                                        @if ($errors->has('memo'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('memo') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                            

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop