@extends('layouts.app')

@section('title')
Account Transfers
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Account Transfers</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('create-company-account')
								<a href="{{route('account.transfer.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add New
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">Transfers</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Memo</th>
                                            <th>From Account</th>
                                            <th>To Account</th>
                                            <th>Amount</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allAccountTransfers as $transfer)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{date('d M Y',strtotime($transfer->date))}}</td>
                                            <td>{{$transfer->memo}}</td>
                                            <td>{{$transfer->from->name}}</td>
                                            <td>{{$transfer->to->name}}</td>
                                            
                                            
                                              <td>{{number_format($transfer->amount)}}</td>

                                             

                                            <td class="text-nowrap">
                                                

                                                @permission('edit-company-account')
                                                <a href="{{route('account.transfer.editView',['id'=>$transfer->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('delete-company-account')
                                                <a href="{{route('account.transfer.delete',['id'=>$transfer->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop