@extends('layouts.app')

@section('title')
    Trash Box 
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Trash Box</li>
    </ol>
@stop
@section('content')

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        <!-- <a href="{{route('customer.addView')}}" class="btn  btn-primary">
                            <i class="fa fa-plus-square"></i>&nbsp; Add new Customer
                        </a> -->
                    </div>
                    <h3 class="box-title">Customers</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletecustomer')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Member Id</th>
                                    <th>Member Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allCustomers as $customer)
                                <tr>
                                    <td>{{$count++}}</td>
                                        <td>M{{$customer->id}}</td>
                                    <td><a href="{{route('customer.detail',['id'=>$customer->id])}}"">{{$customer->name}}</a></td>

                                    <td class="text-nowrap">
                                        <a href="{{route('trash.customer.revert',['id'=>$customer->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.customer.delete',['id'=>$customer->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
        </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">All Inventories</h3>
                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeleteinventory')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>
                        <table id="myTable1" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sr #</th>
                                    <th>Unit #</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allInventories as $i)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td><a href="{{route('inventory.detail',['id'=>$i->id])}}">{{$i->unit_number}}</a></td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.inventory.revert',['id'=>$i->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.inventory.delete',['id'=>$i->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
    
    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Statement</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletemembership')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable4" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Reference #</th>
                                    <th>Unit #</th>
                                    <th>Member Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allStatements as $statement)
                                <tr >
                                    <td>
                                        {{$count++}}
                                    </td>
                                    <td>
                                        <a href="{{route('statement.detail',['id'=>$statement->id])}}">{{$statement->membership_no}}</a>
                                    </td>
                                    <td>
                                        {{$statement->inventory ? $statement->inventory->unit_number : '' }}
                                    </td>
                                    <td>
                                        {{$statement->customer ? $statement->customer->name: ''}}
                                    </td>

                                    <td class="text-nowrap">
                                            <a href="{{route('trash.membership.revert',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                        <a href="{{route('trash.membership.delete',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>

                                </tr>

                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">All Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletereceipt')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable5" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Receipt No.</th>
                                    <th>Unit No. </th>
                                    <th>Payment Head</th>
                                    <th>Received Amount </th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($receipts as $receipt)
                                <tr>
                                    <td>{{$receipt->receipt_no}}</td>
                                    
                                    <td>{{$receipt->property ? $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' : ''}}</td>


                                    @if($receipt->payment_head == \App\Receipt::down_payment)
                                    <td>Down Payment</td>
                                    @elseif($receipt->payment_head == \App\Receipt::possession_fee)
                                    <td>Possession Fee</td>
                                    @elseif($receipt->payment_head == \App\Receipt::installment)
                                    <td>Installment</td>
                                    @elseif($receipt->payment_head == \App\Receipt::other)
                                    <td>Other</td>
                                    @else
                                    <td></td>
                                    @endif

                                    <td>{{number_format($receipt->amount)}} PKR</td>
                                        <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                    <td class="text-nowrap">

                                        <a href="{{route('trash.receipt.revert',['id'=>$receipt->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.receipt.delete',['id'=>$receipt->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Dealers</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletedealer')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable6" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Total Sale</th>
                                    <th>Total Rebate</th>
                                    <th>Paid Amount</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allDealers as $dealer)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td> <a href="{{route('dealer.detail',['id'=>$dealer->id])}}"><b>{{$dealer->name}}</b> - {{$dealer->dealerType ? $dealer->dealerType->name : ''}}</a></td>



                                    <td>{{$dealer->total_sale ? number_format($dealer->total_sale) : 0}} PKR</td>
                                    <td>{{$dealer->total_rebate ? number_format($dealer->total_rebate) : 0}} PKR</td>
                                    <td>{{$dealer->total_paid_amount ? number_format($dealer->total_paid_amount) : 0}} PKR</td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.dealer.revert',['id'=>$dealer->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.dealer.delete',['id'=>$dealer->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Dealer Rebate</h3>

                    <div class="table-responsive">
                        <a href="#" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable8" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Dealer</th>
                                    <th>Amount</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allDealerRebate as $no)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td>{{$no->dealer->name}}</td>
                                    <td>{{$no->amount}}</td>
                                    <td class="text-nowrap">

                                        <a href="{{route('trash.dealerRebate.revert',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.dealerRebate.delete',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Unit Type</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletetype')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable9" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allUnitType as $no)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td>{{$no->name}}</td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.unitType.revert',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.unitType.delete',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Unit Size</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletesize')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable10" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allUnitSize as $no)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td>{{$no->name}}</td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.unitSize.revert',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.unitSize.delete',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Unit Floor</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletefloor')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable11" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allUnitFloor as $no)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td>{{$no->name}}</td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.unitFloor.revert',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.unitFloor.delete',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Unit Category</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletecategory')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable12" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allUnitCategory as $no)
                                <tr>
                                    <td>{{$count++}}</td>
                                    <td>{{$no->name}}</td>

                                    <td class="text-nowrap">

                                        <a href="{{route('trash.unitCategory.revert',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Revert"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="{{route('trash.unitCategory.delete',['id'=>$no->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Package List</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletepackage')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable13" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allpackage as $no)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $no->name }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.package.revert',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                            <a href="{{ route('trash.package.delete',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Price List</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeleteprice')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable14" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Price List No.</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allprice as $no)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $no->l_no }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.price.revert',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                                                                                                
                                            <a href="{{ route('trash.price.delete',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Open File Packages</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeleteopenfile')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable15" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Dealer Name</th>
                                    <th>Dealer Code</th>
                                    <th>Package Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allopenfile as $no)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $no->dealer->name }}</td>
                                        <td>{{ $no->dealer->code }}</td>
                                        <td>{{ $no->package->name }}</td>
                                        <td>{{ $no->payment_status }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.issue.revert',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.issue.delete',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Dealer Package Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.inventory.alldeletedealerpackagereceipt')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable16" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Receipt No.</th>
                                    <th>Receipt Amount</th>
                                    <th>Receipt Status</th>
                                    <th>Receipt Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allDealerReceipt as $no)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $no->receipt_no }}</td>
                                        <td>{{ $no->amount }}</td>
                                        <td>@if ($no->is_approved == 0)
                                            <span class="label label-danger">Pending</span>
                                        @elseif($no->is_approved == 1)
                                            <span class="label label-success">Approved</span>
                                            @endif</td>
                                        <td>{{ date('y-m-d', strtotime($no->receipt_date)) }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.dealer_receipt.revert',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.dealer_receipt.delete',['id'=>$no->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Refund Unit Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.refund_unit_receipt.delete-all')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable17" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Receipt No.</th>
                                    <th>Receipt Amount</th>
                                    <th>Receipt Status</th>
                                    <th>Receipt Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allRefundUnitReceipt as $refund_rec)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $refund_rec->receipt_no }}</td>
                                        <td>{{ $refund_rec->amount }}</td>
                                        <td>@if ($refund_rec->is_approved == 0)
                                            <span class="label label-danger">Pending</span>
                                        @elseif($refund_rec->is_approved == 1)
                                            <span class="label label-success">Approved</span>
                                            @endif</td>
                                        <td>{{ date('y-m-d', strtotime($refund_rec->receipt_date)) }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.refund_unitreceipt.revert',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.refund_unit_receipt.delete',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Open File Refund Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.refund_open_file_receipt.delete-all')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable20" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Receipt No.</th>
                                    <th>Receipt Amount</th>
                                    <th>Receipt Status</th>
                                    <th>Receipt Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>
                                @foreach($allRefundOpenFileReceipt as $refund_rec)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $refund_rec->receipt_no }}</td>
                                        <td>{{ $refund_rec->amount }}</td>
                                        <td>@if ($refund_rec->is_approved == 0)
                                            <span class="label label-danger">Pending</span>
                                        @elseif($refund_rec->is_approved == 1)
                                            <span class="label label-success">Approved</span>
                                            @endif</td>
                                        <td>{{ date('y-m-d', strtotime($refund_rec->receipt_date)) }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.refund_open_file_receipt.revert',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.refund_open_file_receipt.delete',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Cancel Unit Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.cancel_unit_receipt.delete-all')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable18" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Receipt No.</th>
                                    <th>Receipt Amount</th>
                                    <th>Receipt Status</th>
                                    <th>Receipt Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>                                                                                          
                                @foreach($allCancelUnitReceipt as $cancel_rec)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $cancel_rec->receipt_no }}</td>
                                        <td>{{ $cancel_rec->amount }}</td>
                                        <td>
                                            @if ($cancel_rec->is_approved == 0)
                                            <span class="label label-danger">Pending</span>
                                            @elseif($cancel_rec->is_approved == 1)
                                            <span class="label label-success">Approved</span>
                                            @endif</td>
                                        <td>{{ date('y-m-d', strtotime($cancel_rec->receipt_date)) }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.cancel_unitreceipt.revert',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.cancel_unit_receipt.delete',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>           
    <!-- /.container-fluid -->

    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Open File Cancel Receipts</h3>

                    <div class="table-responsive">
                        <a href="{{route('trash.cancel_open_file_receipt.delete-all')}}" class="btn  btn-primary" style="float: right;">&nbsp; Delete All</a>

                        <table id="myTable19" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Receipt No.</th>
                                    <th>Receipt Amount</th>
                                    <th>Receipt Status</th>
                                    <th>Receipt Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count =1;?>                                                                                          
                                @foreach($allCancelOpenFileReceipt as $cancel_rec)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $cancel_rec->receipt_no }}</td>
                                        <td>{{ $cancel_rec->amount }}</td>
                                        <td>
                                            @if ($cancel_rec->is_approved == 0)
                                            <span class="label label-danger">Pending</span>
                                            @elseif($cancel_rec->is_approved == 1)
                                            <span class="label label-success">Approved</span>
                                            @endif</td>
                                        <td>{{ date('y-m-d', strtotime($cancel_rec->receipt_date)) }}</td>

                                        <td class="text-nowrap">

                                            <a href="{{ route('trash.cancel_open_file_receipt.revert',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Revert"> <i
                                                    class="fa fa-pencil text-inverse m-r-10"></i> </a>

                                            <a href="{{ route('trash.cancel_open_file_receipt.delete',['id'=>$refund_rec->id]) }}"
                                                data-toggle="tooltip" data-original-title="Delete"> <i
                                                    class="fa fa-close text-danger"></i> </a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>           
    <!-- /.container-fluid -->

    


@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();
        $('#myTable1').DataTable();
        $('#myTable2').DataTable();
        $('#myTable3').DataTable();
        $('#myTable4').DataTable();
        $('#myTable5').DataTable();
        $('#myTable6').DataTable();
        $('#myTable7').DataTable();
        $('#myTable8').DataTable();
        $('#myTable9').DataTable();
        $('#myTable10').DataTable();
        $('#myTable11').DataTable();
        $('#myTable12').DataTable();
        $('#myTable13').DataTable();
        $('#myTable14').DataTable();
        $('#myTable15').DataTable();
        $('#myTable16').DataTable();
        $('#myTable17').DataTable();
        $('#myTable18').DataTable();
        $('#myTable19').DataTable();
        $('#myTable20').DataTable();
    });


    </script>
@stop