@extends( 'layouts.app' )

@section('title')
Vendor Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
         @permission('view-vendor')
        <li ><a href="{{route('vendor1.all')}}">Vendors</a></li>
        @endpermission
        <li class="active">Vendor Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <div class="row colorbox-group-widget">
                     <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="profile-widget">
                                <div class="profile-img">
                                    <img src="{{asset('plugins/images/users/jeffery.png')}}" height="70px" width="auto" alt="user-img" class="img-circle">
                                     <p class="m-t-10 m-b-5"><a href="javascript:void(0);" class="profile-text font-22 font-semibold">{{$vendor->name}}</a></p>
                                     

                                    @if($vendor->vendor_type == \App\Vendor::Trader)
                                    <span class="label label-success ">Trader</span>
                                    @else
                                    <span class="label label-danger ">Non Trader</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-info">
                                <div class="media-body">
                                    <h3 class="info-count">{{$bill_count}}<span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">Count</p>
                                    <p class="info-ot font-20">Transactions</p>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-success" style="background-color: green!important;">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($paidAmount)}} <span class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                    <p class="info-text font-12">PKR</p>
                                    <p class="info-ot font-20">Paid Amount</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 info-color-box">
                        <div class="white-box">
                            <div class="media bg-danger">
                                <div class="media-body">
                                    <h3 class="info-count">{{number_format($billAmount - $paidAmount)}}<span class="pull-right"><i class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                    <p class="info-text font-12">PKR </p>
                                    <p class="info-ot font-20">Balance</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-5">
                        <div class="white-box">
                            <h3 class="box-title">Basic Info</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Cnic</td>
                                                    <td> {{$vendor->cnic}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Rep Name</td>
                                                    <td> {{$vendor->rep_name}} </td>
                                                </tr>
                                                

                                                <tr>
                                                    <td>Opening Balance</td>
                                                    <td> {{$vendor->opening_balance}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Phone Number</td>
                                                    <td> {{$vendor->phone_number}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Email</td>
                                                    <td> {{$vendor->email}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Address</td>
                                                    <td> {{$vendor->address}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Status</td>
                                                    @if($vendor->status == true)
                                                    <td>Active </td>
                                                    @else
                                                    <td> InActive </td>
                                                    @endif
                                                </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$vendor->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$vendor->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>

                    <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Account Ledger</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table table-bordered" >
                                    <thead>
                                        <tr><th>Bill</th>
                                            <th>Date</th>
                                            <th>Category</th>
                                            <th>Memo</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Balance</th>
                                        </tr>
                                        
                                    </thead>
                                    <tbody>

                                        <?php $balance = $vendor->opening_balance;$debit = 0; $credit = 0;?>

                                        <tr>
                                            <td colspan="6" style="text-align: center;"><b>Opening Balance</b></td>
                                            <td><b>{{number_format($balance)}}</b></td>
                                        </tr>

                                        @foreach($records as $r)
                                        <tr>
                                            <td>{{$r['bill_id']}}</td>
                                            <td>{{date('d-m-Y',strtotime($r['date']))}}</td> 
                                            <td>{{$r['category']}}</td>
                                            
                                             <td>{{$r['memo']}}</td>

                                             
                                             @if($r['bill'])
                                             <td></td>
                                             <?php $balance -= $r['amount'];
                                             $credit -= $r['amount'];?>
                                             <td>{{number_format($r['amount'])}}</td>
                                             @else
                                             <td>{{number_format($r['amount'])}}</td>
                                             <td></td>
                                             <?php $balance += $r['amount'];
                                             $debit += $r['amount'];?>

                                             @endif

                                             <td>@if($balance >= 0)
                                             {{number_format($balance)}}
                                         @else
                                         ({{number_format(abs($balance))}})
                                         @endif
                                     </td>
                                        </tr>
                                        @endforeach

                                        <tr>
                                            <td colspan="4" style="text-align: center;"><b>Total</b></td>
                                            <td><b>{{number_format($debit)}}</b></td>
                                            <td><b>{{number_format(abs($credit))}}</b></td>
                                            <td><b>{{number_format($balance)}}</b></td>
                                        </tr>

                                        <tr>
                                            <td colspan="6" style="text-align: center;"><b>Closing Balance</b></td>
                                            <td>@if($balance >= 0)
                                             <b>{{number_format($balance)}}</b>
                                         @else
                                         (<b>{{number_format(abs($balance))}}</b>)
                                         @endif
                                     </td>
                                        </tr>

                                    </tbody>
                                </table>
                                    </div>

                        </div>
                    </div>
                </div>

                </div>
                <!-- /.row -->



              </div>
            <!-- /.container-fluid -->




@stop