

<?php $__env->startSection('title'); ?>
    Update Inventory
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-inventory')): ?>
            <li><a href="<?php echo e(route('inventory.all')); ?>">All Inventories</a></li>
        <?php endif; ?>
        <li class="active">Update Inventory</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
        $society = false;
        $highrise = false;
        $size = '';
        
        if ($projecttype->id == App\ProjectType::society) {
            $society = true;
            $size = \App\ProjectType::society_size;
        }
        
        if ($projecttype->id == App\ProjectType::high_rise) {
            $highrise = true;
            $size = \App\ProjectType::high_rise_size;
        }
        
    ?>
    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                <?php if($errors->any()): ?>
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            <?php echo implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')); ?>

                        </ul>
                    </div>
                <?php endif; ?>
                <div class="white-box">

                    <h3 class="box-title m-b-0"><i class="fa fa-dashboard"></i> Update Inventory</h3>
                    <p class="text-muted m-b-30 font-13"> Basic Information </p>
                    <form class="form-horizontal" action="<?php echo e(route('inventory.update')); ?>" method="post">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="id" value="<?php echo e($inventory->id); ?>">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Allocated</label>
                            <div class="col-sm-4">
                                <div class="input-group">

                                    <input type="radio" <?= $inventory->inventory_type == 0 ? 'checked' : '' ?> name="type"
                                        value="0" style="zoom: 1.6;" onchange="check_post(this)">
                                    <?php if($errors->has('type')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('type')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php if( $society): ?>

                                <label for="address" class="col-sm-2 control-label">Unallocated</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="radio" name="type" value="1"
                                            <?= $inventory->inventory_type == 1 ? 'checked' : '' ?> style="zoom: 1.6;"
                                            onchange="check_post(this)">
                                        <?php if($errors->has('type')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('type')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label" id="inventory_type">Unit / Serial
                                No</label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" name="unit_number"
                                    value="<?php echo e($inventory->unit_number); ?>" id="unit_number"
                                        placeholder="Enter Plot / Serial Number">
                                    <?php if($errors->has('unit_number')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('unit_number')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group">
                            <label for="address" class="col-sm-2 control-label" id="inventory_type">Select Project<span
                                style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select id="multipro" class="form-control chosen-select" name="multipro_id">
                                        <option value=""><b>None</b></option>
                                        <?php $__currentLoopData = $multi_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($inventory->multi_project_id == $pro->id): ?>
                                                <option selected="" value="<?php echo e($pro->id); ?>"><?php echo e($pro->name); ?>

                                                </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($pro->id); ?>"><?php echo e($pro->name); ?> </option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                    <?php if($errors->has('multipro_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('multipro_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        </div>

                        <div class="form-group" id="pricelist">
                            <label for="floor" class="col-sm-2 control-label">Price List<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select id="price_list_id" class="form-control chosen-select" name="price_list_id">
                                        <option value=""><b>None</b></option>
                                        <?php $__currentLoopData = $pricelist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($b->id == $inventory->pricelist_id): ?>
                                                <option selected=""  value="<?php echo e($b->id); ?>"><?php echo e($b->l_no); ?> </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($b->id); ?>"><?php echo e($b->l_no); ?> </option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                    <?php if($errors->has('price_list_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('price_list_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group" id="parent_div" style="display:<?= old('type') == 1 ? 'none' : '' ?>">
                            <?php if(\App\ProjectType::getProjectType() == \App\ProjectType::society): ?>
                                <label for="floor" class="col-sm-2 control-label">Unit Street<span
                                        style="color: red">*</span></label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select id="unit_floor_id" class="form-control chosen-select" name="unit_floor_id">
                                            <option value=""><b>None</b></option>
                                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($inventory->unit_floor_id == $b->id): ?>
                                            <option selected="" value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?> -
                                                <?php echo e($b->unitBlock ? $b->unitBlock->name : ''); ?></option>
                                        
                                                <?php else: ?>
                                                    <option value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?> -
                                                        <?php echo e($b->unitBlock ? $b->unitBlock->name : ''); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                        <?php if($errors->has('unit_floor_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('unit_floor_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if(\App\ProjectType::getProjectType() == \App\ProjectType::high_rise): ?>
                                <label for="floor" class="col-sm-2 control-label">Unit Floor<span
                                        style="color: red">*</span></label>

                                <div class="col-sm-4">
                                    <div class="input-group" style="margin-right: 6px;">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select id="unit_floor_id" class="form-control  " name="unit_floor_id">
                                            <option value=""><b>None</b></option>

                                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                                <?php if($inventory->unit_floor_id == $b->id): ?>
                                                <option selected="" value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?> - <?php echo e($b->unitBlock->name); ?></option> 
                                                <?php else: ?>
                                                <option value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?> - <?php echo e($b->unitBlock->name); ?></option> 
                                                <?php endif; ?> 
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            
                                           
                                        </select>
                                        <?php if($errors->has('unit_floor_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('unit_floor_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>


                            <?php endif; ?>
                        </div>
                        </div>

                      
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Type <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_type_id" name="unit_type_id">
                                        <option value=""><b>None</b></option>
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($inventory->unit_type_id == $t->id): ?>
                                        <option selected="" value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?>

                                        </option>
                                    <?php else: ?>
                                                <option value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php if($errors->has('unit_type_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('unit_type_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>

                            </div>
                            <?php if($society): ?>

<div class="form-group">
    <label for="address" class="col-sm-2 control-label">Size<span
            style="color: red">*</span></label>
    <div class="col-sm-4">
        <div class="input-group">
            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
            <select class="form-control chosen-select" id="unit_size_id" name="unit_size_id">
                <option value="">None</option>
                <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($inventory->unit_size_id == $s->id): ?>
                <option selected="" value="<?php echo e($s->id); ?>"> <?php echo e($s->name); ?>

                    <?php echo e($size); ?></option>
            <?php else: ?>
                        <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?>

                            <?php echo e($size); ?></option>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if($errors->has('unit_size_id')): ?>
                <span class="help-block">
                    <strong><?php echo e($errors->first('unit_size_id')); ?></strong>
                </span>
            <?php endif; ?>

        </div>
    </div>
</div>
<?php endif; ?>
<?php if($highrise): ?>
                            <input type='hidden' value="<?php echo e($list_amount); ?>" id='per_size_value' name='per_size_value'>
                            <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Unit Size<span
                                        style="color: red">*</span></label>
                                <div class="col-sm-4">
                                    <div class="input-group" style="margin-right: 6px;">
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        
                                        <select class="form-control " id='unit_size_id' name="unit_size_id">

                                            <option value="">None</option>
                                            <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($inventory->unit_size_id == $s->id): ?>
                                            <option selected="" value="<?php echo e($s->id); ?>"> <?php echo e($s->name); ?>

                                                <?php echo e($size); ?></option>
                                        <?php else: ?>
                                                    <option value="<?php echo e($s->id); ?>"
                                                        data-value='<?php echo e($s->name); ?>'><?php echo e($s->name); ?>

                                                        <?php echo e($size); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                        <?php if($errors->has('unit_size_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('unit_size_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
</div>    
                     
                        <?php endif; ?>
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Dimension (w*h)</label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" value="<?php echo e(old('area')); ?>"
                                        placeholder="Total Dimension" name="area"  value="<?php echo e($inventory->area); ?>">
                                    <?php if($errors->has('area')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('area')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label" style="margin-left: -2px;">Total Amount <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group" style="margin-right: 5px;">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="integer" class="form-control"   value="<?php echo e($inventory->total_price - $inventory->extra_amount); ?>"
                                        id="total_price" placeholder="Total Price" name="total_price">
                                    <?php if($errors->has('total_price')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('total_price')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        </div>



                      
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Unit Category </label>
                            <div class="col-sm-4">
                                <div class="input-group" style="margin-left:5px;">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" id="unit_category_id"
                                        name="unit_category_id[]" multiple="">
                                        <!--  <option value="" ><b>None</b></option> -->
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(in_array($c->id, $selected_categories)): ?>
                                        <option selected="" value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?>

                                        </option>
                                    <?php else: ?>
                                                <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>


                                    <?php if($errors->has('unit_category_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('unit_category_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label" style="margin-left: -2px;">Net Amount<span
                                    style="color: red">*</span> </label>
                            <div class="col-sm-4">
                                <div class="input-group" style="margin-right: 5px;">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="integer" class="form-control"value="<?php echo e($inventory->total_price); ?>"
                                        name="net_amount" id="net_amount" placeholder="Net Amount">
                                    <?php if($errors->has('net_amount')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('net_amount')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        </div>

                        



                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Description </label>
                            <div class="col-sm-4">
                                <div class="input-group" style="margin-left: 5px;">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>

                                    <input type="text" class="form-control" name="description"
                                    value="<?php echo e($inventory->description); ?>" id="description" placeholder="Description">
                                    <?php if($errors->has('description')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('description')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-group">
                            <label for="inputPassword3" class="col-sm-2 control-label"style="margin-left: -2px;">Status <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group" style="margin-right: 5px;">
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <select class="form-control chosen-select" name="status" onchange="infoBox(this.value)">
                                        <?php if($inventory->status == \App\Inventory::open || $inventory->status == \App\Inventory::package_open_file ): ?>
                                       <?php if($inventory->dealerPackageOpenFileUnit): ?>    
                                        <option value="<?php echo e(\App\Inventory::package_open_file); ?>" selected="">Open</option>
                                         
                                        <?php else: ?>
                                        <option value="<?php echo e(\App\Inventory::open); ?>" selected="">Open</option>
                                        
                                        <?php endif; ?>
                                            <option value="<?php echo e(\App\Inventory::hold_company); ?>">Company Hold</option>
                                            <option value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold</option>
                                            <option value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold</option>

                                            <option value="<?php echo e(\App\Inventory::sold); ?>">Sold</option>
                                        <?php elseif($inventory->status == \App\Inventory::sold): ?>
                                          
                                        <?php if($inventory->dealerPackageOpenFileUnit): ?>    
                                        <option value="<?php echo e(\App\Inventory::package_open_file); ?>"  >Open</option>
                                         
                                        <?php else: ?>
                                        <option value="<?php echo e(\App\Inventory::open); ?>"  >Open</option>
                                        
                                        <?php endif; ?>
                                            <option value="<?php echo e(\App\Inventory::hold_company); ?>">Company Hold</option>
                                            <option value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold</option>
                                            <option value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold</option>

                                            <option value="<?php echo e(\App\Inventory::sold); ?>" selected="">Sold</option>
                                        <?php elseif($inventory->status == \App\Inventory::hold_company): ?>
                                        <?php if($inventory->dealerPackageOpenFileUnit): ?>    
                                        <option value="<?php echo e(\App\Inventory::package_open_file); ?>"  >Open</option>
                                         
                                        <?php else: ?>
                                        <option value="<?php echo e(\App\Inventory::open); ?>"  >Open</option>
                                        
                                        <?php endif; ?>

                                            <option selected="" value="<?php echo e(\App\Inventory::hold_company); ?>">Company
                                                Hold</option>
                                            <option value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold</option>
                                            <option value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold</option>
                                            <option value="<?php echo e(\App\Inventory::sold); ?>">Sold</option>
                                        <?php elseif($inventory->status == \App\Inventory::token_hold): ?>
                                        <?php if($inventory->dealerPackageOpenFileUnit): ?>    
                                        <option value="<?php echo e(\App\Inventory::package_open_file); ?>" >Open</option>
                                         
                                        <?php else: ?>
                                        <option value="<?php echo e(\App\Inventory::open); ?>" >Open</option>
                                        
                                        <?php endif; ?>
                                            <option value="<?php echo e(\App\Inventory::hold_company); ?>">Company Hold</option>
                                            <option selected="" value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold
                                            </option>
                                            <option value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold</option>
                                            <option value="<?php echo e(\App\Inventory::sold); ?>">Sold</option>
                                        <?php elseif($inventory->status == \App\Inventory::temp_hold): ?>
                                        <?php if($inventory->dealerPackageOpenFileUnit): ?>    
                                        <option value="<?php echo e(\App\Inventory::package_open_file); ?>" >Open</option>
                                         
                                        <?php else: ?>
                                        <option value="<?php echo e(\App\Inventory::open); ?>" >Open</option>
                                        
                                        <?php endif; ?>

                                            <option value="<?php echo e(\App\Inventory::hold_company); ?>">Company Hold</option>
                                            <option value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold</option>
                                            <option selected="" value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold
                                            </option>
                                            <option value="<?php echo e(\App\Inventory::sold); ?>">Sold</option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        </div>
                     
                        <div id="info" style="display: none;">



                            <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Dealer</label>
                                <div class="col-sm-4">
                                    <div class="input-group" style="margin-left: 5px;" >
                                        <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                        <select class="form-control chosen-select" name="dealer_id">
                                            <option value=""><b>None</b></option>
                                            <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($inventory->dealer_id == $d->id): ?>
                                                    <option selected="" value="<?php echo e($d->id); ?>">
                                                        <?php echo e($d->name); ?></option>
                                                <?php else: ?>
                                                    <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('dealer_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('dealer_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div id="infoC">

<div class="form-group">
    <label for="exampleInputEmail1" class="col-sm-2 control-label" style="margin-left: -2px;">Token Amount </label>
    <div class="col-sm-4">
        <div class="input-group" style="margin-right: 5px;">
            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
            <input type="text" class="form-control"
                value="<?php echo e($inventory->token_amount); ?>" name="token_amount"
                placeholder="Token Amount">
            <?php if($errors->has('Token Amout')): ?>
                <span class="help-block">
                    <strong><?php echo e($errors->first('Token Amount')); ?></strong>
                </span>
            <?php endif; ?>
        </div>
    </div>
</div>
                            </div>

                         

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Name</label>
                                    <div class="col-sm-4">
                                        <div class="input-group" style="margin-left: 10px;">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="<?php echo e($inventory->name); ?>"
                                                name="name" id="name" placeholder="Name">
                                            <?php if($errors->has('name')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('name')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label"style="margin-left: -5px;">CNIC </label>
                                    <div class="col-sm-4">
                                        <div class="input-group" style="margin-right: 10px;">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="<?php echo e($inventory->cnic); ?>"
                                                name="cnic" placeholder="CNIC">
                                            <?php if($errors->has('cnic')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('cnic')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                </div>
                               
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number </label>
                                    <div class="col-sm-4">
                                        <div class="input-group" style="margin-left: 10px;">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control"
                                                value="<?php echo e($inventory->phone_number); ?>" name="phone_number"
                                                placeholder="Phone Number">
                                            <?php if($errors->has('phone_number')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('phone_number')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label"style="margin-left: -5px;">Email </label>
                                    <div class="col-sm-4">
                                        <div class="input-group"  style="margin-right: 10px;">
                                            <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                            <input type="text" class="form-control" value="<?php echo e($inventory->email); ?>"
                                                name="email" placeholder="Email">
                                            <?php if($errors->has('email')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('email')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                </div>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light "
                                    style="width: 100%">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        <?php if($inventory->inventory_type == 1): ?>
        $('#parent_div').hide()
                $('#inventory_type').html('Inventory Id')

               
                $('#unit_floor_id').html('<option selected value=""></option>');


        <?php endif; ?>
        function check_post(self) {

            if ($(self).val() == 1) { //unallocated portion
                $('#parent_div').hide()
                $('#inventory_type').html('Inventory Id')

                var data = {
                    'type': $(self).val()
                };
                $('#unit_floor_id').html('<option selected value=""></option>');


                // $.get('/getNillFloor', data, function(data) {

                //     $('#unit_floor_id').html('<option selected value="' + data.output.id + '">' + data.output.name +
                //         '</option>');

                //     // $(".chosen-select").val(data.output.id).trigger("chosen:updated");
                // }, 'json');



            } else {

                $('#parent_div').show()
                $('#inventory_type').html('Plot / Serial No')

                var data = {
                    'type': $(self).val()
                };

                $.get('/getNillFloor', data, function(data) {

                    $option = '<option selected value="0">none</option>';

                    $.each(data.output, function(index, val) {
                        $option += '<option  value="' + val.id + '">' + val.name + '</option>';
                    });
                    $('#unit_floor_id').html($option);
                    $(".chosen-select").val(0).trigger("chosen:updated");
                }, 'json');
            }
        }

        <?php if($highrise): ?>
            $('#unit_type_id').change(function() {

                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var pricelist_id = $('#price_list_id').find(":selected").val();
                var project_type = <?php echo e(App\ProjectType::high_rise); ?>

                if (floor && type) {
                    var data = {
                        'floor': floor,
                        'type': type,
                        'pricelist_id': pricelist_id,
                        'project_type': project_type
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#per_size_value').val(data);

                        siz = $('#size').val();
                        if (siz > 0 && data > 0) {

                            // $('#total_price').val( siz*data);
                            //     $('#net_amount').val( siz*data);
                        } else {

                            $('#total_price').val(0);
                            $('#net_amount').val(0);
                        }

                        // $('#total_price').val(data);
                        // $('#net_amount').val(data);
                    });
                }
            });
            $("#unit_size_id").select2({

                    width: '100%',
                    tags: true,
                    createTag: function(params) {
                        var term = $.trim(params.term);

                        // Regular expression to check if input is a number (integer or float)
                        var numberRegex = /^[-+]?[0-9]*\.?[0-9]+$/;

                        // Return the tag if it's a valid number, otherwise return null
                        if (numberRegex.test(term)) {
                            return {
                                id: 'create' + term,
                                text: term + ' <?php echo e($size); ?>',
                                value: 'tttt',
                                newTag: true, // add additional parameters



                                newOption: true
                            };
                        }

                        return null;
                    }
                }

            ).on('change', function() {
                var sizevalue = $(this).find(":selected").data("value");
                if (isNaN(sizevalue)) {
                    var word = "create";
                    sizevalue = $(this).val();
                    sizevalue = sizevalue.replace(word, "");
                }







                value = $('#per_size_value').val();

                $('#total_price').val(0);
                $('#net_amount').val(0);

                var s = sizevalue * value;
                $('#total_price').val(Math.round(s));
                $('#net_amount').val(Math.round(s));
            });

           
        <?php endif; ?>
        <?php if($society): ?>
            $('#unit_size_id').change(function() {
                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var size = $('#unit_size_id').val();
                var pricelist_id = $('#price_list_id').find(":selected").val();
                var project_type = <?php echo e(App\ProjectType::society); ?>


                // if (floor && type && size) {
                if (type && size) {
                    var data = {
                        'floor': floor,

                        'type': type,
                        'size': size,
                        'pricelist_id': pricelist_id,
                        'project_type': project_type
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#total_price').val(data);
                        $('#net_amount').val(data);
                    });
                }
            });

            $('#unit_type_id').change(function() {
                $('#total_price').val(0);
                $('#net_amount').val(0);
            });
        <?php endif; ?>
        $('#unit_floor_id').change(function() {
            <?php if($highrise): ?>
                var floor = $('#unit_floor_id').val();

                var pricelist_id = $('#price_list_id').find(":selected").val();
                var project_type = <?php echo e(App\ProjectType::high_rise); ?>


                var data = {
                    'floor': floor,
                    'pricelist_id': pricelist_id,
                    'project_type': project_type
                };






                $.get('/getTypeByFloor', data, function(data) {
                    $('#unit_type_id option').remove();

                    $('#unit_type_id').append('<option value="">None</option>');
                    for (i = 0; i < data.name.length; i++) {
                        $('#unit_type_id').append('<option value="' + data.id[i] + '">' + data.name[i] +
                            '</option>');
                    }
                    //         $('#total_price').val(data);
                    //         $('#net_amount').val(data);
                    $('#unit_type_id').trigger('chosen:updated');

                });
            <?php endif; ?>

            <?php if($society): ?>


                var floor = $('#unit_floor_id').val();
                var type = $('#unit_type_id').val();
                var size = $('#unit_size_id').val();



                if (floor && type && size) {
                    var data = {
                        'floor': floor,
                        'type': type,
                        'size': size
                    };

                    $.get('/getRateByFloor', data, function(data) {

                        $('#total_price').val(data);
                        $('#net_amount').val(data);
                    });
                }
            <?php endif; ?>
        });


        $('#price_list_id').change(function() {
            $('#total_price').val(0);
            $('#net_amount').val(0);
            <?php if($highrise): ?>
                var pricelist_id = $('#price_list_id').find(":selected").val();
                var data = {
                    'price_list_id': pricelist_id
                };
                $.get('/getFloorByPrice', data, function(data) {

                    $('#unit_floor_id').empty();
                    $('#unit_floor_id').append('<option value="">None</option>');
                    for (i = 0; i < data.name.length; i++) {
                        $('#unit_floor_id').append('<option value="' + data.id[i] + '">' + data.name[i] +
                            '</option>');
                    }


                    $('#unit_floor_id').chosen();

                });
            <?php endif; ?>



        });

        $('#unit_category_id').change(function() {
            var category = $('#unit_category_id').val();

            var amount = parseInt($('#total_price').val());
            var sum = 0;
            if (category && amount > 0) {
                for (i = 0; i < category.length; i++) {
                    categories = <?php echo json_encode($categories); ?>;
                    obj = categories.find(obj => obj.id == category[i]);
                    percent = parseFloat(obj['percent']);
                    if (obj['is_percent'])
                        sum += (amount * percent) / 100;
                    else
                        sum += percent;


                }
                sum += amount;
                $('#net_amount').val(sum);

            } else {
                $('#net_amount').val(amount);
            }


        });
        function infoBox(val) {

if (val == '<?php echo e(\App\Inventory::token_hold); ?>') {
    document.getElementById('info').style.display = 'block';
    document.getElementById('infoC').style.display = 'block';
} else if (val == '<?php echo e(\App\Inventory::temp_hold); ?>') {
    document.getElementById('info').style.display = 'block';
    document.getElementById('infoC').style.display = 'none';
} else {
    document.getElementById('info').style.display = 'none';
}

}

val = '<?php echo e($inventory->status); ?>';
if (val == '<?php echo e(\App\Inventory::token_hold); ?>') {
document.getElementById('info').style.display = 'block';
}
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/inventory/edit-inventory.blade.php ENDPATH**/ ?>