

<?php $__env->startSection('title'); ?>
    Add New Transfer
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo e(route('transfer.all')); ?>">Transfers</a></li>
        <li class="active">Add New Transfer</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

    <style type="text/css">

    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid">
        <div class="row">

            <form method='post' autocomplete="off" action="<?php echo e(route('transfer.insert')); ?>" enctype="multipart/form-data">
                <?php echo e(csrf_field()); ?>

                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Add New Transfer</h3>
                        <p class="text-muted m-b-30 font-13"> Note: All * fields are mandatory </p>
                        <hr>


                        <div class="col-lg-12 col-sm-12 col-xs-12">
                            <div class="white-box">
                                <h3 class="box-title">Unit Information</h3>
                                <hr>
                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label style="padding-top: 8px;" class="control-label col-md-4">Unit No<span
                                                style="color:red">*</span></label>
                                        <div class="col-md-8">
                                            <select class="form-control chosen-select" id="property-no" name="property_id"
                                                onchange="updateSchedule()">
                                                <option value="" selected="">None</option>
                                                <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($p->id); ?>">
                                                        
                                                                    <?php if($p->inventory->registration): ?>
                                                                        <?php echo e($p->inventory->registration->registrationNo->number); ?>

                                                                    <?php endif; ?>
                                                                    - <?php echo e($p->inventory->unit_number); ?>

                                                                
                                                            
                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if($errors->has('property_id')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('property_id')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Owner Name</label>
                                        <div class="col-md-8">

                                            <input type="text" readonly="" class="form-control" id="owner-name"
                                                name="owner_name" value="<?php echo e(old('owner_name')); ?>" placeholder="Owner Name">
                                            <?php if($errors->has('owner-name')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('owner-name')); ?></strong>
                                                </span>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>

                                <br>

                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Old Ref #</label>
                                        <div class="col-md-8">

                                            <input type="text" readonly="" class="form-control" id="old_client_id"
                                                name="old_client_id" value="<?php echo e(old('old_client_id')); ?>"
                                                placeholder="old_ref_no">
                                            <?php if($errors->has('old_client_id')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('old_client_id')); ?></strong>
                                                </span>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12 col-sm-12 col-xs-12">
                                    <div class="white-box">
                                        <h3 class="box-title">Customer Information </h3>





                                        <!-- Nav tabs -->
                                        <ul class="nav customtab nav-tabs" role="tablist"
                                            style="    background: #87c490;color: white;">
                                            <li style="    border: 1px solid #29b329;" role="presentation" class="active"><a
                                                    href="#home1" aria-controls="home" role="tab" data-toggle="tab"
                                                    aria-expanded="true" style="font-weight: 700;"><span
                                                        class="visible-xs"><i class="ti-home"></i></span><span
                                                        class="hidden-xs"> New Customer</span></a></li>
                                            <li style="border: 1px solid #29b329;" role="presentation" class=""><a
                                                    href="#profile1" aria-controls="profile" role="tab"
                                                    data-toggle="tab" aria-expanded="false" style="font-weight: 700;"><span
                                                        class="visible-xs"><i class="ti-user"></i></span> <span
                                                        class="hidden-xs">Existing Customer</span></a></li>

                                        </ul>
                                        <!-- Tab panes -->
                                        <div class="tab-content">
                                            <div role="tabpanel" class="tab-pane fade" id="profile1">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Name of Applicant</label>
                                                        <div class="col-md-9">
                                                            <select class="form-control chosen-select" name="customer_id"
                                                                autofocus="off" style="width: 100%!important;">
                                                                <option value="" selected="" disabled="">None
                                                                </option>
                                                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if(isset($customer)): ?>
                                                                        <?php if($customer->id == $c->id): ?>
                                                                            <option value="<?php echo e($c->id); ?>"
                                                                                selected=""><?php echo e($c->name); ?>

                                                                            </option>
                                                                        <?php endif; ?>
                                                                    <?php else: ?>
                                                                        <?php if(old('customer_id') == $c->id): ?>
                                                                            <option value="<?php echo e($c->id); ?>"
                                                                                selected=""><?php echo e($c->name); ?>

                                                                            </option>
                                                                        <?php else: ?>
                                                                            <option value="<?php echo e($c->id); ?>">
                                                                                <?php echo e($c->name); ?></option>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="clearfix"></div>
                                                <button type="button" style="float: left!important;"
                                                    class="btn btn-primary add_field_button1">Add Nominee</button>
                                                <div class="input_fields_wrap2">
                                                    <div class="clearfix"></div>
                                                    <div>
                                                    </div>


                                                </div>
                                            </div>




                                            <div role="tabpanel" class="tab-pane fade  active in" id="home1">

                                                <div class="form-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Name of Applicant
                                                                    <span style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="name" value="<?php echo e(old('name')); ?>"
                                                                        placeholder="Enter Name">
                                                                    <?php if($errors->has('name')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('name')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">S/O D/O W/O <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="father_name"
                                                                        value="<?php echo e(old('father_name')); ?>" placeholder="">
                                                                    <input type="radio" name="father_type"
                                                                        value="1">S/O
                                                                    <input type="radio" name="father_type"
                                                                        value="2">D/O
                                                                    <input type="radio" name="father_type"
                                                                        value="3"> W/O
                                                                    <?php if($errors->has('father_name')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('father_name')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">CNIC <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        value="<?php echo e(old('cnic')); ?>" name="cnic"
                                                                        id="cnic"
                                                                        data-inputmask="'mask': '9999999999999'"
                                                                        placeholder="XXXXXXXXXXXXX">
                                                                    <input type="radio" name="cnic_flag"
                                                                        value="1"> Locally
                                                                    <input type="radio" name="cnic_flag"
                                                                        value="2"> Internationally
                                                                    <?php if($errors->has('cnic')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('cnic')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Passport No.</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        value="<?php echo e(old('passport_no')); ?>"
                                                                        name="passport_no" id="passport_no"
                                                                        placeholder="XXXXXXXXX">
                                                                    <?php if($errors->has('passport_no')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('passport_no')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Date of Birth <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="date" class="form-control"
                                                                        value="<?php echo e(old('dob')); ?>" name="dob"
                                                                        max="<?php echo e(date('Y-m-d')); ?>" id="dob"
                                                                        placeholder="XX-XX-XXXX">
                                                                    <?php if($errors->has('dob')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('dob')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Occupation </label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        value="<?php echo e(old('occupation')); ?>" name="occupation"
                                                                        id="occupation">
                                                                    <?php if($errors->has('occupation')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('occupation')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>



                                                        <div class="clearfix"></div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Mailing Address <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <textarea class="form-control" name="mailing_address" id="mailing_address"><?php echo e(old('mailing_address')); ?></textarea>
                                                                    <?php if($errors->has('mailing_address')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('mailing_address')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Permanent Address
                                                                    <span style="color: red">*</span></label> &nbsp;
                                                                &nbsp;&nbsp;same as above <input type="checkbox"
                                                                    id="same_address" name="same_address">
                                                                <div class="col-md-9">
                                                                    <textarea class="form-control" name="permanent_address" id="permanent_address"><?php echo e(old('permanent_address')); ?></textarea>
                                                                    <?php if($errors->has('permanent_address')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('permanent_address')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Email</label>
                                                                <div class="col-md-9">
                                                                    <input type="email" class="form-control"
                                                                        name="email" value="<?php echo e(old('email')); ?>"
                                                                        id="exampleInputEmail1" placeholder="Enter email">

                                                                    <?php if($errors->has('address')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('address')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Password</label>
                                                                <div class="col-md-9">
                                                                    <input type="password" class="form-control"
                                                                        name="password" value="<?php echo e(old('password')); ?>"
                                                                        id="exampleInputEmail1"
                                                                        placeholder="Enter Password">

                                                                    <?php if($errors->has('password')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('password')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Mobile Number <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        type='number' name="mobile_number"
                                                                        value="<?php echo e(old('mobile_number')); ?>"
                                                                        placeholder="Enter Mobile Number">
                                                                    <label style="text-align: right">Note (use comma for
                                                                        multiple numbers)</label>
                                                                    <?php if($errors->has('mobile_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('mobile_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="clearfix"></div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Residential
                                                                    Number</label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        name="res_number" value="<?php echo e(old('res_number')); ?>"
                                                                        placeholder="Enter Res. Number">
                                                                    <?php if($errors->has('res_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('res_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Phone Number</label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        type='number' name="phone_number"
                                                                        value="<?php echo e(old('phone_number')); ?>"
                                                                        placeholder="Enter Phone Number">
                                                                    <?php if($errors->has('phone_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('phone_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="clearfix"></div>
                                                        <div class="form-group">
                                                            <label for="exampleInputEmail1"
                                                                class="col-sm-2 control-label">Picture <span
                                                                    style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <div class="input-group-addon"><i
                                                                            class="icon-picture"></i></div>
                                                                    <input type="file" class="form-control"
                                                                        name="file">
                                                                    <?php if($errors->has('file')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('file')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="exampleInputEmail1"
                                                                class="col-sm-2 control-label">Documents (CNIC, Passport
                                                                etc) <span style="color: red">*</span></label>
                                                            <div class="col-sm-10">
                                                                <div class="input-group">
                                                                    <div class="input-group-addon"><i
                                                                            class="icon-picture"></i></div>
                                                                    <input multiple="" type="file"
                                                                        class="form-control" name="photos[]">
                                                                    <?php if($errors->has('document')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('document')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                        <hr>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Nominee Name <span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="nominee_name"
                                                                        value="<?php echo e(old('nominee_name')); ?>"
                                                                        id="exampleInputuname" placeholder="Enter Name">
                                                                    <?php if($errors->has('nominee_name')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_name')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">S/O, D/O, W/O.<span
                                                                        style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="nominee_so_do_wo"
                                                                        value="<?php echo e(old('nominee_so_do_wo')); ?>"
                                                                        id="exampleInputuname"
                                                                        placeholder="Enter Father Name">
                                                                    <input type="radio" name="nominee_father_type"
                                                                        value="1">S/O
                                                                    <input type="radio" name="nominee_father_type"
                                                                        value="2">D/O
                                                                    <input type="radio" name="nominee_father_type"
                                                                        value="3"> W/O
                                                                    <?php if($errors->has('nominee_so_do_wo')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_so_do_wo')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">CNIC</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        value="<?php echo e(old('nominee_cnic')); ?>"
                                                                        name="nominee_cnic" id="nominee_cnic"
                                                                        data-inputmask="'mask': '9999999999999'"
                                                                        placeholder="XXXXXXXXXXXXX">
                                                                    <input type="radio" name="nominee_cnic_flag"
                                                                        value="1"> Locally
                                                                    <input type="radio" name="nominee_cnic_flag"
                                                                        value="2"> Internationally
                                                                    <?php if($errors->has('nominee_cnic')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_cnic')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Passport No.</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        value="<?php echo e(old('nominee_passport_no')); ?>"
                                                                        name="nominee_passport_no"
                                                                        id="nominee_passport_no" placeholder="XXXXXXXXX">
                                                                    <?php if($errors->has('nominee_passport_no')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_passport_no')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Relation With
                                                                    Applicant <span style="color: red">*</span></label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="nominee_relation"
                                                                        value="<?php echo e(old('nominee_relation')); ?>"
                                                                        placeholder="Enter Relation">
                                                                    <?php if($errors->has('nominee_relation')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_relation')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Email</label>
                                                                <div class="col-md-9">
                                                                    <input type="text" class="form-control"
                                                                        name="nominee_email"
                                                                        value="<?php echo e(old('nominee_email')); ?>"
                                                                        placeholder="Enter Email">
                                                                    <?php if($errors->has('nominee_email')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_email')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>

                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Mobile Number
                                                                </label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        name="nominee_mobile_number"
                                                                        value="<?php echo e(old('nominee_mobile_number')); ?>"
                                                                        placeholder="Enter Mobile Number">
                                                                    <?php if($errors->has('nominee_mobile_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_mobile_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Res. Number </label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        name="nominee_res_number"
                                                                        value="<?php echo e(old('nominee_res_number')); ?>"
                                                                        placeholder="Enter Res Number">
                                                                    <?php if($errors->has('nominee_res_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_res_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="clearfix"></div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label col-md-3">Phone Number </label>
                                                                <div class="col-md-9">

                                                                    <input type="text" class="form-control"
                                                                        name="nominee_phone_number"
                                                                        value="<?php echo e(old('nominee_phone_number')); ?>"
                                                                        placeholder="Enter Phone Number">
                                                                    <?php if($errors->has('nominee_phone_number')): ?>
                                                                        <span class="help-block">
                                                                            <strong><?php echo e($errors->first('nominee_phone_number')); ?></strong>
                                                                        </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="clearfix"></div>


                                                    </div>

                                                    <div class="clearfix"></div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <br>

                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Transfer Charges <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">

                                            <input type="text" class="form-control" id="transfer_charges"
                                                name="transfer_charges" value="<?php echo e(old('transfer_charges')); ?>"
                                                placeholder="">
                                            <?php if($errors->has('transfer_charges')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('transfer_charges')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>



                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Transfer Date <span
                                                style="color:red">*</span></label>
                                        <div class="col-md-8">

                                            <input type="date" class="form-control" name="transfer_date"
                                                value="<?php echo e(old('transfer_date')); ?>" id="exampleInputEmail1"
                                                placeholder="Transfer Date">
                                            <?php if($errors->has('transfer_date')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('transfer_date')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <br>

                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Cost Of unit</label>
                                        <div class="col-md-8">

                                            <input type="text" readonly="" id='cost-amount' class="form-control"
                                                name="cost" value="<?php echo e(old('cost')); ?>" placeholder="Cost Amount">
                                            <?php if($errors->has('cost')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('cost')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                            <div style="color:black;" class="help-block" id='cost-amount-label'></div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Transfer Note</label>
                                        <div class="col-md-8">

                                            <textarea class="form-control" name="transfer_note" value="<?php echo e(old('transfer_note')); ?>"></textarea>
                                            <?php if($errors->has('transfer_note')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('transfer_note')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>




                                <br>

                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Received Amount</label>
                                        <div class="col-md-8">

                                            <input type="text" class="form-control" readonly=""
                                                id="received-amount" name="received_amount"
                                                value="<?php echo e(old('received_amount')); ?>">
                                            <?php if($errors->has('received_amount')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('received_amount')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Pending Due</label>
                                        <div class="col-md-8">

                                            <input type="text" class="form-control" disabled="" id="pending_due"
                                                name="pending_due" value="<?php echo e(old('pending_due')); ?>">
                                            <?php if($errors->has('pending_due')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('pending_due')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>



                            </div>
                        </div>


                    </div>
                </div>

                <!--receipt module -->
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">
                        <h3 class="box-title">Receipt Info</h3>
                        <hr>
                        <div id="receipt_div">

                            <div class="col-md-6" style="margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Payment Head <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="payment_head">
                                            <?php if(old('payment_head') == \App\Receipt::transfer_fee): ?>
                                                <option value="<?php echo e(\App\Receipt::transfer_fee); ?>" selected="">Transfer
                                                    Fee</option>
                                            <?php else: ?>
                                                <option value="<?php echo e(\App\Receipt::transfer_fee); ?>">Transfer Fee</option>
                                            <?php endif; ?>
                                        </select>
                                        <?php if($errors->has('payment_head')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('payment_head')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" style="margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Payment Mode <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name='payment_mode'
                                            onchange="changeFunc(this.value)">
                                            <?php if(old('payment_mode') == \App\Receipt::cash): ?>
                                                <option value="<?php echo e(\App\Receipt::cash); ?>" selected="">Cash</option>
                                                <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer</option>
                                                <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque</option>
                                                <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <?php elseif(old('payment_mode') == \App\Receipt::bank): ?>
                                                <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                <option value="<?php echo e(\App\Receipt::bank); ?>" selected="">Bank Transfer
                                                </option>
                                                <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque</option>
                                                <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <?php elseif(old('payment_mode') == \App\Receipt::cheque): ?>
                                                <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer</option>
                                                <option value="<?php echo e(\App\Receipt::cheque); ?>" selected="">Cheque</option>
                                                <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <?php elseif(old('payment_mode') == \App\Receipt::cheque): ?>
                                                <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer</option>
                                                <option value="<?php echo e(\App\Receipt::cheque); ?>" selected="">Cheque</option>
                                                <option selected="" value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment
                                                </option>
                                            <?php else: ?>
                                                <option selected='' value="<?php echo e(\App\Receipt::cash); ?>" selected="">
                                                    Cash</option>
                                                <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer</option>
                                                <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque</option>
                                                <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <?php endif; ?>
                                        </select>
                                        <?php if($errors->has('payment_mode')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('payment_mode')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" id='bank' style="display: none;margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Depositor Bank Name</label>
                                    <div class="col-md-8">
                                        <select name="bank_name" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(old('bank_name') == $bank->id): ?>
                                                    <option selected="" value="<?php echo e($bank->id); ?>">
                                                        <?php echo e($bank->name); ?></option>
                                                <?php else: ?>
                                                    <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('bank_name')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('bank_name')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div id='adjustment' style="display: none;">
                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Type <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select class="form-control chosen-select" name='adjustment_type'>
                                                <?php if(old('adjustment_type') == \App\ProjectAccount::property): ?>
                                                    <option value="<?php echo e(\App\ProjectAccount::property); ?>" selected="">
                                                        Property</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::vehicle); ?>">Vehicle</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::others); ?>">Others</option>
                                                <?php elseif(old('adjustment_type') == \App\ProjectAccount::vehicle): ?>
                                                    <option value="<?php echo e(\App\ProjectAccount::property); ?>">Property</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::vehicle); ?>" selected="">
                                                        Vehicle</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::others); ?>">Others</option>
                                                <?php elseif(old('adjustment_type') == \App\ProjectAccount::others): ?>
                                                    <option value="<?php echo e(\App\ProjectAccount::property); ?>">Property</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::vehicle); ?>">Vehicle</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::others); ?>" selected="">
                                                        Others</option>
                                                <?php else: ?>
                                                    <option selected='' value="<?php echo e(\App\ProjectAccount::property); ?>"
                                                        selected="">Property</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::vehicle); ?>">Vehicle</option>
                                                    <option value="<?php echo e(\App\ProjectAccount::others); ?>">Others</option>
                                                <?php endif; ?>
                                            </select>
                                            <?php if($errors->has('adjustment_type')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('adjustment_type')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6" style="margin-bottom: 10px;">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Detail <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <textarea name="adjustment_detail" class="form-control"></textarea>

                                            <?php if($errors->has('adjustment_detail')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('adjustment_detail')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" id='company-bank' style="display: none;margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Company Account</label>
                                    <div class="col-md-8">
                                        <select name="company_account" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            <?php $__currentLoopData = $cBanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(old('bank_name') == $bank->id): ?>
                                                    <option selected="" value="<?php echo e($bank->id); ?>">
                                                        <?php echo e($bank->name); ?> - <?php echo e($bank->account_number); ?></option>
                                                <?php else: ?>
                                                    <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?> -
                                                        <?php echo e($bank->account_number); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('company_account')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('company_account')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" id='cheque' style="display: none;margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Cheque Number</label>
                                    <div class="col-md-8">
                                        <input type="text" name='cheque_number' value="<?php echo e(old('cheque_number')); ?>"
                                            class="form-control" id="exampleInputEmail1"
                                            placeholder="Enter Check Number">
                                        <?php if($errors->has('cheque_number')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('cheque_number')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6" style="margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <input type="text" name="amount" value="<?php echo e(old('amount')); ?>"
                                            class="form-control" id="receipt_amount" placeholder="Enter Amount">
                                        <?php if($errors->has('amount')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('amount')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6" style="margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Receipt Date <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <input type="date" class="form-control" name='receipt_date'
                                            value="<?php echo e(old('receipt_date')); ?>" id="receipt_date"
                                            placeholder="Enter Registration Date">
                                        <?php if($errors->has('receipt_date')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('receipt_date')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <br>
                            <div class="clearfix"></div>

                            
                            <div class="col-md-6" style="margin-bottom: 10px;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Receipt Number<span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <?php if(old('receipt_no')): ?>
                                    <input type="text" class="form-control" name='receipt_no' value="<?php echo e(old('receipt_no')); ?>" id="exampleInputEmail1" placeholder="Enter Receipt Number">
                                    <?php else: ?>
                                    <input type="text" class="form-control" name='receipt_no' value="<?php echo e($receipt_no); ?>" id="exampleInputEmail1" placeholder="Enter Receipt Number">
                                    <?php endif; ?>
                                    <!--<input type="text" class="form-control" name='receipt_no' value="<?php echo e(old('receipt_no')); ?>" id="exampleInputEmail1" placeholder="Enter Receipt Number">-->
                                    <?php if($errors->has('receipt_no')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('receipt_no')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                </div>
                          </div>

                        </div>

                        <hr>

                        <br>
                        <div class="form-group m-b-0 pull-right">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                            </div>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        $(":input").inputmask();

        function updateSchedule() {
            $('.preloader').fadeIn();
            var id = $('#property-no').val();

            var data = {
                'id': id
            };

            $.get('/transfer/updateInfo', data, function(data) {

                if (data) {
                    $('#cost-amount').val(new Intl.NumberFormat().format(data['info'].net_pay));
                    $('#owner-name').val(data['info'].customer.name);
                    $('#old_client_id').val(data['info'].membership_no);
                    $('#received-amount').val(new Intl.NumberFormat().format(data['received']));

                    $('#pending_due').val(new Intl.NumberFormat().format(data['due']));

                    if (data['due'] > 0) {
                        toastr.error('Pending Due Amount.');
                    }

                }

            });
            $('.preloader').fadeOut();
        }

        $('#country_id').change(function() {
            $('.preloader').fadeIn();
            var data = {
                'country_id': $(this).val()
            };

            $.get('/getCitiesByCountry', data, function(data) {
                var model = $('#city_id');
                model.empty();

                model.append("<option value='' disabled selected>" + '' + "</option>");


                $.each(data, function(index, element) {
                    model.append("<option value='" + element.id + "'>" + element.name +
                    "</option>");
                });
            });
            $('.preloader').fadeOut();
        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/transfer/add-transfer.blade.php ENDPATH**/ ?>