

<?php $__env->startSection('title'); ?>
All Transfer Properties 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Transfers</li>
      </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								<a href="<?php echo e(route('transfer.addView')); ?>" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Transfer
								</a>
							</div>
                            <h3 class="box-title">All Transfers</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
<!--                                            <th>Block & unit</th>
                                            <th>unit Size</th>-->
                                            <th>Unit #</th>
                                            <th>Owner Name</th>
                                            <th>Transfer to</th>
                                            <th>Cost Amount</th>
                                            <th>Paid Amount</th>

                                            <th>Transfer Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        <?php $__currentLoopData = $allTransfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($count++); ?></td>

                                             <td><b><?php echo e($t->property->inventory->unit_number); ?></b></td>
                                            <td><?php echo e($t->owner ? $t->owner->name: ''); ?></td>
                                            <td><?php echo e($t->transfer ? $t->transfer->name: ''); ?></td>

                                             <td><?php echo e(number_format($t->property->net_pay)); ?> PKR</td>
                                            <td><?php echo e(number_format($t->amount_paid)); ?> PKR</td>




                                            <td><?php echo e(date('d-m-Y', strtotime($t->transfer_date))); ?></td>

                                            <td class="text-nowrap">
                                                <a href="<?php echo e(route('transfer.detail',['id'=>$t->id])); ?>" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
<!--                                                <a href="<?php echo e(route('transfer.editView',['id'=>$t->id])); ?>" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>-->
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/transfer/index.blade.php ENDPATH**/ ?>