

<?php $__env->startSection('title'); ?>
    All Receipts
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (\Illuminate\Support\Facades\Blade::check('permission', 'print-receipt')): ?>
<?php $print_receipt = true; ?>
<?php else: ?>
<?php $print_receipt = false; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-receipt')): ?>
<?php $view_receipt = true; ?>
<?php else: ?>
<?php $view_receipt = false; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-receipt')): ?>
<?php $edit_receipt = true; ?>
<?php else: ?>
<?php $edit_receipt = false; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('permission', 'download-receipt')): ?>
<?php $download_receipt = true; ?>
<?php else: ?>
<?php $download_receipt = false; ?>
<?php endif; ?>

<?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-receipt')): ?>
<?php $delete_receipt = true; ?>
<?php else: ?>
<?php $delete_receipt = false; ?>
<?php endif; ?>

    <div class="container-fluid">


        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <div class="pull-right">


                        
                    </div>

                    <h3 class="box-title">All Refund Receipt List</h3>

                    <ul class="nav customtab nav-tabs" role="tablist">

                        <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab"
                                data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                        class="ti-home"></i></span><span class="hidden-xs">Close Unit  
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);"><?php echo e(number_format($totalAmount)); ?></span>
                                   
                                </span>
                            </a></li>

                            <?php if($projectType->id == \App\ProjectType::society): ?>    
                        <li role="presentation" class=""><a href="#open_file" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Open File  
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);"><?php echo e(number_format($openfile_count)); ?> </span>
                                    
                                </span></a></li>
                                <?php endif; ?>

                    </ul>




                    <div class="tab-content">
                        <div id="close_file" class="tab-pane fade in active">
                    <div class="table-responsive">
                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Receipt No.</th>
                                        <th>Project</th>
                                        <th>Unit No. </th>
                                        <th>Payment Method</th>
    
                                        <th>Received Amount </th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
    
    
    
                                    <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($receipt->receipt_no); ?></td>
                                            <td><?php echo e($receipt->multiProject ? $receipt->multiProject->name : 'None'); ?></td>
    
                                            <td><?php echo e($receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : ''); ?>

                                            </td>
    
    
                                            <?php if($receipt->payment_method == \App\Receipt::cash): ?>
                                                <td>Cash</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?>
                                                <td>Bank</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?>
                                                <td>Adjustment</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?>
                                                <td>Cheque</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::merging): ?>
                                                <td>Merging</td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>
    
    
    
    
    
                                            <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                                <td><?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?> PKR</td>
                                            <?php else: ?>
                                                <td><?php echo e(number_format($receipt->amount)); ?> PKR</td>
                                            <?php endif; ?>
                                            <td> <?php echo e(date('d-m-Y', strtotime($receipt->receipt_date))); ?></td>
                                         
                                         




                                           
                                            <?php if($receipt->is_approved == true): ?>
                                                <td>
                                                    <span class="label label-success">
                                                        Approved
                                                    </span>
                                                </td>
                                            <?php else: ?>
                                                
                                                    <td>
                                                        <span class="label label-warning">
                                                            Pending
                                                        </span>
                                                    </td>
                                                <?php endif; ?>
                                          


                                         
                                            <td class="text-nowrap">
                                                <?php if($view_receipt): ?>
                                                <a href="<?php echo e(route('receipt.refund.detail', ['id' => $receipt->id])); ?>"
                                                    class="btn btn-default">View</a>
                                                 <?php endif; ?>
    
    
                                                
                                               
                                                 <?php if($delete_receipt): ?>
            
    
                                                <a href="<?php echo e(route('receipt-refund.delete', ['id' => $receipt->id])); ?>"
                                                    class="btn btn-danger" data-toggle="confirmation" data-placement="left"
                                                    data-title="Are you sure to delete?">Delete </a>
                                                    <?php endif; ?>
    
    
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    
                                </tbody>
                            </table>
    
                        </div>

                    </div>
                        </div>

                        <?php if($projectType->id == \App\ProjectType::society): ?>  
                        <div id="open_file" class="tab-pane fade  ">
                            <div class="table-responsive">
                                <div class="table-responsive">
                                    <table id="myTable" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Receipt No.</th>
                                                <th>Project</th>
                                                <th>Unit No. </th>
                                                <th>Payment Method</th>
            
                                                <th>Received Amount </th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
            
            
            
                                            <?php $__currentLoopData = $openfile_receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $open_filereceipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($open_filereceipt->receipt_no); ?></td>
                                                    <td><?php echo e($open_filereceipt->multiProject ? $open_filereceipt->multiProject->name : 'None'); ?></td>
            
                                                    <td><?php echo e($open_filereceipt->openFileDealerInfo ? ($open_filereceipt->openFileDealerInfo->inventory ? $open_filereceipt->openFileDealerInfo->inventory->unit_number : '') : ''); ?>

                                                    </td>
            
            
                                                    <?php if($open_filereceipt->payment_method == \App\Receipt::cash): ?>
                                                        <td>Cash</td>
                                                    <?php elseif($open_filereceipt->payment_method == \App\Receipt::bank): ?>
                                                        <td>Bank</td>
                                                    <?php elseif($open_filereceipt->payment_method == \App\Receipt::adjustment): ?>
                                                        <td>Adjustment</td>
                                                    <?php elseif($open_filereceipt->payment_method == \App\Receipt::cheque): ?>
                                                        <td>Cheque</td>
                                                    <?php elseif($open_filereceipt->payment_method == \App\Receipt::merging): ?>
                                                        <td>Merging</td>
                                                    <?php else: ?>
                                                        <td></td>
                                                    <?php endif; ?>
            
            
            
            
            
                                                    <?php if($open_filereceipt->tax_paid_by == \App\Receipt::company): ?>
                                                        <td><?php echo e(number_format($open_filereceipt->amount + $open_filereceipt->tax_amount)); ?> PKR</td>
                                                    <?php else: ?>
                                                        <td><?php echo e(number_format($open_filereceipt->amount)); ?> PKR</td>
                                                    <?php endif; ?>
                                                    <td> <?php echo e(date('d-m-Y', strtotime($open_filereceipt->receipt_date))); ?></td>
                                                  
                                                   
                                            <?php if($open_filereceipt->is_approved == true): ?>
                                            <td>
                                                <span class="label label-success">
                                                    Approved
                                                </span>
                                            </td>
                                        <?php else: ?>
                                            
                                                <td>
                                                    <span class="label label-warning">
                                                        Pending
                                                    </span>
                                                </td>
                                            <?php endif; ?>
                                                    <td class="text-nowrap">
                                                        <?php if($view_receipt): ?>
                                                        <a href="<?php echo e(route('receipt.refund-openfile.detail', ['id' => $open_filereceipt->id])); ?>"
                                                            class="btn btn-default">View</a>
            
                                                            <?php endif; ?>
            
                                                            <?php if($delete_receipt): ?>
            
                                                       
            
                                                        <a href="<?php echo e(route('receipt-refund-openfile.delete', ['id' => $open_filereceipt->id])); ?>"
                                                            class="btn btn-danger" data-toggle="confirmation" data-placement="left"
                                                            data-title="Are you sure to delete?">Delete </a>
            
                                                             <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            
                                        </tbody>
                                    </table>
            
                                </div>
                                <div style="float: right;"></div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'sorting': false,
                'ordering': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no = $('#receipt_no').val();

            if (plot == 0 && customer == 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==
                0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {
                'plot': plot,
                'customer': customer,
                'dealer': dealer,
                'payment_mode': payment_mode,
                'payment_head': payment_head,
                'receipt_no': receipt_no
            };
            $.get('/receipt/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': true,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'sorting': false,
                    'ordering': false,
                    "aaSorting": [
                        [5, "asc"]
                    ],
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/refund-receipt-list.blade.php ENDPATH**/ ?>