

<?php $__env->startSection('title'); ?>
    All Pending Statements
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Pending Statements</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    ?>

    <?php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    ?>

    <div class="container-fluid">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
            <?php echo $__env->make('partial.multiproject_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div id='updatecontent'>
            <div class="row" style="margin-top: 3%;">
                <div class="col-md-12">
                    <div class="panel panel-info">
                        <div class="panel-heading">Search Statements</div>
                        <div class="panel-wrapper collapse in" aria-expanded="true">
                            <div class="panel-body">
                                <form>
                                    <div class="form-body">
                                        <div class="row">
                                            <!--/span-->

                                            <!--/span-->
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Unit No.</label>

                                                    <select id="unit" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->unit_number); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Customer</label>

                                                    <select id="customer" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->

                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Dealer</label>

                                                    <select id="dealer" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($d->id); ?>">
                                                                <?php echo e($d->name); ?>-<?php echo e($d->code); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->

                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By status</label>
                                                    <select id="status" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <option value="<?php echo e(\App\CustomerProperty::pending); ?>">Pending
                                                        </option>
                                                        <option value="<?php echo e(\App\CustomerProperty::cancel); ?>">Cancelled
                                                        </option>

                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-actions" style="margin-top: 26px">
                                                    <button type="button" class="btn btn-success search-customer"> <i
                                                            class="fa fa-check"></i> Search</button>

                                                </div>
                                            </div>
                                        </div>


                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /row -->
            <div class="row" id="update-table">
                <div class="col-sm-12">
                    <div class="white-box">

                        <h3 class="box-title">Pending Statements (<?php echo e($statementCount); ?>)</h3>

                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>Unit #</th>
                                        <th>Size</th>
                                        <th>Member Name</th>
                                        <th>Net Amount</th>

                                        <th>Received Amount</th>
                                        <th>Sold By</th>
                                        <th>Booking Date</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    <?php $__currentLoopData = $allStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($count++); ?></td>
                                            <td>
                                                <?php if($statement->inventory): ?>
                                                    <?php if($statement->inventory->multiProject): ?>
                                                        <?php echo e($statement->inventory->multiProject->name); ?>

                                                    <?php else: ?>
                                                        None
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>

                                            <td><?php echo e($statement->inventory ? $statement->inventory->unit_number : ''); ?></td>
                                            <td>
                                                <?php if($statement->inventory): ?>
                                                    <?php if($statement->inventory->size): ?>
                                                        <?php echo e($statement->inventory->size->name); ?> <?php echo e($size); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($statement->customer ? $statement->customer->name : ''); ?></td>

                                            <td><?php echo e(number_format($statement->net_pay)); ?> PKR</td>


                                            <td><?php echo e(number_format($receivedAmt[$statement->id])); ?> PKR</td>

                                            <td>
                                                <?php if($statement->dealer): ?>
                                                    <?php echo e($statement->dealer->name); ?>

                                                    <b>(<?php echo e($statement->dealer->dealerType->name); ?>)</b>
                                                <?php else: ?>
                                                    Company
                                                <?php endif; ?>
                                            </td>

                                            <td><?php echo e(date('d-m-Y', strtotime($statement->booking_date))); ?></td>



                                            <?php if($statement->status == \App\CustomerProperty::pending): ?>
                                                <td><span class="label label-primary"
                                                        style="background-color:#cd703d;">Pending</span></td>
                                            <?php elseif($statement->status == \App\CustomerProperty::approved): ?>
                                                <td><span class="label label-success">Approved</span></td>
                                            <?php elseif($statement->status == \App\CustomerProperty::cancel): ?>
                                                <td><span class="label label-danger">Canceled</span></td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>



                                            <td class="text-nowrap">
                                                <a href="<?php echo e(route('statement.detail', ['id' => $statement->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i> </a>

                                                <a href="<?php echo e(route('statement.editPendingView', ['id' => $statement->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="Update Reference No."> <i
                                                        class="fa fa-sun-o text-inverse m-r-10"></i> </a>


                                                <a href="<?php echo e(route('statement.delete', ['id' => $statement->id])); ?>"
                                                    data-toggle="confirmation" data-placement="left"
                                                    data-title="Are you sure to delete?"> <i
                                                        class="fa fa-close text-danger"></i> </a>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </div>
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $(function() {
            $('#myTable').DataTable();


            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                "displayLength": 25,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group +
                                '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });

        function callItBack() {
            $('.search-customer').on('click', function() {
                $('.preloader').fadeIn();
                unit = $('#unit').val();
                customer = $('#customer').val();
                dealer = $('#dealer').val();
                status = $('#status').val();
                var multipro_id = "";
                if ($("#multipro").length > 0) {
                    if ($("#multipro").val() !== 'search') {
                        multipro_id = $("#multipro").val();
                    }
                    // Do something with the value
                }


                if (unit == 0 && customer == 0 && status == 0 && dealer == 0 && multipro_id == 0) {
                    toastr.warning("please select any option.");
                    return false;
                }

                var data = {
                    'multipro_id': multipro_id,
                    'unit': unit,
                    'customer': customer,
                    'dealer': dealer,
                    'status': status
                };
                $.get('/pending-statement/updateTable', data, function(data) {
                    document.getElementById('update-table').innerHTML = data;

                    $('#myTable').DataTable({
                        'pageLength': 50,
                        'paging': false,
                        'searching': false,
                        'info': true
                    });
                    toastr.success("Search updated.");


                    $('.preloader').fadeOut();
                });
            });
        }
        callItBack();


        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('<?php echo e(route('statement.pending')); ?>', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/pending-statement.blade.php ENDPATH**/ ?>