

<?php $__env->startSection('title'); ?> Add Receipt <?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Add Receipt</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <form method="post" action="<?php echo e(route('receipt.insert')); ?>" class="form-horizontal" id="receipt_form">
            <?php echo e(csrf_field()); ?>

            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <?php if($errors->any()): ?>
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul> <?php echo implode(
                                '',
                                $errors->all('
                                                                                                            <li><span class="help-block"><strong>:message</strong></span></li>'),
                            ); ?>

                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="white-box1">
                        <h3 class="box-title">Payment Information</h3>
                        <hr>

                        <input type="hidden" name="is_approved" value="0">
                        <div class="form-group">
                           
                            <div class="col-sm-4">
                                <div class="input-group">
                                    
                                    <input type="radio"  checked  name="type" value="0" style="zoom: 1.6;"   hidden>
                                    <?php if($errors->has('type')): ?>
                                    <span class="help-block">
                                    <strong><?php echo e($errors->first('type')); ?></strong>
                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            
                            
                            
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='select_customer_or_dealer'>
                                <label class="control-label col-md-4">Select Customer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="customer_id" id='customer_id' class="form-control chosen-select"
                                        onchange="updateProperty(this.value)">
                                        <option value="" selected="">None</option>

                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(old('customer_id') == $customer->id): ?>
                                                <option selected="" value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?> -
                                                    <?php echo e($customer->cnic); ?> </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?> -
                                                    <?php echo e($customer->cnic); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php if($errors->has('customer_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('customer_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="col-md-12" id='property'> </div>
                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Head <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    
                                    <select class="form-control chosen-select" name="payment_head" id="payment_head"
                                        onchange="getAmountAgainstPaymentHead(this)">


                                        

                                    </select>

                                    <?php if($errors->has('payment_head')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('payment_head')); ?></strong>
                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='specific_outstanding'>
                                <label class="control-label col-md-4">
                                    <span id="payment_head_label">Down Payment</span> Outstanding
                                </label>
                                <div class="col-md-8">
                                    <input readonly type="text" id="remain_amount" class="form-control">
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='cheque' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Cheque Number</label>
                                <div class="col-md-8">

                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <span style="font-weight:bold;" id="surcharge_amount"></span>

                                    <input type="text" name="amount" value="<?php echo e(old('amount')); ?>" class="form-control"
                                        id="amount" onkeyup="toWords(this)" placeholder="Enter Amount">
                                    <span style="font-weight:bold;" id="total_amount"></span>
                                    <?php if($errors->has('amount')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('amount')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="due_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Outstanding</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="due" value="<?php echo e(old('due')); ?>"
                                        class="form-control" id="due">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_amount_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="tax_amount" value="<?php echo e(old('tax_amount')); ?>"
                                        class="form-control" id="tax_amount">

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_paid_by">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Pay By</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_paid_by" id='tax_paid_by_option'
                                        onchange="changeTaxOption(this)">
                                        <option value="<?php echo e(\App\Receipt::customer); ?>"> Customer</option>
                                        <option value="<?php echo e(\App\Receipt::company); ?>"> Company</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_option_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount Received</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_payment_received" id="tax_option">
                                        <option value="0"> NO</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Method <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" id="payment_method" name='payment_method'
                                        onchange="changeFunc(this.value)">

                                        <?php if(old('payment_method') == \App\Receipt::cash): ?>
                                            <option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option>
                                            <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php elseif(old('payment_method') == \App\Receipt::bank): ?>
                                            <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option selected value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)
                                            </option>
                                            <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php elseif(old('payment_method') == \App\Receipt::cheque): ?>
                                            <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option>
                                            <option selected value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php elseif(old('payment_method') == \App\Receipt::adjustment): ?>
                                            <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option>
                                            <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option selected value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php elseif(old('payment_method') == \App\Receipt::merging): ?>
                                            <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option>
                                            <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option selected value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php else: ?>
                                            <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                            <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option>
                                            <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                            <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                            <option value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>
                                        <?php endif; ?>

                                    </select>
                                    <?php if($errors->has('payment_method')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('payment_method')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='merging_property' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Merging Properties <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="merging_properties" class="form-control chosen-select"
                                        onchange="getMergingProperty(this)">
                                        <option value="" selected="">None</option>

                                        <?php $__currentLoopData = $merging_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $merging_property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(old('merging_properties') == $merging_property->id): ?>
                                                <option selected="" value="<?php echo e($merging_property->id); ?>">
                                                    <?php echo e($merging_property->mrf_no); ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo e($merging_property->id); ?>">
                                                    <?php echo e($merging_property->mrf_no); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php if($errors->has('merging_properties')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('merging_properties')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Depositor Bank Name <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="bank_name" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(old('bank_name') == $bank->id): ?>
                                                <option selected="" value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?>

                                                </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php if($errors->has('bank_name')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('bank_name')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id='company-bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Company Account <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="company_account" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        <?php $__currentLoopData = $cBanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(old('company_account') == $bank->id): ?>
                                                <option selected="" value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?> -
                                                    <?php echo e($bank->account_number); ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?> -
                                                    <?php echo e($bank->account_number); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>

                                    <?php if($errors->has('company_account')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('company_account')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"><span id="date_type"> Drawn Date</span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='drawn_date' value=""
                                        id="exampleInputEmail1" placeholder="Enter Receipt Date">
                                    <?php if($errors->has('drawn_date')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('drawn_date')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"> <span id="number_type_inst">Instrument No </span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" name='cheque_number' value="" class="form-control"
                                        id="exampleInputEmail1" placeholder="Enter Instrument Number">
                                    <?php if($errors->has('cheque_number')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('cheque_number')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>


                        <div id='adjustment' style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Adjustment Type <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" onchange="checkAdjustmentType(this)"
                                            name='adjustment_type' id='adjustment_type'>
                                            
                                            <?php if(old('adjustment_type') == \App\Receipt::property): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>" selected="">Property
                                                </option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Other</option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::vehicle): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>" selected="">Vehicle
                                                </option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Others</option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::rebate): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>" selected="">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Others</option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::vendor): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>" selected="">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Others</option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::token_receipt): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>" selected="">Token
                                                    Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Others</option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::others): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>" selected="">Others
                                                </option>
                                            <?php elseif(old('adjustment_type') == \App\Receipt::roll_back): ?>
                                                <option value="<?php echo e(\App\Receipt::property); ?>">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>" selected="">Roll Back
                                                </option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>
                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>" selected="">Others
                                                </option>
                                            <?php else: ?>
                                                <option selected='' value="<?php echo e(\App\Receipt::property); ?>"
                                                    selected="">Property</option>
                                                <option value="<?php echo e(\App\Receipt::roll_back); ?>">Roll Back</option>
                                                <option value="<?php echo e(\App\Receipt::vehicle); ?>">Vehicle</option>

                                                <option value="<?php echo e(\App\Receipt::rebate); ?>">Rebate</option>
                                                <option value="<?php echo e(\App\Receipt::vendor); ?>">Vendor</option>
                                                <option value="<?php echo e(\App\Receipt::token_receipt); ?>">Token Receipt</option>
                                                <option value="<?php echo e(\App\Receipt::others); ?>">Others</option>
                                            <?php endif; ?>
                                        </select>

                                        <?php if($errors->has('adjustment_type')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('adjustment_type')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6" style="display:none;" id="procuremnt_bills">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Vendor Pending Bill </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="vendor_purchase_order_id"
                                            id="vendor_purchase_order_id" onchange="return getPoPayment(this)">
                                            <option value="">None</option>
                                            <?php $__currentLoopData = $vendor_pos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="Vendor Purchase Orders">
                                                    <?php $__currentLoopData = $b->receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($list->purchase_order_id); ?>">
                                                            PO-<?php echo e(ucfirst($list->purchase_order_id)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </optgroup>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('vendor_purchase_order_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('vendor_purchase_order_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-6" style="display:none;" id="token_amount_div">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Unit Token </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="token_amount" id="token_amount"
                                            onchange="return getUnitToken(this)">
                                            <option value="">None</option>
                                            <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="Unit Token">

                                                    <option value="<?php echo e($u->inventory->id); ?>">
                                                        <?php echo e($u->inventory->unit_number); ?> -
                                                        <?php echo e(number_format($u->token_amount)); ?> </option>

                                                </optgroup>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('token_amount')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('token_amount')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-6" id="adjustment_detail_head">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Adjustment Detail <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <textarea name="adjustment_detail" class="form-control"></textarea>
                                        <?php if($errors->has('adjustment_detail')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('adjustment_detail')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" style="display:none;" id="dealers_rebarts">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Dealer Payable Rebates </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="dealer_adjustment_unit_id">
                                            <option value="">None</option>
                                            <?php $__currentLoopData = $dealersRecord; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="<?php echo e($d['info']->name); ?>">
                                                    <?php $__currentLoopData = $d['rebate']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>"><?php echo e($val); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </optgroup>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php if($errors->has('dealer_adjustment_unit_id')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('dealer_adjustment_unit_id')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-roll-back" style="display:none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"> <span id="number_type">Roll Back/Adjust Properties
                                    </span> <span style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" name='roll_back_properties'
                                        id='roll_back_properties' >

                                        <?php $__currentLoopData = $adjusted_properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adjusted_property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        $value_='';
                                        $amount_value='';
                                            if( $adjusted_property->customerAdjustHistory){
                                                $amount_value =$adjusted_property->customerAdjustHistory->total_received_amount - $adjusted_property->includeInReceipt->sum('amount');
                                                $value_=     $adjusted_property->customerAdjustHistory->ua_no . ' ---- Remaining Amount: ' . ( $amount_value);
                                            }
                                            
                                       
                                      
                                      ?>
                                            <?php if(old('roll_back_properties') == $adjusted_property->id): ?>
                                                <option selected="" value="<?php echo e($adjusted_property->id); ?>" data-amount='<?php echo e($amount_value); ?>'>
                                                   <?php echo e($value_); ?>

                                                </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($adjusted_property->id); ?>" data-amount='<?php echo e($amount_value); ?>'>
                                                    <?php echo e($value_); ?>

                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('roll_back_properties')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('roll_back_properties')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="col-md-12" id='merging-property'> </div>
                        <div class="clearfix"></div>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Number <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <?php if(old('receipt_no')): ?>
                                        <input type="text" class="form-control" name='receipt_no' id='receipt_no'
                                            value="<?php echo e(old('receipt_no')); ?>"  
                                            placeholder="Enter Receipt Number">
                                    <?php else: ?>
                                        <input type="text" class="form-control" name='receipt_no'
                                            value="<?php echo e($receipt_no); ?>"  
                                            placeholder="Enter Receipt Number"  id='receipt_no'>
                                    <?php endif; ?>
                                    <?php if($errors->has('receipt_no')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('receipt_no')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Date <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='receipt_date'
                                        value="<?php echo e(date('Y-m-d')); ?>" id="exampleInputEmail1"
                                        placeholder="Enter Receipt Date">
                                    <?php if($errors->has('receipt_date')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('receipt_date')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Notes</label>
                                <div class="col-md-8">
                                    <textarea class="form-control" name="notes"></textarea>
                                    <?php if($errors->has('notes')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('notes')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <input type="checkbox" name="notify_sms" value="1"> Sms Notification
                            <br>
                            <input type="checkbox" name="notify_email" value="1"> Email Notification
                        </div>
                        <div class="col-md-4">
                            <div class="form-group m-b-0 pull-right">
                                <input type="submit" class="btn btn-info btn-sm waves-effect waves-light "
                                    id="saveBtn" disabled onclick="return validateAmount(this)" value="Save">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function getMergingAmount(self) {
            $('#amount').val(0);
            $('#amount').val($('input[name=merging_property_id]:checked').data("amount"));

        }



        function getAmount(self) {

            
            //  $(".chosen-select").chosen('destroy');


            // var dataAttri = $('input[name="customer_property_id"]:checked').data("booking_type");

            // if (dataAttri != '' && dataAttri == '<?php echo e(\App\CustomerProperty::full_payment); ?>') {
            //     $('#payment_head option:contains("Down Payment")').text('Full Payment');
            // } else {
            //     $('#payment_head option:contains("Full Payment")').text('Down Payment');
            // }

            // if ($(self).val() == '<?php echo e(\App\Receipt::surcharge); ?>') {
            //     $('#due_head').hide();
            //     $('#tax_paid_by').hide();
            //     $('#tax_amount_head').hide();
            //     $('#adjustment').hide();
            //     $('#adjustment_detail_head').hide();
            //     $('#surcharge_amount').html('Put Zero To Waive Off Surcharge.')
            //     $('#surcharge_amount').show()
            //     $('#tax_option_head').hide();
            //     $("#payment_method").html(
            //         '<option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option><option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option><option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option><option  value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>'
            //         )
            // } else {
            //     $('#due_head').show();
            //     $('#tax_paid_by').show();
            //     $('#tax_amount_head').show();
            //     $('#tax_option_head').show();
            //     $('#surcharge_amount').hide()
            //     $("#payment_method").html(
            //         '<option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option><option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option><option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option><option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option><option  value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>'
            //         )
            // }

            //  $(".chosen-select").chosen();

            $('#amount').val(0);
            let property_id = $('input[name=customer_property_id]:checked').val();
            // let entered_amount = $('#amount').val();
            // let payment_head = $('#payment_head').val();



            var data = {
                'property_id': property_id,
                // 'entered_amount': entered_amount,
                // 'payment_head': payment_head
            };

            $.get('/validate/receipt/amount', data, function(data) {
                $('#remain_amount').val(Number(0));
                $("#payment_head").chosen('destroy');
                $('#payment_head').empty();
                $('#payment_head').append('<option selected="selected" disabled>Select an option </option>');
                for (i = 0; i < data.array_property_payment_head.payment_head_name.length; i++) {
                    $('#payment_head').append('<option value="' + data.array_property_payment_head.payment_head_val[
                        i] + '">' + data.array_property_payment_head.payment_head_name[i] + '</option>');
                }
                $("#payment_head").chosen();
                //    if (data.response == '1') 
                //    {
                //         // $('#invalid_amount').html('Invalid Amount!');
                //         // $('#invalid_amount').show()
                //         // $('#payment_head').empty();

                //         // $('#payment_head_label').html(data.payment_head)
                //         // $('#remain_amount').val(Math.round(data.remaining))

                //    }
                //    else
                //    {

                //     //  $('#payment_head').empty();

                //         // $('#invalid_amount').html('');
                //         // $('#invalid_amount').hide()
                //         // $('#payment_head_label').html(data.payment_head)
                //         // $('#remain_amount').val(Math.round(data.remaining))

                //    }



            }, 'json');


            changeTotalRemaining()

        }


        function getPackageAmount(self) {

 

$('#amount').val(0);


let dealerpackage_id = $('input[name=dealerpackage_id]:checked').val();

$('#remain_amount').val(Number(0));
    $("#payment_head").chosen('destroy');
    $('#payment_head').empty();
    $('#payment_head').append('<option value="' + 
            <?php echo e(\App\Receipt::package_payment); ?> + '"> Package Payment </option>');
            $("#payment_head").chosen();



 

 
    

    


 


            changeTotalRemainingPackage();

}




        function getAmountAgainstPaymentHead(self) {

            //  $(".chosen-select").chosen('destroy');

       var type=     $('input[name="type"]:checked').val();
         if(type==0){
        var dataAttri = $('input[name="customer_property_id"]:checked').data("booking_type");

if (dataAttri != '' && dataAttri == '<?php echo e(\App\CustomerProperty::full_payment); ?>') {
    $('#payment_head option:contains("Down Payment")').text('Full Payment');
} else {
    $('#payment_head option:contains("Full Payment")').text('Down Payment');
}

if ($(self).val() == '<?php echo e(\App\Receipt::surcharge); ?>') {
    $('#due_head').hide();
    $('#tax_paid_by').hide();
    $('#tax_amount_head').hide();
    $('#adjustment').hide();
    $('#adjustment_detail_head').hide();
    $('#surcharge_amount').html('Put Zero To Waive Off Surcharge.')
    $('#surcharge_amount').show()
    $('#tax_option_head').hide();
    $("#payment_method").html(
        '<option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option><option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option><option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option><option  value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>'
    )
} else {
    $('#due_head').show();
    $('#tax_paid_by').show();
    $('#tax_amount_head').show();
    $('#tax_option_head').show();
    $('#surcharge_amount').hide()
    $("#payment_method").html(
        '<option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option><option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)</option><option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option><option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option><option  value="<?php echo e(\App\Receipt::merging); ?>">Merging</option>'
    )
}

//  $(".chosen-select").chosen();

$('#amount').val(0);
let property_id = $('input[name=customer_property_id]:checked').val();
let entered_amount = $('#amount').val();
let payment_head = $('#payment_head').val();



var data = {
    'property_id': property_id,
    'entered_amount': entered_amount,
    'payment_head': payment_head
};

$.get('/get/payment_head/amount', data, function(data) {
    if (data.response == '1') {
        // $('#invalid_amount').html('Invalid Amount!');
        // $('#invalid_amount').show()
        //  

        $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(Math.round(data.remaining))

    } else {

        // $('#invalid_amount').html('');
        // $('#invalid_amount').hide()
        $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(Math.round(data.remaining))

    }



}, 'json');




changeTotalRemaining()

       }
           
        }



        function validateAmount(argument) {



            if ($('#adjustment_type').val() == '<?php echo e(\App\Receipt::vendor); ?>') {
                var data_1 = {
                    'vendor_purchase_order_id': $('#vendor_purchase_order_id').val(),
                    'entered_amount': $('#amount').val()
                };
                $.get('/validate/purchase-order/amount', data_1, function(data_2) {
                    console.log('Invalid::', data_2);
                    if (data_2.response == 'invalid') {
                        $('#invalid_amount').html('<strong>Invalid Amount!</strong> <span>valid amount of ' + data_2
                            .amount + '</span>');
                        $('#invalid_amount').show()
                        return false;
                    } else {
                        $('#invalid_amount').html('');
                        $('#invalid_amount').hide()
                        $('#receipt_form').submit()
                    }

                }, 'json');

            } else {
                $('#receipt_form').submit()
            }

            return false;
        }

        function getPoPayment(self) {

            var po = $(self).val();

            var data = {
                'purchase_order': po
            };

            $.get('/purchase-order/payment', data, function(data) {

                $('#amount').val(data.response);
            }, 'json');

            return false;
        }


        function getUnitToken(self) {
            var unit_id = $(self).val();

            var data = {
                'unit_id': unit_id
            };

            $.get('/unit-token', data, function(data) {

                $('#amount').val(data.response);
            }, 'json');

            return false;
        }

        function checkAdjustmentType(self) {

            if ($(self).val() == '<?php echo e(\App\Receipt::rebate); ?>') {
                $('#dealers_rebarts').show()
                $('#token_amount_div').hide()
                $('#procuremnt_bills').hide()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '<?php echo e(\App\Receipt::vendor); ?>') {
                $('#dealers_rebarts').hide()
                $('#token_amount_div').hide()
                $('#procuremnt_bills').show()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '<?php echo e(\App\Receipt::token_receipt); ?>') {
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').show()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '<?php echo e(\App\Receipt::roll_back); ?>') {
                $('#cheque-dd-po-roll-back').show()
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').hide()
            } else {
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').hide()
                $('#cheque-dd-po-roll-back').hide()
            }



        }


        function changeTaxOption(self) {
            if ($(self).val() == "<?php echo e(\App\Receipt::company); ?>") {
                $('#tax_option').html('<option value="1"> YES</option>');
            } else if ($(self).val() == "<?php echo e(\App\Receipt::customer); ?>") {
                $('#tax_option').html('<option value="0"> NO</option>');
            } else {
                $('#tax_option').html('<option value="1"> YES</option><option value="0"> NO</option>');
            }
        }

        function toWords(self) {

            // payment_method
            // 
          val=  $('#payment_method').find(":selected").val();
           console.log(val,<?php echo e(\App\Receipt::adjustment); ?>);
          if(val == <?php echo e(\App\Receipt::adjustment); ?>)
          {
            
            check_again=  $('#adjustment_type').find(":selected").val();
            if(check_again == <?php echo e(\App\Receipt::roll_back); ?>){
                
           amount=     $('#roll_back_properties').find(":selected").data('amount');
           if($(self).val() > amount){
           
           
            $("#amount").val(amount);
           }
            }
            
          }
            var total_amount = inWords($(self).val())
            $('#total_amount').text(total_amount)

            let property_id = $('input[name=customer_property_id]:checked').val();
            let entered_amount = $(self).val();
            let payment_head = $('#payment_head').val();

            var data = {
                'property_id': property_id,
                'entered_amount': entered_amount,
                'payment_head': payment_head
            };
           
            if (isNaN(data.entered_amount)) {
                return false;
            } else {
                $.get('/get/payment_head/amount', data, function(data) {

                    if (data.response == '1') {
                        // $('#invalid_amount').html('Invalid Amount!');
                        // $('#invalid_amount').show()

                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(data.remaining)
                        // $('#saveBtn').prop('disabled' , true)
                    } else {
                        // $('#invalid_amount').html('');
                        // $('#invalid_amount').hide()
                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(data.remaining)
                        // $('#saveBtn').prop('disabled' , false)
                    }



                }, 'json');
            }





        }


        setInterval(function() {

            property = $('input[name="customer_property_id"]:checked').val();


            if (property) {
                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());
            } else {
                remaining_amount = 0;
            }


            if ($('#payment_head').val() === '<?php echo e(\App\Receipt::installment); ?>' && ($('#amount').val() >
                    remaining_amount)) {

                $('#saveBtn').prop('disabled', true)
            } else if ($('#payment_head').val() === '<?php echo e(\App\Receipt::surcharge); ?>' && ($('#amount').val() >
                    remaining_amount)) {
                $('#saveBtn').prop('disabled', true)

            } else {
                if ($('#payment_head').val() !== '<?php echo e(\App\Receipt::surcharge); ?>' && $('#due').val() < 0) {

                    $('#saveBtn').prop('disabled', true)
                } else {

                    $('#saveBtn').prop('disabled', false)
                }
            }





            $('#remain_amount').val(Number($('#remain_amount').val()).toFixed(2))


        }, 500);


        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        function inWords(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
            return 'Rupees ' + str + ' Only';
        }



        function changeFunc(a) {
            $("#date_type").text("Drawn Date");
                $("#number_type_inst").text("Instrument No");
            if (a == <?php echo e(\App\Receipt::cash); ?>) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == <?php echo e(\App\Receipt::bank); ?>) {


                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide();
                $("#date_type").text("Transaction Date");
                $("#number_type_inst").text("STAN No");


            } else if (a == <?php echo e(\App\Receipt::cheque); ?>) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == <?php echo e(\App\Receipt::adjustment); ?>) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'block');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == <?php echo e(\App\Receipt::merging); ?>) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').show();
                $('#cheque-dd-po-roll-back').hide()

            }

        }


        function getMergingProperty(self) {
            var mer_pro = $(self).val();

            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();

            var data = {
                'customer_id': customer_id,
                'mer_pro': mer_pro
            };

            $.get('/update-merging-properties', data, function(data) {

                document.getElementById('merging-property').innerHTML = data;

                $('.preloader').fadeOut();
            });
        }


        function updateProperty() {

            $('#remain_amount').val(Number(0));
            $("#payment_head").chosen('destroy');
            $('#payment_head').empty();
            $("#payment_head").chosen();
            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();


            var data = {
                'customer_id': customer_id
            }; 
       
            $.get('/add/receipt/update-properties', data, function(data) {

                document.getElementById('property').innerHTML = data;

                $('#myTable').DataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false
                });
            });

            //  $('#wait').hide();
            $('.preloader').fadeOut();

        }

        function updatePackage() {

$('#remain_amount').val(Number(0));
$("#payment_head").chosen('destroy');
$('#payment_head').empty();
$("#payment_head").chosen();
$('.preloader').fadeIn();

var dealer_id = $('#dealer_id').val();


var data = {
    'dealer_id': dealer_id
};

// $('#property').empty();
$.get('/add/receipt/update-package', data, function(data) {

    document.getElementById('property').innerHTML = data;

    $('#myTable').DataTable({
        "paging": false,
        "ordering": false,
        "info": false
    });
});

//  $('#wait').hide();
$('.preloader').fadeOut();

}
function changeTotalRemainingPackage() {

amount = parseInt($('#amount').val());

if (amount) {
    var pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;

    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount - amount);


    // isFiler = parseInt($('#is_filer').val());

    // if (isFiler == 1)
        // $('#tax_amount').val(amount * 0.01);
    // else
        $('#tax_amount').val(amount * 0.02);

} else {
    pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;
    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount);
}

if ($('#due').val() < 0) {
    $('#saveBtn').prop('disabled', true)
} else {
    $('#saveBtn').prop('disabled', false)
}
}








        function changeTotalRemaining() {

            amount = parseInt($('#amount').val());

            if (amount) {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                isFiler = parseInt($('#is_filer').val());

                if (isFiler == 1)
                    $('#tax_amount').val(amount * 0.01);
                else
                    $('#tax_amount').val(amount * 0.02);

            } else {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            if ($('#due').val() < 0) {
                $('#saveBtn').prop('disabled', true)
            } else {
                $('#saveBtn').prop('disabled', false)
            }
        }

        $('#amount').keyup(function() {

            amount = parseInt($('#amount').val());
       var type=     $('input[name="type"]:checked').val();
            if(type == 1){
                
                if (amount) {
    var pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;

    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount - amount);


    // isFiler = parseInt($('#is_filer').val());

    // if (isFiler == 1)
        // $('#tax_amount').val(amount * 0.01);
    // else
        $('#tax_amount').val(amount * 0.02);

} else {
    pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;
    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount);
}

if ($('#due').val() < 0) {
    $('#saveBtn').prop('disabled', true)
} else {
    $('#saveBtn').prop('disabled', false)
}

            }
            else if(type == 0)
            {
                if (amount) {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                isFiler = parseInt($('#is_filer').val());

                if (isFiler == 1)
                    $('#tax_amount').val(amount * 0.01);
                else
                    $('#tax_amount').val(amount * 0.02);

            } else {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            }
           


        });

    


    



    </script>

<?php $__env->stopSection(); ?>

<?php if($errors->any()): ?>
    <script>
        window.onload = function() {

            updateProperty('<?php echo e(old('customer_id')); ?>');

            var payment_method = $('#payment_method').val();
            changeFunc(payment_method)
        }
    </script>
<?php endif; ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/add-receipt.blade.php ENDPATH**/ ?>