

<?php $__env->startSection('title'); ?>
    All Receipts
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <div class="container-fluid">

        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-info">
                    <div class="panel-heading">Search Receipt</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit No.</label>

                                                <select id="unit" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($p->id); ?>"><?php echo e($p->unit_number); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Customer</label>

                                                <select id="customer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Dealer</label>

                                                <select id="dealer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($d->id); ?>">
                                                            <?php echo e($d->name); ?>-<?php echo e($d->code); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Receipt No</label>
                                                <select id="receipt_no" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <?php $__currentLoopData = $receiptNo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($r->id); ?>"><?php echo e($r->receipt_no); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Payment Mode</label>
                                                <select id="payment_mode" class="form-control chosen-select">

                                                    <option value="all">All</option>
                                                    <?php if(old('payment_method') == \App\Receipt::cash): ?>
                                                        <option selected value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                        <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                                        <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                                    <?php elseif(old('payment_method') == \App\Receipt::bank): ?>
                                                        <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                        <option selected value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer
                                                            (IBFT)</option>
                                                        <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                                        <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                                    <?php elseif(old('payment_method') == \App\Receipt::cheque): ?>
                                                        <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                        <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)
                                                        </option>
                                                        <option selected value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO
                                                        </option>
                                                        <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                                    <?php elseif(old('payment_method') == \App\Receipt::adjustment): ?>
                                                        <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                        <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                                        <option selected value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment
                                                        </option>
                                                    <?php else: ?>
                                                        <option value="<?php echo e(\App\Receipt::cash); ?>">Cash</option>
                                                        <option value="<?php echo e(\App\Receipt::bank); ?>">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="<?php echo e(\App\Receipt::cheque); ?>">Cheque/ DD/ PO</option>
                                                        <option value="<?php echo e(\App\Receipt::adjustment); ?>">Adjustment</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Payment Head</label>
                                                <select id="payment_head" class="form-control chosen-select">
                                                    <option value="0">None</option>


                                                    <option value="<?php echo e(\App\Receipt::down_payment); ?>">Down Payment</option>
                                                    <option value="<?php echo e(\App\Receipt::installment); ?>">Installment</option>

                                                    <option value="<?php echo e(\App\Receipt::possession_fee); ?>">Possession Fee
                                                    </option>



                                                    <option value="<?php echo e(\App\Receipt::allotment); ?>">Allotment</option>
                                                    <option value="<?php echo e(\App\Receipt::confirmation); ?>">Confirmation</option>

                                                    <option value="<?php echo e(\App\Receipt::booking); ?>">Booking</option>



                                                    <option value="<?php echo e(\App\Receipt::development); ?>">Development</option>
                                                    <option value="<?php echo e(\App\Receipt::file_processing); ?>">File Processing
                                                    </option>

                                                    <option value="<?php echo e(\App\Receipt::registration); ?>">Registration</option>



                                                    <option value="<?php echo e(\App\Receipt::other); ?>">Other</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <div class="col-md-3">
                                            <div class="form-actions" style="margin-top: 26px">
                                                <button type="button" class="btn btn-success search-customer"> <i
                                                        class="fa fa-check"></i> Search</button>

                                            </div>
                                        </div>
                                    </div>


                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->

        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Receipts (<?php echo e(number_format($totalAmount)); ?>)</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Project</th>
                                    <th>Receipt No.</th>
                                    <th>Unit No. </th>
                                    <th>Payment Mode</th>
                                    <th>Payment Head</th>
                                    <th>Received Amount </th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'print-receipt')): ?>
                                    <?php $print_receipt = true; ?>
                                <?php else: ?>
                                    <?php $print_receipt = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-receipt')): ?>
                                    <?php $view_receipt = true; ?>
                                <?php else: ?>
                                    <?php $view_receipt = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-receipt')): ?>
                                    <?php $edit_receipt = true; ?>
                                <?php else: ?>
                                    <?php $edit_receipt = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'download-receipt')): ?>
                                    <?php $download_receipt = true; ?>
                                <?php else: ?>
                                    <?php $download_receipt = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-receipt')): ?>
                                    <?php $delete_receipt = true; ?>
                                <?php else: ?>
                                    <?php $delete_receipt = false; ?>
                                <?php endif; ?>

                                <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($receipt->multiProject ? $receipt->multiProject->name : 'None'); ?></td>
                                        <td><?php echo e($receipt->receipt_no); ?></td>

                                        <td><?php echo e($receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : ''); ?>

                                        </td>




                                        <?php if(!empty($receipt->payment_method)): ?>
                                            <?php if($receipt->payment_method == \App\Receipt::cash): ?>
                                                <td>Cash</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?>
                                                <td>Bank</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?>
                                                <td>Adjustment</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?>
                                                <td>Cheque/ DD/ PO</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::merging): ?>
                                                <td>Merging</td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php if($receipt->payment_mode == \App\Receipt::cash): ?>
                                                <td>Cash</td>
                                            <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?>
                                                <td>Bank</td>
                                            <?php elseif($receipt->payment_mode == \App\Receipt::adjustment): ?>
                                                <td>Adjustment</td>
                                            <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?>
                                                <td>Cheque/ DD/ PO</td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>
                                        <?php endif; ?>





                                        <?php if($receipt->payment_head == \App\CustomerStatement::down_payment): ?>
                                            <td class="printFV">

                                                <?php if($receipt->property->booking_type == \App\CustomerProperty::full_payment): ?>
                                                    <?php echo e('Full Payment'); ?>

                                                <?php else: ?>
                                                    <?php echo e('Down Payment'); ?>

                                                <?php endif; ?>

                                            </td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::possession): ?>
                                            <td class="printFV">Possession Fee</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::installment): ?>
                                            <td class="printFV">Installment </td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::other): ?>
                                            <td class="printFV">Other</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::allotment): ?>
                                            <td class="printFV">Allotment</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::confirmation): ?>
                                            <td class="printFV">Confirmation</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::booking): ?>
                                            <td class="printFV">Booking</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::development): ?>
                                            <td class="printFV">Development</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::file_processing): ?>
                                            <td class="printFV">File Processing</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::registration): ?>
                                            <td class="printFV">Registration</td>
                                        <?php elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee): ?>
                                            <td class="printFV">Transfer Fee</td>
                                        <?php else: ?>
                                            <td class="printFV"></td>
                                        <?php endif; ?>





                                        <td><?php echo e(number_format($receipt->amount)); ?> PKR</td>

                                        <td> <?php echo e(date('d-m-Y', strtotime($receipt->receipt_date))); ?></td>

                                        <?php if($receipt->property->status == \App\CustomerProperty::cancel): ?>
                                            <td>
                                                <span class="label label-danger">Canceled</span>
                                            </td>
                                        <?php else: ?>
                                            <?php if($receipt->is_approved == \App\Receipt::approve): ?>
                                                <td>
                                                    <span class="label label-success">
                                                        Approved
                                                    </span>
                                                </td>
                                            <?php else: ?>
                                                <?php if($receipt->cheaque_status == \App\Receipt::cancel): ?>
                                                    <td>
                                                        <span class="label label-danger">
                                                            Cheaque Cancel
                                                        </span>
                                                    </td>
                                                <?php else: ?>
                                                    <td>
                                                        <span class="label label-warning">
                                                            Pending
                                                        </span>
                                                    </td>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <td class="text-nowrap">

                                            <!-- <?php if($print_receipt): ?>
    <?php if($receipt->print_count > 0): ?>
    <a style="color: #ff9800;" target="_blank" href="<?php echo e(route('receipt.print', ['id' => $receipt->id])); ?>" data-toggle="tooltip" data-original-title="Print - <?php echo e($receipt->print_count); ?>"> <i class="fa fa-print text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
<?php else: ?>
    <a target="_blank" href="<?php echo e(route('receipt.print', ['id' => $receipt->id])); ?>" data-toggle="tooltip" data-original-title="Print"> <i class="fa fa-print text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
    <?php endif; ?>
    <?php endif; ?> -->

                                            <?php if($view_receipt): ?>
                                                <a href="<?php echo e(route('receipt.detail', ['id' => $receipt->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp; </a>
                                            <?php endif; ?>

                                            <!--   <?php if($edit_receipt): ?>
    <a href="<?php echo e(route('receipt.editView', ['id' => $receipt->id])); ?>" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
    <?php endif; ?> -->

                                            <!-- <?php if($download_receipt): ?>
    <?php if($receipt->download_count > 0): ?>
    <a style="color: #ff9800;" target="_blank" href="<?php echo e(route('receipt.download', ['id' => $receipt->id])); ?>" data-toggle="tooltip" data-original-title="Download - <?php echo e($receipt->download_count); ?>"> <i class="fa fa-download text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
<?php else: ?>
    <a target="_blank" href="<?php echo e(route('receipt.download', ['id' => $receipt->id])); ?>" data-toggle="tooltip" data-original-title="Download"> <i class="fa fa-download text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
    <?php endif; ?>
    <?php endif; ?> -->

                                            <?php if($delete_receipt): ?>
                                                <a href="<?php echo e(route('receipt.delete', ['id' => $receipt->id])); ?>"
                                                    data-toggle="confirmation" data-placement="left"
                                                    data-title="Are you sure to delete?"> <i
                                                        class="fa fa-close text-danger"></i> </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </tbody>
                        </table>
                        <div style="float: right;"><?php echo e($receipts->links()); ?></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'sorting': false,
                'ordering': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no = $('#receipt_no').val();

            if (unit == 0 && customer == 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==
                0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {
                'unit': unit,
                'customer': customer,
                'dealer': dealer,
                'payment_mode': payment_mode,
                'payment_head': payment_head,
                'receipt_no': receipt_no
            };
            $.get('/receipt/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': true,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'sorting': false,
                    'ordering': false,
                    "aaSorting": [
                        [5, "asc"]
                    ],
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/index.blade.php ENDPATH**/ ?>