


<?php $__env->startSection('title'); ?>
    SMS Log
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo e(route('email-sms.index')); ?>"> Email Sms Type</a></li>


        <li class="active"> SMS Log</li>

    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- .container-fluid -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12" style="margin-top: 15px;">
                <div class="panel panel-info">
                    <div class="panel-heading">Search SMS</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">

                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Title</label>
                                                <select id="title" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $email_sms_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($email->name); ?>"><?php echo e($email->name); ?></option>
                                                    
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    
                                                </select>

                                            </div>
                                        </div>
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Number</label>

                                                <select id="mobile" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $customer_mobile; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($mobile->mobile_number); ?>"><?php echo e($mobile->mobile_number); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                   
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By status</label>
                                                <select id="status" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <option value="1">Success</option>
                                                    <option value="2">Fail</option>

                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                    </div>

                                </div>
                                <div class="form-actions">
                                    <button type="button" class="btn btn-success search-customer"> <i
                                            class="fa fa-check"></i> Search</button>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">


                    </div>
                    <h3 class="box-title">All SMS</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>

                                    <th>Title</th>
                                    <th>Receiver Number</th>
                                    <th>Content</th>
                                    <th>Total Character</th>
                                    <th>Time</th>
                                    <th>Status</th>

                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                <?php $__currentLoopData = $sms_log; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($count++); ?></td>
                                        <td><?php echo e($log->title); ?></td>
                                        <td><?php echo e($log->receiver_number); ?></td>
                                        <td><?php echo e($log->content); ?></td>
                                        <td><?php echo e($log->total_charcter); ?></td>



                                        <td><?php echo e(date('Y-m-d h:i:s A', strtotime($log->created_at))); ?></td>
                                        <td>

                                            <?php if($log->status == 1): ?>
                                                <span class="label label-success">Success</span>
                                            <?php else: ?>
                                                <span class="label label-danger">Fail</span>
                                            <?php endif; ?>
                                        </td>


                                        <td>
                                            <?php if($log->status != 1): ?>
                                                <form action="<?php echo e(route('emaillog.resend-email')); ?>" method="post"
                                                    style='display: inline;'>

                                                    <?php echo csrf_field(); ?>


                                                    <input type='hidden' name='value' value="<?php echo e($log->id); ?>">

                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="resend" data-toggle="confirmation"
                                                        data-title="Are you sure to resend?">
                                                        <i class="fa fa-paper-plane-o" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        $(document).ready(function() {
            $('#myTable').DataTable();
        });
        $('.search-customer').on('click', function() {
                $('.preloader').fadeIn();
                title = $('#title').val();
                mobile = $('#mobile').val();
               
                status = $('#status').val();
                


                if (title == 0 && mobile == 0  && status == 0) {
                    toastr.warning("please select any option.");
                    $('.preloader').fadeOut();
                    return false;
                }

                var data = {
                    'title': title,
                    'mobile': mobile,
                  
                    'status': status,
                     
                };

                $.get('<?php echo e(route("smslog.index.updateTable")); ?>', data, function(data) {
                    document.getElementById('update-table').innerHTML = data;

                    $('#myTable').DataTable({
                        'pageLength': 50,
                        'paging': false,
                        'searching': false,
                        'info': true,
                        'dom': 'Bfrtip',
                        'buttons': [
                            'copy', 'csv', 'excel', 'pdf', 'print'
                        ]
                    });
                    toastr.success("Search updated.");


                    $('.preloader').fadeOut();
                });
            });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/Setting/smslog/index.blade.php ENDPATH**/ ?>