

<?php $__env->startSection('title'); ?>
    All Refund Units
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Refund Units</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <div class="container-fluid">
        <!-- /row -->

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
            <?php echo $__env->make('partial.multiproject_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div id='updatecontent'  >
            <div class="row" id="update-table">
                <div class="col-sm-12">
                    <div class="white-box">
                        <div class="pull-right">

                        </div>

                        <h3 class="box-title">Refund Units </h3>

                        <!-- Nav tabs -->
                        <div class="container">

                            <ul class="nav customtab nav-tabs" role="tablist">

                                <li role="presentation" class="active"><a href="#close_file" aria-controls="home"
                                        role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                                class="ti-home"></i></span><span class="hidden-xs">Close Unit</span></a>
                                </li>
                                <?php if($projectType->id == \App\ProjectType::society): ?>
                                <li role="presentation" class=""><a href="#open_file" aria-controls="profile"
                                        role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                                class="ti-user"></i></span> <span class="hidden-xs">Open File </span></a>
                                </li>
                                <?php endif; ?>

                            </ul>

                            <div class="tab-content">
                                <div id="close_file" class="tab-pane fade in active">

                                    <ul class="nav nav-tabs">
                                        <li class="active"><a data-toggle="tab" href="#home">Refunded
                                                (<?php echo e(number_format($statement_count_refunded)); ?>)</a></li>
                                        <li><a data-toggle="tab" href="#menu1">Pending Refunds
                                                (<?php echo e(number_format($statementCount)); ?>) </a></li>
                                        <li><a data-toggle="tab" href="#menu2">Decline (<?php echo e($statement_count_decline); ?>)</a>
                                        </li>

                                    </ul>

                                    <div class="tab-content">
                                        <div id="home" class="tab-pane fade in active">
                                            <h3>Refunded Units </h3>
                                            <div class="table-responsive">
                                                <table id="myTable" class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Project</th>
                                                            <th style="width: 66px;">Unit #</th>
                                                            <th>Member Name</th>
                                                            <th>Received Amount</th>
                                                            <th>Total Refund</th>
                                                            <th>Total Deduction</th>
                                                            <th>Total Deduction Percentage</th>
                                                            <th>Status</th>
                                                            <th>
                                                                Action
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $count = 1; ?>



                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                            <?php $view_membership = true; ?>
                                                        <?php else: ?>
                                                            <?php $view_membership = false; ?>
                                                        <?php endif; ?>

                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-refund')): ?>
                                                            <?php $edit_refund = true; ?>
                                                        <?php else: ?>
                                                            <?php $edit_refund = false; ?>
                                                        <?php endif; ?>



                                                        <?php $__currentLoopData = $allStatementsRefunded; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statementrefunded): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($count++); ?></td>
                                                                <td><?php echo e($statementrefunded->multiProject ? $statementrefunded->multiProject->name : ' '); ?></td>

                                                                <td><?php echo e($statementrefunded->inventory->unit_number); ?></td>

                                                                <td><?php echo e($statementrefunded->customer ? $statementrefunded->customer->name : ''); ?><br><b>Dealer:
                                                                    </b><?php echo e($statementrefunded->dealer ? $statementrefunded->dealer->name : ''); ?>

                                                                </td>


                                                                <td><b><?php echo e(number_format($statementrefunded->unitRefundHistory->total_amount)); ?></b>
                                                                </td>

                                                                <td><b><?php echo e(number_format($statementrefunded->unitRefundHistory->total_refund)); ?></b>
                                                                </td>

                                                                <td><b><?php echo e(number_format($statementrefunded->unitRefundHistory->total_deduct)); ?></b>
                                                                </td>


                                                                <td><b><?php echo e(round($statementrefunded->unitRefundHistory->total_deduct_percentage, 3)); ?>

                                                                        %</b></td>

                                                                <?php if($statementrefunded->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementrefunded->cancelProperty->after_cancellation_status == 'adjust-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Adjust/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementrefunded->cancelProperty->after_cancellation_status == 'refund-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Refund/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementrefunded->cancelProperty->after_cancellation_status == 'adjusted'): ?>
                                                                    <td><span class="label label-success">Adjusted</span>
                                                                    </td>
                                                                <?php elseif($statementrefunded->cancelProperty->after_cancellation_status == 'refunded'): ?>
                                                                    <td><span class="label label-success">Refunded</span>
                                                                    </td>
                                                                <?php endif; ?>




                                                                <td class="text-nowrap">
                                                                    <center>

                                                                        <?php if($view_membership): ?>
                                                                            <a href="<?php echo e(route('property.refund.history', ['id' => $statementrefunded->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="View"> <i
                                                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>


                                                                        <?php if($edit_refund && $statementrefunded->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                                            <a href="<?php echo e(route('property.refund.edit', ['id' => $statementrefunded->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="Edit"> <i
                                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>
                                                                       




                                                                    </center>
                                                                </td>

                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                                                    </tbody>
                                                </table>
                                                <div style="float: right;"><?php echo e($allStatementsRefunded->links()); ?> </div>
                                            </div>
                                        </div>
                                        <div id="menu1" class="tab-pane fade">
                                            <h3>Pending Refunds Units</h3>
                                            <div class="table-responsive">
                                                <table id="myTable" class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Project</th>

                                                            <th style="width: 58px;">Unit #</th>
                                                            
                                                            <th>Member Name</th>
                                                            <th>Net Amount</th>

                                                            <th>Received Amount</th>

                                                            
                                                            <th>Cancel Date</th>
                                                            <th>Cancel Fee(pkr)</th>
                                                            <th>Request Status</th>
                                                            <th>Unit Status</th>
                                                            <th>After Cancellation Decision Request</th>
                                                            <th>
                                                                Action
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $count = 1; ?>



                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                            <?php $view_membership = true; ?>
                                                        <?php else: ?>
                                                            <?php $view_membership = false; ?>
                                                        <?php endif; ?>

                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-refund')): ?>
                                                            <?php $edit_refund = true; ?>
                                                        <?php else: ?>
                                                            <?php $edit_refund = false; ?>
                                                        <?php endif; ?>





                                                        <?php $__currentLoopData = $allStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($count++); ?></td>
                                                                <td><?php echo e($statement->multiProject ? $statement->multiProject->name : ''); ?></td>


                                                                <td><?php echo e($statement->inventory->unit_number); ?></td>
                                                                
                                                                <td><?php echo e($statement->customer ? $statement->customer->name : ''); ?><br><b>Dealer:
                                                                    </b><?php echo e($statement->dealer ? $statement->dealer->name : ''); ?>

                                                                </td>

                                                                <td><b><?php echo e(number_format($statement->net_pay)); ?></b></td>


                                                                <td><b><?php echo e(number_format($receivedAmt[$statement->id])); ?></b>
                                                                </td>



                                                                

                                                                <td><?php echo e(date('d-m-Y', strtotime($statement->cancel_date))); ?>

                                                                </td>
                                                                <td><?php echo e($statement->cancelProperty->fee); ?> </td>

                                                                <?php if($statement->cancelProperty->status == 0): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statement->cancelProperty->status == 1): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>


                                                                <?php if($statement->status == \App\CustomerProperty::pending): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#cd703d;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statement->status == \App\CustomerProperty::approved): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php elseif($statement->status == \App\CustomerProperty::cancel): ?>
                                                                    <td><span class="label label-danger">Canceled</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>

                                                                <?php if($statement->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'adjust-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Adjust/Pending</span>
                                                                    </td>
                                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'refund-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Refund/Pending</span>
                                                                    </td>
                                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'adjusted'): ?>
                                                                    <td><span class="label label-success">Adjusted</span>
                                                                    </td>
                                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'refunded'): ?>
                                                                    <td><span class="label label-success">Refunded</span>
                                                                    </td>
                                                                <?php endif; ?>




                                                                <td class="text-nowrap">
                                                                    <center>

                                                                        <?php if($view_membership): ?>
                                                                            <a href="<?php echo e(route('statement.detail', ['id' => $statement->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="View"> <i
                                                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>


                                                                        <?php if($edit_refund): ?>
                                                                            <a href="<?php echo e(route('property.refund.edit', ['id' => $statement->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="Edit"> <i
                                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>





                                                                    </center>
                                                                </td>

                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </tbody>
                                                </table>
                                                <div style="float: right;"><?php echo e($allStatements->links()); ?></div>
                                            </div>
                                        </div>

                                        <div id="menu2" class="tab-pane fade">
                                            <h3>Decline Refunds Units</h3>
                                            <div class="table-responsive">
                                                <table id="myTable" class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>

                                                            <th>Project</th>
                                                            <th>Unit #</th>
                                                            
                                                            <th>Member Name</th>
                                                            <th>Net Amount</th>


                                                            
                                                            <th>Cancel Date</th>
                                                            <th>Cancel Fee(pkr)</th>
                                                            <th>Request Status</th>
                                                            <th>Unit Status</th>
                                                            <th>After Cancellation Decision Request</th>
                                                            <th>
                                                                Action
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $count = 1; ?>



                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                            <?php $view_membership = true; ?>
                                                        <?php else: ?>
                                                            <?php $view_membership = false; ?>
                                                        <?php endif; ?>

                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-refund')): ?>
                                                            <?php $edit_refund = true; ?>
                                                        <?php else: ?>
                                                            <?php $edit_refund = false; ?>
                                                        <?php endif; ?>


                                                        <?php $__currentLoopData = $allStatementsdecline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statementdecline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($count++); ?></td>

                                                                <td><?php echo e($statementdecline->multiProject->name); ?></td>
                                                                <td><?php echo e($statementdecline->inventory->unit_number); ?></td>
                                                                
                                                                <td><?php echo e($statementdecline->customer ? $statementdecline->customer->name : ''); ?><br><b>Dealer:
                                                                    </b><?php echo e($statementdecline->dealer ? $statementdecline->dealer->name : ''); ?>

                                                                </td>

                                                                <td><b><?php echo e(number_format($statementdecline->net_pay)); ?></b>
                                                                </td>





                                                                

                                                                <td><?php echo e(date('d-m-Y', strtotime($statementdecline->cancel_date))); ?>

                                                                </td>
                                                                <td><?php echo e($statementdecline->cancelProperty->fee); ?> </td>

                                                                <?php if($statementdecline->cancelProperty->status == 0): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->status == 1): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>


                                                                <?php if($statementdecline->status == \App\CustomerProperty::pending): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#cd703d;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->status == \App\CustomerProperty::approved): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->status == \App\CustomerProperty::cancel): ?>
                                                                    <td><span class="label label-danger">Canceled</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>

                                                                <?php if($statementdecline->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjust-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Adjust/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'refund-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Refund/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjusted'): ?>
                                                                    <td><span class="label label-success">Adjusted</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'refunded'): ?>
                                                                    <td><span class="label label-success">Refunded</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'decline'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#f80808;;">Decline</span>
                                                                    </td>
                                                                <?php endif; ?>




                                                                <td class="text-nowrap">
                                                                    <center>

                                                                        <?php if($view_membership): ?>
                                                                            <a href="<?php echo e(route('statement.detail', ['id' => $statementdecline->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="View"> <i
                                                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>


                                                                        <?php if($edit_refund): ?>
                                                                            <a href="<?php echo e(route('property.refund.edit', ['id' => $statementdecline->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="Edit"> <i
                                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>





                                                                    </center>
                                                                </td>

                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                                                    </tbody>
                                                </table>
                                                <div style="float: right;"><?php echo e($allStatementsdecline->links()); ?></div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <?php if($projectType->id == \App\ProjectType::society): ?>
                                <div id="open_file" class="tab-pane fade  ">

                                    <ul class="nav nav-tabs">
                                        <li class="active"><a data-toggle="tab" href="#openfilehome">Refunded
                                                (<?php echo e(number_format($refundedapprovedcount)); ?>)</a></li>
                                        <li><a data-toggle="tab" href="#openfilemenu1">Pending Refunds
                                                (<?php echo e(number_format($OpenFileDealerInfocount)); ?>) </a></li>
                                        

                                    </ul>

                                    <div class="tab-content">
                                        <div id="openfilehome" class="tab-pane fade in active">
                                            <h3>Refunded Units </h3>
                                            <div class="table-responsive">
                                                <table id="myTable" class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Project</th>
                                                            <th>Unit #</th>
                                                            <th>Dealer Name</th>
                                                            <th>Received Amount</th>
                                                            <th>Total Refund</th>
                                                            <th>Total Deduction</th>
                                                            <th>Total Deduction Percentage</th>
                                                            <th>Status</th>

                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $count = 1; ?>



                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                            <?php $view_membership = true; ?>
                                                        <?php else: ?>
                                                            <?php $view_membership = false; ?>
                                                        <?php endif; ?>

                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-refund')): ?>
                                                            <?php $edit_refund = true; ?>
                                                        <?php else: ?>
                                                            <?php $edit_refund = false; ?>
                                                        <?php endif; ?>



                                                        <?php $__currentLoopData = $OpenFileDealerInfo_approved_refund; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $openrefunded): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($count++); ?></td>
                                                                <td><?php echo e($openrefunded->inventory->multiProject ? $openrefunded->inventory->multiProject->name : ''); ?></td>


                                                                <td><?php echo e($openrefunded->inventory->unit_number); ?></td>

                                                                <td><?php echo e($openrefunded->dealer->code); ?>

                                                                    <?php echo e($openrefunded->dealer->name); ?>

                                                                </td>


                                                                <td><b><?php echo e(number_format($openrefunded->cancelOpenFile->openFileRefunded->total_amount)); ?></b>
                                                                </td>

                                                                <td><b><?php echo e(number_format($openrefunded->cancelOpenFile->openFileRefunded->total_refund)); ?></b>
                                                                </td>

                                                                <td><b><?php echo e(number_format($openrefunded->cancelOpenFile->openFileRefunded->total_deduct)); ?></b>
                                                                </td>


                                                                <td><b><?php echo e(round($openrefunded->cancelOpenFile->openFileRefunded->total_deduct_percentage, 3)); ?>

                                                                        %</b></td>

                                                                <?php if($openrefunded->cancelOpenFile->after_cancellation_status == 'pending'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($openrefunded->cancelOpenFile->after_cancellation_status == 'adjust-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Adjust/Pending</span>
                                                                    </td>
                                                                <?php elseif($openrefunded->cancelOpenFile->after_cancellation_status == 'refund-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Refund/Pending</span>
                                                                    </td>
                                                                <?php elseif($openrefunded->cancelOpenFile->after_cancellation_status == 'adjusted'): ?>
                                                                    <td><span class="label label-success">Adjusted</span>
                                                                    </td>
                                                                <?php elseif($openrefunded->cancelOpenFile->after_cancellation_status == 'refunded'): ?>
                                                                    <td><span class="label label-success">Refunded</span>
                                                                    </td>
                                                                <?php endif; ?>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                                                    </tbody>
                                                </table>
                                                <div style="float: right;">
                                                    <?php echo e($OpenFileDealerInfo_approved_refund->links()); ?> </div>
                                            </div>
                                        </div>
                                        <div id="openfilemenu1" class="tab-pane fade">
                                            <h3>Pending Refunds Units</h3>
                                            <table id="myTable2" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Project</th>
                                                        <th>Package Name</th>
                                                        <th>Unit #</th>

                                                        <th>Dealer Name</th>
                                                        <th>Dealer Code</th>


                                                        <th>Cancel Date</th>
                                                        <th>Cancel Fee(pkr)</th>
                                                        <th>Request Status</th>
                                                        <th>Open File<br/>Status</th>
                                                        <th>After Cancellation Decision Request</th>
                                                        <th>
                                                        <!-- style="width: 185px!important;" -->
                                                            <center>Action</center>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $count = 1; ?>


                                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'approve-cancellation')): ?>
                                                        <?php $reopen_membership = true; ?>
                                                    <?php else: ?>
                                                        <?php $reopen_membership = false; ?>
                                                    <?php endif; ?>

                                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                        <?php $view_membership = true; ?>
                                                    <?php else: ?>
                                                        <?php $view_membership = false; ?>
                                                    <?php endif; ?>

                                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-cancellation')): ?>
                                                        <?php $edit_membership = true; ?>
                                                    <?php else: ?>
                                                        <?php $edit_membership = false; ?>
                                                    <?php endif; ?>

                                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-cancellation')): ?>
                                                        <?php $delete_membership = true; ?>
                                                    <?php else: ?>
                                                        <?php $delete_membership = false; ?>
                                                    <?php endif; ?>
                                                                    


                                                    <?php $__currentLoopData = $OpenFileDealerInfo_pending_refund; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $openfile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($count++); ?></td>
                                                            <td><?php echo e($openfile->inventory->multiProject ? $openfile->inventory->multiProject->name : ''); ?></td>

                                                            <td>
                                                                <?php if($openfile->dealerPackage): ?>
                                                                    <a
                                                                        href='<?php echo e(route('openfile.detail', $openfile->dealerPackage->id)); ?>'>
                                                                        <?php echo e($openfile->dealerPackage->package->name); ?>

                                                                    </a>
                                                                <?php endif; ?>

                                                            </td>
                                                            <td><?php echo e($openfile->inventory->unit_number); ?></td>
                                                            <td><?php echo e($openfile->dealer->name); ?></td>
                                                            <td><?php echo e($openfile->dealer->code); ?></td>





                                                            <td><?php echo e(date('d-m-Y', strtotime($openfile->cancelOpenFile->created_at))); ?>

                                                            </td>
                                                            <td><?php echo e($openfile->cancelOpenFile->fee); ?> </td>

                                                            <?php if($openfile->cancelOpenFile->status == 0): ?>
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            <?php elseif($openfile->cancelOpenFile->status == 1): ?>
                                                                <td><span class="label label-success">Approved</span></td>
                                                            <?php else: ?>
                                                                <td></td>
                                                            <?php endif; ?>



                                                            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                                                                <?php $admin = true; ?>
                                                            <?php else: ?>
                                                                <?php $admin = false; ?>
                                                            <?php endif; ?>
                                                            <?php if($admin): ?>
                                                                <?php if($openfile->inventory->status == \App\Inventory::open): ?>
                                                                    <td><span class="label label-success">Open</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::package_open_file): ?>
                                                                    <td><span class="label label-success">Open/Dealer
                                                                            Package File</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::sold): ?>
                                                                    <td><span class="label label-danger">Sold</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::hold_client): ?>
                                                                    <td><span class="label label-primary">Client
                                                                            Hold</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::hold_company): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#cd703d;">Company
                                                                            Hold</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::token_hold): ?>
                                                                    <td><span class="label label-primary">Token Hold</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if($openfile->inventory->status == \App\Inventory::open): ?>
                                                                    <td><span class="label label-success">Open</span></td>
                                                                <?php else: ?>
                                                                    <td><span class="label label-danger">Sold</span></td>
                                                                <?php endif; ?>
                                                            <?php endif; ?>

                                                            <?php if($openfile->cancelOpenFile->after_cancellation_status == 'pending'): ?>
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#4871c6;;">Pending</span>
                                                                </td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjust-pending'): ?>
                                                                <td><span class="label label-success">Adjust/Pending</span>
                                                                </td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'refund-pending'): ?>
                                                                <td><span class="label label-success">Refund/Pending</span>
                                                                </td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjusted'): ?>
                                                                <td><span class="label label-success">Adjusted</span></td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'refunded'): ?>
                                                                <td><span class="label label-success">Refunded</span></td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'decline'): ?>
                                                                <td><span class="label label-primary"
                                                                        style="background-color:#f80808;;">Decline</span>
                                                                </td>
                                                            <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'swap-pending'): ?>
                                                                <td><span class="label label-success">Swap/Pending</span>
                                                                </td>
                                                            <?php endif; ?>




                                                            <td>

                                                                <?php if($edit_refund): ?>
                                                                    <a href="<?php echo e(route('openfile.refund.edit', ['id' => $openfile->id])); ?>"
                                                                        data-toggle="tooltip" data-original-title="Edit">
                                                                        <i
                                                                            class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                <?php endif; ?>

                                                            </td>

                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody>
                                            </table>
                                        </div>

                                        <div id="openfilemenu2" class="tab-pane fade">
                                            <h3>Decline Refunds Units</h3>
                                            <div class="table-responsive">
                                                <table id="myTable" class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Project</th>

                                                            <th>Unit #</th>
                                                            
                                                            <th>Member Name</th>
                                                            <th>Net Amount</th>


                                                            
                                                            <th>Cancel Date</th>
                                                            <th>Cancel Fee(pkr)</th>
                                                            <th>Request Status</th>
                                                            <th>Unit Status</th>
                                                            <th>After Cancellation Decision Request</th>
                                                            <th>
                                                                Action
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $count = 1; ?>



                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                                            <?php $view_membership = true; ?>
                                                        <?php else: ?>
                                                            <?php $view_membership = false; ?>
                                                        <?php endif; ?>

                                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-refund')): ?>
                                                            <?php $edit_refund = true; ?>
                                                        <?php else: ?>
                                                            <?php $edit_refund = false; ?>
                                                        <?php endif; ?>


                                                        <?php $__currentLoopData = $allStatementsdecline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statementdecline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($count++); ?></td>

                                                                <td><?php echo e($statementdecline->inventory->multiProject->name); ?>

                                                                </td>
                                                                <td><?php echo e($statementdecline->inventory->unit_number); ?></td>
                                                                
                                                                <td><?php echo e($statementdecline->customer ? $statementdecline->customer->name : ''); ?><br><b>Dealer:
                                                                    </b><?php echo e($statementdecline->dealer ? $statementdecline->dealer->name : ''); ?>

                                                                </td>

                                                                <td><b><?php echo e(number_format($statementdecline->net_pay)); ?></b>
                                                                </td>





                                                                

                                                                <td><?php echo e(date('d-m-Y', strtotime($statementdecline->cancel_date))); ?>

                                                                </td>
                                                                <td><?php echo e($statementdecline->cancelProperty->fee); ?> </td>

                                                                <?php if($statementdecline->cancelProperty->status == 0): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->status == 1): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>


                                                                <?php if($statementdecline->status == \App\CustomerProperty::pending): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#cd703d;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->status == \App\CustomerProperty::approved): ?>
                                                                    <td><span class="label label-success">Approved</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->status == \App\CustomerProperty::cancel): ?>
                                                                    <td><span class="label label-danger">Canceled</span>
                                                                    </td>
                                                                <?php else: ?>
                                                                    <td></td>
                                                                <?php endif; ?>

                                                                <?php if($statementdecline->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#4871c6;;">Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjust-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Adjust/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'refund-pending'): ?>
                                                                    <td><span
                                                                            class="label label-success">Refund/Pending</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'adjusted'): ?>
                                                                    <td><span class="label label-success">Adjusted</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'refunded'): ?>
                                                                    <td><span class="label label-success">Refunded</span>
                                                                    </td>
                                                                <?php elseif($statementdecline->cancelProperty->after_cancellation_status == 'decline'): ?>
                                                                    <td><span class="label label-primary"
                                                                            style="background-color:#f80808;;">Decline</span>
                                                                    </td>
                                                                <?php endif; ?>




                                                                <td class="text-nowrap">
                                                                    <center>

                                                                        <?php if($view_membership): ?>
                                                                            <a href="<?php echo e(route('statement.detail', ['id' => $statementdecline->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="View"> <i
                                                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>


                                                                        <?php if($edit_refund): ?>
                                                                            <a href="<?php echo e(route('property.refund.edit', ['id' => $statementdecline->id])); ?>"
                                                                                data-toggle="tooltip"
                                                                                data-original-title="Edit"> <i
                                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                                        <?php endif; ?>





                                                                    </center>
                                                                </td>

                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                                                    </tbody>
                                                </table>
                                                <div style="float: right;"><?php echo e($allStatementsdecline->links()); ?></div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>


                        </div>
                        <!-- Tab panes -->


                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        function callItBack() {
            function confirmReopen(val) {

                var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');



                Swal.fire({
                        title: "Are you sure?",
                        text: "You want to reopen the Unit!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, Sure!'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            $('.preloader').fadeIn();
                            $.ajax({
                                /* the route pointing to the post function */
                                url: '<?php echo e(route('reopen.cancel')); ?>',
                                type: 'POST',
                                /* send the csrf-token and the input to the controller */
                                data: {
                                    _token: CSRF_TOKEN,
                                    id: val
                                },
                                dataType: 'JSON',
                                /* remind that 'data' is the response of the AjaxController */
                                success: function(data) {
                                    $('.preloader').fadeOut();
                                    Swal.fire("Poof! Unit Reopened Successfully!", {

                                        confirmButtonColor: '#3085d6',
                                        cancelButtonColor: '#d33',
                                        confirmButtonText: 'Yes, Sure!'
                                    }).then((result) => {
                                        location.reload();
                                    });
                                }
                            });
                        } else {
                            $('.preloader').fadeOut();
                            Swal.fire("OK! Action Revert");
                        }
                    });




                // return false;
                // if (confirm('Are you sure you want to reopen this property.')) 
                // {
                //    return true; 
                // }
                // else
                // {
                //     return false;
                // }
                $('.preloader').fadeOut();
            }
        }
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });

        callItBack();

        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('<?php echo e(route('property.refund')); ?>', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/refund/index.blade.php ENDPATH**/ ?>