

<?php $__env->startSection('title'); ?>
    Role Permissions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Role Access</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

    <style type="text/css">
        .table>tbody>tr>td {
            font-size: 12px !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Role Permission Management</h3>
                    <form method="post" action="<?php echo e(route('role.permission.update')); ?>">
                        <?php echo e(csrf_field()); ?>


                        <select class="form-control" name="select_department" id='select_department' style="width: 500px;"
                            onchange="updateAccordingToSelect(this.value)">
                            <option value='all' >
                                All Departments
                            </option>
                            <option value="<?php echo e(\App\Permission::SALES); ?>">
                                Sales Department
                            </option>
                            <option value="<?php echo e(\App\Permission::ACCOUNTS); ?>">
                                Accounts Department
                            </option>
                            <option value="<?php echo e(\App\Permission::PROCUREMENT); ?>">
                                Procurement Department
                            </option>

                        </select>


                        <input type="hidden" name="role_id" value="<?php echo e($roles[0]->id); ?>">
                        <input type="submit" class="btn btn-primary" name="submit" value="Submit"
                            style="float: right;"><br>
                        <hr>
                        <div class="table-responsive">

                            <table class="table table-bordered" id="myTable">

                                <tbody>

                                    <?php $department = 0; ?>

                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($p->department): ?>
                                            <?php if($department == $p->department): ?>
                                                <tr class='dep_row<?php echo e($department); ?>'>
                                                    <td style="text-align: center;"><b><?php echo e($p->display_name); ?></b></td>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first()): ?>
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep<?php echo e($department); ?>"
                                                                    checked=""
                                                                    name="permission[<?php echo e($role->id); ?>][<?php echo e($p->id); ?>]">
                                                            </th>
                                                        <?php else: ?>
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep<?php echo e($department); ?>"
                                                                    name="permission[<?php echo e($role->id); ?>][<?php echo e($p->id); ?>]">
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                </tr>
                                            <?php else: ?>
                                                <?php $department = $p->department; ?>

                                                <tr class='dep_row<?php echo e($department); ?>'></tr>

                                                <tr class='dep_row<?php echo e($department); ?>'>
                                                    <td colspan="4"><b style="font-weight: 900;">
                                                            <?php if($department == \App\Permission::SALES): ?>
                                                                SALES DEPARTMENT PERMISSIONS
                                                            <?php elseif($department == \App\Permission::ACCOUNTS): ?>
                                                                ACCOUNTS DEPARTMENT PERMISSIONS
                                                            <?php elseif($department == \App\Permission::PROCUREMENT): ?>
                                                                PROCUREMENT DEPARTMENT PERMISSIONS
                                                            <?php endif; ?>
                                                        </b>
                                                    </td>
                                                </tr>

                                                <tr></tr>

                                                <tr style="text-align: center;" class='dep_row<?php echo e($department); ?>'>
                                                    <th width="300px" style="text-align: center;">Access</th>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <th style="text-align: center;"> <input type="checkbox"
                                                                onclick="updateDepartment(<?php echo e($department); ?>)"
                                                                class="form-control selectAllDep<?php echo e($department); ?>">
                                                            &nbsp;&nbsp;<?php echo e($role->name); ?></th>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tr>

                                                <tr class='dep_row<?php echo e($department); ?>'>
                                                    <td style="text-align: center;"><b><?php echo e($p->display_name); ?></b></td>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first()): ?>
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep<?php echo e($department); ?>"
                                                                    checked=""
                                                                    name="permission[<?php echo e($role->id); ?>][<?php echo e($p->id); ?>]">
                                                            </th>
                                                        <?php else: ?>
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep<?php echo e($department); ?>"
                                                                    name="permission[<?php echo e($role->id); ?>][<?php echo e($p->id); ?>]">
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                                </tr>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                </tbody>
                            </table>

                    </form>
                </div>

            </div>
        </div>
    </div>
    <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $(function() {
            $('#myTable').DataTable({
                'order': false,
                'paging': false

            });

        });

        function updateDepartment(id) {

            c_id = '.selectAllDep' + id;
            check_id = '.dep' + id;

            var checked = $(c_id).is(':checked');
            if (checked) {

                $(check_id).each(function() {
                    $(this).prop("checked", true);
                });
            } else {
                $(check_id).each(function() {
                    $(this).prop("checked", false);
                });
            }

        }

        function updateAccordingToSelect(id) {
           
            if(id == 'all'){
                $("#select_department option:not(:selected)").each(function() {
                dep_row2 = '.dep_row' +$(this).val();
  $(dep_row2).each(function() {
                $(this).show();
            });
});
            }else
            {
                dep_row = '.dep_row' + id;
            $(dep_row).each(function() {
                $(this).show();
            });
            
            $("#select_department option:not(:selected)").each(function() {
                dep_row2 = '.dep_row' +$(this).val();
  $(dep_row2).each(function() {
                $(this).hide();
            });
});
            }
          
           
           



        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/Setting/role/permission.blade.php ENDPATH**/ ?>