

<?php $__env->startSection('title'); ?>
All Receipts 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
      </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


            <div class="container-fluid">


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <div class="pull-right">


                                <a href="<?php echo e(route('receipt.approve.all')); ?>" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Approve All 
                                </a>
                            </div>
                            
                            <h3 class="box-title">All Pending Receipts (<?php echo e(number_format($totalAmount)); ?>)</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Project</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                

                                        <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                            <td><?php echo e($receipt->receipt_no); ?></td>
                            <td><?php echo e($receipt->multiProject?$receipt->multiProject->name:'None'); ?></td>

                            <td><?php echo e($receipt->property ?  $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' : ''); ?></td>


                            <?php if($receipt->payment_method == \App\Receipt::cash): ?>
                            <td>Cash</td>
                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?>
                            <td>Bank</td>
                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?>
                            <td>Adjustment</td>
                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?>
                            <td>Cheque</td>
                             <?php elseif($receipt->payment_method == \App\Receipt::merging): ?>
                                            <td>Merging</td>
                            <?php else: ?>
                            <td></td>
                            <?php endif; ?>


                                    <?php if($receipt->payment_head == \App\CustomerStatement::down_payment): ?>
                                    <td class="printFV">
                                    <?php if( $receipt->property->booking_type == \App\CustomerProperty::full_payment): ?>
                                    <?php echo e('Full Payment'); ?>

                                    <?php else: ?>
                                    <?php echo e('Down Payment'); ?>

                                    <?php endif; ?>
                                    </td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::possession): ?>
                                    <td class="printFV">Possession Fee</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::installment): ?>
                                    <td class="printFV">Installment </td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::other): ?>
                                    <td class="printFV">Other</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::allotment): ?>
                                    <td class="printFV">Allotment</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::confirmation): ?>
                                    <td class="printFV">Confirmation</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::booking): ?>
                                    <td class="printFV">Booking</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::development): ?>
                                    <td class="printFV">Development</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::ballon): ?>
                                    <td class="printFV">Ballon</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::balloting): ?>
                                    <td class="printFV">Balloting</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::file_processing): ?>
                                    <td class="printFV">File Processing</td>
                                    <?php elseif($receipt->payment_head == \App\CustomerStatement::registration): ?>
                                    <td class="printFV">Registration</td>
                                    <?php else: ?>
                                    <td class="printFV"></td>
                                    <?php endif; ?>

                            
                            <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <td><?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?> PKR</td>
                            <?php else: ?>
                            <td><?php echo e(number_format($receipt->amount)); ?> PKR</td>
                            <?php endif; ?>
                            <td> <?php echo e(date('d-m-Y', strtotime($receipt->receipt_date))); ?></td>
                            <td class="text-nowrap">

                            <a href="<?php echo e(route('receipt.detail',['id'=>$receipt->id])); ?>" class="btn btn-default">View</a>



                            <a href="<?php echo e(route('receipt.editView',['id'=>$receipt->id])); ?>"  class="btn btn-success"> Edit </a>

                            <a  href="<?php echo e(route('receipt.approved',['id'=>$receipt->id])); ?>" class="btn btn-success" style="background: #4aa200; border: 1px solid #4aa200;"> 
                            Approve 
                            </a>

                            <?php if($receipt->payment_method == \App\Receipt::cheque): ?>
                                <a  href="<?php echo e(route('receipt.cancelled',['id'=>$receipt->id])); ?>" class="btn btn-warning" data-toggle="confirmation" data-placement="left" data-title="Are you sure to Cancel?"> 
                                Cancel 
                                </a>
                             <?php endif; ?>


                            <a href="<?php echo e(route('receipt.delete',['id'=>$receipt->id])); ?>" class="btn btn-danger" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" >Delete </a>


                            </td>
                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    $(function() {
      $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'sorting':false,
            'ordering':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if(plot == 0  && customer== 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'plot':plot,'customer':customer,'dealer':dealer,'payment_mode':payment_mode,'payment_head':payment_head,'receipt_no':receipt_no};
            $.get('/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                 $('#myTable').DataTable({
                'pageLength':50,
                'paging':true,
                'searching':false,
                'info':true,
                'dom': 'Bfrtip',
                'sorting':false,
                'ordering':false,
                "aaSorting": [[ 5, "asc" ]] ,
                'buttons': [
                'copy', 'csv', 'excel', 'pdf', 'print'
                ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/pending.blade.php ENDPATH**/ ?>