

<?php $__env->startSection('title'); ?>
    All Cancel Units
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Cancelled Units</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    ?>

    <?php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    ?>

    <div class="container-fluid">

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
            <?php echo $__env->make('partial.multiproject_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div id='updatecontent'  >
        

        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-cancellation')): ?>
                            <a href="<?php echo e(route('statement.cancel.add')); ?>" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Apply For Cancellation
                            </a>
                        <?php endif; ?>
                    </div>

                    <h3 class="box-title">Cancel Units </h3>



                    <ul class="nav customtab nav-tabs" role="tablist">

                        <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab"
                                data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                        class="ti-home"></i></span><span class="hidden-xs">Close Unit <?php if(count($allStatements) > 0): ?>
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);"><?php echo e(count($allStatements)); ?></span>
                                    <?php endif; ?>
                                </span>
                            </a></li>

                            <?php if($projectType->id == \App\ProjectType::society): ?>    
                        <li role="presentation" class=""><a href="#open_file" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Open File <?php if(count($allopenfile) > 0): ?>
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);"><?php echo e(count($allopenfile)); ?></span>
                                    <?php endif; ?>
                                </span></a></li>
                                <?php endif; ?>

                    </ul>
                    <div class="tab-content">
                        <div id="close_file" class="tab-pane fade in active">
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>

                                            <th>Project</th>
                                            <th style="width: 80px;">Unit #</th>
                                            
                                            <th>Member Name</th>
                                            <th>Net Amount</th>

                                            <th>Received Amount</th>

                                            
                                            <th>Cancel Date</th>
                                            <th>Cancel Fee(pkr)</th>
                                            <th>Request Status</th>
                                            <th>Unit Status</th>
                                            <th style="width: 386px;">After Cancellation Decision Request</th>
                                            <th>
                                            <!-- style="width: 185px!important;" -->
                                              Action
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>


                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'approve-cancellation')): ?>
                                            <?php $reopen_membership = true; ?>
                                        <?php else: ?>
                                            <?php $reopen_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                            <?php $view_membership = true; ?>
                                        <?php else: ?>
                                            <?php $view_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-cancellation')): ?>
                                            <?php $edit_membership = true; ?>
                                        <?php else: ?>
                                            <?php $edit_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-cancellation')): ?>
                                            <?php $delete_membership = true; ?>
                                        <?php else: ?>
                                            <?php $delete_membership = false; ?>
                                        <?php endif; ?>



                                        <?php $__currentLoopData = $allStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($count++); ?></td>

                                                <td><?php echo e($statement->multiProject ? $statement->multiProject->name : ' '); ?></td>
                                                <td><?php echo e($statement->inventory->unit_number); ?></td>
                                                
                                                <td><?php echo e($statement->customer ? $statement->customer->name : ''); ?><br><b>Dealer:
                                                    </b><?php echo e($statement->dealer ? $statement->dealer->name : ''); ?></td>

                                                <td><b><?php echo e(number_format($statement->net_pay)); ?></b></td>


                                                <td><b><?php echo e(number_format($receivedAmt[$statement->id])); ?></b></td>



                                                

                                                <td>
                                                    <?php if(empty($statement->cancel_date)): ?>
                                                        <?php echo e(date('d-m-Y', strtotime($statement->cancelProperty->created_at))); ?>

                                                    <?php else: ?>
                                                        <?php echo e(date('d-m-Y', strtotime($statement->cancel_date))); ?>

                                                    <?php endif; ?>

                                                </td>
                                                <td><?php echo e($statement->cancelProperty->fee); ?> </td>

                                                <?php if($statement->cancelProperty->status == 0): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#4871c6;;">Pending</span></td>
                                                <?php elseif($statement->cancelProperty->status == 1): ?>
                                                    <td><span class="label label-success">Approved</span></td>
                                                <?php else: ?>
                                                    <td></td>
                                                <?php endif; ?>


                                                <?php if($statement->status == \App\CustomerProperty::pending): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#cd703d;">Pending</span></td>
                                                <?php elseif($statement->status == \App\CustomerProperty::approved): ?>
                                                    <td><span class="label label-success">Approved</span></td>
                                                <?php elseif($statement->status == \App\CustomerProperty::cancel): ?>
                                                    <td><span class="label label-danger">Canceled</span></td>
                                                <?php else: ?>
                                                    <td></td>
                                                <?php endif; ?>

                                                <?php if($statement->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#4871c6;;">Pending</span></td>
                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'adjust-pending'): ?>
                                                    <td><span class="label label-success">Adjust/Pending</span></td>
                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'refund-pending'): ?>
                                                    <td><span class="label label-success">Refund/Pending</span></td>
                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'adjusted'): ?>
                                                    <td><span class="label label-success">Adjusted</span></td>
                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'refunded'): ?>
                                                    <td><span class="label label-success">Refunded</span></td>
                                                <?php elseif($statement->cancelProperty->after_cancellation_status == 'decline'): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#f80808;;">Decline</span></td>
                                                <?php endif; ?>




                                                <td class="text-nowrap">
                                                    <center>

                                                        <?php if($view_membership): ?>
                                                            <a href="<?php echo e(route('statement.detail', ['id' => $statement->id])); ?>"
                                                                data-toggle="tooltip" data-original-title="View"> <i
                                                                    class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>


                                                        <?php if(
                                                            $edit_membership &&
                                                                $statement->cancelProperty->after_cancellation_status != 'adjusted' &&
                                                                $statement->cancelProperty->after_cancellation_status != 'refunded' &&
                                                                $statement->cancelProperty->after_cancellation_status != 'decline'): ?>
                                                            <a href="<?php echo e(route('statement.cancel.edit', ['id' => $statement->id])); ?>"
                                                                data-toggle="tooltip" data-original-title="Edit"> <i
                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>
                                                        <?php if(
                                                            $reopen_membership &&
                                                                $statement->cancelProperty->status == 1 &&
                                                                $statement->cancelProperty->after_cancellation_status == 'pending'): ?>
                                                            <a type='button'
                                                                onclick="confirmReopen('<?php echo e($statement->id); ?>')"> <i
                                                                    class="fa fa fa-repeat text-inverse m-r-10"
                                                                    data-toggle="tooltip"
                                                                    data-original-title="ReOpen"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>

                                                        <?php if($delete_membership && $statement->cancelProperty->status == 0 && empty($statement->cancelProperty)): ?>
                                                            
                                                            <form
                                                                action="<?php echo e(route('statement.cancel.delete', [$statement->id])); ?>"
                                                                method="post" style='display: inline;'>
                                                                <?php echo method_field('delete'); ?>

                                                                <?php echo csrf_field(); ?>



                                                                <button class="btn btn-link btn-s" style="color:red;"
                                                                    type="submit" name="action" value="delete"
                                                                    data-toggle="confirmation"
                                                                    data-title="Are you sure to delete?">
                                                                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                                </button>
                                                            </form>
                                                        <?php endif; ?>




                                                    </center>
                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                                <div style="float: right;"><?php echo e($allStatements->links()); ?></div>
                            </div>
                        </div>
                        <?php if($projectType->id == \App\ProjectType::society): ?>  
                        <div id="open_file" class="tab-pane fade  ">
                            <div class="table-responsive">
                                <table id="myTable2" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project</th>
                                            <th>Package Name</th>
                                            <th>Unit #</th>

                                            <th>Dealer Name</th>
                                            <th>Dealer Code</th>
                                            

                                            


                                            <th>Cancel Date</th>
                                            <th>Cancel Fee(pkr)</th>
                                            <th>Request Status</th>
                                            <th>Open File Status</th>
                                            <th style="width: 138px;">After Cancellation Decision Request</th>
                                            <th>
                                            <!-- style="width: 185px!important;" -->
                                                <center>Action</center>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>


                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'approve-cancellation')): ?>
                                            <?php $reopen_membership = true; ?>
                                        <?php else: ?>
                                            <?php $reopen_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-cancellation')): ?>
                                            <?php $view_membership = true; ?>
                                        <?php else: ?>
                                            <?php $view_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-cancellation')): ?>
                                            <?php $edit_membership = true; ?>
                                        <?php else: ?>
                                            <?php $edit_membership = false; ?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-cancellation')): ?>
                                            <?php $delete_membership = true; ?>
                                        <?php else: ?>
                                            <?php $delete_membership = false; ?>
                                        <?php endif; ?>



                                        <?php $__currentLoopData = $allopenfile; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $openfile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($count++); ?></td>

                                                <td><?php echo e($openfile->inventory->multiProject ? $openfile->inventory->multiProject->name : ''); ?></td>
                                                <td>
                                                    <?php if($openfile->dealerPackage): ?>
                                                        <a
                                                            href='<?php echo e(route('openfile.detail', $openfile->dealerPackage->id)); ?>'>
                                                            <?php echo e($openfile->dealerPackage->package ? $openfile->dealerPackage->package->name : ''); ?>

                                                        </a>
                                                    <?php endif; ?>

                                                </td>
                                                <td><?php echo e($openfile->inventory->unit_number); ?></td>
                                                <td><?php echo e($openfile->dealer->name); ?></td>
                                                <td><?php echo e($openfile->dealer->code); ?></td>





                                                <td><?php echo e(date('d-m-Y', strtotime($openfile->cancelOpenFile->created_at))); ?>

                                                </td>
                                                <td><?php echo e($openfile->cancelOpenFile->fee); ?> </td>

                                                <?php if($openfile->cancelOpenFile->status == 0): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#4871c6;;">Pending</span></td>
                                                <?php elseif($openfile->cancelOpenFile->status == 1): ?>
                                                    <td><span class="label label-success">Approved</span></td>
                                                <?php else: ?>
                                                    <td></td>
                                                <?php endif; ?>



                                                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                                                    <?php $admin = true; ?>
                                                <?php else: ?>
                                                    <?php $admin = false; ?>
                                                <?php endif; ?>
                                                <?php if($admin): ?>
                                                    <?php if($openfile->inventory->status == \App\Inventory::open): ?>
                                                        <td><span class="label label-success">Open</span></td>
                                                    <?php elseif($openfile->inventory->status == \App\Inventory::package_open_file): ?>
                                                        <td><span class="label label-success">Open/Dealer Package
                                                                File</span></td>
                                                    <?php elseif($openfile->inventory->status == \App\Inventory::sold): ?>
                                                        <td><span class="label label-danger">Sold</span></td>
                                                    <?php elseif($openfile->inventory->status == \App\Inventory::hold_client): ?>
                                                        <td><span class="label label-primary">Client Hold</span></td>
                                                    <?php elseif($openfile->inventory->status == \App\Inventory::hold_company): ?>
                                                        <td><span class="label label-primary"
                                                                style="background-color:#cd703d;">Company Hold</span></td>
                                                                <?php elseif($openfile->inventory->status == \App\Inventory::package_open_file_refunded): ?>
                                                                <td><span class="label label-success">Open/Dealer Package Refunded</span>
                                                                </td>
                                                    <?php elseif($openfile->inventory->status == \App\Inventory::token_hold): ?>
                                                        <td><span class="label label-primary">Token Hold</span></td>
                                                    <?php else: ?>
                                                        <td></td>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <?php if($openfile->inventory->status == \App\Inventory::open): ?>
                                                        <td><span class="label label-success">Open</span></td>
                                                    <?php else: ?>
                                                        <td><span class="label label-danger">Sold</span></td>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <?php if($openfile->cancelOpenFile->after_cancellation_status == 'pending'): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#4871c6;;">Pending</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjust-pending'): ?>
                                                    <td><span class="label label-success">Adjust/Pending</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'refund-pending'): ?>
                                                    <td><span class="label label-success">Refund/Pending</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'adjusted'): ?>
                                                    <td><span class="label label-success">Adjusted</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'refunded'): ?>
                                                    <td><span class="label label-success">Refunded</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'decline'): ?>
                                                    <td><span class="label label-primary"
                                                            style="background-color:#f80808;;">Decline</span></td>
                                                <?php elseif($openfile->cancelOpenFile->after_cancellation_status == 'swap-pending'): ?>
                                                    <td><span class="label label-success">Swap/Pending</span></td>
                                                <?php endif; ?>




                                                <td class="text-nowrap">
                                                    <center>

                                                        


                                                        <?php if(
                                                            $edit_membership &&
                                                                $openfile->cancelOpenFile->after_cancellation_status != 'adjusted' &&
                                                                $openfile->cancelOpenFile->after_cancellation_status != 'refunded' &&
                                                                $openfile->cancelOpenFile->after_cancellation_status != 'decline'): ?>
                                                            <a href="<?php echo e(route('openfile.cancel.edit', ['id' => $openfile->id])); ?>"
                                                                data-toggle="tooltip" data-original-title="Edit"> <i
                                                                    class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>
                                                        <?php if(
                                                            $reopen_membership &&
                                                                $openfile->cancelOpenFile->status == 1 &&
                                                                $openfile->cancelOpenFile->after_cancellation_status == 'pending'): ?>
                                                            <a type='button'
                                                                onclick="confirmReopen('<?php echo e($openfile->id); ?>')"> <i
                                                                    class="fa fa fa-repeat text-inverse m-r-10"
                                                                    data-toggle="tooltip"
                                                                    data-original-title="ReOpen"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>

                                                        <?php if($delete_membership && $openfile->cancelOpenFile->status == 0 && empty($openfile->cancelOpenFile)): ?>
                                                            <form
                                                                action="<?php echo e(route('statement.cancel.delete', [$openfile->id])); ?>"
                                                                method="post" style='display: inline;'>
                                                                <?php echo method_field('delete'); ?>

                                                                <?php echo csrf_field(); ?>



                                                                <button class="btn btn-link btn-s" style="color:red;"
                                                                    type="submit" name="action" value="delete"
                                                                    data-toggle="confirmation"
                                                                    data-title="Are you sure to delete?">
                                                                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                                </button>
                                                            </form>
                                                        <?php endif; ?>




                                                    </center>
                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                                <div style="float: right;"><?php echo e($allStatements->links()); ?></div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
          $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,

            });
            $('#myTable2').DataTable({
                'pageLength': 25,

            });

        });
        function callItBack(){
        function confirmReopen(val) {

            var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');



            Swal.fire({
                    title: "Are you sure?",
                    text: "You want to reopen the Unit!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, Sure!'
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        $('.preloader').fadeIn();
                        $.ajax({
                            /* the route pointing to the post function */
                            url: '<?php echo e(route('reopen.cancel')); ?>',
                            type: 'POST',
                            /* send the csrf-token and the input to the controller */
                            data: {
                                _token: CSRF_TOKEN,
                                id: val
                            },
                            dataType: 'JSON',
                            /* remind that 'data' is the response of the AjaxController */
                            success: function(data) {
                                $('.preloader').fadeOut();
                                Swal.fire("Poof! Unit Reopened Successfully!", {

                                    confirmButtonColor: '#3085d6',
                                    cancelButtonColor: '#d33',
                                    confirmButtonText: 'Yes, Sure!'
                                }).then((result) => {
                                    location.reload();
                                });
                            }
                        });
                    } else {
                        $('.preloader').fadeOut();
                        Swal.fire("OK! Action Revert");
                    }
                });




            $('.preloader').fadeOut();
        }

      
      

    }
    callItBack();
        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('<?php echo e(route('statement.cancel')); ?>', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/cancel/index.blade.php ENDPATH**/ ?>