

<?php $__env->startSection('title'); ?>
All Balloting Map Files 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Balloting Map Files</li>
      </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-balloting')): ?>
								<a href="<?php echo e(route('balloting.setting.file.add')); ?>" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add Map File
								</a>
                                <?php endif; ?>
							</div>
                            <h3 class="box-title">All Balloting Map Files</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project</th>
                                            <th>Name</th>
                                             <th>Description </th>
                                            <th>Status</th>
                                           

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        <?php $__currentLoopData = $balloting_files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($count++); ?></td>
                                            <td><?php echo e($file->multiProject?$file->multiProject->name:'None'); ?></td>
                                            <td><a href='<?php echo e(route('balloting.setting.file.format.map',['id' => $file->id])); ?>'><?php echo e($file->name); ?></a></td>
                                            <td><?php echo e($file->description); ?></td>
                                            <?php if($file->status == 1): ?>
                                            <td><span class="label label-success">Active</span></td>
                                            <?php else: ?>
                                            <td><span class="label label-danger">InActive</span></td>
                                            <?php endif; ?>
                                            <td class="text-nowrap">
                                                <?php if($file->publish == 0): ?>
                                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-balloting')): ?>
                                                <a href="<?php echo e(route('balloting.publish.map',$file->id)); ?>" class="btn  btn-primary">
                                                    <i class="fa fa-plus-square"></i>&nbsp; Publish
                                                </a>
                                                <?php endif; ?>
                                                <?php else: ?>

                                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-balloting')): ?>
                                                <a href="<?php echo e(route('balloting.setting.file.view',['id' => $file->id])); ?>" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                
                                                <?php endif; ?>
<?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/balloting/setting/index.blade.php ENDPATH**/ ?>