

<?php $__env->startSection('title'); ?>
All Dealers List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right no-print">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Dealers List</li>
      </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'dealer-payment')): ?>
                                <!-- <a href="<?php echo e(route('dealer.payment.add')); ?>" class="btn  btn-default">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add Dealer Payment
                                </a> -->
                                <?php endif; ?>
                                
							</div>
                            <h3 class="box-title">All Dealers List</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Code</th>
                                            <th>Percentage</th>
                                            

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-dealer')): ?> 
                                            <?php $view_dealer = true;?>
                                        <?php else: ?>
                                            <?php $view_dealer = false;?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-dealer')): ?> 
                                            <?php $edit_dealer = true;?>
                                        <?php else: ?>
                                            <?php $edit_dealer = false;?>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-dealer')): ?> 
                                            <?php $delete_dealer = true;?>
                                        <?php else: ?>
                                            <?php $delete_dealer = false;?>
                                        <?php endif; ?>


                                        <?php $__currentLoopData = $allDealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($count++); ?></td>
                                            <td>
                                            <?php if($view_dealer): ?> 
                                                <a href="<?php echo e(route('dealer.detail',['id'=>$dealer->id])); ?>"><b><?php echo e($dealer->name); ?></b> - <?php echo e($dealer->dealerType ? $dealer->dealerType->name : ''); ?></a>
                                                <?php else: ?>
                                                <b><?php echo e($dealer->name); ?></b> - <?php echo e($dealer->dealerType ? $dealer->dealerType->name : ''); ?>

                                                <?php endif; ?>

                                            </td>
                                            <td><?php echo e($dealer->code); ?></td>
                                            <?php if($dealer->rebate_in_percent): ?>
                                            <td><?php echo e($dealer->percentage); ?> %</td>
                                            <?php else: ?>
                                            <td><?php echo e($dealer->percentage); ?> PKR</td>
                                            <?php endif; ?>
                                         
                                            <td class="text-nowrap">
                                                <?php if($view_dealer): ?>
                                                <a href="<?php echo e(route('dealer.detail',['id'=>$dealer->id])); ?>" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                <?php endif; ?>
                                                &nbsp;&nbsp;&nbsp;

                                                <?php if($edit_dealer): ?>
                                                <a href="<?php echo e(route('dealer.editView',['id'=>$dealer->id])); ?>" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                <?php endif; ?>
                                                    &nbsp;&nbsp;&nbsp;

                                                <?php if($delete_dealer): ?>
                                                <a href="<?php echo e(route('dealer.delete',['id'=>$dealer->id])); ?>" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/Dealer/index.blade.php ENDPATH**/ ?>