

<?php $__env->startSection('title'); ?>
All Receipts 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
      </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


            <div class="container-fluid">

                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                            
                            <h3 class="box-title">All Receipts (<?php echo e(number_format($totalAmount)); ?>)</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Payment Mode</th>
                                            
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                        <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                           <td><?php echo e($receipt->receipt_no); ?></td>
                                           
                                             <?php if($receipt->payment_method == \App\Receipt::cash): ?>
                                            <td>Cash</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?>
                                            <td>Bank</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?>
                                            <td>Adjustment</td>
                                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?>
                                            <td>Cheque</td>
                                            <?php else: ?>
                                            <td></td>
                                            <?php endif; ?>


                                            <?php if($receipt->customerPropertyTax->tax_paid_by == \App\Receipt::company): ?>
                                            <td><?php echo e(number_format($receipt->receipt_amount)); ?> PKR</td>
                                            <?php else: ?>
                                            <td><?php echo e(number_format($receipt->receipt_amount)); ?> PKR</td>
                                            <?php endif; ?>
                                             <td> <?php echo e(date('d-m-Y', strtotime($receipt->receipt_date))); ?></td>
                                            <td class="text-nowrap">
                                                
                                              
                                                <a href="<?php echo e(route('receipt.tax.detail',['id'=>$receipt->id])); ?>" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
                                          

                                                <a href="<?php echo e(route('customer.receipt.delete',['id'=>$receipt->id])); ?>" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                             
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>
                                </table>
                              
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':true,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if(unit == 0 && customer== 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'unit':unit,'customer':customer,'dealer':dealer,'payment_mode':payment_mode,'payment_head':payment_head,'receipt_no':receipt_no};
            $.get('/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true,
                    'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/customer_tax_receipt.blade.php ENDPATH**/ ?>