 

<?php $__env->startSection('title'); ?> Payment Receipt <?php $__env->stopSection(); ?> 

<?php $__env->startSection('css'); ?>
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media  print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right no-print">
    <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li> <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-dealer')): ?>
    <li><a href="#">Payment Receipt</a></li> 
    <?php endif; ?>
    <li class="active">Receipt Detail</li>
</ol> 
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
       
                
        <div class="col-lg-12">
            
            
            
            
            
             <div class="row no-print">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Receipt Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt #</td>
                                                    <td><?php echo e($receipt->receipt_no); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>Date</td>
                                                    <td><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>Customer</td>
                                                    <td><?php echo e($receipt->customerPropertyTax->statement->receipt->customer->name); ?> </td>
                                                </tr>
                                                <tr>
                                                    <td>Unit No.</td>
                                                    <td> <?php echo e($receipt->customerPropertyTax->statement->receipt->property->inventory->unit_number); ?> </td>
                                                </tr>

                                                <tr>
                                                    <td>Payment Head</td>
                                                        <td>
                                                        <?php if($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::down_payment): ?>
                                                        Down Payment
                                                        <?php elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::installment): ?>
                                                        Installment
                                                        <?php elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::others): ?>
                                                        Others
                                                        <?php endif; ?>
                                                        </td>
                                                </tr>

                                               <tr>
                                                    <td>Payment Mode</td>
                                                    <?php if($receipt->payment_method == \App\Receipt::cash): ?>
                                                    <td>Cash</td>
                                                    <?php elseif($receipt->payment_method == \App\Receipt::bank): ?>
                                                    <td>Bank transfer
                                                    <br>
                                                    <b>Depositor bank:</b> 

                                                    <?php echo e($receipt->DepositorBank ? $receipt->DepositorBank->name : ''); ?>


                                                    <br>
                                                    <b>Company bank:</b> 

                                                    <?php echo e($receipt->companyAccount ? $receipt->companyAccount->name : ''); ?>



                                                    </td>
                                                    <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?>
                                                    <td>Cheque</td>
                                                    <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?>
                                                    <td>Adjustment</td>
                                                    <?php endif; ?>
                                                </tr>

                                                <?php if($receipt->payment_method == \App\Receipt::cheque || $receipt->payment_method == \App\Receipt::bank): ?>
                                                 <tr>
                                                    <td>Instrument No </td>
                                                    <td><?php echo e($receipt->cheque_number); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                              
                                        

                                                 <tr>
                                                    <td>Net Amount</td>
                                                    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                                    <td><?php echo e(number_format($receipt->receipt_amount )); ?></td>

                                                    <?php else: ?>

                                                    <td><?php echo e(number_format($receipt->receipt_amount)); ?></td>

                                                    <?php endif; ?>
                                                </tr>

                                               

                                                <tr>
                                                    <td>Tax Payment Received</td>
                                                    <td><?php if($receipt->tax_payment_received): ?>
                                                        YES
                                                        <?php else: ?>
                                                        NO
                                                    <?php endif; ?>
                                                </td>
                                                </tr>

                                                <tr>
                                                    <td>Notes</td>
                                                    <td><?php echo e($receipt->note); ?></td>
                                                </tr>
                                                

                                              
                                            
                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                
                
                
                
                
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>
                            <?php if($receipt): ?>
                                <?php if($receipt->customerPropertyTax): ?>
                                    <?php echo e($receipt->customerPropertyTax->statement->receipt->property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h3>
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Office Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->receipt_no); ?></div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->customerPropertyTax->statement->receipt->customer->name); ?></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->customerPropertyTax->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        <?php if($i == 5 || $i == 12): ?> - <?php endif; ?> <?php echo e($c[$i]); ?>

                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                 <?php if(!empty($receipt->payment_method)): ?>
                                        
                                        <?php if($receipt->payment_method == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        <?php else: ?>
                                        
                                        <?php if($receipt->payment_mode == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        
                                        <?php endif; ?>

                            </div>

                            <?php if($receipt->customerPropertyTax->tax_paid_by == \App\Receipt::company): ?> 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;<?php echo e(number_format($receipt->tax_amount)); ?>


                            </div>
                            <?php endif; ?>


                            <?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?>
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    <?php echo e($receipt->instrument_no); ?> 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong><?php echo e($receipt->drawn_date); ?></strong>
                            </div>
                            <?php endif; ?>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                            <?php endif; ?>
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b><?php echo e($words); ?> only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

           <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>
                            <?php if($receipt): ?>
                                <?php if($receipt->customerPropertyTax): ?>
                                    <?php echo e($receipt->customerPropertyTax->statement->receipt->property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h3>
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Accounts Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->receipt_no); ?></div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->customerPropertyTax->statement->receipt->customer->name); ?></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->customerPropertyTax->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        <?php if($i == 5 || $i == 12): ?> - <?php endif; ?> <?php echo e($c[$i]); ?>

                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                 <?php if(!empty($receipt->payment_method)): ?>
                                        
                                        <?php if($receipt->payment_method == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        <?php else: ?>
                                        
                                        
                                          
                                        <?php if($receipt->payment_mode == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        
                                        <?php endif; ?>

                            </div>

                            <?php if($receipt->customerPropertyTax->tax_paid_by == \App\Receipt::company): ?> 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;<?php echo e(number_format($receipt->tax_amount)); ?>


                            </div>
                            <?php endif; ?>


                            <?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?>
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    <?php echo e($receipt->instrument_no); ?> 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong><?php echo e($receipt->drawn_date); ?></strong>
                            </div>
                            <?php endif; ?>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                            <?php endif; ?>
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b><?php echo e($words); ?> only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

          <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>
                            <?php if($receipt): ?>
                                <?php if($receipt->customerPropertyTax): ?>
                                    <?php echo e($receipt->customerPropertyTax->statement->receipt->property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h3>
                    
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Client Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->receipt_no); ?></div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->customerPropertyTax->statement->receipt->customer->name); ?></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->customerPropertyTax->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        <?php if($i == 5 || $i == 12): ?> - <?php endif; ?> <?php echo e($c[$i]); ?>

                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                 <?php if(!empty($receipt->payment_method)): ?>
                                        
                                        <?php if($receipt->payment_method == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        <?php else: ?>
                                        
                                        
                                          
                                        <?php if($receipt->payment_mode == \App\Receipt::cash): ?> Cash 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?> Bank 

                                        <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                        <?php else: ?> 
                                        Adjustment 

                                        <?php endif; ?> 
                                        
                                        
                                        <?php endif; ?>

                            </div>

                            <?php if($receipt->customerPropertyTax->tax_paid_by == \App\Receipt::company): ?> 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;<?php echo e(number_format($receipt->tax_amount)); ?>


                            </div>
                            <?php endif; ?>


                            <?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?>
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    <?php echo e($receipt->instrument_no); ?> 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong><?php echo e($receipt->drawn_date); ?></strong>
                            </div>
                            <?php endif; ?>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->receipt_amount)); ?>

                            <?php endif; ?>
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b><?php echo e($words); ?> only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script src="<?php echo e(asset('js/jquery.PrintArea.js')); ?>" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"<?php echo e(route('receipt.document')); ?>",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/customer_tax_detail.blade.php ENDPATH**/ ?>