

<?php $__env->startSection('title'); ?>
NOC
<?php $__env->stopSection(); ?>

    <?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo e(route('noc_req')); ?>">NOCs</a></li>
        <li class="active">Issue of NOC</li>
    </ol>
    <?php $__env->stopSection(); ?>

        <?php $__env->startSection('css'); ?>

        <style type="text/css">

        </style>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

            <div class="container-fluid">
                <form method="post" action="<?php echo e(route('noc.update')); ?>" class="form-horizontal"
                    id="receipt_form">
                    <?php echo method_field('put'); ?>

                    <?php echo csrf_field(); ?>

                    <input type='hidden' value='<?php echo e($noc->id); ?>' name='id'>
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-xs-12">
                            <?php if($errors->any()): ?>
                                <div class="white-box">
                                    <h2>Errors</h2>
                                    <ul>
                                        <?php echo implode('', $errors->all('<li><span
                                                class="help-block"><strong>:message</strong></span></li>')); ?>

                                    </ul>
                                </div>
                            <?php endif; ?>
                            <div class="white-box1">
                                <h3 class="box-title">Issue of NOC</h3>
                                <hr>



                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">Status
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <select name="status" id="status">
                                                    <?php if($noc->status==1): ?> {
                                                        <option value="1" selected="">Approved</option>
                                                        <option value="0" >Pending</option>
                                                    }
                                                    <?php else: ?> {
                                                        <option value="1" >Approved</option>
                                                        <option value="0" selected="">Pending</option>
                                                    }
                                                    <?php endif; ?>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">NOC No
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="noc_no"
                                                    value="<?php echo e($noc->noc_no); ?>" id="noc_no">
                                                <?php if($errors->has('noc_no')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('noc_no')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputuname" class="control-label col-md-4">NOC Date
                                            <span style="color: red">*</span>
                                        </label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="date" class="form-control" name="noc_date" id="noc_date"
                                                    value="<?php echo e($noc->noc_date); ?>">
                                                <?php if($errors->has('noc_date')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('noc_date')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">


                                        <label class="control-label col-md-4">Select Customer<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select name="customer_id" id='customer_id'
                                                class="form-control chosen-select"
                                                onchange="updateProperty(this.value)">
                                                <option value="<?php echo e($noc->customer_id); ?>" selected="">
                                                    <?php echo e($noc->customer->name); ?></option>
 
                                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php if(old('customer_id') == $customer->id): ?>
                                                        <option selected="" value="<?php echo e($customer->id); ?>">None
                                                            <?php echo e($customer->name); ?> - <?php echo e($customer->cnic); ?> </option>

                                                    <?php else: ?>
                                                        <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?> -
                                                            <?php echo e($customer->cnic); ?></option>
                                                    <?php endif; ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <?php if($errors->has('customer_id')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('customer_id')); ?></strong>
                                                </span>
                                            <?php endif; ?>

                                        </div>

                                        <br><br><br><br>
                                        <div class="form-group">
                                            <label for="exampleInputuname" class="control-label col-md-4">Contact No
                                                <span style="color: red">*</span>
                                            </label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="contact_no" readonly
                                                        value="<?php echo e($noc->customer->mobile_number); ?>"
                                                        id="contact_no">
                                                    <?php if($errors->has('contact_no')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('contact_no')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputuname"
                                                class="control-label col-md-4">S/O,D/O,W/O<span
                                                    style="color: red">*</span>
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="father_name_parent"
                                                        readonly value="<?php echo e($noc->customer->father_name); ?>"
                                                        id="father_name_parent">
<?php if($errors->has('father_name_parent')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('father_name_parent')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="cnic" class="control-label col-md-4">CNIC
                                                <span style="color: red">*</span></label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" readonly
                                                        value="<?php echo e($noc->customer->cnic); ?>" name="cnic"
                                                        id="cnic">


                                                    <?php if($errors->has('cnic')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('cnic')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <br><br><br><br><br><br>
                                        <label class="control-label col-md-4">Select Unit No.<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select name="unit_number_id" id='unit_number_id' class="form-control"
                                                onchange="updateUnit(this.value)">
                                                <option value="<?php echo e($noc->unit_number_id); ?>" selected="">
                                                    <?php echo e($noc->unitNumber->unit_number); ?></option>

                                            </select>

                                            <?php if($errors->has('unit_number_id')): ?>
                                                <span class="help-block">
                                                    <strong><?php echo e($errors->first('unit_number_id')); ?></strong>
                                                </span>
                                            <?php endif; ?>

                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="address" class="control-label col-md-4">Sector
                                            <span style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="unit_floor_id" readonly
                                                    value="<?php echo e($noc->unitNumber->floor ? $noc->unitNumber->floor->name : ''); ?>"
                                                    id="unit_floor_id">
                                                <?php if($errors->has('unit_floor_id')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('unit_floor_id')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>




                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="control-label col-md-4">Phase<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="phase" readonly
                                                    value="<?php echo e($noc->unitNumber->floor? $noc->unitNumber->floor->unit_block ? $noc->unitNumber->floor->unit_block->name : 'N/A':''); ?>"
                                                    id="phase">
                                                <?php if($errors->has('phase')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('phase')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="control-label col-md-4">Membership No.
                                            <span style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="membership_no" readonly
                                                    value="<?php echo e($noc->unitNumber->property->membership_no); ?>"
                                                    id="membership_no" style="width: 390px">
                                                <?php if($errors->has('membership_no')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('membership_no')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="col-md-12" id='property'> </div>

                                <div class="clearfix"></div>
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                    <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                        style="width: 100%">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            </form>
            </div>

            <?php $__env->stopSection(); ?>

                <?php $__env->startSection('js'); ?>

                <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                </script>

                <script>
                    $(":input").inputmask();

                    function updateUnit(id) {


                        $('.preloader').fadeIn();

                        var unit_number_id = id;


                        var data = {
                            'unit_number_id': unit_number_id
                        };

                        $.get('/noc/getunitinfo', data, function (data) {

                            console.log(data);


                            $('#unit_floor_id').val(data.floor.name);
                            $('#phase').val(data.floor.unit_block.name);
                            $('#membership_no').val(data.property.membership_no);

                            $('.preloader').fadeOut();
                        });
                    }

                    function updateProperty(id) {


                        $('.preloader').fadeIn();

                        var customer_id = id;


                        var data = {
                            'customer_id': customer_id
                        };

                        $.get('/noc/getcustomerinfo', data, function (data) {


                            $('#contact_no').val(data.mobile_number);
                            $('#father_name_parent').val(data.father_name);
                            $('#cnic').val(data.cnic);


                            var model = $('#unit_number_id');
                            model.empty();

                            model.append("<option value='' disabled selected>" +
                                '' +
                                "</option>");


                            $.each(data.properties, function (index, element) {



                                model.append("<option value='" + element.inventory.id + "'>" +
                                    element.inventory.unit_number + "</option>");
                            });
                            // document.getElementById('property').innerHTML = data;

                            // $('#myTable').DataTable({
                            //     "paging": false,
                            //     "ordering": false,
                            //     "info": false
                            // });
                        });

                        // $('#wait').hide();
                        $('.preloader').fadeOut();

                    }
                </script>


                <?php $__env->stopSection(); ?>
                    <?php if($errors->any()): ?>

                        <script>
                            window.onload = function () {

                                updateProperty('<?php echo e(old("customer_id")); ?>');

                                var payment_method = $('#payment_method').val();
                                changeFunc(payment_method)
                            }
                        </script>
                    <?php endif; ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views//noc/edit.blade.php ENDPATH**/ ?>