

<?php $__env->startSection('title'); ?>
    All Inventories
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i>Home</a></li>

        <li class="active">All Inventories</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    ?>


    <?php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    ?>

    <div class="container-fluid">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
            <?php echo $__env->make('partial.multiproject_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <!--./row-->


        <div id='updatecontent'>


            <!--.row-->
            <div class="row" style="margin-top: 25px;">
                <div class="col-md-12">
                    <div class="panel panel-info">
                        <div class="panel-heading">Search Inventory</div>
                        <div class="panel-wrapper collapse in" aria-expanded="true">

                            <div class="panel-body">
                                <form>
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Unit Number</label>
                                                    <select id="unit" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($p->id); ?>"><?php echo e($p->unit_number); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                </div>
                                            </div>
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By <?php echo e($map); ?></label>

                                                    <select id="floor" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By Size</label>

                                                    <select id="size" class="form-control chosen-select">
                                                        <option value="0">None</option>
                                                        <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($s->id); ?>">
                                                                <?php echo e($s->name); ?> <?php echo e($size); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->

                                            <!--/span-->
                                            <div class="col-md-3">
                                                <div class="form-group has-success" style="margin-bottom: 15px">
                                                    <label class="control-label">By status</label>
                                                    <select id="status" class="form-control chosen-select">
                                                        <option value="0">None</option>

                                                        <option value="<?php echo e(\App\Inventory::open); ?>">Open</option>
                                                        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                                                            <!-- <option  value="<?php echo e(\App\Inventory::hold_client); ?>">Client Hold</option> -->
                                                            <option value="<?php echo e(\App\Inventory::hold_company); ?>">Company Hold
                                                            </option>
                                                            <option value="<?php echo e(\App\Inventory::token_hold); ?>">Token Hold
                                                            </option>
                                                            <option value="<?php echo e(\App\Inventory::temp_hold); ?>">Temporary Hold
                                                            </option>
                                                        <?php endif; ?>
                                                        <option value="<?php echo e(\App\Inventory::sold); ?>">Sold</option>

                                                    </select>
                                                </div>
                                            </div>
                                            <!--/span-->
                                        </div>

                                    </div>
                                    <div class="form-actions">
                                        <button type="button" class="btn btn-success search-customer"> <i
                                                class="fa fa-check"></i> Search</button>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row colorbox-group-widget">
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-primary">
                            <div class="media-body">
                                <h3 class="info-count"><?php echo e(number_format($total_units_count)); ?><span class="pull-right"><i
                                            class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                <p class="info-text font-12">Total Units</p>
                                <p class="info-ot font-15"><span class="label "
                                        style="color:#58508d!important; background: #58508d!important">.</span></p>
                                <p class="info-ot font-15">Booked Units<span
                                        class="label label-rounded"><?php echo e(number_format($booked_units_count)); ?></span></p>
                                <p class="info-ot font-15">Un-Booked Units<span
                                        class="label label-rounded"><?php echo e(number_format($un_booked_units_count)); ?></span></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-success">
                            <div class="media-body">
                                <h3 class="info-count"><?php echo e(number_format($total_units_area)); ?> <?php echo e(env('SIZE')); ?><span
                                        class="pull-right"><i class="mdi mdi-comment-text-outline"></i></span></h3>
                                <p class="info-text font-12">Total Area</p>
                                <p class="info-ot font-15"><span class="label "
                                        style="color:#bc5090!important; background: #bc5090!important">.</span></p>
                                <p class="info-ot font-15">Booked Area<span
                                        class="label label-rounded"><?php echo e(number_format($booked_units_area)); ?>

                                        <?php echo e(env('SIZE')); ?></span></p>
                                <p class="info-ot font-15">Un-Booked Area<span
                                        class="label label-rounded"><?php echo e(number_format($un_booked_units_area)); ?>

                                        <?php echo e(env('SIZE')); ?></span></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-6 info-color-box">
                    <div class="white-box">
                        <div class="media bg-danger">
                            <div class="media-body">
                                <h3 class="info-count">Rs. <?php echo e(number_format($total_units_amount)); ?> <span
                                        class="pull-right"><i class="mdi mdi-coin"></i></span></h3>
                                <p class="info-text font-12">Total Price</p>
                                <p class="info-ot font-15">Booked Price<span class="label label-rounded">Rs.
                                        <?php echo e(number_format($booked_units_amount)); ?> </span></p>
                                <p class="info-ot font-15">Un-Booked Price<span class="label label-rounded">Rs.
                                        <?php echo e(number_format($un_booked_units_amount)); ?> </span></p>
                                <p class="info-ot font-15">Discount<span class="label label-rounded">Rs.
                                        <?php echo e(number_format($booked_units_amount - $total_cost_booked_units)); ?> </span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- /row -->
            <div class="row" id="update-table">
                <div class="col-sm-12">
                    <div class="white-box">
                        <!-- <div class="pull-right">
                                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-inventory')): ?>
        <a href="<?php echo e(route('inventory.add')); ?>" class="btn  btn-primary">
                                                                            <i class="fa fa-plus-square"></i>&nbsp; Add new Inventory
                                                                        </a>
    <?php endif; ?>
                                                </div> -->
                        <h3 class="box-title">All Inventories (<?php echo e(number_format($inventoryCount)); ?>)</h3>

                        <div class="table-responsive">
                            <table id="myTable" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Sr #</th>
                                        <th>Project</th>
                                        <th>Unit #</th>
                                        <!-- <th>floor</th>
                                                                <th>Type</th> -->
                                        <th>Size</th>

                                        <th>Net Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $count = 1; ?>
                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-inventory')): ?>
                                        <?php $view_inventory = true; ?>
                                    <?php else: ?>
                                        <?php $view_inventory = false; ?>
                                    <?php endif; ?>
                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-inventory')): ?>
                                        <?php $edit_inventory = true; ?>
                                    <?php else: ?>
                                        <?php $edit_inventory = false; ?>
                                    <?php endif; ?>
                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-inventory')): ?>
                                        <?php $delete_inventory = true; ?>
                                    <?php else: ?>
                                        <?php $delete_inventory = false; ?>
                                    <?php endif; ?>
                                    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                                        <?php $admin = true; ?>
                                    <?php else: ?>
                                        <?php $admin = false; ?>
                                    <?php endif; ?>

                                    <?php $__currentLoopData = $allInventories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($count++); ?></td>
                                            <td><?php echo e($i->multiProject ? $i->multiProject->name : 'None'); ?>


                                            </td>
                                            <td>
                                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-inventory')): ?>
                                                    <a
                                                        href="<?php echo e(route('inventory.detail', ['id' => $i->id])); ?>"><?php echo e($i->unit_number); ?></a>
                                                <?php else: ?>
                                                    <?php echo e($i->unit_number); ?>

                                                <?php endif; ?>

                                            </td>

                                            <td><?php echo e($i->size ? $i->size->name : ''); ?>

                                                <?php echo e($size); ?>

                                            </td>
                                            <td><?php echo e(number_format($i->total_price)); ?></td>

                                            <?php if($admin): ?>
                                                <?php if($i->status == \App\Inventory::open): ?>
                                                    <td><span class="label label-success">Open</span></td>
                                                <?php elseif($i->status == \App\Inventory::package_open_file): ?>
                                                    <td><span class="label label-success">Open/Dealer Package File</span></td>
                                                <?php elseif($i->status == \App\Inventory::package_open_file_refunded): ?>
                                                    <td><span class="label label-success">Open/Dealer Package Refunded</span></td>
                                                <?php elseif($i->status == \App\Inventory::sold): ?>
                                                    <td><span class="label label-danger">Sold</span></td>
                                                <?php elseif($i->status == \App\Inventory::hold_client): ?>
                                                    <td><span class="label label-primary">Client Hold</span></td>
                                                <?php elseif($i->status == \App\Inventory::hold_company): ?>
                                                    <td><span class="label label-primary">Company Hold</span></td>
                                                <?php elseif($i->status == \App\Inventory::token_hold): ?>
                                                    <td><span class="label label-primary">Token Hold</span></td>
                                                <?php elseif($i->status == \App\Inventory::temp_hold): ?>
                                                    <td><span class="label label-primary">Temporary Hold</span></td>
                                                <?php else: ?>
                                                    <td></td>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php if($i->status == \App\Inventory::open): ?>
                                                    <td><span class="label label-success">Open</span></td>
                                                <?php else: ?>
                                                    <td><span class="label label-danger">Sold</span></td>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <td class="text-nowrap">
                                                <?php if($view_inventory): ?>
                                                    <a href="<?php echo e(route('inventory.detail', ['id' => $i->id])); ?>"
                                                        data-toggle="tooltip" data-original-title="View"> <i
                                                            class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                <?php endif; ?>

                                                <?php if($i->status != \App\Inventory::package_open_file): ?>
                                                <?php if($edit_inventory): ?>
                                                    <a href="<?php echo e(route('inventory.editView', ['id' => $i->id])); ?>"
                                                        data-toggle="tooltip" data-original-title="Edit"> <i
                                                            class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                <?php endif; ?>
                                                <?php endif; ?>

                                                
                                                <?php if($delete_inventory): ?>
                                                    <a data-toggle="confirmation" data-title="Are you sure to delete?"
                                                        href="<?php echo e(route('inventory.delete', ['id' => $i->id])); ?>"> <i
                                                            class="fa fa-close text-danger"></i> </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                
                            </table>
                            <div style="float: right;"><?php echo e($allInventories->links()); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


    <script>
         $(function() {
                $('#myTable').DataTable({
                    'pageLength': 25,
                    'paging': false,
                    'searching': false,
                    'info': false,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
            });
        function callItBack() {
           

            $('.search-customer').on('click', function() {
                $('.preloader').fadeIn();
                unit = $('#unit').val();
                floor = $('#floor').val();
                size = $('#size').val();
                status = $('#status').val();
                var selectValue = "";
                if ($("#multipro").length > 0) {
                     if($("#multipro").val() !== 'search'){
                    selectValue = $("#multipro").val();
                     }
                    // Do something with the value
                }


                if (unit == 0 && floor == 0 && size == 0 && status == 0) {
                    toastr.warning("please select any option.");
                    $('.preloader').fadeOut();
                    return false;
                }

                var data = {
                    'unit': unit,
                    'floor': floor,
                    'size': size,
                    'status': status,
                    'multipro_id': selectValue
                };

                $.get('/inventory/updateTable', data, function(data) {
                    document.getElementById('update-table').innerHTML = data;

                    $('#myTable').DataTable({
                        'pageLength': 50,
                        'paging': false,
                        'searching': false,
                        'info': true,
                        'dom': 'Bfrtip',
                        'buttons': [
                            'copy', 'csv', 'excel', 'pdf', 'print'
                        ]
                    });
                    toastr.success("Search updated.");


                    $('.preloader').fadeOut();
                });
            });
        }

        callItBack();
        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            if (value == "") {
                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('<?php echo e(route('inventory.all')); ?>', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/inventory/index.blade.php ENDPATH**/ ?>