 

<?php $__env->startSection('title'); ?> Payment Receipt <?php $__env->stopSection(); ?> 

<?php $__env->startSection('css'); ?>
<style type="text/css">

/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

/*Old css starts here*/
/*.container-fluid {
    padding: 3px 30px 0;
}

@media  print {
    
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    
    h3 {
        margin: 0;
        line-height: 1;
    }
    
    .white-box {
        border: none !important;
    }

    
}*/
/*Old css ends here*/

.container-fluid {
    padding: 3px 30px 0;
}

.qr-code {
    display: inline-block;
    border: 1px solid black;
    margin-top: 5px;
}

.payment {
    font-size: 16px;
    text-transform: capitalize;
}

h1 strong, h3 strong {
    color: black !important;
}

@media  print {
    
    .page-wrapper {
        font-size: 10.5px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    
    p {
        margin-bottom: 5px;
    }
    
    h3 {
        margin: 0;
        line-height: 1;
        font-size: 14px;
    }
    
    /*.white-box {
        border: none !important;
    }*/
    
    .margin-less {
        margin-left: -4px;
        margin-right: -4px;
    }
    
    .sperator {
        margin-top: 5px;
        margin-bottom: 5px;
    }
    
    .payment {
        font-size: 14px;
    }
}


strong {
    color: #000000 !important;
}

body, p {
    color: black;
}

</style> 
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right no-print">
    <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li> <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-dealer')): ?>
    <li><a href="#">Payment Receipt</a></li> 
    <?php endif; ?>
    <li class="active">Receipt Detail</li>
</ol> 
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('content'); ?>

<?php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
?>

<?php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

?>
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
        <div class="row no-print">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">

                        <div class="row">
                            <div class="col-sm-6" style="margin-top: 1rem;">
                                  <span> Receipt Information</span>
                            </div>

                            <div class="col-sm-6">
                                <form class="d-flex" style="padding-left: 15rem;" method="post" onsubmit="return upload_receipt_docs(this , '<?php echo e($receipt->id); ?>')">
                                    <div class="row">
                                        <div class="col-sm-8">
                                            <span id="error_message" style="color: red;display: none;"></span>
                                            <span id="success_message" style="color: green;display: none;"></span>
                                            <input type='hidden' id='unit_type' name="unit_type" value="<?php echo e(\App\RefundReceiptDocument::close_unit); ?>">
                                            <label>Upload Multiple docx <small>(image, pdf, word)</small></label>
                                            <input name="files[]" id="files" class="form-control me-2" multiple type="file" aria-label="Search">
                                        </div>
                                        <div class="col-sm-4" style="margin-top: 3.5rem;">
                                            <button id="upload_btn" class="btn btn-outline-success" type="submit">Upload</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                         
                    </h3>
                    
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Receipt #</td>
                                    <td><?php echo e($receipt->receipt_no); ?></td>
                                </tr>
                                <tr>
                                    <td>Date</td>
                                    <td><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></td>
                                </tr>
                                <tr>
                                    <td>Customer</td>
                                    <td><?php echo e($receipt->customer->name); ?> </td>
                                </tr>
                                <tr>
                                    <td>Unit No.</td>
                                    <td> <?php echo e($receipt->property->inventory ? $receipt->property->inventory->unit_number : ''); ?> </td>
                                </tr>
                               
                                <tr>
                                    <td>Payment Mode</td> 

                                    <td>
                                        
                                        <?php if(!empty($receipt->payment_method)): ?>
                                        
                                            <?php if($receipt->payment_method == \App\Receipt::cash): ?> Cash 
                                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> Bank 
                                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> Cheque/ DD/ PO 
                                            <?php else: ?> 
                                            Adjustment 
                                            <?php endif; ?> 
                                        
                                        <?php else: ?>
                                        
                                            <?php if($receipt->payment_mode == \App\Receipt::cash): ?> Cash 
    
                                            <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?> Bank 
    
                                            <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?> Cheque/ DD/ PO 
    
                                            <?php else: ?> 
                                            
                                            Adjustment 
    
                                            <?php endif; ?> 
                                        
                                        
                                        <?php endif; ?>
                                        
                                        
                                        
                                    </td>
                                </tr>

                                <?php if(!empty($receipt->cheque_number)): ?>
                                <tr>
                                    <td>Instrument No.</td>
                                    <td> <?php echo e($receipt->cheque_number); ?> </td>
                                </tr>
                                <?php endif; ?>

                                <?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?>
                                <tr>
                                    <td>Company Account</td>
                                    <td>
                                        
                                        <?php $__currentLoopData = $cBanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <?php if($company_bank->id == $receipt->company_account): ?>
                                        <?php echo e($company_bank->name); ?>

                                        <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>Depositor Bank Account</td>
                                    <td>
                                        
                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depositor_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        
                                        <?php if($depositor_bank->id == $receipt->bank_name): ?>
                                        <?php echo e($depositor_bank->name); ?>

                                        <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>


                                <tr>
                                    <td>Deduction Amount</td>
                                    <td><?php echo e(number_format($receipt->amount)); ?></td>
                                </tr>
                                <tr>
                                    <td>Refunded Amount</td>
                                    <td><?php echo e(number_format($property->unitRefundHistory->total_refund)); ?></td>
                                </tr>
                                <tr>
                                    <td>Tax Amount</td>
                                    <td>
                                        <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                        <?php echo e(number_format($receipt->tax_amount)); ?>

                                        <?php else: ?>
                                        <?php echo e(number_format(0)); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Net Amount</td>
                                    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                    <td><?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?></td>
                                    <?php else: ?>
                                    <td><?php echo e(number_format($receipt->amount)); ?></td>
                                    <?php endif; ?>
                                </tr>

                                <tr>
                                    <td>Tax Pay By</td>
                                    <td>
                                        <?php if($receipt->tax_paid_by == \App\Receipt::customer): ?>
                                        Customer
                                        <?php else: ?>
                                        Company
                                        <?php endif; ?>
                                    </td>
                                </tr>

                                <tr>
                                    <td>Tax Payment Received</td>
                                    <td>
                                        <?php if($receipt->tax_payment_received): ?>
                                        YES
                                        <?php else: ?>
                                        NO
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Notes</td>
                                    <td><?php echo e($receipt->notes); ?></td>
                                </tr> 

                                <?php if($receipt->payment_method == \App\Receipt::adjustment): ?>
                                <tr>
                                    <td>Adjustment Detail</td>
                                    <td><?php echo e($receipt->adjustment_detail); ?></td>
                                </tr> 

                                <?php if($receipt->dealer_adjustment_unit_id): ?>
                                <tr>
                                    <td>Rebate Detail</td>
                                    <td>Adjust againt <?php echo e($receipt->rebate->property->inventory->unit_number); ?></td>
                                </tr> 
                                <?php endif; ?> 
                                
                                <?php endif; ?> 

                            </tbody>
                        
                        </table> 

                        <?php if(count($receipt->documents) > 0): ?>
                        <h3 style="margin-top: 5rem;margin-bottom: 3rem;">Receipt Documents</h3> 

                        <?php 

                        $images = json_decode($receipt->documents , true); 

                        $file_ext = array('docx','pdf'); 


                        echo '<div class="row">'; 

                        for($img = 0; $img < count($images); $img++) 
                        { 
                            
                            $url = asset( 'storage/receipt_documents/'.$images[$img][ 'document_path']); 

                            $urlExt = pathinfo($url, PATHINFO_EXTENSION); 

                            if (!in_array($urlExt, $file_ext)) 
                            { 

                                echo '<div class="col-md-2" >
                                        <a target="_blank" href="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                            <img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                        </a>
                                        <a href="'.route( 'receipt-refund.document.delete' , [$images[$img][ 'id']]) . '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>
                                    </div>'; 
                            } 

                            if (in_array($urlExt, $file_ext)) 
                            { 

                                echo '<div class="col-md-2" >
                                    <a target="_blank" href="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                        <img title="'.ucfirst($urlExt). ' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url( 'storage/file.jpg'). '">
                                    </a>
                                    <a href="'.route( 'receipt-refund.document.delete' , [$images[$img][ 'id']]) . '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                    </a>
                                </div>'; 
                            } 
                        } 

                        echo '</div>'; 

                        ?> 

                        <?php endif; ?> 

                    </div>
            
                </div>
            
            </div>
        </div>
        
        <?php 
        
        $application_no =  ' APPLICATION NO : '. $receipt->property->application_no; 
        
        $membership_no =  ' MEMEBERSHIP NO : '. $receipt->property->membership_no; 
        
        $name = ' NAME :  '.$receipt->customer->name;  
        
        $receipt_amount =  ' TOTAL RECEIVED AMOUNT : '. $receipt->amount;
            
        $qrCodeOutput =  $membership_no.$name.$receipt_amount;
            
        ?>
           
        <div class="col-lg-12">
            
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	                <div class="col-sm-2 col-xs-3"> 
	                    <?php if($receipt->property): ?>
                            <?php if($receipt->property->inventory->multiProject): ?>
                                <img id="blah" class='circle'
                                    src="<?php echo e(asset('images/'.$receipt->property->inventory->multiProject->image)); ?>"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            <?php endif; ?>
                        <?php endif; ?> 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            <?php if($receipt->property): ?>
                                <?php if($receipt->property->inventory->multiProject): ?>
                                    <?php echo e($property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color: #000000;">Office Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e($receipt->receipt_no); ?></strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong><?php echo e($receipt->customer->name); ?> </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style=" font-weight:800; "><?php echo e($property->membership_no); ?></strong></p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;color:#000000;">
            		       Refund Unit 
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>  <?php echo e($size); ?></p>
            		</div>
                   
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->type->name : ''); ?> Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    <?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                            Cash
                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> 
                            Bank
                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> 
                            Cheque 
                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?> 
                            Adjustment
                            <?php endif; ?>
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			<?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?> 
            			<?php echo e($receipt->cheque_number); ?>

            			<?php else: ?>
            			N/A
            			<?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y')); ?></strong></p>
                        <?php else: ?>
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></p>
                        <?php endif; ?>
            		</div>
            	</div>
                <div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                <?php echo e($refund_words); ?> only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Refunded Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                
            	                    <?php echo e(number_format($property->unitRefundHistory->total_refund)); ?>

            	                
            	            </strong>
            	        </p>
            	    </div>
            	    
            	</div>
            	<div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            		<div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            			<p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;"> <?php echo e($words); ?> only</strong></p>
            		</div>
                    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
                        <p><strong>Paid Amount</strong></p>
                    </div>
                    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
                        <p>
                            <strong style="color: white;">
                                Rs.
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                    <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($receipt->amount)); ?>

                                <?php endif; ?>
                            </strong>
                        </p>
                    </div>
            		<div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            			<p><strong>Balance Amount</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            			<p> 
            			    <strong style="color: white;">
                                Rs. <?php echo e(number_format($balance)); ?>

                            </strong> 
                        </p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    
            		
            	</div>
            	
            	<?php
                    echo '<div style="page-break-after: always;"></div>';
                ?>
            	
                <!--<br>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; background: #1c3752;color:white; border-top: 1px dashed; border-bottom: 1px dashed">
            		<div class="col-sm-1 col-xs-1">
            			<p>Sr#</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p>Paid Against <?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>   <?php echo e($size); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Due Amount</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Paid Amount</strong></p>
            		</div>
            	</div>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; padding-bottom: 0px; border-bottom: 1px solid black;">
            		<div class="col-sm-1 col-xs-1">
            			<p>1</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p><?php echo e($receipt->notes); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            	</div>
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-10 col-xs-10">
            			<p>The Sum of Rupees: <strong style="color:black !important"> <?php echo e($words); ?> only</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p> 
            			    <strong>
                                Rs.
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->amount)); ?>

                                <?php endif; ?>
                            </strong> 
                        </p>
            		</div>
            	</div>-->
                
                <!--<div class="row" style="font-weight: 600; padding-top: 10px;">
                    <div class="col-sm-2 col-xs-2"></div>
                    <div class="col-sm-7 col-xs-7" style="background: black; color: white; padding-top: 10px;">
                        <ul class="a" style="padding-left: 15px;">
                          <li>Confirmation amouint due on 12 march 2021 Non payment till due date will result in cancellation. 75% of paid amount be refunded in 6 months except MS Fee. </li>
                          <li>MS fee, if not paid, will be deducted from refunded amount</li>
                        </ul>
                    </div>
                    <div class="col-sm-3 col-xs-3"></div>
                </div>
            	
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-9 col-xs-9"></div>
            		<div class="col-sm-2 col-xs-2">
            			<p style="border-top: 1px solid black; text-align: center; margin-bottom: 0;">Signature</p>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>-->
            
            
            </div>
            
            <!--<div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong><?php echo e(env('APP_NAME')); ?></strong></h3>
                        <h3><strong>Payment Receipt</strong></h3> <span class="payment">Office Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->receipt_no); ?></div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; <?php echo e($receipt->customer->name); ?></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        <?php if($i == 5 || $i == 12): ?> - <?php endif; ?> <?php echo e($c[$i]); ?>

                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                            <div class="col-sm-5 col-xs-7">
                                <div class="col-sm-9 col-xs-9"> On account of Office/shop/Floor </div>
                                <div class="col-sm-3 col-xs-3" style="border-bottom: 1px dotted">&nbsp;<?php echo e($receipt->property ? $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' : ''); ?></div>
                            </div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-6 col-sm-6"> 
                                Payment Head:  

                                <?php if($receipt->payment_head == \App\CustomerStatement::down_payment): ?>
                                
                                <?php if( $receipt->property->booking_type == \App\CustomerProperty::full_payment): ?>
                                <?php echo e('Full Payment'); ?>

                                <?php else: ?>
                                <?php echo e('Down Payment'); ?>

                                <?php endif; ?>
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::possession): ?>
                                Possession Fee
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::installment): ?>
                                Installment 
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::other): ?>
                                Other
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::allotment): ?>
                                Allotment
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::confirmation): ?>
                                Confirmation
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::booking): ?>
                                Booking
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::development): ?>
                                Development
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::file_processing): ?>
                                File Processing
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::registration): ?>
                                Registration
                                <?php elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee): ?>
                                Transfer Fee
                                <?php endif; ?>

                                 
                            </div>
                           
                                    
                            <div class="col-xs-6 col-sm-6">
                                Payment Mode: 

                                   
                                <?php if(!empty($receipt->payment_method)): ?>
                                
                                <?php if($receipt->payment_method == \App\Receipt::cash): ?> Cash 

                                <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> Bank 

                                <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                <?php else: ?> 
                                Adjustment 

                                <?php endif; ?> 
                                
                                <?php else: ?>
                                
                                
                                  
                                <?php if($receipt->payment_mode == \App\Receipt::cash): ?> Cash 

                                <?php elseif($receipt->payment_mode == \App\Receipt::bank): ?> Bank 

                                <?php elseif($receipt->payment_mode == \App\Receipt::cheque): ?> Cheque/ DD/ PO 

                                <?php else: ?> 
                                Adjustment 

                                <?php endif; ?> 
                                
                                
                                <?php endif; ?>

                            </div>

                            <?php if($receipt->payment_method == \App\Receipt::adjustment): ?> 
                        
                                        
                                <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                    Adjustment Type: 

                                    <?php if($receipt->adjustment_type == \App\Receipt::property): ?> 
                                    Property  

                                    <?php elseif($receipt->adjustment_type == \App\Receipt::vehicle): ?> 
                                    Vehicle  

                                    <?php elseif($receipt->adjustment_type == \App\Receipt::rebate): ?> 
                                    Rebate &nbsp;&nbsp;<span>( <?php echo e($receipt->rebate->property->inventory->unit_number); ?> )</span>

                                    <?php elseif($receipt->adjustment_type == \App\Receipt::vendor): ?> 
                                    Vendor bill &nbsp;&nbsp;<span>( PO-<?php echo e($receipt->vendor_purchase_order_id); ?> )</span>

                                    <?php elseif($receipt->adjustment_type == \App\Receipt::token_receipt): ?> 
                                    Token 

                                    <?php elseif($receipt->adjustment_type == \App\Receipt::others): ?> 
                                    Others 
                                    <?php endif; ?>


                                </div>


                                  <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                    Adjustment Details . 
                                    <span><?php echo e($receipt->adjustment_detail); ?></span>

                                  </div>


                            <?php endif; ?>


                            <?php if($receipt->tax_paid_by == \App\Receipt::company): ?> 
                            <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                            Tax Amount: &nbsp;&nbsp;&nbsp;<?php echo e(number_format($receipt->tax_amount)); ?>


                            </div>
                            <?php endif; ?>


                            <?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?>
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    <?php echo e($receipt->cheque_number); ?> 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong><?php echo e(date('d-m-Y' , strtotime($receipt->drawn_date))); ?></strong>
                            </div>
                            <?php endif; ?>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;
                                <strong>
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->amount)); ?>

                                <?php endif; ?>
                                </strong>
                            </div>
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b><?php echo e($words); ?> only</b></div>
                            
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>-->
        </div>
        

        <div class="col-lg-12">
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	               <div class="col-sm-2 col-xs-3"> 
	                    <?php if($receipt->property): ?>
                            <?php if($receipt->property->inventory->multiProject): ?>
                                <img id="blah" class='circle'
                                    src="<?php echo e(asset('images/'.$receipt->property->inventory->multiProject->image)); ?>"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            <?php endif; ?>
                        <?php endif; ?> 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            <?php if($receipt->property): ?>
                                <?php if($receipt->property->inventory->multiProject): ?>
                                    <?php echo e($property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color: #000000;">Accounts Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e($receipt->receipt_no); ?></strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 3px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong><?php echo e($receipt->customer->name); ?> </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style="font-weight:800;"><?php echo e($property->membership_no); ?></strong></p>
            		</div>
                     
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;">
                                Refund Unit 
            		        
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>  <?php echo e($size); ?></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->type->name : ''); ?> Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    <?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                            Cash
                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> 
                            Bank
                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> 
                            Cheque 
                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?> 
                            Adjustment
                            <?php endif; ?>
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			<?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?> 
            			<?php echo e($receipt->cheque_number); ?>

            			<?php else: ?>
            			N/A
            			<?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y')); ?></strong></p>
                        <?php else: ?>
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></p>
                        <?php endif; ?>
            		</div>
            	</div>
            	<div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                <?php echo e($refund_words); ?> only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Refunded Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                
            	                    <?php echo e(number_format($property->unitRefundHistory->total_refund)); ?>

            	                
            	            </strong>
            	        </p>
            	    </div>
            	    
            	</div>
                <div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                <?php echo e($words); ?> only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Paid Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
            	                    <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

        	                    <?php else: ?>
            	                    <?php echo e(number_format($receipt->amount)); ?>

            	                <?php endif; ?>
            	            </strong>
            	        </p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Balance Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs. <?php echo e(number_format($balance)); ?>

            	            </strong>
            	        </p>
            	    </div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>


            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    
            	    <!-- <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-phone" aria-hidden="true"></i> (051) 611 2368
            	                <br>
            	                <i class="fa fa-phone" aria-hidden="true"></i> 0311-111 0272</span>
            	        </p>
            	    </div>
            	    <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-globe" aria-hidden="true"></i>
            	                info@bluearc.com.pk <br>
            	                <i class="fa fa-globe" aria-hidden="true"></i> www.bluearc.com .pk</span>
            	        </p>
            	    </div>
            	    <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-map-marker" aria-hidden="true"></i> Plaza # 4,
            	                Eiffel
            	                Tower Commercial,
            	                Main Expressway, Phase 8, Bahria Town, Rwp</span>
            	        </p>
            	    </div>
            		
            	</div> -->

                <div class="row" style="font-weight:600; margin:-15px 25px 0">

                    

                </div>
            	
            	<?php
                    echo '<div style="page-break-after: always;"></div>';
                ?>
            	
                <!--<br>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; background: #1c3752;color:white; border-top: 1px dashed; border-bottom: 1px dashed">
            		<div class="col-sm-1 col-xs-1">
            			<p>Sr#</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p>Paid Against <?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>  <?php echo e($size); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Due Amount</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Paid Amount</strong></p>
            		</div>
            	</div>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; padding-bottom: 0px; border-bottom: 1px solid black;">
            		<div class="col-sm-1 col-xs-1">
            			<p>1</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p><?php echo e($receipt->notes); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            	</div>
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-10 col-xs-10">
            			<p>The Sum of Rupees: <strong style="color:black !important"> <?php echo e($words); ?> only</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p> 
            			    <strong>
                                Rs.
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->amount)); ?>

                                <?php endif; ?>
                            </strong> 
                        </p>
            		</div>
            	</div>-->
                
                <!--<div class="row" style="font-weight: 600; padding-top: 10px;">
                    <div class="col-sm-2 col-xs-2"></div>
                    <div class="col-sm-7 col-xs-7" style="background: black; color: white; padding-top: 10px;">
                        <ul class="a" style="padding-left: 15px;">
                          <li>Confirmation amouint due on 12 march 2021 Non payment till due date will result in cancellation. 75% of paid amount be refunded in 6 months except MS Fee. </li>
                          <li>MS fee, if not paid, will be deducted from refunded amount</li>
                        </ul>
                    </div>
                    <div class="col-sm-3 col-xs-3"></div>
                </div>
            	
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-9 col-xs-9"></div>
            		<div class="col-sm-2 col-xs-2">
            			<p style="border-top: 1px solid black; text-align: center; margin-bottom: 0;">Signature</p>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>-->
            
            
            </div>
            
        </div>
        

        <div class="col-lg-12">
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	                <div class="col-sm-2 col-xs-3"> 
	                    <?php if($receipt->property): ?>
                            <?php if($receipt->property->inventory->multiProject): ?>
                                <img id="blah" class='circle'
                                    src="<?php echo e(asset('images/'.$receipt->property->inventory->multiProject->image)); ?>"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            <?php endif; ?>
                        <?php endif; ?> 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            <?php if($receipt->property): ?>
                                <?php if($receipt->property->inventory->multiProject): ?>
                                    <?php echo e($property->inventory->multiProject->name); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color:#000000;">Customer Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important"><?php echo e($receipt->receipt_no); ?></strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong><?php echo e($receipt->customer->name); ?> </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style="font-weight:800;"><?php echo e($property->membership_no); ?></strong></p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;">
            		        Refund Unit
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>   <?php echo e($size); ?></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;<?php echo e($receipt->property->inventory ? $receipt->property->inventory->type->name : ''); ?> Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    <?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                            Cash
                            <?php elseif($receipt->payment_method == \App\Receipt::bank): ?> 
                            Bank
                            <?php elseif($receipt->payment_method == \App\Receipt::cheque): ?> 
                            Cheque 
                            <?php elseif($receipt->payment_method == \App\Receipt::adjustment): ?> 
                            Adjustment
                            <?php endif; ?>
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			<?php if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque): ?> 
            			<?php echo e($receipt->cheque_number); ?>

            			<?php else: ?>
            			N/A
            			<?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<?php if($receipt->payment_method == \App\Receipt::cash): ?> 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y')); ?></strong></p>
                        <?php else: ?>
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong><?php echo e(date('d-m-Y',strtotime($receipt->receipt_date))); ?></strong></p>
                        <?php endif; ?>
            		</div>
            	</div>
                <div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                <?php echo e($refund_words); ?> only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Refunded Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                
            	                    <?php echo e(number_format($property->unitRefundHistory->total_refund)); ?>

            	                
            	            </strong>
            	        </p>
            	    </div>
            	    
            	</div>
            	<div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                <?php echo e($words); ?> only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Paid Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
            	                    <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

        	                    <?php else: ?>
            	                    <?php echo e(number_format($receipt->amount)); ?>

            	                <?php endif; ?>
            	            </strong>
            	        </p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Balance Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs. <?php echo e(number_format($balance)); ?>

            	            </strong>
            	        </p>
            	    </div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                <?php echo QrCode::size(100)->generate($qrCodeOutput);; ?>

                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    

            	</div>
            	
            	
            	
                <!--<br>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; background: #1c3752;color:white; border-top: 1px dashed; border-bottom: 1px dashed">
            		<div class="col-sm-1 col-xs-1">
            			<p>Sr#</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p>Paid Against <?php echo e($receipt->property->inventory ? $receipt->property->inventory->size->name : ''); ?>  <?php echo e($size); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Due Amount</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p><strong>Paid Amount</strong></p>
            		</div>
            	</div>
            	<div class="row margin-less" style="text-transform: capitalize; font-weight: 600; padding-top: 10px; padding-bottom: 0px; border-bottom: 1px solid black;">
            		<div class="col-sm-1 col-xs-1">
            			<p>1</p>
            		</div>
            		<div class="col-sm-7 col-xs-7">
            			<p><?php echo e($receipt->notes); ?></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p>
            			    <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                            <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                            <?php else: ?>
                            <?php echo e(number_format($receipt->amount)); ?>

                            <?php endif; ?>
            			</p>
            		</div>
            	</div>
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-10 col-xs-10">
            			<p>The Sum of Rupees: <strong style="color:black !important"> <?php echo e($words); ?> only</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="text-align: right;">
            			<p> 
            			    <strong>
                                Rs.
                                <?php if($receipt->tax_paid_by == \App\Receipt::company): ?>
                                <?php echo e(number_format($receipt->amount + $receipt->tax_amount)); ?>

                                <?php else: ?>
                                <?php echo e(number_format($receipt->amount)); ?>

                                <?php endif; ?>
                            </strong> 
                        </p>
            		</div>
            	</div>-->
                
                <!--<div class="row" style="font-weight: 600; padding-top: 10px;">
                    <div class="col-sm-2 col-xs-2"></div>
                    <div class="col-sm-7 col-xs-7" style="background: black; color: white; padding-top: 10px;">
                        <ul class="a" style="padding-left: 15px;">
                          <li>Confirmation amouint due on 12 march 2021 Non payment till due date will result in cancellation. 75% of paid amount be refunded in 6 months except MS Fee. </li>
                          <li>MS fee, if not paid, will be deducted from refunded amount</li>
                        </ul>
                    </div>
                    <div class="col-sm-3 col-xs-3"></div>
                </div>
            	
            	<div class="row" style="text-transform: capitalize; font-weight: 600; padding-top: 10px;">
            		<div class="col-sm-9 col-xs-9"></div>
            		<div class="col-sm-2 col-xs-2">
            			<p style="border-top: 1px solid black; text-align: center; margin-bottom: 0;">Signature</p>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>-->
            
            
            </div>
                
        </div>
            
            
        </div>
                
    </div>
    
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display:inline-block; margin-bottom:95px">
            <button class="btn btn-default btn-outline" onclick="window.print(); return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script src="<?php echo e(asset('js/jquery.PrintArea.js')); ?>" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
    $('#upload_btn').html('Uploading...')
    $('#upload_btn').prop('disabled' , true)

    var form_data = new FormData();

       // Read selected files
    var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

     
    unit_type= $('#unit_type').val();
    form_data.append("receipt_id", receipt_id);
    form_data.append("unit_type", unit_type);
    

    $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
    $.ajax({
     url:"<?php echo e(route('receipt-refund.document')); ?>",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/receipt/detail-unit-refund-receipt.blade.php ENDPATH**/ ?>