

<?php $__env->startSection('title'); ?>
Inventory Detail 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-inventory')): ?>
        <li ><a href="<?php echo e(route('inventory.all')); ?>">All Inventories</a></li>
        <?php endif; ?>
        <li class="active">Inventory Detail</li>
      </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<?php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
?>

<?php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

    $map= \App\ProjectType::society_map;
    }
    else
    { $map= \App\ProjectType::high_rise_map;}

?>
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Inventory Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table ">
                                            <tbody>
                                                <tr>
                                                    <td width="360"><b>Unit Number</b></td>
                                                    <td> <span style="font-size:18px;"> <?php echo e($inventory->unit_number); ?> </span>

                                                        
                                                        
                                                        <?php $__currentLoopData = $inventory->oldNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($loop->first): ?>

                                                        <br>
                                                        <b style="font-size:12px;">Old Numbers : </b>
                                                        <ul>
                                                        <?php endif; ?>
                                                        <li>

                                                        <?php echo e($o->name); ?> </li>

                                                       

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Project </b></td>
                                                    <td><span class="label label-success"><?php echo e($inventory->multiProject?$inventory->multiProject->name:''); ?></span></td>
                                                </tr>
                                                <tr>
                                                    <td><b>Project </b></td>  
                                                    <td><span class="label label-success"><?php echo e($inventory->priceList ? $inventory->priceList->l_no : ''); ?></span></td>
                                                </tr>
                                                <tr>
                                                    <td><b><?php echo e($map); ?></b></td>
                                                    <td>
                                                        <?php echo e($inventory->floor ? $inventory->floor->name  : ''); ?>

                                                    </td>
                                                </tr>

                                                <tr>
                                                    <td><b>Block</b></td>
                                                    <td><?php echo e($inventory->floor?$inventory->floor->unitBlock->name:''); ?></td>
                                                </tr>


                                                <tr>
                                                    <td><b>Type</b></td>
                                                    <td><?php echo e($inventory->type ? $inventory->type->name  : ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><b>Size</b></td>

                                                    <td><?php echo e($inventory->size?$inventory->size->name:''); ?>  <?php echo e($size); ?>

                                              
                                            </td>
                                                    </tr>

                                                <tr>
                                                    <td><b>Area</b></td>
                                                    <td>
                                                    <?php echo e($inventory->area); ?> </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Total amount</b></td>
                                                    <td> <?php echo e(number_format($inventory->total_price - $inventory->extra_amount)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><b>Category</b></td>
                                                    <?php $sum =0;?>
                                                    <td><?php $__currentLoopData = $inventory->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php $sum += $c->category->percent;?>
                                                        <?php if($loop->last): ?>
                                                        <?php echo e($c->category->name); ?> 
                                                        <?php if($c->category->is_percent): ?>
                                                        (<?php echo e($c->category->percent); ?> %)
                                                        <?php else: ?>
                                                        (<?php echo e($c->category->percent); ?> )
                                                        <?php endif; ?>
                                                        <?php else: ?>
                                                        <?php echo e($c->category->name); ?> <?php if($c->category->is_percent): ?>
                                                        (<?php echo e($c->category->percent); ?> %)
                                                        <?php else: ?>
                                                        (<?php echo e($c->category->percent); ?> )
                                                        <?php endif; ?>,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><b>Extra Charges</b></td>
                                                    <td><?php echo e(number_format($inventory->extra_amount)); ?> </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Net Amount</b></td>
                                                    <td> <?php echo e(number_format($inventory->total_price)); ?></td>
                                                </tr>


                                                <tr>
                                                    <td><b>Description</b></td>
                                                    <td> <?php echo e($inventory->description); ?></td>
                                                </tr>
                                                <tr>
                                                    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                                                    <td><b>Status</b></td>
                                                    <?php if($inventory->status == \App\Inventory::open): ?>
                                                    <td> Open</td>
                                                    <?php elseif($inventory->status == \App\Inventory::sold): ?>
                                                    <td>Sold</td>
                                                    <?php elseif($inventory->status == \App\Inventory::hold_company): ?>
                                                    <td>Company Hold</td>
                                                    <?php elseif($inventory->status == \App\Inventory::hold_client): ?>
                                                    <td>Client Hold</td>
                                                    <?php elseif($inventory->status == \App\Inventory::token_hold): ?>
                                                    <td>Token Hold</td>
                                                    

                                                    <?php elseif($inventory->status == \App\Inventory::temp_hold): ?>
                                                    <td>Temporary Hold</td>
                                                    <?php elseif($inventory->status == \App\Inventory::package_open_file): ?>
                                                    <td>Open/Dealer Package File</td>
                                                    <?php endif; ?>

                                                    <?php else: ?>

                                                     <td><b>Status</b></td>
                                                    <?php if($inventory->status == \App\Inventory::open): ?>
                                                    <td> Open</td>
                                                    <?php else: ?>
                                                    <td>Sold</td>
                                                    <?php endif; ?>


                                                    <?php endif; ?>
                                                </tr>
                                                
                                                <?php if($inventory->dealer_id): ?>
                                                <tr>
                                                    <td><b>Dealer</b></td>
                                                    <td><?php if($inventory->dealer_id): ?>
                                                        <?php echo e($inventory->dealer->name); ?>

                                                    <?php endif; ?></td>
                                                </tr>
                                                <?php endif; ?>

                                                <?php if($inventory->token_amount): ?>
                                                <tr>
                                                    <td><b>Token Amount</b></td>
                                                    <td><?php echo e($inventory->token_amount); ?></td>
                                                </tr>
                                                <?php endif; ?>

                                                <?php if($inventory->name): ?>
                                                <tr>
                                                    <td><b>Name</b></td>
                                                    <td><?php echo e($inventory->name); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if($inventory->cnic): ?>
                                                <tr>
                                                    <td><b>Cnic</b></td>
                                                    <td><?php echo e($inventory->cnic); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if($inventory->email): ?>
                                                <tr>
                                                    <td><b>Email</b></td>
                                                    <td><?php echo e($inventory->email); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if($inventory->phone_number): ?>
                                                <tr>
                                                    <td><b>Phone Number</b></td>
                                                    <td><?php echo e($inventory->phone_number); ?></td>

                                                </tr>
                                                <?php endif; ?>
                                                

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/inventory/detail-inventory.blade.php ENDPATH**/ ?>