

<?php $__env->startSection('title'); ?>
    Add Sale
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-membership')): ?>
            <li><a href="<?php echo e(route('statement.all')); ?>">Statements</a></li>
        <?php endif; ?>
        <li class="active">Add Sale</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .select2-container {
            width: 300px !important;
            /* set the width to 300 pixels */
        }

        .help-block {
            font-weight: bold;
        }

        span {
            display: inline-block;
        }
        .lallu{
    display: flex;
    padding: 5px;
}
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>




    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="<?php echo e(route('statement.insert')); ?>" enctype="multipart/form-data"
                onsubmit="return validateData(this)">
                <?php echo e(csrf_field()); ?>

                <div class="col-md-12">
                    <?php if($errors->any()): ?>
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                <?php echo implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')); ?>

                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Add New Sale</h3>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box">

                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-user"></i> Customer Information</h3>

                        <hr>
                        <div class="clearfix"></div>
                        <!-- Nav tabs -->
                        <ul class="nav customtab nav-tabs" role="tablist">
                            <li role="presentation" class="active">
                                <a href="#profile1" aria-controls="profile" role="tab" data-toggle="tab"
                                    aria-expanded="false" style="font-weight: 700;"><span class="visible-xs"><i
                                            class="ti-user"></i></span> <span class="hidden-xs">Existing Customer</span></a>
                            </li>
                            <li role="presentation"><a href="#home1" aria-controls="home" role="tab" data-toggle="tab"
                                    aria-expanded="true" style="font-weight: 700;"><span class="visible-xs"><i
                                            class="ti-home"></i></span><span class="hidden-xs"> New Customer</span></a></li>
                        </ul>
                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane fade active in" id="profile1">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Name of Applicant</label>
                                        <div class="col-md-8">
                                            <select autocomplete="off" class="form-control chosen-select" id="customer_id"
                                                name="customer_id" style="width: 100%!important;">
                                                <option value="" selected="">None</option>
                                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(isset($customer)): ?>
                                                        <?php if($customer->id == $c->id): ?>
                                                            <option value="<?php echo e($c->id); ?>" selected="">
                                                                <?php echo e($c->name); ?> -

                                                                <b><?php echo e($c->cnic); ?></b>

                                                            </option>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php if(old('customer_id') == $c->id): ?>
                                                            <option value="<?php echo e($c->id); ?>" selected="">
                                                                <?php echo e($c->name); ?> -
                                                                <b><?php echo e($c->cnic); ?></b>
                                                            </option>
                                                        <?php else: ?>
                                                            <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?> -
                                                                <b><?php echo e($c->cnic); ?></b>
                                                            </option>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <button type="button" style="float: left!important;"
                                    class="btn btn-primary add_field_button3">Add Nominee</button>
                                <div class="input_fields_wrap3">
                                    <div class="clearfix"></div>
                                    <div>
                                    </div>


                                </div>
                            </div>




                            <div role="tabpanel" class="tab-pane fade " id="home1">

                                <div class="form-body">
                                    <div class="row">

                                        <div class="col-md-12" style="margin-bottom: 2rem;">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">Unit Type<span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <input type="hidden" value="0" name="user_type"
                                                                id="type">
                                                            <label style="font-weight: bold;"> Individual </label>
                                                            <input type="radio" <?= old('type') == 0 ? 'checked' : '' ?>
                                                                onchange="return hideFields('individual')" name="radio_type"
                                                                style="margin-left: 1rem;">

                                                        </div>

                                                        <div class="col-sm-6">

                                                            <label style="font-weight: bold;"> Company </label>
                                                            <input type="radio" <?= old('type') == 1 ? 'checked' : '' ?>
                                                                onchange="return hideFields('company')" name="radio_type"
                                                                style="margin-left: 1rem;">

                                                        </div>

                                                    </div>


                                                    <?php if($errors->has('type')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('type')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>

                                                </div>

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Name of Applicant <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="name"
                                                        value="<?php echo e(old('name')); ?>" placeholder="Enter Name">
                                                    <?php if($errors->has('name')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('name')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" style="display: <?= old('type') == 1 ? 'none' : '' ?>"
                                            id="father_name_parent">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">S/O D/O W/O <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" id="father_name"
                                                        name="father_name" value="<?php echo e(old('father_name')); ?>"
                                                        placeholder="">
                                                    <input type="radio" name="father_type" value="1">S/O
                                                    <input type="radio" name="father_type" value="2">D/O
                                                    <input type="radio" name="father_type" value="3"> W/O
                                                    <?php if($errors->has('father_name')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('father_name')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="cnic_no"><?= old('type') == 1 ? 'Incorporation no' : 'CNIC' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        onfocusout="return validateCnic(this)"
                                                        value="<?php echo e(old('cnic')); ?>" name="cnic" id="cnic"
                                                        data-inputmask="'mask': '9999999999999'"
                                                        placeholder="XXXXXXXXXXXXX">
                                                    <input type="radio" name="cnic_flag" value="1"> Locally
                                                    <input type="radio" name="cnic_flag" value="2">
                                                    Internationally
                                                    <?php if($errors->has('cnic')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('cnic')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>

                                                <div style="color: red;display: none;" id="cnic_error1">This Customer cnic
                                                    is found in list of DNFBP. You can't add this Customer record. </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6" id="passport_no"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Passport No.</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="<?php echo e(old('passport_no')); ?>" name="passport_no"
                                                        id="passport_no" placeholder="XXXXXXXXX">
                                                    <?php if($errors->has('passport_no')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('passport_no')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3" id="date_of_birth">
                                                    <?= old('type') == 1 ? 'Date of Incorporation' : 'Date of Birth' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="date" class="form-control"
                                                        value="<?php echo e(old('dob')); ?>" name="dob"
                                                        max="<?php echo e(date('Y-m-d')); ?>" id="dob"
                                                        placeholder="XX-XX-XXXX">
                                                    <?php if($errors->has('dob')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('dob')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="occupations"><?= old('type') == 1 ? 'Type Of Company' : 'Occupation' ?>
                                                </label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="<?php echo e(old('occupation')); ?>" name="occupation"
                                                        id="occupation">
                                                    <?php if($errors->has('occupation')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('occupation')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>



                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3" id="mailing_label">
                                                    <?= old('type') == 1 ? 'Company Registered Address' : 'Mailing Address' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea class="form-control" name="mailing_address" id="mailing_address"><?php echo e(old('mailing_address')); ?></textarea>
                                                    <?php if($errors->has('mailing_address')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('mailing_address')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="permanent_add"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Permanent Address <span
                                                        style="color: red">*</span></label> &nbsp; &nbsp;&nbsp;same as
                                                above <input type="checkbox" id="same_address" name="same_address">
                                                <div class="col-md-9">
                                                    <textarea class="form-control" name="permanent_address" id="permanent_address"><?php echo e(old('permanent_address')); ?></textarea>
                                                    <?php if($errors->has('permanent_address')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('permanent_address')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Email</label>
                                                <div class="col-md-9">
                                                    <input type="email" class="form-control" name="email"
                                                        value="<?php echo e(old('email')); ?>" id="exampleInputEmail1"
                                                        placeholder="Enter email">

                                                    <?php if($errors->has('address')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('address')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Password</label>
                                                <div class="col-md-9">
                                                    <input type="text" autocomplete="off" class="form-control"
                                                        name="password" value="<?php echo e(old('password')); ?>"
                                                        id="exampleInputEmail1" placeholder="Enter Password">

                                                    <?php if($errors->has('password')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('password')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3"
                                                    id="mobile_number"><?= old('type') == 1 ? 'Mobile Number' : 'Phone Number' ?>
                                                    <span style="color: red">*</span></label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" type='number'
                                                        name="mobile_number" value="<?php echo e(old('mobile_number')); ?>"
                                                        placeholder="Enter Mobile Number">
                                                    <?php if($errors->has('mobile_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('mobile_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="res_number"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Residential Number</label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" name="res_number"
                                                        value="<?php echo e(old('res_number')); ?>" placeholder="Enter Res. Number">
                                                    <?php if($errors->has('res_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('res_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="phone_number"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Phone Number</label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" type='number'
                                                        name="phone_number" value="<?php echo e(old('phone_number')); ?>"
                                                        placeholder="Enter Phone Number">
                                                    <?php if($errors->has('phone_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('phone_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label"
                                                    id="imgs_label"><?= old('type') == 1 ? 'Certificate' : 'Passport size photo' ?><span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-picture"></i></div>
                                                        <label for="cropzee-input" class="image-previewer"
                                                            data-cropzee="cropzee-input"></label>
                                                        <input name="file" id="cropzee-input" class="form-control"
                                                            type="file" accept="image/*">

                                                        <?php if($errors->has('file')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('file')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6" id="photo_s"
                                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label">Documents
                                                    (CNIC, Passport etc) <span style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-picture"></i></div>
                                                        <input multiple="" type="file" class="form-control"
                                                            name="photos[]">
                                                        <?php if($errors->has('document')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('document')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">

                                            <div class="form-group">
                                                <label for="exampleInputEmail1" class="col-sm-3 control-label">Is Filer
                                                </label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-phone"></i></div>
                                                        <select class="form-control select2" name="is_filer">
                                                            <option value="1">YES</option>
                                                            <option value="0">NO</option>
                                                        </select>


                                                        <?php if($errors->has('is_filer')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('is_filer')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">NTN
                                                    Number</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="ti-user"></i></div>
                                                        <input type="text" class="form-control" name="ntn_number"
                                                            value="<?php echo e(old('ntn_number')); ?>" placeholder="Enter NTN">
                                                        <?php if($errors->has('ntn_number')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('ntn_number')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputuname" class="col-sm-3 control-label">Payment
                                                    Method</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="ti-user"></i></div>
                                                        <select class="form-control chosen-select" name="payment_method">
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::CASH ? 'selected' : '' ?>
                                                                value="0">Cash</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::BANK ? 'selected' : '' ?>
                                                                value="1">Bank</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::CHEAQUE ? 'selected' : '' ?>
                                                                value="2">Cheaque</option>
                                                            <option
                                                                <?= old('payment_method') == \App\Customer::OPEN_CHEAQUE ? 'selected' : '' ?>
                                                                value="3">Open Cheaque</option>
                                                        </select>

                                                        <?php if($errors->has('payment_method')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('payment_method')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>





                                        <div class="clearfix"></div>

                                        <hr>


                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">Account
                                                Title</label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="account_title"
                                                        value="<?php echo e(old('account_title')); ?>"
                                                        placeholder="Enter Account Title">

                                                </div>
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Bank Name
                                            </label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                                    <select class="form-control chosen-select" name="depositer_bank">
                                                        <option value="">None</option>
                                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($list->id); ?>"><?php echo e($list->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </select>

                                                </div>
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-3 control-label">IBAN
                                                Number</label>
                                            <div class="col-sm-9">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="iban_number"
                                                        value="<?php echo e(old('iban_number')); ?>"
                                                        placeholder="Enter Account IBAN Number">

                                                </div>
                                            </div>
                                        </div>


                                        <div class="clearfix"></div>
                                        <hr>

                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 2</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner"
                                                        value="<?php echo e(old('first_owner')); ?>" placeholder="Enter First Owner">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 3</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner"
                                                        value="<?php echo e(old('second_owner')); ?>"
                                                        placeholder="Enter Second Owner">

                                                </div>
                                            </div>

                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-2 control-label">First Owner
                                                Father</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner_father"
                                                        value="<?php echo e(old('first_owner_father')); ?>"
                                                        placeholder="Enter First Owner">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner
                                                Father</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner_father"
                                                        value="<?php echo e(old('second_owner_father')); ?>"
                                                        placeholder="Enter Second Owner Father">

                                                </div>
                                            </div>

                                        </div>



                                        <div class="form-group">
                                            <label for="exampleInputuname" class="col-sm-2 control-label">First Owner
                                                Cnic</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="first_owner_cnic"
                                                        value="<?php echo e(old('first_owner_cnic')); ?>"
                                                        placeholder="Enter First Owner Cnic">

                                                </div>
                                            </div>

                                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner
                                                Cnic</label>

                                            <div class="col-sm-4">
                                                <div class="input-group">
                                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                                    <input type="text" class="form-control" name="second_owner_cnic"
                                                        value="<?php echo e(old('second_owner_cnic')); ?>"
                                                        placeholder="Enter Second Owner Cnic">

                                                </div>
                                            </div>

                                        </div>


                                        <div class="clearfix"></div>
                                        <hr>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Nominee Name <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_name"
                                                        value="<?php echo e(old('nominee_name')); ?>" id="exampleInputuname"
                                                        placeholder="Enter Name">
                                                    <?php if($errors->has('nominee_name')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_name')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">S/O, D/O, W/O.<span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_so_do_wo"
                                                        value="<?php echo e(old('nominee_so_do_wo')); ?>" id="exampleInputuname"
                                                        placeholder="Enter Father Name">
                                                    <input type="radio" name="nominee_father_type" value="1">S/O
                                                    <input type="radio" name="nominee_father_type" value="2">D/O
                                                    <input type="radio" name="nominee_father_type" value="3"> W/O
                                                    <?php if($errors->has('nominee_so_do_wo')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_so_do_wo')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">CNIC</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="<?php echo e(old('nominee_cnic')); ?>"
                                                        onfocusout="return validateCnic(this)" name="nominee_cnic"
                                                        id="nominee_cnic" data-inputmask="'mask': '9999999999999'"
                                                        placeholder="XXXXXXXXXXXXX">
                                                    <input type="radio" name="nominee_cnic_flag" value="1">
                                                    Locally
                                                    <input type="radio" name="nominee_cnic_flag" value="2">
                                                    Internationally


                                                    <?php if($errors->has('nominee_cnic')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_cnic')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>

                                                <div style="color: red;display: none;" id="cnic_error1">This Customer cnic
                                                    is found in list of DNFBP. You can't add this Customer record. </div>

                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group" id="nominee_address">
                                                <label for="address" class="col-sm-3 control-label"
                                                    id="nominee_address">Nominee Address <span
                                                        style="color: red">*</span></label>
                                                <div class="col-sm-9">
                                                    <div class="input-group">
                                                        <div class="input-group-addon"><i class="icon-location-pin"></i>
                                                        </div>
                                                        <textarea class="form-control" id="nominee_address" name="nominee_address"><?php echo e(old('nominee_address')); ?></textarea>
                                                        <?php if($errors->has('nominee_address')): ?>
                                                            <span class="help-block">
                                                                <strong><?php echo e($errors->first('nominee_address')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Passport No.</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control"
                                                        value="<?php echo e(old('nominee_passport_no')); ?>"
                                                        name="nominee_passport_no" id="nominee_passport_no"
                                                        placeholder="XXXXXXXXX">
                                                    <?php if($errors->has('nominee_passport_no')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_passport_no')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Relation With Applicant <span
                                                        style="color: red">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_relation"
                                                        value="<?php echo e(old('nominee_relation')); ?>"
                                                        placeholder="Enter Relation">
                                                    <?php if($errors->has('nominee_relation')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_relation')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Email</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" name="nominee_email"
                                                        value="<?php echo e(old('nominee_email')); ?>" placeholder="Enter Email">
                                                    <?php if($errors->has('nominee_email')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_email')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Mobile Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control"
                                                        name="nominee_mobile_number"
                                                        value="<?php echo e(old('nominee_mobile_number')); ?>"
                                                        placeholder="Enter Mobile Number">
                                                    <?php if($errors->has('nominee_mobile_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_mobile_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Res. Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control" name="nominee_res_number"
                                                        value="<?php echo e(old('nominee_res_number')); ?>"
                                                        placeholder="Enter Res Number">
                                                    <?php if($errors->has('nominee_res_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_res_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">Phone Number </label>
                                                <div class="col-md-9">

                                                    <input type="text" class="form-control"
                                                        name="nominee_phone_number"
                                                        value="<?php echo e(old('nominee_phone_number')); ?>"
                                                        placeholder="Enter Phone Number">
                                                    <?php if($errors->has('nominee_phone_number')): ?>
                                                        <span class="help-block">
                                                            <strong><?php echo e($errors->first('nominee_phone_number')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="clearfix"></div>
                                        <button type="button" style="float: left!important;"
                                            class="btn btn-primary add_field_button4">Add Nominee</button>
                                        <div class="input_fields_wrap4">
                                            <div class="clearfix"></div>
                                            <div>
                                            </div>


                                        </div>

                                    </div>

                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>



                <?php if($projecttype->id == \App\ProjectType::society): ?>
                    
                    <div class="col-lg-12 col-sm-12 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Select Unit Type</h3>


                            <hr />
                            <div class="clearfix"></div>
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist">
                                <li role="presentation" class="active">
                                    <a onclick='addBasicUnit();' aria-controls="profile" role="tab"
                                        data-toggle="tab" aria-expanded="false" style="font-weight: 700;">
                                        <span class="visible-xs"><i class="ti-user"></i></span> <span
                                            class="hidden-xs">Direct Inventory</span>
                                    </a>
                                </li>

                                <li role="presentation">
                                    <a onclick='addDealerUnit();' aria-controls="home" role="tab" data-toggle="tab"
                                        aria-expanded="true" style="font-weight: 700;">
                                        <span class="visible-xs"><i class="ti-home"></i></span><span
                                            class="hidden-xs">Open File Inventory</span>
                                    </a>
                                </li>
                                <li role="presentation">
                                    <a onclick='addTokenHoldUnit();' aria-controls="home" role="tab"
                                        data-toggle="tab" aria-expanded="true" style="font-weight: 700;">
                                        <span class="visible-xs"><i class="ti-home"></i></span><span
                                            class="hidden-xs">Token Hold Inventory</span>
                                    </a>
                                </li>

                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane fade active in">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">Unit #</label>
                                            <div class="col-md-8">

                                                <div id='addUnitDetail'>
                                                    <select class="form-control chosen-select" id="unit_number"
                                                        name="unit_number" data-id='0'>
                                                        <option value="" selected="">None</option>
                                                        <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($unit->id); ?>">
                                                                <?php echo e($unit->multiProject ? $unit->multiProject->name : ''); ?>

                                                                <?php echo e($unit->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>


                                                <?php if($errors->has('unit_number')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('unit_number')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="input_fields_wrap3">
                                        <div class="clearfix"></div>
                                        <div></div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                    
                <?php endif; ?>




                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title">Unit Information</h3>
                        <hr>
                        <input type="hidden" name='inventory_id' id='inventory-id' value='<?php echo e(old('inventory_id')); ?>'>









                        <?php if($projecttype->id == \App\ProjectType::high_rise): ?>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Unit # <span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div id='addUnitDetail'>
                                            <select class="form-control chosen-select" id="unit_number"
                                                name="unit_number" data-id='0'>
                                                <option value="" selected="">None</option>
                                                <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($unit->id); ?>">
                                                        <?php echo e($unit->multiProject ? $unit->multiProject->name : ''); ?>

                                                        <?php echo e($unit->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php if($errors->has('unit_number')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('unit_number')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>


                        <?php endif; ?>









                        <div class="col-md-6" id="inventory_type">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="type"
                                        value="<?php echo e(old('type')); ?>" id="type">
                                    <?php if($errors->has('type')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('type')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Inventory Type</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" id='invent_id' class="form-control"
                                        name="invent_id">
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Size (<?php if($projectType->id == \App\ProjectType::society): ?>
                                        <?php echo e(\App\ProjectType::society_size); ?>

                                    <?php else: ?>
                                        <?php echo e(\App\ProjectType::high_rise_size); ?>

                                    <?php endif; ?>)</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" class="form-control" name="size"
                                        value="<?php echo e(old('size')); ?>" id="size">
                                    <?php if($errors->has('size')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('size')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Price</label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='total-amount' class="form-control"
                                        name="total_price" value="<?php echo e(old('total_price')); ?>">
                                    <?php if($errors->has('total_price')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('total_price')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                    <div style="color:black;" class="help-block" id='total-amount-label'></div>
                                </div>
                            </div>
                        </div>


                        <div class="clearfix"></div>

                        <div class="col-md-6" id='allocated_category'>
                            <div class="form-group">
                                <label class="control-label col-md-4">Unit Category</label>
                                <div class="col-md-8">

                                    <input readonly="" type="category" class="form-control" name="category"
                                        value="<?php echo e(old('category')); ?>" id="category">
                                    <?php if($errors->has('category')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('category')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        
                        <?php if($projecttype->id == \App\ProjectType::society): ?>
                        <div class="col-md-6" id='category_col'>
                            <div class="form-group">
                                <label class="control-label col-md-4">Preferred Category</label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select " id="unit_category_id"
                                        name="unit_category_id[]" multiple="">
                                        <!--  <option value="" ><b>None</b></option> -->
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(old('unit_category_id') == $c->id): ?>
                                                <option selected="" value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?>

                                                </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php if($errors->has('unit_category_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('unit_category_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>


                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Extra Charges </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='extra_charges' class="form-control"
                                        name="extra_charges" value="<?php echo e(old('extra_charges')); ?>">

                                    <div style="color:black;" class="help-block" id='extra-charges-label'></div>
                                </div>
                            </div>
                        </div>









                        <!--    <div class="col-md-6" >
                                <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Access Amount </label>
                                <div class="col-md-8">

                                <input  type="text"  id='access_amount' class="form-control" name="access_amount" value="<?php echo e(old('access_amount')); ?>">

                                </div>
                                </div>
                                </div> -->

                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Unit Description </label>
                                <div class="col-md-8">

                                    <input readonly="" type="text" id='description' class="form-control"
                                        name="description" value="<?php echo e(old('description')); ?>">


                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Discount<br> (use percent <input type="checkbox"
                                        onclick="percentCheckbox()" name="discount_percent"
                                        id="discount_percent">)</label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 12px;"
                                            id="dis_input">PKR</span>
                                        <input id='discount_s' type="numeric" class="form-control" name="discount"
                                            value="<?php echo e(old('discount')); ?>" placeholder="Enter Discount ">
                                    </div>

                                    <?php if($errors->has('discount')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('discount')); ?></strong>
                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>






                        <div class="clearfix"></div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Net Amount</label>
                                <div class="col-md-8">
                                    <input type="hidden" id="dummy_net_amount">
                                    <input readonly="" type="text" id='net_amount' class="form-control"
                                        name="net_amount" value="<?php echo e(old('net_amount')); ?>">
                                    <?php if($errors->has('net_amount')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('net_amount')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                    <div style="color:black;" class="help-block" id='net_amount-label'></div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Booking Date <span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">

                                    <input type="date" class="form-control" name="original_boooking_date"
                                        value="<?php echo e(old('original_boooking_date')); ?>" id="original_boooking_date"
                                        placeholder="Enter Booking Date">
                                    <?php if($errors->has('original_boooking_date')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('original_boooking_date')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>

                        <!-- <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-4">Membership Number </label>
                                                            <div class="col-md-8">

                                                                <input type="text" class="form-control" name="membership_number" value="<?php echo e(old('membership_number')); ?>" id="exampleInputEmail1" placeholder="Enter Membership Number">
                                            <?php if($errors->has('membership_number')): ?>
    <span class="help-block">
                                            <strong><?php echo e($errors->first('membership_number')); ?></strong>
                                        </span>
    <?php endif; ?>
    </div>
    </div>
                                </div> -->



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4"> Rate <br> (Per <?php if($projectType->id == \App\ProjectType::society): ?>
                                        <?php echo e(\App\ProjectType::society_size); ?>

                                    <?php else: ?>
                                        <?php echo e(\App\ProjectType::high_rise_size); ?>

                                    <?php endif; ?>)</label>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <span style="display:none;" id="sqrt"></span>
                                        <input readonly="" style="width: 37.5rem;" type="text" id='per_sqrt_value'
                                            class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>




                        <!--    <div class="col-md-6" >
                                    <div class="form-group">
                                         <label class="control-label col-md-4">Downpayment Date <span style="color:red">*</span></label>
                                        <div class="col-md-8">

                                        <input type="date" class="form-control" name="booking_date" value="<?php echo e(old('booking_date')); ?>" id="exampleInputEmail1" placeholder="Enter Booking Date">
                                        <?php if($errors->has('booking_date')): ?>
    <span class="help-block">
                                        <strong><?php echo e($errors->first('booking_date')); ?></strong>
                                        </span>
    <?php endif; ?>
                                        </div>
                                </div>
                                </div> -->
                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-5">Booking Type <span
                                        style="color: red">*</span></label>
                                <div class="col-md-7 lallu">

                                    <input type='radio' onchange="activeNormal()" name="booking_type"
                                        value='<?php echo e(\App\CustomerProperty::normal); ?>' checked=""> Installment&nbsp;&nbsp;&nbsp;
                                        

                                    <input type='radio' onchange="activeFullPayment()" name="booking_type"
                                        value='<?php echo e(\App\CustomerProperty::full_payment); ?>'> Full Payment
                                    <?php if($errors->has('booking_type')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('booking_type')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>




                    </div>
                </div>
                <div class="col-lg-12 col-sm-12 col-xs-12" id='dealer_rebate_information'>
                    <div class="white-box">
                        <h3 class="box-title" style="display: inline-block;">Dealer Rebate Information</h3>
                        <span style="margin-left:7%">%
                            <input type="float" name="rebate_in_percentage" style="width: 23%;display: inherit;"
                                class="form-control" id="rebate_in_percentage">
                            <input type="float" class="form-control" style="width: 50%;display: inherit;"
                                name="rebate_in_amount" id="rebate_in_amount"> PKR</span><span><input style="" readonly="" type="integer" id='remaining_amount_in_rebate' class="form-control"   placeholder="Remaining amount"></span>

                        <a class="btn btn-outline btn-default waves-effect waves-light pull-right add_field_button5"
                            style="margin-top: 9px"> <span>Add More</span></a>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Authorized Dealer<span style="color: red">*</span>
                                </label>
                                <div class="col-md-8">
                                    <select class="form-control  " name="dealer_id[]" id="dealer_id">
                                        <option value="">None</option>
                                        <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $dealer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($loop->first): ?>
                                                    <optgroup label="<?php echo e($dealerTypes[$d->dealer_type_id]); ?>">
                                                <?php endif; ?>
                                                <?php if(old('dealer_id')): ?>
                                                    <?php if(old('dealer_id') == $d->id): ?>
                                                        <option value="<?php echo e($d->id); ?>" selected="">
                                                            <?php echo e($d->name); ?> ( <?php echo e($d->percentage); ?> %)</option>
                                                    <?php else: ?>
                                                        <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?> (
                                                            <?php echo e($d->percentage); ?> %)</option>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?> (
                                                        <?php echo e($d->percentage); ?> %)</option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <!-- </optgroup> -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php if($errors->has('dealer_id')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('dealer_id')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-2"> Rebate<span style="color: red">*</span> </label>
                                <div class="col-md-8 ">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="font-size: 10px;">PKR</span>
                                        <input id="total_rebate1" type="text" class="form-control total_rebate"
                                            name="total_rebate[]" value="">


                                        <?php if($errors->has('total_rebate')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('total_rebate')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="clearfix"></div>


                        








                        <div class="input_fields_wrap5">
                            <div class="clearfix"></div>
                            <div>
                            </div>


                        </div>

                        



                    </div>
                </div>




                <div class="col-lg-12 col-sm-12 col-xs-12" id="" style="display:none">
                    <div class="white-box">
                        <h3 class="box-title">Discount Payment Terms</h3>
                        isDiscounted? <input type="checkbox" name="full_discount" value="1"
                            id="discount_full_payment" onclick="fullPaymentBox()">
                        <div id="discount_div" style="display: none">
                            <hr>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Total Amount <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input id="total_amount_full_payment" readonly="" class="form-control"
                                            type='number' name="total_amount_full_payment">
                                        <?php if($errors->has('total_amount_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('total_amount_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                        <div style="color:black;" class="help-block"
                                            id='total-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Total Tenure (months)<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input class="form-control" id="total_tenure_full_payment" type='number'
                                            name="total_tenure_full_payment">
                                        <?php if($errors->has('total_tenure_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('total_tenure_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Discount Percentage <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input id="discount_percentage_full_payment" class="form-control"
                                            type='numeric' name="discount_percentage_full_payment">
                                        <?php if($errors->has('discount_percentage_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('discount_percentage_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Return Tenure <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">
                                        <select class="form-control chosen-select" name="return_tenure_full_payment"
                                            id="return_tenure_full_payment">
                                            <?php if(old('return_tenure_full_payment')): ?>
                                                <?php if(old('reutrn_tenure_full_payment') == \App\CustomerProperty::monthly): ?>
                                                    <option selected=""
                                                        value="<?php echo e(\App\CustomerProperty::monthly); ?>">Monthly</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi
                                                        Annually</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually
                                                    </option>
                                                <?php elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::quarterly): ?>
                                                    <option value="<?php echo e(\App\CustomerProperty::monthly); ?>">Monthly
                                                    </option>
                                                    <option selected=""
                                                        value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi
                                                        Annually</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually
                                                    </option>
                                                <?php elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::semi_annually): ?>
                                                    <option value="<?php echo e(\App\CustomerProperty::monthly); ?>">Monthly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                    </option>
                                                    <option selected=""
                                                        value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi Annually
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually
                                                    </option>
                                                <?php elseif(old('reutrn_tenure_full_payment') == \App\CustomerProperty::annually): ?>
                                                    <option value="<?php echo e(\App\CustomerProperty::monthly); ?>">Monthly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi
                                                        Annually</option>
                                                    <option selected=""
                                                        value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually</option>
                                                <?php else: ?>
                                                    <option selected=""
                                                        value="<?php echo e(\App\CustomerProperty::monthly); ?>">Monthly</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                    </option>
                                                    <option value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi
                                                        Annually</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually
                                                    </option>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <option selected="" value="<?php echo e(\App\CustomerProperty::monthly); ?>">
                                                    Monthly</option>
                                                <option value="<?php echo e(\App\CustomerProperty::quarterly); ?>">Quarterly
                                                </option>
                                                <option value="<?php echo e(\App\CustomerProperty::semi_annually); ?>">Semi Annually
                                                </option>
                                                <option value="<?php echo e(\App\CustomerProperty::annually); ?>">Annually</option>
                                            <?php endif; ?>

                                        </select>
                                        <?php if($errors->has('return_tenure_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('return_tenure_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Discount Amount<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input readonly="" class="form-control" id="discount_amount_full_payment"
                                            type='number' name="discount_amount_full_payment">
                                        <?php if($errors->has('discount_amount_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('discount_amount_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                        <div style="color:black;" class="help-block"
                                            id='rebate-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Deduction Amount </label>
                                    <div class="col-md-7">

                                        <input id="deduction_amount_full_payment" class="form-control" type='number'
                                            name="deduction_amount_full_payment">
                                        <?php if($errors->has('deduction_amount_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('deduction_amount_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Net Amount after Deduction<span
                                            style="color: red">*</span></label>
                                    <div class="col-md-7">

                                        <input readonly="" id="net_amount_full_payment" class="form-control"
                                            type='number' name="net_amount_full_payment">
                                        <?php if($errors->has('net_amount_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('net_amount_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                        <div style="color:black;" class="help-block"
                                            id='net-amount-full-payment-label'></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Per tenure Amount</label>
                                    <div class="col-md-7">

                                        <input readonly="" id="per_full_payment" class="form-control"
                                            type='number' name="per_full_payment">
                                        <?php if($errors->has('per_full_payment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('per_full_payment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                        <div style="color:black;" class="help-block" id='per-full-payment-label'>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>


                <div class="col-lg-12 col-sm-12 col-xs-12" id="normal">
                    <div class="white-box">
                        <h3 class="box-title">Payment Scheduler</h3>
                        <hr>

                        <!--    <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="control-label col-md-5">Amount Schedule in <span style="color: red">*</span></label>
                                    <div class="col-md-7">

                                    <input type='radio' onchange="manToPer()" name="amount_schedule" value='1' > Percentage<br>
                                    <input type='radio' onchange="perToMan()"  name="amount_schedule" value='2' checked="" > Manual
                                    <?php if($errors->has('amount_schedule')): ?>
    <span class="help-block">
                                    <strong><?php echo e($errors->first('amount_schedule')); ?></strong>
                                    </span>
    <?php endif; ?>
    </div>
    </div>
                                    </div>

                                    <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="control-label col-md-5">Schedule Start Date <span style="color:red">*</span></label>
                                    <div class="col-md-7">

                                    <input type="date" class="form-control" name="schedule_start_date" value="<?php echo e(old('schedule_start_date')); ?>" id="exampleInputEmail1" placeholder="Enter Schedule Start Date">
                                    <?php if($errors->has('schedule_start_date')): ?>
    <span class="help-block">
                                    <strong><?php echo e($errors->first('schedule_start_date')); ?></strong>
                                    </span>
    <?php endif; ?>
    </div>
                                    </div>
                                    </div>

                                <div class="clearfix"></div>
                                <hr> -->
                        <div class="col-md-12">

                            <div class="form-group">
                                <label class="control-label col-md-2">Schedular Type<span
                                        style="color: red">*</span></label>


                                <div class="col-md-10">


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon); ?>'> Monthly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableQuar()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>' checked="">
                                        Monthly with Quarterly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>' checked="">
                                        Monthly with Semi Annually
                                    </div>


                                    <div class="clearfix"></div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableAnn()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>' checked="">
                                        Monthly with Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_bi_mon); ?>'> Bi Monthly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_quar); ?>'> Quarterly
                                    </div>


                                    <div class="clearfix"></div>

                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>'> Quarterly with
                                        SemiAnnually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_semi); ?>'> SemiAnnually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_ann); ?>'> Annually
                                    </div>

                                    <div class="clearfix"></div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableAnn()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_exclude_ann); ?>'> Monthly exclude
                                        Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableQuar()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_exclude_quar); ?>'> Monthly exclude
                                        Quarterly
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_mon_exclude_semi); ?>'> Monthly exclude
                                        Semi Annually
                                    </div>


                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableSemi()" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_quar_exclude_semi); ?>'> Quarterly
                                        exclude SemiAnnually
                                    </div>



                                    <div class="col-md-4">
                                        <input type='radio' onchange="enableCustom(this.value)" name="schedule_type"
                                            value='<?php echo e(\App\CustomerProperty::inst_custom); ?>'> Custom
                                    </div>


                                    <?php if($errors->has('schedule_type')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('schedule_type')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
















                        <div class="clearfix"></div>
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Schedule Start Date <span
                                        style="color:red">*</span></label>

                                <input type="date" class="form-control" name="schedule_start_date"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="schedule_start_date"
                                    placeholder="Enter Schedule Start Date">
                                <?php if($errors->has('schedule_start_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('schedule_start_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Booking <span style="color: red">*</span></label>
                                <input type="integer" id='booking' class="form-control" name="booking"
                                    value="<?php echo e(old('booking')); ?>" placeholder="Enter Booking">
                                <div style="color:black;" class="help-block" id='booking-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_booking" placeholder="%">
                                </div>


                                <?php if($errors->has('booking')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('booking')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Down Payment Date <span style="color:red">*</span></label>

                                <input type="date" class="form-control" name="booking_date"
                                    value="<?php echo e(date('Y-m-d')); ?>" id="booking_date">
                                <?php if($errors->has('booking_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('booking_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Down Payment <span style="color: red">*</span></label>
                                <input type="integer" id='down-payment' class="form-control" name="down_payment"
                                    value="<?php echo e(old('down_payment')); ?>" placeholder="Down Payment">
                                <div style="color:black;" class="help-block" id='down-payment-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_down_payment"
                                        placeholder="%">
                                </div>
                                <?php if($errors->has('down_payment')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('down_payment')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>


                        </div>



                        
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Possession Date </label>
                                <input type="date" id='possession_date' class="form-control"
                                    name="possession_date" value="<?php echo e($possession_date); ?>">

                                <?php if($errors->has('possession_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('possession_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Possession <span style="color: red">*</span></label>
                                <input type="integer" id='possession' class="form-control" name="possession"
                                    value="<?php echo e(old('possession')); ?>" placeholder="Enter Possession">
                                <div style="color:black;" class="help-block" id='possession-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_possession" placeholder="%">
                                </div>
                                <?php if($errors->has('possession')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('possession')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Confirmation Date </label>
                                <input type="date" id='confirmation_date' value="<?php echo e(date('Y-m-d')); ?>"
                                    class="form-control" name="confirmation_date">

                                <?php if($errors->has('confirmation_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('confirmation_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Confirmation <span style="color: red">*</span></label>
                                <input type="integer" id='confirmation' class="form-control" name="confirmation"
                                    value="<?php echo e(old('confirmation')); ?>" placeholder="Confirmation">
                                <div style="color:black;" class="help-block" id='confirmation-label'></div>

                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_confirmation"
                                        placeholder="%">

                                </div>


                                <?php if($errors->has('confirmation')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('confirmation')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Allotment Date </label>
                                <input type="date" id='allotment_date' class="form-control"
                                    value="<?php echo e(date('Y-m-d')); ?>" name="allotment_date">

                                <?php if($errors->has('allotment_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('allotment_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Allotment <span style="color: red">*</span></label>
                                <input type="integer" id='allotment' class="form-control" name="allotment"
                                    value="<?php echo e(old('allotment')); ?>" placeholder="Enter Allotment">
                                <div style="color:black;" class="help-block" id='allotment-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>

                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_allotment" placeholder="%">
                                </div>
                                <?php if($errors->has('allotment')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('allotment')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Registration Date </label>
                                <input type="date" id='registration_date' value="<?php echo e(date('Y-m-d')); ?>"
                                    class="form-control" name="registration_date">

                                <?php if($errors->has('registration_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('registration_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Registration <span style="color: red">*</span></label>
                                <input type="integer" id='registration' class="form-control" name="registration"
                                    value="<?php echo e(old('registration')); ?>" placeholder="Registration">
                                <div style="color:black;" class="help-block" id='registration-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_registration"
                                        placeholder="%">

                                </div>


                                <?php if($errors->has('registration')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('registration')); ?></strong>
                                    </span>
                                <?php endif; ?>

                            </div>
                        </div>



                        
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">File Processing Date </label>
                                <input type="date" id='file_processing_date' value="<?php echo e(date('Y-m-d')); ?>"
                                    class="form-control" name="file_processing_date">

                                <?php if($errors->has('file_processing_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('file_processing_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">File Processing <span style="color: red">*</span></label>
                                <input type="integer" id='file_processing' class="form-control"
                                    name="file_processing" value="<?php echo e(old('file_processing')); ?>"
                                    placeholder="Enter File Processing">
                                <div style="color:black;" class="help-block" id='file_processing-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_file_processing"
                                        placeholder="%">

                                </div>


                                <?php if($errors->has('file_processing')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('file_processing')); ?></strong>
                                    </span>
                                <?php endif; ?>

                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">Balloting Date </label>
                                <input type="date" id='bulleting_date' value="<?php echo e(date('Y-m-d')); ?>"
                                    class="form-control" name="bulleting_date">

                                <?php if($errors->has('bulleting_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('bulleting_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Balloting <span style="color: red">*</span></label>
                                <input type="integer" id='bulleting' class="form-control" name="bulleting"
                                    value="<?php echo e(old('bulleting')); ?>" placeholder="Balloting">
                                <div style="color:black;" class="help-block" id='bullating-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%;    margin-left: -41px;'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_bulleting" placeholder="%">

                                </div>


                                <?php if($errors->has('bulleting')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('bulleting')); ?></strong>
                                    </span>
                                <?php endif; ?>

                            </div>
                        </div>

                        
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">Ballon Payment Date </label>
                                <input type="date" id='ballonpayment_date' value="<?php echo e(date('Y-m-d')); ?>"
                                    class="form-control" name="ballonpayment_date">

                                <?php if($errors->has('ballonpayment_date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('ballonpayment_date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">Ballon Payment<span style="color: red">*</span></label>
                                <input type="integer" id='ballon' class="form-control" name="ballon"
                                    value="<?php echo e(old('ballon')); ?>" placeholder="Enter Ballon">
                                <div style="color:black;" class="help-block" id='ballon-label'></div>
                            </div>
                            <div class="col-md-2" style='margin-top: 2.2%; margin-left: -40px'>
                                <div class="input-group">
                                    <span class="input-group-addon" style="font-size: 16px;background: none;">%</span>
                                    <input type="float" class="form-control" id="per_file_ballon" placeholder="%">

                                </div>


                                <?php if($errors->has('ballon')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('ballon')); ?></strong>
                                    </span>
                                <?php endif; ?>

                            </div>

                        </div>






















                        <div class="col-md-1"></div>


                        <div class="clearfix"></div>

                        <div id="auto" style="margin-top: 2%;">

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Per Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 23%;" type="integer"
                                            id='installment' class="form-control" name="installment"
                                            value="<?php echo e(old('installment')); ?>" placeholder="Per installment">
                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_installment"
                                            placeholder="%" style="width: 15%;display: inline-block;">




                                        <input style="display: inline-block;width: 28%;" type="integer"
                                            id='total_installment' class="form-control" name="total_installment"
                                            value="<?php echo e(old('total_installment')); ?>" placeholder="Total amount">

                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_total_installment"
                                            placeholder="%" style="width: 10%;display: inline-block;">


                                        <!-- <label class="control-label col-md-5">Total Installments (Months) <span style="color: red">*</span></label> -->
                                        <input type="integer" style="width: 10.5%;display: inline-block;"
                                            id='total-months' class="form-control" name="installment_plan"
                                            value="<?php echo e(old('installment_plan')); ?>" placeholder="Count">

                                        <div style="display: inline-block;width: 49%;color:black;" class="help-block"
                                            id='installment-label'></div>
                                        <div style="display: inline-block;width: 49%;color:black;" class="help-block"
                                            id='total-installment-label'></div>
                                        <?php if($errors->has('installment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('installment')); ?></strong>
                                            </span>
                                        <?php endif; ?>

                                        <?php if($errors->has('installment_plan')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('installment_plan')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                        <div style="color:black;" class="help-block" id='total-months-label'></div>
                                    </div>


                                </div>
                            </div>


                            <div class="col-md-10" id="ann_div">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Annual Installments <span style="color: red">*</span></label>
                                    <div class="col-md-9">



                                        <input style="display: inline-block;width: 23%;" type="integer"
                                            id='annual-installment' class="form-control" name="annual_installment"
                                            value="<?php echo e(old('annual_installment')); ?>" id="exampleInputEmail1"
                                            placeholder=" Annual">


                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_annual-installment"
                                            placeholder="%" style="width: 15%;display: inline-block;">
                                        <input style="display: inline-block;width: 28%;" type="integer"
                                            id='total_annual_installment' class="form-control"
                                            name="total_annual_installment"
                                            value="<?php echo e(old('total_annual_installment')); ?>" id="exampleInputEmail1"
                                            placeholder="Total Annual">

                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_total_annual_installment"
                                            placeholder="%" style="width: 10%;display: inline-block;">

                                        <input style="display: inline-block;width: 10.5%;" type="integer"
                                            id='total_annual_installment_count' class="form-control"
                                            name="total_annual_installment_count"
                                            value="<?php echo e(old('total_annual_installment_count')); ?>"
                                            id="exampleInputEmail1" placeholder="Count">


                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='annual-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-annual-installment-label'></div>





                                        <?php if($errors->has('annual_installment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('annual_installment')); ?></strong>
                                            </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="semi_div" style="display: none">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Semi Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        
                                        <input style="display: inline-block;width: 23%;" type="integer"
                                            id='semi-installment' class="form-control" name="semi_installment"
                                            value="<?php echo e(old('semi_installment')); ?>" id="exampleInputEmail1"
                                            placeholder=" Semi">


                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_semi_installment"
                                            placeholder="%" style="width: 15%;display: inline-block;">


                                        <input style="display: inline-block;width: 28%;" type="integer"
                                            id='total_semi_installment' class="form-control"
                                            name="total_semi_installment" value="<?php echo e(old('total_semi_installment')); ?>"
                                            id="exampleInputEmail1" placeholder="Total Semi Annually">


                                        <span>%</span>
                                        <input type="float" class="form-control" id="per_total_semi_installment"
                                            placeholder="%" style="width: 10%;display: inline-block;">



                                        <input style="width: 10.5%;display: inline-block;" type="integer"
                                            id='total_semi_installment_count' class="form-control"
                                            name="total_semi_installment_count"
                                            value="<?php echo e(old('total_semi_installment_count')); ?>" id="exampleInputEmail1"
                                            placeholder="Count">

                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='semi-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-semi-installment-label'></div>
                                        <?php if($errors->has('semi_installment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('semi_installment')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="bi_mon_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Bi Monthly Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        <input style="display: inline-block;width: 40%;" type="integer"
                                            id='bi-mon-installment' class="form-control" name="bi_mon_installment"
                                            value="<?php echo e(old('bi_mon_installment')); ?>" id="exampleInputEmail1"
                                            placeholder=" Bi Monthly">

                                        <input style="display: inline-block;width: 40%;" type="integer" readonly=""
                                            id='total_bi_mon_installment' class="form-control"
                                            name="total_bi_mon_installment"
                                            value="<?php echo e(old('total_bi_mon_installment')); ?>" id="exampleInputEmail1"
                                            placeholder="Total Bi Monthly">
                                        <input style="display: inline-block;width: 15%;" type="integer" readonly=""
                                            id='total_bi_mon_installment_count' class="form-control"
                                            name="total_bi_mon_installment_count"
                                            value="<?php echo e(old('total_bi_mon_installment_count')); ?>"
                                            id="exampleInputEmail1" placeholder="Count">
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='bi-mon-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-bi-mon-installment-label'></div>
                                        <?php if($errors->has('bi_mon_installment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('bi_mon_installment')); ?></strong>
                                            </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-10" id="quar_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Quarterly Installments <br> <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">
                                        <input style="display: inline-block;width: 43%;" type="integer"
                                            id='quarterly-installment' class="form-control"
                                            name="quarterly_installment" value="<?php echo e(old('quarterly_installment')); ?>"
                                            id="exampleInputEmail1" placeholder=" Quarterly">

                                        <input style="display: inline-block;width: 40%;" type="integer"
                                            id='total_quarterly_installment' class="form-control"
                                            name="total_quarterly_installment"
                                            value="<?php echo e(old('total_quarterly_installment')); ?>" id="exampleInputEmail1"
                                            placeholder="Total Quarterly">
                                        <input style="display: inline-block;width: 15%;" type="integer" readonly=""
                                            id='total_quarterly_installment_count' class="form-control"
                                            name="total_quarterly_installment_count"
                                            value="<?php echo e(old('total_quarterly_installment_count')); ?>"
                                            id="exampleInputEmail1" placeholder="Count">
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='quarterly-installment-label'></div>
                                        <div style="display: inline-block;width: 40%;color:black;" class="help-block"
                                            id='total-quarterly-installment-label'></div>
                                        <?php if($errors->has('quarterly_installment')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('quarterly_installment')); ?></strong>
                                            </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>




                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-5">Remaining Amount</label>
                                    <div class="col-md-7">

                                        <input readonly="" type="integer" id='remaining_amount'
                                            class="form-control" value="<?php echo e(old('remaining_amount')); ?>"
                                            placeholder="Remaining amount">
                                        <br>


                                        Adjust to <br>
                                        <ul type="none">
                                            <span>
                                         <li>
                                             <input type="radio" id="adjust" name="adjust" onclick="adjustAmount(1)" > Installment
                                         </li>
                                         <!-- <li><input type="radio" name="adjust" id="adjust" onclick="adjustAmount(2)"> Semi-Installment</li> -->
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(3)"> Down Payment
                                         </li>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(4)"> Possession
                                         </li>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(5)"> Allotment
                                         </li>
             </span>
             <span style="float:right">
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(6)"> Confirmation
                                         </li>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(7)"> Booking
                                         </li>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(8)"> Development
                                         </li>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(9)"> File Processing
                                         </li>
                                         <li><input type="radio" name="adjust" id="adjust_balloting"
                                            onclick="adjustAmount(19)"> Balloting</li>

                                            <li><input type="radio" name="adjust" id="adjust_ballon"
                                                onclick="adjustAmount(18)"> Ballon</li>
             </span>
                                         <li>
                                             <input type="radio" name="adjust" id="adjust" onclick="adjustAmount(10)"> Registration
                                         </li>
                                         
                                         </ul>
                                        


                                        <div style="color:black;" class="help-block" id='remaining-amount-label'>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="input_fields_wrap1">
                                <button type="button" style="float: left!important;"
                                    class="btn btn-primary add_field_button">Add Payment</button>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>


                        </div>

                        <!---Custom-->
                        <div id="custom" style="display: none;">

                            <div class="col-md-10">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Installment <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-9">

                                        <input style="display: inline-block;width: 43%;" type="date"
                                            id='installment' class="form-control" name="custom_date[]"
                                            placeholder="Date">

                                        <input style="display: inline-block;width: 49%;" type="integer"
                                            class="form-control" name="custom_amount[]" onkeyup="customPayment()"
                                            placeholder="Amount">
                                    </div>
                                </div>
                            </div>


                            <div class="clearfix"></div>
                            <div class="input_fields_wrap2 col-md-10">

                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                            <button type="button" class="btn btn-primary add_field_button2">Add
                                Installment</button>&nbsp;&nbsp;&nbsp;
                            <input style="display: inline-block;width: 30%;" type="integer" readonly=""
                                id='custome_rem' class="form-control" placeholder="Remaining amount">
                            <div class="clearfix"></div>
                        </div>

                        <!-- Custom End -->

                    </div>
                </div>
                <!--receipt module -->




                <div class="col-md-12" style="height: 70px;">
                    <div class="alert alert-danger" style="display:none;" role="alert" id="required_field_error">
                        All Fields With * is Required.
                    </div>

                    <button style="float: right;" type="submit"
                        class="btn btn-info  waves-effect waves-light btn-lg">Save</button>
                </div>


        </div>
    </div>


    </form>
    </div>
    </div>
    <input type='hidden' id="possession_per">
    <input type='hidden' id="down_payment_per">
    <input type='hidden' id="total_month_per">
    <input type='hidden' id="annual_installment_per">
    <input type='hidden' id="monthly_installment_per">
    <input type="hidden" id="down_payment_dis">
    <input type="hidden" name="percentage" id="percentage">
    <input type="hidden" name="rebate_in_percent" id="rebate_in_percent">

    <input type="hidden" name="semi_installment_hid_per" id="semi_installment_hid_per">
    <input type="hidden" name="semi_installment_hid_amount" id="semi_installment_hid_amount">


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function percentage(num, per) {
            return (num / 100) * per;
        }

        function validateData(self) {

            var customer = $(self).find('#customer_id').val();
            var unit_number = $(self).find('#unit_number').val();
            var original_boooking_date = $(self).find('#original_boooking_date').val();
            var dealer_id = $(self).find('#dealer_id').val();
            var total_rebate1 = $(self).find('#total_rebate1').val();
            var schedule_start_date = $(self).find('#schedule_start_date').val();
            var booking_date = $(self).find('#booking_date').val();
            var possession = $(self).find('#possession').val();
            var down_payment = $(self).find('#down-payment').val();
            var allotment = $(self).find('#allotment').val();
            var confirmation = $(self).find('#confirmation').val();
            var booking = $(self).find('#booking').val();

            var file_processing = $(self).find('#file_processing').val();
            var registration = $(self).find('#registration').val();
            var installment = $(self).find('#installment').val();

            var ballon_date = $(self).find('#development').val();
            var ballon_payment = $(self).find('#file_processing').val();
            var bullating_date = $(self).find('#registration').val();
            var bullating_payment = $(self).find('#installment').val();


            if (confirmation == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (booking == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }


            if (development == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }



            if (file_processing == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (registration == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }


            if (installment == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }



            if (possession == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (down_payment == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }


            if (allotment == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }



            if (schedule_start_date == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (booking_date == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }
            if (bullating_payment == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }
            if (bullating_date == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (ballon_payment == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }

            if (ballon_date == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }



            //     if (total_rebate1 == "")
            //     {
            //         $('#required_field_error').show();
            //         setTimeout(function() { 
            //         $('#required_field_error').hide();        
            //         }, 3000);
            // return false;
            //     }

            //     if (dealer_id == "")
            //     {
            //         $('#required_field_error').show();
            //         setTimeout(function() { 
            //         $('#required_field_error').hide();        
            //         }, 3000);
            // return false;
            //     }

            //    if (customer == "")
            //     {
            //         $('#required_field_error').show();
            //         setTimeout(function() { 
            //         $('#required_field_error').hide();        
            //         }, 3000);
            // return false;
            //     }


            if (unit_number == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }


            if (original_boooking_date == "") {
                $('#required_field_error').show();
                setTimeout(function() {
                    $('#required_field_error').hide();
                }, 3000);
                return false;
            }



        }

        function hideFields(self) {

            if (self === 'company') {
                $('#father_name').val('null');
                $('#father_name_parent').hide();
                $('#passport_no').hide()
                $('#date_of_birth').html('Date of Incorporation <span style="color: red">*</span>')
                $('#cnic_no').html('Incorporation no <span style="color: red">*</span>')
                $('#mobile_number').html('Phone Number <span style="color: red">*</span>')
                $('#res_number').hide()
                $('#phone_number').hide()
                $('#photo_s').hide()
                $('#mailing_label').html('Company Registered Address <span style="color: red">*</span>')
                $('#permanent_address').val($('#mailing_address').val())
                $('#permanent_add').hide()
                $('#occupations').html('Type Of Company <span style="color: red">*</span>')
                $('#imgs_label').html('Certificate  <span style="color: red">*</span>')
                $('#type').val(1)
            }

            if (self === 'individual') {
                $('#type').val(0)
                $('#father_name').val('');
                $('#father_name_parent').show();
                $('#passport_no').show()
                $('#date_of_birth').html('Date of Birth <span style="color: red">*</span>')
                $('#cnic_no').html('Cnic <span style="color: red">*</span>')
                $('#mobile_number').html('Mobile Number <span style="color: red">*</span>')
                $('#res_number').show()
                $('#photo_s').show()
                $('#phone_number').show()
                $('#mailing_label').html('Mailing Address <span style="color: red">*</span>')
                $('#permanent_add').show()
                $('#occupations').html('Occupation <span style="color: red">*</span>')
                $('#imgs_label').html('Passport size photo  <span style="color: red">*</span>')
            }


            return false;
        }

        function validateCnic(self) {
            var cnic = $(self).val().replaceAll('-', '');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('validate.dnfbp.cnic')); ?>",
                method: 'POST',
                dataType: 'json',
                data: {
                    cnic: cnic
                },
                success: function(data) {
                    if (data.response == 'invalid') {
                        $(self).closest('.form-group').find('#cnic_error1').show();
                    }

                }
            })



            return false;
        }

        //multiple nominees
        $(document).ready(function() {
            var max_fields = 5; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap4"); //Fields wrapper

            var add_button = $(".add_field_button4"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Nominee Name <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_name_1[]" value="" id="exampleInputuname" placeholder="Enter Name"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">S/O, D/O, W/O.<span style="color: red">*</span></label><div class="col-md-9"><input  type="text" class="form-control" name="nominee_so_do_wo_1[]" value="" id="exampleInputuname" placeholder="Enter Father Name"></div></div></div><div <div class="form-group"><label class="control-label col-md-1">CNIC</label><div class="col-md-5"><input type="text"  class="form-control" value="" name="nominee_cnic_1[]" id="nominee_cnic"  placeholder="XXXXXXXXXXXXX" onfocusout="return validateCnic(this)" ></div><div class="col-md-12" style="color: red;display: none;" id="cnic_error1">This Customer cnic is found in list of DNFBP. You cant add this Customer record.</div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Passport No.</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_passport_no_1[]" id="nominee_passport_no"  placeholder="XXXXXXXXX" ></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Relation With Applicant <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_relation_1[]" value=""  placeholder="Enter Relation"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Email</label><div class="col-md-9"><input type="text" class="form-control" name="nominee_email_1[]" value=""  placeholder="Enter Email"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Mobile Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_mobile_number_1[]" value=""  placeholder="Enter Mobile Number"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Res. Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_res_number_1[]" value=""  placeholder="Enter Res Number"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Phone Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_phone_number_1[]" value=""  placeholder="Enter Phone Number"></div></div></div><a href="#"class="remove_field">Remove</a>'
                        ); //add input box

                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })

        });

        $(document).ready(function() {
            var max_fields = 2; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap3"); //Fields wrapper

            var add_button = $(".add_field_button3"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Nominee Name <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_name_n" value="" id="exampleInputuname" placeholder="Enter Name"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">S/O, D/O, W/O.<span style="color: red">*</span></label><div class="col-md-9"><input  type="text" class="form-control" name="nominee_so_do_wo_n" value="" id="exampleInputuname" placeholder="Enter Father Name"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">CNIC</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_cnic_n" id="nominee_cnic"  placeholder="XXXXXXXXXXXXX"  onfocusout="return validateCnic(this)"><input type="radio" name="nominee_cnic_flag_n" value="1"> Locally<input type="radio" name="nominee_cnic_flag_n" value="2"> Internationally</div><div style="color: red;display: none;" class="col-md-12"  id="cnic_error1">This Customer cnic is found in list of DNFBP. You cant add this Customer record. </div></div></div> <div class="col-md-6"><div class="form-group" id="nominee_address"><label for="address" class="col-sm-3 control-label" id="nominee_address">Nominee Address <span style="color: red">*</span></label><div class="col-sm-9"><div class="input-group"><div class="input-group-addon"><i class="icon-location-pin"></i></div><textarea class="form-control" id="nominee_address" name="nominee_address" ></textarea></div></div> </div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Passport No.</label><div class="col-md-9"><input type="text"  class="form-control" value="" name="nominee_passport_no_n" id="nominee_passport_no"  placeholder="XXXXXXXXX" ></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Relation With Applicant <span style="color: red">*</span></label><div class="col-md-9"><input type="text" class="form-control" name="nominee_relation_n" value=""  placeholder="Enter Relation"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Email</label><div class="col-md-9"><input type="text" class="form-control" name="nominee_email_n" value=""  placeholder="Enter Email"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Mobile Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_mobile_number_n" value=""  placeholder="Enter Mobile Number"></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Res. Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_res_number_n" value=""  placeholder="Enter Res Number"></div></div></div><div class="clearfix"></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-3">Phone Number </label><div class="col-md-9"><input type="text" class="form-control" name="nominee_phone_number_n" value=""  placeholder="Enter Phone Number"></div></div></div><a href="#"class="remove_field">Remove</a>'
                        ); //add input box

                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })

        });


        //multiple dealers
        $(document).ready(function() {
            var max_fields = 5; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap5"); //Fields wrapper

            var add_button = $(".add_field_button5"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div><hr><div class="col-md-6"><div class="form-group"><label class="control-label col-md-4">Authorized Dealer <span style="color: red">*</span></label><div class="col-md-8"><select class="form-control chosen-select" name="dealer_id[]" ><option value="" >None</option><?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php $__currentLoopData = $dealer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if($loop->first): ?><optgroup label="<?php echo e($dealerTypes[$d->dealer_type_id]); ?>"><?php endif; ?><option value="<?php echo e($d->id); ?>" ><?php echo e($d->name); ?> ( <?php echo e($d->percentage); ?> %)</option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></optgroup><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div></div></div><div class="col-md-6"><div class="form-group"><label class="control-label col-md-2">Rebate <span style="color: red">*</span></label><div class="col-md-8"><div class="input-group"><span class="input-group-addon" style="font-size: 10px;">PKR</span><input id="total_rebate' +
                        x +
                        '" type="text" class="form-control total_rebate" name="total_rebate[]" value="0" ></div></div></div></div> <br><div class="clearfix"></div><div class="clearfix"></div> <a href="#"class="remove_field">Remove</a>'
                        ); //add input box

                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })

        });


        $('#total_rebate1').keyup(function() {

            downPC = $('#d_rebate_p1').val();
            rebate = $('#total_rebate1').val();

            $('#d_rebate1').val(Math.round((downPC * rebate) / 100));

            insPC = $('#i_rebate_p1').val();
            $('#i_rebate1').val(Math.round((insPC * rebate) / 100));

        });

        $('#d_rebate1').keyup(function() {
            downVC = $('#d_rebate1').val();
            rebate = $('#total_rebate1').val();

            $('#d_rebate_p1').val(Math.round((downVC * 100) / rebate));
            $('#i_rebate_p1').val(Math.round(100 - $('#d_rebate_p1').val()));

            insPC = $('#i_rebate_p1').val();
            rebate = $('#total_rebate1').val();

            $('#i_rebate1').val(Math.round((insPC * rebate) / 100));

        });

        $('#d_rebate_p1').keyup(function() {

            downPC = $('#d_rebate_p1').val();

            rebate = $('#total_rebate1').val();

            $('#d_rebate1').val(Math.round((downPC * rebate) / 100));
            $('#i_rebate_p1').val(Math.round(100 - downPC));

            insPC = $('#i_rebate_p1').val();
            rebate = $('#total_rebate1').val();

            $('#i_rebate1').val(Math.round((insPC * rebate) / 100));

        });



        function openRebate(val, id) {

            if (val) {
                $('.preloader').fadeIn();
                var data = {
                    'id': val
                };
                $.get('/getDealerById', data, function(data) {
                    amount = $('#total-amount').val();
                    if (data.rebate_in_percent)
                        rebate = (data.percentage * amount) / 100;
                    else
                        rebate = data.percentage;
                    $('#percentage' + id).val(data.percentage);
                    $('#rebate_in_percent' + id).val(data.rebate_in_percent);
                    $('#total_rebate' + id).val(rebate);
                    $('#d_rebate' + id).val(Math.round((rebate * data.down_payment_rebate) / 100));
                    $('#i_rebate' + id).val(Math.round((rebate * data.installment_rebate) / 100));
                    $('#d_rebate_p' + id).val(Math.round(data.down_payment_rebate));
                    $('#i_rebate_p' + id).val(Math.round(data.installment_rebate));
                    $('#p_rebate' + id).val(Math.round(data.paid_installment_rebate));
                });
                rebate = 'rebate' + id;
                document.getElementById(rebate).style.display = 'block';
                $('.preloader').fadeOut();
            } else
                document.getElementById('rebate').style.display = 'none';
        }

        $(document).ready(function() {
            var max_fields = 50; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap1"); //Fields wrapper
            var wrapper1 = $(".input_fields_wrap"); //Fields wrapper
            var add_button = $(".add_field_button"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Add Extra Payment<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" onkeyup="addPayment()" type="integer" class="form-control" name="add_amount[]" placeholder="Amount"><input style="display: inline-block;width: 49%;" type="date" class="form-control"  name="add_date[]"  placeholder=""></div> </div><a href="#" class="remove_field">Remove</a>'
                        ); //add input box
                    $(".bdpk").datepicker({
                        dateFormat: "dd-mm-yy"
                    });
                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
            $(wrapper1).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
        });

        //custom
        $(document).ready(function() {
            var max_fields = 100; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap2"); //Fields wrapper
            var wrapper1 = $(".input_fields_wrap2"); //Fields wrapper
            var add_button = $(".add_field_button2"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Installment-' +
                        x +
                        '<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 43%;margin-right: 4px;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'
                        ); //add input box
                    $(".bdpk").datepicker({
                        dateFormat: "dd-mm-yy"
                    });
                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
            $(wrapper1).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
        });

        //end custom

        function customPayment() {

            // net_amount = parseInt($('#net_amount').val());
            // down_payment = parseInt($('#down-payment').val());
            // possession = parseInt($('#possession').val());

            var cus_amount = 0;

            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }

            });

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());
            remaining_amount = net_amount - down_payment - possession - allotment - confirmation - booking -
                file_processing - registration - cus_amount - ballon - bullating;

            // remaining_amount = net_amount - down_payment - possession - cus_amount;

            $('#custome_rem').val(Math.round(remaining_amount));

        }

        function addPayment() {

            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            }


            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount;

            $('#remaining_amount').val(remaining_amount);

            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        }


        function receiptBox() {
            if ($('#receipt').prop("checked") == true) {
                $('#receipt_div').css('display', 'block');
            } else if ($('#receipt').prop("checked") == false) {
                $('#receipt_div').css('display', 'none');
            }
        }

        function fullPaymentBox() {
            if ($('#discount_full_payment').prop("checked") == true) {
                $('#discount_div').css('display', 'block');
            } else if ($('#discount_full_payment').prop("checked") == false) {
                $('#discount_div').css('display', 'none');
            }
        }

        function changeFunc(a) {
            if (a == <?php echo e(\App\Receipt::cash); ?>) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
            } else if (a == <?php echo e(\App\Receipt::bank); ?>) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
            } else if (a == <?php echo e(\App\Receipt::cheque); ?>) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'block');
                $('#adjustment').css('display', 'none');
            } else if (a == <?php echo e(\App\Receipt::adjustment); ?>) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'block');
            }
        }
    </script>


    <script>
        $('input[type="checkbox"]').click(function() {
            if ($(this).prop("checked") == true) {
                $('textarea#permanent_address').val($('textarea#mailing_address').val());
            } else if ($(this).prop("checked") == false) {
                $('textarea#permanent_address').val('');
            }
        });

        function updateSchedule() {

            var type = $('#type').val();
            var size = $('#size').val();
            var floor = $('#floor').val();

            var data = {
                'type': type,
                'size': size,
                'floor': floor
            };
            $.get('/statement/updateSchedule', data, function(data) {
                // console.log(data);
                if (data) {
                    $('#cost-amount').val(Math.round(data.cost_amount));
                    $('#down-payment').val(Math.round(data.down_payment / 100 * data.cost_amount));
                    $('#possession').val(Math.round(data.possession / 100 * data.cost_amount));
                    $('#annual-installment').val(Math.round(data.annual_installment / 100 * data.cost_amount / 4));
                    $('#total-months').val(Math.round(data.total_months));
                    $('#total_annual_installment_count').val(Math.round(data.total_months / 12));
                    $('#total_semi_installment_count').val(Math.round(data.total_months / 6));
                    $('#total_quarterly_installment_count').val(Math.round(data.total_months / 3));
                    $('#total_bi_mon_installment_count').val(Math.round(data.total_months / 2));

                    $('#installment').val(Math.round(data.installment / 100 * data.cost_amount / data
                    .total_months));

                    updateCurrency();
                }

            });

        }
    </script>


    <script>
        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        //update the cost label




        //update the registration

        $('#registration').keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            registration = parseInt($('#registration').val());
            possession = parseFloat($('#possession').val());
            $('#per_registration').val(((registration / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;
            num = $("#registration").val();
            $("#registration-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }

            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(registration)) {
                registration = 0;
                $('#per_registration').val(0);

            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the per registraiton

        $('#per_registration').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            per_registration = parseFloat($('#per_registration').val());
            possession = parseFloat($('#possession').val());

            $('#registration').val(percentage(net_amount, per_registration));

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#registration").val();
            $("#registration-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }

            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(registration)) {
                registration = 0;
                $('#registration').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });


        //update the file processing

        $('#file_processing').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            file_processing = parseInt($('#file_processing').val());
            possession = parseFloat($('#possession').val());
            $('#per_file_processing').val(((file_processing / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#file_processing").val();
            $("#file_processing-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(file_processing)) {
                file_processing = 0;
                $('#per_file_processing').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the per file processing

        $('#per_file_processing').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            per_file_processing = parseFloat($('#per_file_processing').val());
            possession = parseFloat($('#possession').val());

            $('#file_processing').val(percentage(net_amount, per_file_processing));

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#file_processing").val();
            $("#file_processing-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            
  else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            
 var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(file_processing)) {
                file_processing = 0;
                $('#file_processing').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });

        //update the booking

        $('#booking').keyup(function() {


            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            booking = parseInt($('#booking').val());
            possession = parseFloat($('#possession').val());
            $('#per_booking').val(((booking / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#booking").val();
            $("#booking-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }




            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());


            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            if (isNaN(booking)) {
                booking = 0;
                $('#per_booking').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating-cus_amount;

            
            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });




        //update the per booking

        $('#per_booking').keyup(function() {


            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            per_booking = parseFloat($('#per_booking').val());
            possession = parseFloat($('#possession').val());

            $('#booking').val(percentage(net_amount, per_booking));

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#booking").val();
            $("#booking-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(booking)) {
                booking = 0;
                $('#per_booking').val(0);
                $('#booking').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating -cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the confirmation

        $('#confirmation').keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            confirmation = parseInt($('#confirmation').val());
            possession = parseFloat($('#possession').val());
            $('#per_confirmation').val(((confirmation / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;


            num = $("#confirmation").val();
            $("#confirmation-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
          

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(confirmation)) {
                confirmation = 0;
                $('#per_confirmation').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating -cus_amount;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the per confirmation

        $('#per_confirmation').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            per_confirmation = parseFloat($('#per_confirmation').val());
            possession = parseFloat($('#possession').val());

            $('#confirmation').val(percentage(net_amount, per_confirmation));

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#confirmation").val();
            $("#confirmation-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());


            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            
  if (isNaN(confirmation)) {
    confirmation = 0;
                $('#confirmation').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the allotment

        $('#allotment').keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            possession = parseFloat($('#possession').val());
            allotment = parseFloat($('#allotment').val());
            $('#per_allotment').val(((allotment / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#allotment").val();
            $("#allotment-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }

            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(allotment)) {
                allotment = 0;
                $('#per_allotment').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the per allotment

        $('#per_allotment').keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }


            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            allotment_per = parseFloat($('#per_allotment').val());
            possession = parseFloat($('#possession').val());

            $('#allotment').val(percentage(net_amount, allotment_per));

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;


            num = $("#allotment").val();
            $("#allotment-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(allotment)) {
                allotment = 0;
                $('#allotment').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        $('#access_amount').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            access_amount = parseInt($(this).val())

            if (access_amount > 0) {
                $('#net_amount').val(net_amount + access_amount)
            } else {
                $('#net_amount').val($('#dummy_net_amount').val())
            }


            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            possession = parseInt($('#possession').val());
            $('#per_possession').val(((possession / net_amount) * 100).toFixed(2));
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;


            num = $("#possession").val();
            $("#possession-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            if (isNaN(booking)) {
                booking = 0;
                $('#per_booking').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });



        //update the possession

        $('#possession').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;
            // possession = parseInt($('#possession').val());
            if (isNaN(this.value) || this.value == "" || this.value == ' ') {
                $('#per_possession').val(0);
                possession = parseInt(0);
            } else {
                $('#per_possession').val(((possession / net_amount) * 100).toFixed(2));
                possession = parseInt($('#possession').val());
            }

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;


            num = $("#possession").val();
            $("#possession-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            if (isNaN(possession)) {
                possession = 0;
                $('#per_possession').val(0);

            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;

            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });




        // function percentage(num, per)
        // {
        //   return (num/100)*per;
        // }

        //update the per possession

        $('#per_possession').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());

            if (isNaN(this.value) || this.value == '' || this.value == " ") {
                possession_per = parseFloat(0);
                $('#possession').val(0);
            } else {
                possession_per = parseFloat($('#per_possession').val());
                $('#possession').val(percentage(net_amount, possession_per));
            }



            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;


            possession = parseFloat($('#possession').val());

            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = 0;

            num = $("#possession").val();
            $("#possession-label").text(number2TextConversion(num));

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            



            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(possession)) {
                possession = 0;
                $('#possession').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });


        $('#down-payment').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());
            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;

            monthly_installment = parseInt($('#total_installment').val());

            $('#per_down_payment').val(((down_payment / net_amount) * 100).toFixed(2));

            possession = parseInt($('#possession').val());

            num = $("#down-payment").val();
            $("#down-payment-label").text(number2TextConversion(num));


            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(down_payment)) {
                down_payment = 0;
                $('#per_down_payment').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });


        $('#per_down_payment').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());

            // possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            per_down_payment = parseFloat($('#per_down_payment').val());


            $('#down-payment').val(percentage(net_amount, per_down_payment));

            possession = parseFloat($('#possession').val());

            if ($('#down-payment').val())
                down_payment = parseInt($('#down-payment').val());
            else
                down_payment = 0;

            num = $("#down-payment").val();
            $("#down-payment-label").text(number2TextConversion(num));

            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
 if (isNaN(down_payment)) {
    down_payment = 0;
                $('#down-payment').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });

        // update per ballon
        $('#per_file_ballon').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());

            // possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            per_file_ballon = parseFloat($('#per_file_ballon').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#ballon').val(0);
            } else {
                $('#ballon').val(percentage(net_amount, per_file_ballon));

            }


            possession = parseFloat($('#possession').val());

            if ($('#ballon').val())
                ballon = parseInt($('#ballon').val());
            else
                ballon = 0;


            num = $("#ballon").val();
            $("#ballon-label").text(number2TextConversion(num));

            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            annual_installment = parseFloat(annual_installment);
            bullating = parseFloat($('#bulleting').val());
            down_payment = parseFloat($('#down-payment').val());
            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());
            development = parseFloat($('#development').val());
            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(ballon)) {
                ballon = 0;
                $('#ballon').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount ;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });


        //update ballon
        $('#ballon').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());
            if ($('#ballon').val())
                ballon = parseInt($('#ballon').val());
            else
                ballon = 0;

            monthly_installment = parseInt($('#total_installment').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_file_ballon').val(0);
            } else {
                $('#per_file_ballon').val(((ballon / net_amount) * 100).toFixed(2));
            }
            possession = parseInt($('#possession').val());

            num = $("#ballon").val();
            $("#ballon-label").text(number2TextConversion(num));


            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });

            down_payment = parseFloat($('#down-payment').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());
            development = parseFloat($('#development').val());
            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(ballon)) {
                ballon = 0;
                $('#per_file_ballon').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });

        // update per bullating
        $('#per_bulleting').keyup(function() {


            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());

            // possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            per_bulleting = parseFloat($('#per_bulleting').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#bulleting').val(0);
            } else {
                $('#bulleting').val(percentage(net_amount, per_bulleting));

            }


            possession = parseFloat($('#possession').val());

            if ($('#bulleting').val())
                bullating = parseInt($('#bulleting').val());
            else
                bullating = 0;


            num = $("#bulleting").val();
            $("#bullating-label").text(number2TextConversion(num));

            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }


            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            annual_installment = parseFloat(annual_installment);
            ballon = parseFloat($('#ballon').val());
            down_payment = parseFloat($('#down-payment').val());
            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());
            development = parseFloat($('#development').val());
            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(bullating)) {
                bullating = 0;
                $('#bulleting').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });

        //update bullating
        $('#bulleting').keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }
            net_amount = parseInt($('#net_amount').val());
            if ($('#bulleting').val())
                bullating = parseInt($('#bulleting').val());
            else
                bullating = 0;

            monthly_installment = parseInt($('#total_installment').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_bulleting').val(0);
            } else {
                $('#per_bulleting').val(((bullating / net_amount) * 100).toFixed(2));
            }
            possession = parseInt($('#possession').val());

            num = $("#bulleting").val();
            $("#bullating-label").text(number2TextConversion(num));


            annual_installment = 0;

            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            
  else if (val == <?php echo e(\App\CustomerProperty::inst_custom); ?>) {
                // monthly_installment = $('#custome_rem').val();
                monthly_installment =0;
            }
            var add_amount = 0;

            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            var cus_amount = 0;
            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }
            });
            

            down_payment = parseFloat($('#down-payment').val());
            ballon = parseFloat($('#ballon').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());
            development = parseFloat($('#development').val());
            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(bullating)) {
                bullating = 0;
                $('#per_bulleting').val(0);

            }

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating - cus_amount;


            $('#remaining_amount').val(remaining_amount);
            var radioValue = $("input[name='schedule_type']:checked").val();

            if (radioValue == '<?php echo e(\App\CustomerProperty::inst_custom); ?>') {
                remaining_amount = remaining_amount + parseInt($('#custome_rem').val())
            }
            $('#custome_rem').val(Math.round(remaining_amount));
        });




        //update the six installment fee label
        $("#annual-installment").keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }
            num = $("#annual-installment").val();
            $("#annual-installment-label").text(number2TextConversion(num));
            annual_ins = $("#annual-installment").val();

            count = $('#total_annual_installment_count').val();

            $('#total_annual_installment').val(Math.round(parseInt($("#annual-installment").val()) * count));

            num = $("#total_annual_installment").val();
            $("#total-annual-installment-label").text(number2TextConversion(num));




            net_amount = parseInt($('#net_amount').val());


            $('#per_total_annual_installment').val(((num / net_amount) * 100).toFixed(2));

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_annual-installment').val(0);
            } else {
                $('#per_annual-installment').val(((this.value / net_amount) * 100).toFixed(2));
            }

            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_annual_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(annual_installment)) {
                annual_installment = 0
            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));
        });

        // update total annaual installment
        $('#total_annual_installment').keyup(function() {

            price = $('#total_annual_installment').val();
            count = $('#total_annual_installment_count').val();

            $('#annual-installment').val(Math.round(price / count));
            if (isNaN(this.value)) {
                this.value = 0;
            }
            num1 = $("#annual-installment").val();
            $("#annual-installment-label").text(number2TextConversion(num1));
            annual_ins = $("#annual-installment").val();

            count = $('#total_annual_installment_count').val();


            num = $("#total_annual_installment").val();
            $("#total-annual-installment-label").text(number2TextConversion(num));




            net_amount = parseInt($('#net_amount').val());


            $('#per_total_annual_installment').val(((num / net_amount) * 100).toFixed(2));

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_annual-installment').val(0);
            } else {
                $('#per_annual-installment').val(((num1 / net_amount) * 100).toFixed(2));
            }


            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_annual_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(annual_installment)) {
                annual_installment = 0
            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));

            // $('#remaining_amount').val(0);

        });
        // update per annual
        $("#per_annual-installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());
            per_annual_installment = parseFloat($('#per_annual-installment').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#annual-installment').val(0);
            } else {
                $('#annual-installment').val(percentage(net_amount, per_annual_installment));

            }
            num = $("#annual-installment").val();
            $("#annual-installment-label").text(number2TextConversion(num));
            annual_ins = $("#annual-installment").val();

            count = $('#total_annual_installment_count').val();

            $('#total_annual_installment').val(Math.round(parseInt($("#annual-installment").val()) * count));

            num = $("#total_annual_installment").val();
            $("#total-annual-installment-label").text(number2TextConversion(num));
            $('#per_total_annual_installment').val(((num / net_amount) * 100).toFixed(2));
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_annual_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(annual_installment)) {
                annual_installment = 0
            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));

        });


        //update per total anual installemnt
        $("#per_total_annual_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }

            net_amount = parseInt($('#net_amount').val());
            per_total_annual_installment = parseFloat($('#per_total_annual_installment').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#total_annual_installment').val(0);
            } else {
                $('#total_annual_installment').val(percentage(net_amount, per_total_annual_installment));
                $('#annual-installment').val(Math.round(parseInt($("#total_annual_installment").val() / parseInt($(
                    '#total_annual_installment_count').val()))));


            }
            num = $("#annual-installment").val();
            $("#annual-installment-label").text(number2TextConversion(num));
            annual_ins = $("#annual-installment").val();



            num = $("#total_annual_installment").val();
            $("#total_installment").text(number2TextConversion(num));

















            // count = $('#total_annual_installment_count').val();

            // $('#total_annual_installment').val(Math.round(parseInt($("#annual-installment").val()) * count));

            num = $("#total_annual_installment").val();
            $("#total-annual-installment-label").text(number2TextConversion(num));

            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_annual_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());
            if (isNaN(annual_installment)) {
                annual_installment = 0
            }
            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));

        });





        $('#total_annual_installment_count').keyup(function() {

            price = $('#net_amount').val();
            count = $('#total_annual_installment_count').val();

            $('#annual-installment').val(Math.round($('#total_annual_installment').val() / count));

            //$('#annual-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

        });



        //update the semi installment fee label
        $("#semi-installment").keyup(function() {

            if (isNaN(this.value)) {
                this.value = 0;
            }
            num = $("#semi-installment").val();
            $("#semi-installment-label").text(number2TextConversion(num));

            count = $('#total_semi_installment_count').val();
            $('#total_semi_installment').val(Math.round(parseInt($("#semi-installment").val()) * count));

            num = $("#total_semi_installment").val();
            $("#total-semi-installment-label").text(number2TextConversion(num));


            net_amount = parseInt($('#net_amount').val());


            $('#per_total_semi_installment').val(((num / net_amount) * 100).toFixed(2));

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_semi_installment').val(0);
            } else {
                $('#per_semi_installment').val(((this.value / net_amount) * 100).toFixed(2));
            }


            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_semi_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));

        });

        //update the quarterly installment fee label
        $("#bi-mon-installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            num = $("#bi-mon-installment").val();
            $("#bi-mon-installment-label").text(number2TextConversion(num));

            count = $('#total_bi_mon_installment_count').val();
            $('#total_bi_mon_installment').val(Math.round(parseInt($("#bi-mon-installment").val()) * count));

            num = $("#total_bi_mon_installment").val();
            $("#total-bi-mon-installment-label").text(number2TextConversion(num));

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_bi_mon_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));

        });





        //update the quarterly installment fee label
        $("#quarterly-installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            num = $("#quarterly-installment").val();
            $("#quarterly-installment-label").text(number2TextConversion(num));

            count = $('#total_quarterly_installment_count').val();
            $('#total_quarterly_installment').val(Math.round(parseInt($("#quarterly-installment").val()) * count));

            num = $("#total_quarterly_installment").val();
            $("#total-quarterly-installment-label").text(number2TextConversion(num));

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            annual_installment = parseInt($('#total_quarterly_installment').val());

            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());


            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;

            $('#remaining_amount').val(Math.round(remaining_amount));

        });



        //update the quarterly installment fee label
        $("#total_quarterly_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {

                $('#quarterly-installment').val(0);

                $('#remaining_amount').val(Math.round(0));
            } else {
                per_inst = parseInt($('#total_quarterly_installment').val()) / parseInt($(
                    '#total_quarterly_installment_count').val());

                $('#quarterly-installment').val(Math.round(per_inst));

                $('#remaining_amount').val(Math.round(0));
            }

        });

        //update the installment label
        $("#installment").keyup(function() {
            num1 = $("#installment").val();

            $("#installment-label").text(number2TextConversion(num1));

            $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months')
                .val())));

            num = $("#total_installment").val();
            $("#total-installment-label").text(number2TextConversion(num));

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());


            $('#per_installment').val(((num1 / net_amount) * 100).toFixed(2));

            $('#per_total_installment').val(Math.round(parseFloat($("#per_installment").val()) * parseFloat($(
                '#total-months').val())))

            annual_installment = 0;
            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }
            });

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));

        });


        $("#per_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            num1 = $("#installment").val();
            $("#installment-label").text(number2TextConversion(num1));

            $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months')
                .val())));

            num = $("#total_installment").val();
            $("#total-installment-label").text(number2TextConversion(num));

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());


            $('#installment').val(percentage(net_amount, $('#per_installment').val()));
            $('#per_total_installment').val(Math.round(parseFloat($("#per_installment").val()) * parseFloat($(
                '#total-months').val())))

            annual_installment = 0;
            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }
            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));

        });

        //update the total months label
        $("#total-months").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#installment').val(0);



                $('#per_installment').val(0);
            } else {


                $('#installment').val(Math.round(parseInt($("#total_installment").val() / parseInt($(
                    '#total-months').val()))));

                num = $("#installment").val();
                $("#installment-label").text(number2TextConversion(num));

                $('#per_installment').val(((num / net_amount) * 100).toFixed(2));
            }

        });
        //update the total months label
        // $("#total-months").keyup(function(){

        //         num = $("#installment").val();
        //         $("#installment-label").text(number2TextConversion(num));

        //         $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months').val())));

        //         num = $("#total_installment").val();
        //         $("#total-installment-label").text(number2TextConversion(num));

        // });


        // update total installments 
        $("#total_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            num1 = $("#total_installment").val();
            $("#total-installment-label").text(number2TextConversion(num1));



            net_amount = parseInt($('#net_amount').val());


            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#per_total_installment').val(0);
                $('#installment').val(0);
            } else {
                $('#per_total_installment').val(((this.value / net_amount) * 100).toFixed(2));
                $('#installment').val(Math.round(parseInt($("#total_installment").val() / parseInt($(
                    '#total-months').val()))));

                num = $("#installment").val();
                $("#installment-label").text(number2TextConversion(num));
            }


            // $('#installment').val(percentage(net_amount ,  $('#per_installment').val() ));





            annual_installment = 0;
            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }
            });

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));

        });


        // update per_total_installment

        $("#per_total_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }


            net_amount = parseInt($('#net_amount').val());



            per_total = parseFloat($('#per_total_installment').val());

            if (isNaN(this.value) || this.value == '' || this.value == ' ' || this.value == 0) {
                $('#total_installment').val(0);
            } else {
                $('#total_installment').val(percentage(net_amount, per_total));
                $('#installment').val(Math.round(parseInt($("#total_installment").val() / parseInt($(
                    '#total-months').val()))));

            }



            num = $("#total_installment").val();
            $("#total_installment").text(number2TextConversion(num));








            num1 = $("#installment").val();
            $("#installment-label").text(number2TextConversion(num1));


            num = $("#total_installment").val();
            $("#total-installment-label").text(number2TextConversion(num));














            annual_installment = 0;
            val = parseInt($('input[name="schedule_type"]:checked').val());
            if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                annual_installment = $('#total_annual_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {
                annual_installment = $('#total_quarterly_installment').val();
            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar_w_semi); ?>) {
                annual_installment = $('#total_semi_installment').val();
            }
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value) {
                    add_amount += 0;
                } else {
                    add_amount += parseInt($(this).val());
                }
            });

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));

        });









        //update the total months label
        $("#total_semi_installment").keyup(function() {
            if (isNaN(this.value)) {
                this.value = 0;
            }
            price = $("#total_semi_installment").val();
            count = $("#total_semi_installment_count").val();


            $('#semi-installment').val((Math.round(price / count)));


            num = $("#semi-installment").val();
            $("#semi-installment-label").text(number2TextConversion(num));

            // count = $('#total_semi_installment_count').val();
            // $('#total_semi_installment').val(Math.round(parseInt($("#semi-installment").val()) * count));

            num = $("#total_semi_installment").val();
            $("#total-semi-installment-label").text(number2TextConversion(num));


            net_amount = parseInt($('#net_amount').val());


            $('#per_total_semi_installment').val(((num / net_amount) * 100).toFixed(2));




            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            if (isNaN(this.value) || this.value == '' || this.value == ' ') {

                annual_installment = 0;
            } else {

                annual_installment = parseInt($('#total_semi_installment').val());
            }

            monthly_installment = parseInt($('#total_installment').val());
            var add_amount = 0;
            $("input[name='add_amount[]']").each(function() {
                if (!this.value)
                    add_amount += 0;
                else
                    add_amount += parseInt($(this).val());

            });
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                add_amount - allotment - confirmation - booking - file_processing - registration - ballon -
                bullating;


            $('#remaining_amount').val(Math.round(remaining_amount));














            // $("#remaining_amount").val(0);

        });



        function updateCurrency() {


            //update the cost label

            num = $("#total-amount").val();

            $("#total-amount-label").text(number2TextConversion(num));

            //update the net amount
            num = $("#net_amount").val();

            $("#net_amount-label").text(number2TextConversion(num));


            //update the down payemnt label
            num = $("#down-payment").val();

            $("#down-payment-label").text(number2TextConversion(num));


            //update the annual installment text
            num = $("#annual-installment").val();


            $("#annual-installment-label").text(number2TextConversion(num));


            //update the total annual installment text
            num = $("#total_annual_installment").val();

            $("#total-annual-installment-label").text(number2TextConversion(num));

            //update the semi installment text
            num = $("#semi-installment").val();

            $("#semi-installment-label").text(number2TextConversion(num));


            // //update the total semi installment
            num = $("#total_semi_installment").val();

            $("#total-semi-installment-label").text(number2TextConversion(num));

            //     //upte the quarterly installment text
            num = $("#bi-mon-installment").val();

            $("#bi-mon-installment-label").text(number2TextConversion(num));

            // //upte the quarterly installment text
            num = $("#quarterly-installment").val();

            $("#quarterly-installment-label").text(number2TextConversion(num));

            //     //update the total quarterly installment
            num = $("#total_bi_mon_installment").val();

            $("#total-bi-mon-installment-label").text(number2TextConversion(num));


            // //update the total quarterly installment
            num = $("#total_quarterly_installment").val();

            $("#total-quarterly-installment-label").text(number2TextConversion(num));

            // //update the installment label

            num = $("#installment").val();

            $("#installment-label").text(number2TextConversion(num));

            // //update the total_installment
            num = $("#total_installment").val();

            $("#total-installment-label").text(number2TextConversion(num));


            //     //update the possession
            num = $("#possession").val();

            $("#possession-label").text(number2TextConversion(num));
            //      //update the Allotment 
            num = $("#allotment").val();

            $("#allotment-label").text(number2TextConversion(num));
            //        //update the Confirmation 
            num = $("#confirmation").val();

            $("#confirmation-label").text(number2TextConversion(num));

            //      //update the Booking  
            num = $("#booking").val();

            $("#booking-label").text(number2TextConversion(num));
            //update the Booking  

            // //update the file_processing  
            num = $("#file_processing").val();

            $("#file_processing-label").text(number2TextConversion(num));
            // //update the registration  
            // num=$("#registration").val();

            $("#registration-label").text(number2TextConversion(num));
            // //update the registration  
            num = $("#ballon").val();

            $("#ballon-label").text(number2TextConversion(num));

            // //update the bulleting  
            num = $("#bulleting").val();

            $("#bullating-label").text(number2TextConversion(num));


        }


        //update the unit number dropdown when category change
        // $('#customer').change(function() {
        //     $('.preloader').fadeIn();
        //         var data = { 'customer': $(this).val() };

        //         $.get('/getUnitsByCustomer', data, function (data) {
        //            var model = $('#unit_number');
        //                     model.empty();

        //                      model.append("<option value='' disabled selected>" + '' + "</option>");


        //                     $.each(data, function(index, element) {
        //                         model.append("<option value='"+ element.inventory.id +"'>" + element.inventory.unit_number + "</option>");
        //                     });
        //         });
        //          $('.preloader').fadeOut();
        //     });

        //update the unit information when unit number change

        $('#addUnitDetail').on('change', '#unit_number', function() {

            $('.preloader').fadeIn();

            let data_id = $('#unit_number').data('id');
            var data = {
                'unit_number': $(this).val(),
                'data_id': data_id
            };



            $.get('/getInformationByUnit', data, function(data) {

                if (data) {
                    let inventId = $('#invent_id');
                    if (data.info.inventory_type == 1) {
                        $('#category_col').show();
                        $("#allocated_category").hide();
                        inventId.val('Unallocated Unit');




                    } else {
                        $('#category_col').hide();
                        $("#allocated_category").show();
                        inventId.val('Allocated Unit');


                    }

                    $('#total-amount').val(data.info.total_price - data.info.extra_amount);
                    $('#net_amount').val(data.info.total_price);
                    $('#dummy_net_amount').val(data.info.total_price)
                    $('#extra_charges').val(data.info.extra_amount);




                    $('#size').val((data.info.size) ? data.info.size.name : '' + ' <?php echo e(env('SIZE')); ?>');
                    $('#inventory-id').val(data.info.id);
                    $('#description').val(data.info.description);
                    name = '';
                    for (i = 0; i < data.info.categories.length; i++) {
                        name += data.info.categories[i].category.name + ', ';
                    }

                    $('#category').val(name);
                    //$('#category').val(data.info.category.name);
                    $("#inventory_type #type").val(data.info.type.name);


                    $('#down_payment_per').val(data.schedule.down_payment);
                    $('#possession_per').val(data.schedule.possession);

                    $('#per_allotment').val(data.schedule.allotment);
                    $('#per_confirmation').val(data.schedule.confirmation);


                    $('#per_booking').val(data.schedule.booking);
                    $('#per_development').val(data.schedule.development);


                    $('#per_file_processing').val(data.schedule.file_processing);
                    $('#per_registration').val(data.schedule.registration);

                    $('#per_file_ballon').val(data.schedule.ballon);
                    $('#per_bulleting').val(data.schedule.bulleting);

                    $('#semi_installment_hid_per').val(data.schedule.semi_installment);




                    $('#annual_installment_per').val(data.schedule.annual_installment);
                    $('#monthly_installment_per').val(data.schedule.monthly_installment);
                    $('#total_month_per').val(data.schedule.total_months);
                    $('#total_annual_installment_count').val(Math.round(data.schedule.total_months / 12));
                    $('#total_semi_installment_count').val(Math.round(data.schedule.total_months / 6));
                    $('#total_quarterly_installment_count').val(Math.round(data.schedule.total_months / 3));
                    $('#total_bi_mon_installment_count').val(Math.round(data.schedule.total_months / 3));


                    $('#ballon').val(Math.round((parseInt(data.schedule.ballon) / 100 * data.info
                        .total_price)));

                    $('#bulleting').val(Math.round((parseInt(data.schedule.bulleting) / 100 * data.info
                        .total_price)));


                    $('#semi_installment_hid_amount').val((parseInt(data.schedule.semi_installment) / 100 *
                        data.info.total_price));
                    $('#down-payment').val(Math.round((parseInt(data.schedule.down_payment) / 100 * data
                        .info.total_price)));
                    $('#down_payment_dis').val(Math.round((parseInt(data.schedule.down_payment) / 100 * data
                        .info.total_price)));
                    $('#possession').val(Math.round((parseInt(data.schedule.possession) / 100 * data.info
                        .total_price)));
                    $('#possession1').val(Math.round((parseInt(data.schedule.possession) / 100 * data.info
                        .total_price)));

                    $('#allotment').val(Math.round((parseInt(data.schedule.allotment) / 100 * data.info
                        .total_price)));

                    $('#confirmation').val(Math.round((parseInt(data.schedule.confirmation) / 100 * data
                        .info.total_price)));



                    $('#booking').val(Math.round((parseInt(data.schedule.booking) / 100 * data.info
                        .total_price)));

                    $('#development').val(Math.round((parseInt(data.schedule.development) / 100 * data.info
                        .total_price)));



                    $('#file_processing').val(Math.round((parseInt(data.schedule.file_processing) / 100 *
                        data.info.total_price)));

                    $('#registration').val(Math.round((parseInt(data.schedule.registration) / 100 * data
                        .info.total_price)));


                    $('#annual-installment').val(Math.round(data.schedule.annual_installment / 100 * data
                        .info.total_price / (data.schedule.total_months / 12)));
                    $('#total-months').val(Math.round(data.schedule.total_months));

                    $('#total_annual_installment').val(Math.round(data.schedule.annual_installment / 100 *
                        data.info.total_price));

                    $('#installment').val(Math.round(data.schedule.monthly_installment / 100 * data.info
                        .total_price / (data.schedule.total_months)));


                    $('#total_installment').val(Math.round(data.schedule.monthly_installment / 100 * data
                        .info.total_price));

                    manToPer();
                    //  updateCurrency();

                    //Full Payment
                    $('#total_amount_full_payment').val(data.info.total_price);

                    net_amount = parseInt($('#net_amount').val());
                    down_payment = parseInt($('#down-payment').val());
                    possession = parseInt($('#possession').val());
                    monthly_installment = parseInt($('#total_installment').val());
                    annual_installment = parseInt($('#total_annual_installment').val());


                    ballon = parseInt($('#ballon').val());
                    bullating = parseInt($('#bulleting').val());
                    allotment = parseInt($('#allotment').val());
                    confirmation = parseInt($('#confirmation').val());
                    booking = parseInt($('#booking').val());

                    file_processing = parseInt($('#file_processing').val());
                    registration = parseInt($('#registration').val());


                    remaining_amount = net_amount - down_payment - possession - monthly_installment -
                        annual_installment - allotment - confirmation - booking - file_processing -
                        registration - ballon - bullating;

                    $('#remaining_amount').val(Math.round(remaining_amount));

                    //set the rebate 
                    $('#rebate_in_percentage').val(Math.round(5));

                    $('#rebate_in_amount').val(Math.round((data.info.total_price) * 0.05));

                    $('#sqrt').html((data.info.size) ? data.info.size.name : '');
                    vl = (data.info.size) ? data.info.size.name : '';
                    $('#per_sqrt_value').val(net_amount / vl);




                    let data_id = $('#unit_number').data('id');

                    if (data_id == 1) {
                        $('#total_rebate1').val(data.dealer_rebate);


                        $('#dealer_id').val(data.dealer_id);
                        $("#total_rebate1").attr('readonly', 'readonly');
                        //   $('#total_rebate1').attr("disabled","disabled") 
                        // $('#dealer_id').attr("disabled","disabled") 
                        $('#dealer_id option:not(:selected)').prop('disabled', true);
                    }
                }
            });

            // $('#amount_schedule').click()
            $('.preloader').fadeOut();
        });



        // $('#unit_number').change(function() {

        //     $('.preloader').fadeIn();
        //         var data = { 'unit_number': $(this).val() };

        //         $.get('/getInformationByUnit', data, function (data) {
        //             if(data) {
        //             $('#total-amount').val(data.info.total_price - data.info.extra_amount);
        //             $('#net_amount').val(data.info.total_price);



        //            $('#dummy_net_amount').val(data.info.total_price)

        //             $('#extra_charges').val(data.info.extra_amount);

        //             $('#size').val(data.info.size.name  + ' <?php echo e(env('SIZE')); ?>');
        //             $('#inventory-id').val(data.info.id);
        //             $('#description').val(data.info.description);

        //              name = '';
        //              for( i = 0 ; i<data.info.categories.length ; i++)
        //              {
        //                 name += data.info.categories[i].category.name + ', ';
        //              }

        //             $('#category').val(name);
        //             //$('#category').val(data.info.category.name);
        //             $("#inventory_type #type").val(data.info.type.name);


        //              $('#down_payment_per').val(data.schedule.down_payment);
        //              $('#possession_per').val(data.schedule.possession);

        //              $('#per_allotment').val(data.schedule.allotment);
        //              $('#per_confirmation').val(data.schedule.confirmation);


        //              $('#per_booking').val(data.schedule.booking);
        //              $('#per_development').val(data.schedule.development);


        //              $('#per_file_processing').val(data.schedule.file_processing);
        //              $('#per_registration').val(data.schedule.registration);



        //              $('#annual_installment_per').val(data.schedule.annual_installment);
        //              $('#monthly_installment_per').val(data.schedule.monthly_installment);
        //              $('#total_month_per').val(data.schedule.total_months);
        //              $('#total_annual_installment_count').val( Math.round(data.schedule.total_months / 12));
        //                $('#total_semi_installment_count').val( Math.round(data.schedule.total_months / 6));
        //                $('#total_quarterly_installment_count').val( Math.round(data.schedule.total_months / 3));
        //                $('#total_bi_mon_installment_count').val( Math.round(data.schedule.total_months / 3));


        //                $('#down-payment').val( Math.round((parseInt(data.schedule.down_payment) / 100 * data.info.total_price )));
        //                $('#down_payment_dis').val(Math.round((parseInt(data.schedule.down_payment) / 100 * data.info.total_price )));
        //                $('#possession').val( Math.round((parseInt(data.schedule.possession) / 100 * data.info.total_price )));
        //                $('#possession1').val( Math.round((parseInt(data.schedule.possession) / 100 * data.info.total_price )));

        //                $('#allotment').val( Math.round((parseInt(data.schedule.allotment) / 100 * data.info.total_price )));

        //                $('#confirmation').val( Math.round((parseInt(data.schedule.confirmation) / 100 * data.info.total_price )));



        //                $('#booking').val( Math.round((parseInt(data.schedule.booking) / 100 * data.info.total_price )));

        //                $('#development').val( Math.round((parseInt(data.schedule.development) / 100 * data.info.total_price )));



        //                $('#file_processing').val( Math.round((parseInt(data.schedule.file_processing) / 100 * data.info.total_price )));

        //                $('#registration').val( Math.round((parseInt(data.schedule.registration) / 100 * data.info.total_price )));


        //                 $('#annual-installment').val( Math.round(data.schedule.annual_installment / 100 * data.info.total_price / (data.schedule.total_months / 12)));
        //                $('#total-months').val( Math.round(data.schedule.total_months));

        //                $('#total_annual_installment').val( Math.round(data.schedule.annual_installment / 100 * data.info.total_price));

        //              $('#installment').val( Math.round(data.schedule.monthly_installment / 100 * data.info.total_price / (data.schedule.total_months)));


        //                $('#total_installment').val( Math.round(data.schedule.monthly_installment / 100 * data.info.total_price));

        //                manToPer() 
        //                updateCurrency();

        //                //Full Payment
        //                $('#total_amount_full_payment').val(data.info.total_price);

        //                net_amount = parseInt($('#net_amount').val());
        //                down_payment = parseInt($('#down-payment').val());
        //                possession = parseInt($('#possession').val());
        //                monthly_installment = parseInt($('#total_installment').val());
        //                annual_installment = parseInt($('#total_annual_installment').val());


        //                allotment = parseInt($('#allotment').val());
        //                confirmation = parseInt($('#confirmation').val());
        //                booking = parseInt($('#booking').val());
        //                
        //                file_processing = parseInt($('#file_processing').val());
        //                registration = parseInt($('#registration').val());


        //                remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment - allotment - confirmation - booking  - file_processing - registration;

        //                $('#remaining_amount').val(Math.round(remaining_amount));

        //                //set the rebate 
        //                $('#rebate_in_percentage').val(Math.round(5));

        //                $('#rebate_in_amount').val(Math.round((data.info.total_price ) * 0.05));

        //                $('#sqrt').html(data.info.size.name);
        //                $('#per_sqrt_value').val(net_amount/data.info.size.name);
        //             }
        //         });

        //         // $('#amount_schedule').click()
        //          $('.preloader').fadeOut();
        // });

        $('#rebate_in_amount').keyup(function() {

            amount = $('#rebate_in_amount').val();
            percentage = $('#rebate_in_percentage').val();
            total_value = $('#net_amount').val();

            $('#rebate_in_percentage').val(Math.round((amount / total_value) * 100));

        });

        $('#rebate_in_percentage').keyup(function() {

            amount = $('#rebate_in_amount').val();
            percentage = $('#rebate_in_percentage').val();
            total_value = $('#net_amount').val();

            $('#rebate_in_amount').val(Math.round((total_value) * (percentage / 100)));

        });

        $(document).on('keyup', '.total_rebate', function() {



            var id = document.getElementsByClassName('total_rebate');
            var rebate = $('#rebate_in_amount').val();

            given_rebate = 0;

            for (i = 0; i < id.length; i++) {

                given_rebate += parseFloat(id[i].value);
            }

            $('#remaining_amount_in_rebate').val(rebate - given_rebate);

        });


        function manToPer() {
            cost = $('#net_amount').val();
            if (cost) {

                down_payment = $('#down-payment').val();
                if (down_payment) {
                    $('#per_down_payment').val(((down_payment / cost) * 100).toFixed(2));

                }
                possession = $('#possession').val();
                if (possession) {
                    $('#per_possession').val(((possession / cost) * 100).toFixed(2));

                }

                // annual_installment = $('#annual-installment').val();
                // if(annual_installment) {
                //     $('#annual-installment').val( ((annual_installment / cost) * 100).toFixed(2));

                // }


                // total_annual_installment = $('#total_annual_installment').val();
                // if(total_annual_installment) {
                //     $('#total_annual_installment').val( ((total_annual_installment / cost) * 100).toFixed(2));

                // }

                total_months = $('#total-months').val();
                if (total_months) {
                    installment = $('#installment').val();
                    if (installment) {
                        $('#per_installment').val((((installment) / cost) * 100).toFixed(2));

                    }
                    total_installment = $('#total_installment').val();
                    if (total_installment) {
                        $('#per_total_installment').val((((total_installment) / cost) * 100).toFixed(2));

                    }
                }
                updateCurrency();

            }
        }

        function perToMan() {
            cost = $('#net_amount').val();
            if (cost) {

                down_payment = $('#down-payment').val();
                if (down_payment) {
                    $('#down-payment').val(((down_payment * cost) / 100).toFixed(0));

                }
                possession = $('#possession').val();
                if (possession) {
                    $('#possession').val(((possession * cost) / 100).toFixed(0));

                }


                annual_installment = $('#annual-installment').val();
                if (annual_installment) {
                    $('#annual-installment').val(((annual_installment * cost) / 100).toFixed(0));

                }
                total_annual_installment = $('#total_annual_installment').val();
                if (total_annual_installment) {
                    $('#total_annual_installment').val(((total_annual_installment * cost) / 100).toFixed(0));

                }
                total_months = $('#total-months').val();
                if (total_months) {
                    installment = $('#installment').val();
                    if (installment) {
                        $('#installment').val(((installment * cost) / 100).toFixed(0));

                        total_installment = $('#total_installment').val();
                        if (total_installment) {
                            $('#total_installment').val(((total_installment * cost) / 100).toFixed(0));

                        }
                    }
                }
                updateCurrency();

            }
        }


        $('#discount_s').keyup(function() {

            if ($('#discount_s').val()) {

                discount = 0;
                if ($('#discount_percent').prop("checked") == false) {
                    price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()) -
                        parseFloat($('#discount_s').val()));
                    discount = parseFloat($('#discount_s').val());
                } else {
                    price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()) -
                        parseFloat($('#discount_s').val()) / 100 * (parseInt($('#total-amount').val()) +
                            parseInt($('#extra_charges').val())));
                    discount = parseFloat($('#discount_s').val()) / 100 * (parseInt($('#total-amount').val()) +
                        parseInt($('#extra_charges').val()));
                }


                $('#net_amount').val(price);
                var total_value = price / $('#sqrt').text()

                $('#per_sqrt_value').val(total_value.toFixed(1));

                $('#down-payment').val(Math.round(($('#down_payment_per').val() / 100) * price));
                $('#possession1').val(Math.round(($('#possession_per').val() / 100) * price));
                $('#possession').val(Math.round(($('#possession_per').val() / 100) * price));

                disableAnn(1);

                //  $('#down-payment').val( Math.round($('#down_payment_dis').val() -  discount));

                updateCurrency();
            } else {
                price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()));

                $('#net_amount').val(price);

                //  $('#down-payment').val( Math.round($('#down_payment_dis').val()));



                $('#down-payment').val(Math.round(($('down_payment_per').val() / 100) * price));
                $('#possession1').val(Math.round(($('#possession_per').val() / 100) * price));
                $('#possession').val(Math.round(($('#possession_per').val() / 100) * price));

                disableAnn(1);

                updateCurrency();

            }




            amount = $('#rebate_in_amount').val();
            percentage = $('#rebate_in_percentage').val();
            total_value = $('#net_amount').val();

            $('#rebate_in_percentage').val(Math.round((amount / total_value) * 100));

            $('#rebate_in_amount').val(Math.round((total_value) * (percentage / 100)));


        });

        function percentCheckbox() {

            if ($('#discount_percent').prop("checked") == false) {
                document.getElementById('dis_input').innerHTML = 'PKR';
            } else {
                document.getElementById('dis_input').innerHTML = '%';
            }

            if ($('#discount_s').val()) {
                discount = 0;
                if ($('#discount_percent').prop("checked") == false) {
                    price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()) -
                        parseFloat($('#discount_s').val()));
                    discount = parseFloat($('#discount_s').val());
                } else {
                    price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()) -
                        parseFloat($('#discount_s').val()) / 100 * (parseInt($('#total-amount').val()) + parseInt($(
                            '#extra_charges').val())));
                    discount = parseFloat($('#discount_s').val()) / 100 * (parseInt($('#total-amount').val()) + parseInt($(
                        '#extra_charges').val()));
                }

                $('#net_amount').val(price);

                $('#down-payment').val(Math.round($('#down_payment_dis').val() - discount));
                updateCurrency();
            } else {
                price = Math.round(parseInt($('#total-amount').val()) + parseInt($('#extra_charges').val()));

                $('#net_amount').val(price);

                $('#down-payment').val(Math.round($('#down_payment_dis').val()));

                updateCurrency();

            }

            $('#discount_s').keyup()

            updateCurrency();


        }


        function enableAnn() {
            makeInstallmentZero();
            document.getElementById('custom').style.display = 'none';
            document.getElementById('auto').style.display = 'block';

            $('#remaining_amount').val(0);
            document.getElementById('ann_div').style.display = 'block';
            document.getElementById('semi_div').style.display = 'none';
            document.getElementById('quar_div').style.display = 'none';
            document.getElementById('bi_mon_div').style.display = 'none';

            price = parseInt($('#net_amount').val());
            count = $('#total_annual_installment_count').val();

            $('#installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($(
                '#total_month_per').val()))));

            $('#total_installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));
            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());
            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            annual_installment = parseInt($('#total_annual_installment').val());

            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                allotment - confirmation - booking - file_processing - registration - ballon - bullating;





            // $('#annual-installment').val( Math.round(remaining_amount / count)).trigger("keyup");
            // $('#total-months').val( Math.round(parseInt($('#total_month_per').val()))).trigger("keyup");;
            $('#total_annual_installment').val(Math.round(remaining_amount)).trigger("keyup");;


        }


        // function enableAnn() {

        //     document.getElementById('custom').style.display = 'none';
        //     document.getElementById('auto').style.display = 'block';

        //     $('#remaining_amount').val(0);
        //     document.getElementById('ann_div').style.display = 'block';
        //     document.getElementById('semi_div').style.display = 'none';
        //     document.getElementById('quar_div').style.display = 'none';
        //     document.getElementById('bi_mon_div').style.display = 'none';

        //     price = parseInt($('#net_amount').val());
        //     count = $('#total_annual_installment_count').val();

        //      $('#installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($('#total_month_per').val()))));

        //     $('#total_installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

        //     ballon=  parseFloat($('#ballon').val());
        //     bullating=   parseFloat($('#bulleting').val());
        //     net_amount = parseInt($('#net_amount').val());
        //     down_payment = parseInt($('#down-payment').val());
        //     possession = parseInt($('#possession').val());
        //     monthly_installment = parseInt($('#total_installment').val());

        //     annual_installment = parseInt($('#total_annual_installment').val());

        //     allotment = parseInt($('#allotment').val());
        //     confirmation = parseInt($('#confirmation').val());
        //     booking = parseInt($('#booking').val());

        //     file_processing = parseInt($('#file_processing').val());
        //     registration = parseInt($('#registration').val());


        //     remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment - allotment - confirmation - booking  - file_processing - registration - ballon - bullating;


        //     $('#annual-installment').val( Math.round(remaining_amount / count));
        //     $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));

        //     $('#total_annual_installment').val( Math.round(remaining_amount));

        // }

        function enableBiMonth() {
            makeInstallmentZero();
            document.getElementById('custom').style.display = 'none';
            document.getElementById('auto').style.display = 'block';

            $('#remaining_amount').val(0);
            document.getElementById('bi_mon_div').style.display = 'block';
            document.getElementById('quar_div').style.display = 'none';

            document.getElementById('semi_div').style.display = 'none';
            document.getElementById('ann_div').style.display = 'none';

            price = $('#net_amount').val();
            count = $('#total_bi_mon_installment_count').val();

            $('#installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($(
                '#total_month_per').val()))));

            $('#total_installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());
            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            annual_installment = parseInt($('#total_annual_installment').val());

            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                allotment - confirmation - booking - file_processing - registration - ballon - bullating;


               

            $('#bi-mon-installment').val(Math.round(remaining_amount / count));
            $('#total-months').val(Math.round(parseInt($('#total_month_per').val())));

            $('#total_bi_mon_installment').val(Math.round(remaining_amount));

        }

        function enableQuar() {

            makeInstallmentZero();
            document.getElementById('custom').style.display = 'none';
            document.getElementById('auto').style.display = 'block';

            $('#remaining_amount').val(0);
            document.getElementById('quar_div').style.display = 'block';
            document.getElementById('bi_mon_div').style.display = 'none';
            document.getElementById('semi_div').style.display = 'none';
            document.getElementById('ann_div').style.display = 'none';

            price = $('#net_amount').val();
            count = $('#total_quarterly_installment_count').val();

            $('#installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($(
                '#total_month_per').val()))));

            $('#total_installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            monthly_installment = parseInt($('#total_installment').val());

            annual_installment = parseInt($('#total_annual_installment').val());

            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());


            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                allotment - confirmation - booking - file_processing - registration - ballon - bullating;

            $('#quarterly-installment').val(Math.round(remaining_amount / count));
            $('#total-months').val(Math.round(parseInt($('#total_month_per').val())));

            $('#total_quarterly_installment').val(Math.round(remaining_amount));

        }

        function enableSemi() {
            makeInstallmentZero();
            document.getElementById('custom').style.display = 'none';
            document.getElementById('auto').style.display = 'block';


            document.getElementById('semi_div').style.display = 'block';
            document.getElementById('ann_div').style.display = 'none';
            document.getElementById('quar_div').style.display = 'none';
            document.getElementById('bi_mon_div').style.display = 'none';

            price = $('#net_amount').val();
            count = $('#total_semi_installment_count').val();

            $('#installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($(
                '#total_month_per').val()))));

            $('#total_installment').val(Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());

            monthly_installment = parseInt($('#total_installment').val());

            annual_installment = parseInt($('#total_annual_installment').val());

            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());

            semi_install_per = parseInt($('#semi_installment_hid_per').val());
            semi_install_amount = parseInt($('#semi_installment_hid_amount').val());
            $('#total_semi_installment').val(Math.round(semi_install_amount));
            $('#per_total_semi_installment').val(Math.round(semi_install_per));


            $('#semi-installment').val(Math.round(semi_install_per / 100 * net_amount / (count)));
            $('#per_semi_installment').val(((parseInt($('#semi-installment').val()) / net_amount) * 100).toFixed(2));

            remaining_amount = net_amount - down_payment - possession - monthly_installment - annual_installment -
                allotment - confirmation - booking - file_processing - registration - ballon - bullating -
                semi_install_amount;

            $('#remaining_amount').val(remaining_amount);



            //  $('#semi-installment').val( Math.round(remaining_amount / count));
            // $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));

            // $('#total_semi_installment').val( Math.round(remaining_amount));

        }

        function disableAnn(val) {
            makeInstallmentZero();
            document.getElementById('custom').style.display = 'none';
            document.getElementById('auto').style.display = 'block';

            $('#remaining_amount').val(0);
            document.getElementById('semi_div').style.display = 'none';
            document.getElementById('ann_div').style.display = 'none';
            document.getElementById('quar_div').style.display = 'none';
            document.getElementById('bi_mon_div').style.display = 'none';
            price = $('#net_amount').val();

            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            allotment = parseFloat($('#allotment').val());
            confirmation = parseFloat($('#confirmation').val());
            booking = parseFloat($('#booking').val());

            file_processing = parseFloat($('#file_processing').val());
            registration = parseFloat($('#registration').val());

            remaining_amount = net_amount - down_payment - possession - allotment - confirmation - booking -
                file_processing - registration - ballon - bullating;



            if (val == <?php echo e(\App\CustomerProperty::inst_mon); ?>) {

                $('#total_installment').val(Math.round(remaining_amount));

                $('#installment').val(Math.round((remaining_amount) / parseInt($('#total_month_per').val())));

                $('#total-months').val(Math.round(parseInt($('#total_month_per').val())));
            } else if (val == <?php echo e(\App\CustomerProperty::inst_bi_mon); ?>) {

                $('#total_installment').val(Math.round(remaining_amount));

                $('#installment').val(Math.round((remaining_amount) / (parseInt($('#total_month_per').val()) / 2)));

                $('#total-months').val(Math.round(parseInt($('#total_month_per').val() / 2)));

            } else if (val == <?php echo e(\App\CustomerProperty::inst_quar); ?>) {


                $('#total_installment').val(Math.round(remaining_amount));

                $('#installment').val(Math.round((remaining_amount) / (parseInt($('#total_month_per').val()) / 3)));

                $('#total-months').val(Math.round(parseInt($('#total_month_per').val() / 3)));

            } else if (val == <?php echo e(\App\CustomerProperty::inst_semi); ?>) {



                $('#total_installment').val(Math.round(remaining_amount));

                $('#installment').val(Math.round((remaining_amount) / (parseInt($('#total_month_per').val()) / 6)));

                $('#total-months').val(Math.round(parseInt($('#total_month_per').val() / 6)));

            } else if (val == <?php echo e(\App\CustomerProperty::inst_ann); ?>) {


                $('#total_installment').val(Math.round(remaining_amount));

                $('#installment').val(Math.round((remaining_amount) /
                    (parseInt($('#total_month_per').val() / 12))));

                $('#total-months').val(Math.round(parseInt($('#total_month_per').val() / 12)));

            }



        }


        function enableCustom(val) {
            makeInstallmentZero();
            document.getElementById('custom').style.display = 'block';
            document.getElementById('auto').style.display = 'none';



            ballon = parseFloat($('#ballon').val());
            bullating = parseFloat($('#bulleting').val());

            net_amount = parseInt($('#net_amount').val());
            down_payment = parseInt($('#down-payment').val());
            possession = parseInt($('#possession').val());
            allotment = parseInt($('#allotment').val());
            confirmation = parseInt($('#confirmation').val());
            booking = parseInt($('#booking').val());

            file_processing = parseInt($('#file_processing').val());
            registration = parseInt($('#registration').val());



            remaining_amount = net_amount - down_payment - possession - allotment - confirmation - booking -
                file_processing - registration - ballon - bullating;

            $('#custome_rem').val(Math.round(remaining_amount));


        }

        function makeInstallmentZero() {
            $('#annual-installment').val(0);
            $('#per_annual-installment').val(0);
            $('#total_annual_installment').val(0);
            $('#per_total_annual_installment').val(0);

            $('#total_semi_installment').val(0);
            $('#per_total_semi_installment').val(0);


            $('#semi-installment').val(0);
            $('#per_semi_installment').val(0);

            $('#quarterly-installment').val(0);
            $('#total_quarterly_installment').val(0);

        }



        $('#total_semi_installment_count').keyup(function() {

            price = $('#net_amount').val();
            count = $('#total_semi_installment_count').val();

            $('#semi-installment').val(Math.round($('#total_semi_installment').val() / count));

            //$('#semi-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

        });

        $('#total_bi_mon_installment_count').keyup(function() {

            price = $('#net_amount').val();
            count = $('#total_bi_mon_installment_count').val();

            $('#bi-mon-installment').val(Math.round($('#total_bi_mon_installment').val() / count));

            //$('#quarterly-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

        });

        $('#total_quarterly_installment_count').keyup(function() {

            price = $('#net_amount').val();
            count = $('#total_quarterly_installment_count').val();

            $('#quarterly-installment').val(Math.round($('#total_quarterly_installment').val() / count));

            //$('#quarterly-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

        });

        function number2TextConversion(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) +
                'only ' : '';

            return str;
        }


        function adjustAmount(val) {

            amount = parseInt($('#remaining_amount').val());



            if (amount) {
                if (val == 1) { //amount adjustment to per installment
                    $('#total_installment').val(parseInt($('#total_installment').val()) + amount);
                    $('#installment').val(Math.round((parseInt($('#total_installment').val())) / parseInt($('#total-months')
                        .val())));

                    $('#per_installment').val(((parseInt($('#installment').val()) / net_amount) * 100).toFixed(2));
                    total = $('#total_installment').val();
                    net_amount = parseInt($('#net_amount').val());
                    $('#per_total_installment').val(((total / net_amount) * 100).toFixed(2));
                } else if (val == 2) {
                    val = parseInt($('input[name="schedule_type"]:checked').val());
                    if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_semi); ?>) {
                        $('#total_semi_installment').val(parseInt($('#total_semi_installment').val()) + amount);
                        $('#semi-installment').val(Math.round((parseInt($('#total_semi_installment').val())) / parseInt($(
                            '#total_semi_installment_count').val())));
                    } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_ann); ?>) {
                        $('#total_annual_installment').val(parseInt($('#total_annual_installment').val()) + amount);
                        $('#annual-installment').val(Math.round((parseInt($('#total_annual_installment').val())) / parseInt(
                            $('#total_annual_installment_count').val())));
                    } else if (val == <?php echo e(\App\CustomerProperty::inst_mon_w_quar); ?>) {

                        $('#total_quarterly_installment').val(parseInt($('#total_quarterly_installment').val()) + amount);
                        $('#quarterly-installment').val(Math.round((parseInt($('#total_quarterly_installment').val())) /
                            parseInt($('#total_quarterly_installment_count').val())));
                    }

                } else if (val == 3) {

                    $('#down-payment').val(parseInt($('#down-payment').val()) + amount);


                    $('#per_down_payment').val(((parseInt($('#down-payment').val()) / net_amount) * 100).toFixed(2));

                } else if (val == 4) {
                    $('#possession').val(parseInt($('#possession').val()) + amount);

                    $('#per_possession').val(((parseInt($('#possession').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 5) {
                    $('#allotment').val(parseInt($('#allotment').val()) + amount);

                    $('#per_allotment').val(((parseInt($('#allotment').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 6) {
                    $('#confirmation').val(parseInt($('#confirmation').val()) + amount);

                    $('#per_confirmation').val(((parseInt($('#confirmation').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 7) {
                    $('#booking').val(parseInt($('#booking').val()) + amount);

                    $('#per_booking').val(((parseInt($('#booking').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 8) {
                    $('#development').val(parseInt($('#development').val()) + amount);

                    $('#per_development').val(((parseInt($('#development').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 9) {
                    $('#file_processing').val(parseInt($('#file_processing').val()) + amount);

                    $('#per_file_processing').val(((parseInt($('#file_processing').val()) / net_amount) * 100).toFixed(2));
                } else if (val == 10) {
                    $('#registration').val(parseInt($('#registration').val()) + amount);

                    $('#per_registration').val(((parseInt($('#registration').val()) / net_amount) * 100).toFixed(2));
                }

                else if (val == 18) {
                    $('#ballon').val(parseInt($('#ballon').val()) + amount);
                    $('#per_file_ballon').val(((parseInt($('#ballon').val()) / net_amount) * 100)
                        .toFixed(2));
                }
                else if (val == 19) {
                    $('#bulleting').val(parseInt($('#bulleting').val()) + amount);
                    $('#per_bulleting').val(((parseInt($('#bulleting').val()) / net_amount) * 100)
                        .toFixed(2));
                }
                $('#remaining_amount').val(0);
                $("input:radio[name='adjust']").each(function(i) {
                    this.checked = false;
                });
                updateCurrency();
            }
        }

        function activeNormal() {

            document.getElementById('normal').style.display = 'block';

            document.getElementById('full_payment').style.display = 'none';
        }


        function activeFullPayment() {
            document.getElementById('normal').style.display = 'none';

            document.getElementById('full_payment').style.display = 'block';
        }

        $('#return_tenure_full_payment').change(function() {
            tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if (tenure == 2) {
                total_month = total_month / 3;
            } else if (tenure == 3) {
                total_month = total_month / 6;
            } else if (tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
            num = $("#per_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#per-full-payment-label").text(str);
            }
        });

        $('#total_tenure_full_payment').keyup(function() {
            tenure = $('#return_tenure_full_payment').val();
            total_month = $('#total_tenure_full_payment').val();

            if (tenure == 2) {
                total_month = total_month / 3;
            } else if (tenure == 3) {
                total_month = total_month / 6;
            } else if (tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_full_payment').val(Math.round($('#net_amount_full_payment').val() / total_month));

            //update the total_installment
            num = $("#per_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#per-full-payment-label").text(str);
            }
        });

        $('#discount_percentage_full_payment').keyup(function() {

            if ($('#discount_percentage_full_payment').val()) {

                price = Math.round(parseFloat($('#discount_percentage_full_payment').val()) / 100 * $(
                    '#total_amount_full_payment').val());

                $('#discount_amount_full_payment').val(price);
                $('#net_amount_full_payment').val(price);

                //update per tenure full payment

                tenure = $('#return_tenure_full_payment').val();
                total_month = $('#total_tenure_full_payment').val();

                if (tenure == 2) {
                    total_month = total_month / 3;
                } else if (tenure == 3) {
                    total_month = total_month / 6;
                } else if (tenure == 4) {
                    total_month = total_month / 12;
                }

                $('#per_full_payment').val(Math.round(price / total_month));



                //update the total_installment
                num = $("#discount_amount_full_payment").val();
                var str = '';
                if ((num = num.toString()).length < 9) {
                    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                    if (n) {
                        str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                        str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                        str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                        str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                        str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[
                            n[5][1]]) + 'only ' : '';
                    }
                    $("#discount-amount-full-payment-label").text(str);
                }

                //update the total_installment
                num = $("#net_amount_full_payment").val();
                var str = '';
                if ((num = num.toString()).length < 9) {
                    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                    if (n) {
                        str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                        str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                        str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                        str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                        str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[
                            n[5][1]]) + 'only ' : '';
                    }
                    $("#net-amount-full-payment-label").text(str);
                }

                //update the total_installment
                num = $("#per_full_payment").val();
                var str = '';
                if ((num = num.toString()).length < 9) {
                    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                    if (n) {
                        str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                        str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                        str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                        str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                        str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[
                            n[5][1]]) + 'only ' : '';
                    }
                    $("#per-full-payment-label").text(str);
                }
            } else {
                $('#discount_amount_full_payment').val('');
            }

        });

        $('#deduction_amount_full_payment').keyup(function() {

            if ($('#deduction_amount_full_payment').val()) {

                price = Math.round(parseInt($('#discount_amount_full_payment').val()) - parseInt($(
                    '#deduction_amount_full_payment').val()));

                $('#net_amount_full_payment').val(price);

            } else {
                $('#net_amount_full_payment').val($('rebate_amount_full_payment').val());
            }

            //update per tenure full payment

            tenure = $('#return_tenure_buy_back').val();
            total_month = $('#total_tenure_buy_back').val();

            if (tenure == 2) {
                total_month = total_month / 3;
            } else if (tenure == 3) {
                total_month = total_month / 6;
            } else if (tenure == 4) {
                total_month = total_month / 12;
            }

            $('#per_buy_back').val(Math.round($('#net_amount_full_payment').val() / total_month));



            //update the total_installment
            num = $("#net_amount_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#net-amount-full-payment-label").text(str);
            }

            //update the total_installment
            num = $("#per_full_payment").val();
            var str = '';
            if ((num = num.toString()).length < 9) {
                n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
                if (n) {
                    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
                    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
                    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
                    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
                    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5]
                        [1]]) + 'only ' : '';
                }
                $("#per-full-payment-label").text(str);
            }

        });


        function addBasicUnit() {
            $('#dealer_rebate_information').show();

            var apend_data = `<select class="form-control chosen-select" id="unit_number" name="unit_number" data-id='0'>
                                                <option value="" selected="">None</option>
                                                <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($unit->id); ?>"><?php echo e($unit->multiProject ? $unit->multiProject->name : ''); ?> <?php echo e($unit->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>`;
            $('#addUnitDetail').empty();
            $('#addUnitDetail').append(apend_data);
            $('.chosen-select').chosen();
        }

        function addTokenHoldUnit() {
            $('#dealer_rebate_information').show();

            var apend_data = `<select class="form-control chosen-select" id="unit_number" name="unit_number" data-id='0'>
                                                <option value="" selected="">None</option>
                                                <?php $__currentLoopData = $unitNumbersTokenHolds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($unit->id); ?>"><?php echo e($unit->multiProject ? $unit->multiProject->name : ''); ?> <?php echo e($unit->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>`;
            $('#addUnitDetail').empty();
            $('#addUnitDetail').append(apend_data);
            $('.chosen-select').chosen();
        }
        <?php if($projecttype->id == \App\ProjectType::society): ?>
            function addDealerUnit() {

                $('#dealer_rebate_information').hide();
                var apend_data = `<select class="form-control chosen-select" id="unit_number" name="unit_number" data-id='1'> 
                                                    <option value="" selected="">None</option>
                                                    <?php $__currentLoopData = $unitNumbers_of_dealer_package_file; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($dealer_unit->id); ?>"><?php echo e($dealer_unit->multiProject ? $dealer_unit->multiProject->name : ''); ?> <?php echo e($dealer_unit->name); ?> -- Security Code(<?php echo e($dealer_unit->currency_number); ?>)</option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>`;
                $('#addUnitDetail').empty();
                $('#addUnitDetail').append(apend_data);

                $('.chosen-select').chosen();


            }
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/add-statement.blade.php ENDPATH**/ ?>