

<?php $__env->startSection('title'); ?>
    All Balloting Map Files
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">PreCondition Inventory Detail</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style type="text/css">
        .swal2-popup {
            font-size: 2.0rem !important;
        }

        .bg-color {
            background-color: #1c3752;
        }

        .anchor-link {
            display: none;
        }

        body {
            font-weight: bold;
        }

        #slider {
            height: 34px;
            -webkit-appearance: none;
            appearance: none;
            background-color: #ddd;
            outline: none;
            padding: 0;
            margin: 0;
            border-radius: 0px;
        }

        #slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #slider::-moz-range-thumb {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        #switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        #slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        #slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked+#slider {
            background-color: #2196F3;
        }

        input:focus+#slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked+#slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        #slider.round {
            border-radius: 34px;
        }

        #slider.round:before {
            border-radius: 50%;
        }
    </style>
    <style type="text/css" media="print">
        @media  print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                color: black !important;
            }

            h3 {
                line-height: 1px;
            }

            h3 strong {
                text-transform: uppercase;
                color: black !important
            }

            h4 strong {
                text-transform: uppercase;
                color: black !important
            }

            body {
                font-weight: bold;
            }

            .printFH11 {
                font-size: 13px;
                font-weight: 800;
                background-color: #000000;
            }

            .white-box .box-title {
                margin: 0px 0px 4px 0px;
                font-weight: 700;
                font-size: 14px;
                color: #1c3752;
                background-color: #000000 !important;
            }

            .white-box {
                padding: 0px 0px 2px 0px;
                margin-bottom: 0px;
                margin-bottom: 0;
                border-radius: inherit;
            }

            .table {
                width: 100% !important;
                margin-bottom: 5px;
                margin-top: -2px;
            }

            .table>tbody>tr>td,
            .table>tbody>tr>th,
            .table>tfoot>tr>td,
            .table>tfoot>tr>th {
                vertical-align: top;
            }

            .page-wrapper {
                padding-top: 0px;
            }
        }
    </style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


    <div class="container-fluid">
        <!-- /row -->
        <div class="row">


            <div class="col-md-12">
                <?php if($errors->any()): ?>
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            <?php echo implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')); ?>

                        </ul>
                    </div>
                <?php endif; ?>
                <?php
                    $total_val = count($allStatements);
                ?>
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Pre-Condtion Invnetory Detail</h3>

                    <p class="text-muted  font-13"> Total Inventories are : <span class="label label-success"
                            id='total'><?php echo e($total_val); ?></span></p>

                    <hr>

                </div>
            </div>

        </div>
        

            <input type='hidden' name='BallotingPreConditionFile_id' value='<?php echo e($pre_cond->id); ?>'> 
            
            <div class="row" id="update-table">

                <div class="col-lg-12">
                    <div class="white-box1">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> <?php echo e($pre_cond->name); ?></h3>
                        

                        <div class="table-responsive" style=" clear: both; overflow-y:auto;height:381px;">
                            <hr>

                            <table class="table table-bordered" id='state_table'>
                                <thead class="bg-color">
                                    <tr style="text-align: center">
                                        <th style="color: #fff;font-size: 13px;">#</th>
                                        <th style="color: #fff;font-size: 13px;">Unit #</th>
                                        <th style="color: #fff;font-size: 13px;">Size</th>
                                        <th style="color: #fff;font-size: 13px;">Customer</th>
                                        <th class="no-print" style="color: #fff;font-size: 13px;">Net Amount</th>
                                        <th style="color: #fff;font-size: 13px;">Booking Date</th>
                                        <!-- <th class="no-print">Detail</th> -->
                                        <th style="color: #fff;font-size: 13px;">Status</th>
                                        
                                        <!-- <th>Ref#</th> -->

                                        <!-- <th>Net Amt</th> -->
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $count = 1; ?>
                                    <?php $__currentLoopData = $allStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id='account_tr_<?php echo e($count); ?>' data-id="<?php echo e($count); ?>">
                                            <td><?php echo e($count++); ?></td>
                                            <input type='hidden' name='inventory_id[]'
                                                value='<?php echo e($statement->inventory->id); ?>'>
                                            <td><?php echo e($statement->inventory ? $statement->inventory->unit_number : ''); ?></td>
                                            <td>
                                                <?php if($statement->inventory): ?>
                                                    <?php if($statement->inventory->size): ?>
                                                        <?php echo e($statement->inventory->size->name); ?>

                                                        <?php if($projectType->id == \App\ProjectType::society): ?>
                                                            <?php echo e(\App\ProjectType::society_size); ?>

                                                        <?php else: ?>
                                                            <?php echo e(\App\ProjectType::high_rise_size); ?>

                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($statement->customer ? $statement->customer->name . '---' . $statement->customer->cnic : ''); ?><br><b>
                                            </td>

                                            <td><b><?php echo e(number_format($statement->net_pay)); ?></b></td>







                                            <td><?php echo e(date('d-m-Y', strtotime($statement->booking_date))); ?></td>
 
                                            <?php if($statement->inventory->inventory_type == \App\Inventory::allocated): ?>
                                            <td><span class="label label-success"  >Allocated</span></td>

                                            <?php elseif($statement->inventory->inventory_type == \App\Inventory::unallocated): ?>
                                            <td><span class="label label-primary" style="background-color:#cd703d;">Unallocated</span></td>

                                            <?php else: ?>
                                            <td></td>
                                            <?php endif; ?>

                                            


                                            


                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="custom_account_tr_0" class="tr_">

                                    </tr>


                                </tbody>
                            </table>


                        </div>

                    </div>
                    <br>

                </div>
            </div>

          
            <!-- /.row -->
        

    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(function() {
            $('#myTable').DataTable();

            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                "displayLength": 25,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group +
                                '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });

        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            // console.log(id);
            $('#account_tr_' + id).remove();
            count = $('#total').text();
            $('#total').text(parseInt(count) - 1);


        }

        var count = <?php echo e($total_val); ?>;

        function addNewRow() {

            count = parseInt(count) + 1;
            var account_row = `<tr height="2px" id="custom_account_tr_` + count + `"
                                            data-id="` + count + `" >
                                            <input type='hidden' name='inventory_id[]' id='inventory_id` + count + `' >
                                            <td id='count` + count +
                `'>

                                              
                                                
                                            </td>
                                            <td  >
                                                <select class='js-example-basic-single' name="customer_property" id='customer_property` + count + `'
                                                class="form-control "
                                                 onchange='getInformation(this.value,{data_id:` + count + `})'>
                                                 <option value='' select=''> None</option>
                                                
                                                     
                                               
                                            </select> 
                                            </td>
                                            <td id='plot_size` + count + `'></td>
                                            <td id='customer_name` + count + `'></td>



                                               <td id='net_pay` + count + `'></td>


                                              




                               <td id='booking_data` + count + `'></td>

                                          

                                            <td class="pt-3-half name">

                                                <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                    onclick="removeCustomParentDiv(this)"><i
                                                        class="fa fa-times"></i></button>
                                            </td>

                                        </tr>
                                             `;

            // var tr_id =count -1;
            var lastrow = $('#state_table').find('tr').last();
            $(lastrow).after(account_row);
            $('#count' + count).text(count);
            //    $('#custom_account_tr_'+0).after(account_row);

            selectCall();
        }

        function removeCustomParentDiv(self) {
            var id = $(self).closest('tr').data("id");


            $('#custom_account_tr_' + id).remove();
            count = $('#total').text();
            selectCall();
        }

        function getInformation(value, data) {
            //     console.log(value); // logs the selected value of the select element
            //   console.log(data.data_id);
            $.ajax({
                url: '<?php echo e(route('balloting.get.inventory-info')); ?>',
                data: {
                    id: value
                },
                dataType: 'json',
                success: function(response) {
                    // Get the input array using jQuery
                    var inputArray = $('input[name="inventory_id[]"]');
                    var match_count = 0;
                    // Loop through the array to compare each value with item.id
                    inputArray.each(function() {
                        var inputValue = $(this).val(); // Get the value of the current input
                        // The ID to match against

                        // Check if the input value matches the item ID
                        if (inputValue == response.id) {
                            // Trigger a SweetAlert alert
                            Swal.fire("Match found!", "This Unit number  all ready selected.", "error");
                            match_count = match_count + 1;
                        }

                    });

                    if (match_count > 0) {
                        $('#customer_property' + data.data_id).val(null).trigger('change');
                        return false;

                    }
                    // val_t= $('#total').text();
                    //    $('#total').text(parseInt(val_t) + 1);

                    $('#inventory_id' + data.data_id).val(response.id);
                    $('#plot_size' + data.data_id).text(response.size + ' Marla');
                    $('#customer_name' + data.data_id).text(response.name);
                    $('#net_pay' + data.data_id).text(response.netpay);
                    $('#booking_data' + data.data_id).text(response.data);
                },
                error: function() {
                    // Handle errors
                }
            });
        }

        function selectCall() {
            $('.js-example-basic-single').select2({
                width: '250px',
                placeholder: 'Search Unit Number...',
                ajax: {
                    url: '<?php echo e(route('balloting.get.inventory-unit')); ?>',

                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term, // search term

                        };
                    },
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(item) {

                                return {
                                    id: item.id,
                                    text: item.text
                                }
                            })
                        };
                    },
                    cache: true

                }
            });
        }

        function confirmSubmit() {
            Swal.fire({
                title: "Are you sure?",
                text: "Do you want to Lock these inventories for balloting?",
                icon: "warning",
                buttons: ["No", "Yes"]
            }).then((confirm) => {
                if (confirm) {
                    // User clicked "Yes", submit the form
                    document.getElementById("myForm").submit();
                } else {
                    // User clicked "No", do nothing

                }
            });
        }


        function getMapData(self) {

            val = $("#map_file").val();

            var pc_id = "<?php echo e($pre_cond->id); ?>";
            // val = $(self).val();
            $('.preloader').fadeIn();
            $.ajax({
                url: `<?php echo e(route('balloting.get.map.data')); ?>`,

                type: 'GET',
                data: {
                    id: val,
                    pc_id: pc_id
                },
                dataType: 'json',
                success: function(response) {
                    $('.preloader').fadeOut();
                    var sector = "<option value='' >None</option>";

                    for (var i = 0; i < parseInt(response.sector.length); i++) {
                        sector += "<option value='" + response.sector[i].unit_block_id + "'>" + response.sector[
                                i].sector +
                            "</option>";

                    }
                    $("#sector_0").html(sector);

                    Swal.fire({
                        title: 'Size Differences',
                        html: ` <strong>Between Map and Inventory</strong><br> 

`,
                        icon: 'info',
                        //   html:
                        //     'You can use <b>bold text</b>, ' +
                        //     '<a href="//sweetalert2.github.io">links</a> ' +
                        //     'and other HTML tags',
                        showCloseButton: true,
                        showCancelButton: true,
                        focusConfirm: false,
                        confirmButtonText: '<i class="fa fa-thumbs-up"></i> Ok Continue!',
                        confirmButtonAriaLabel: 'Thumbs up, great!',
                        cancelButtonText: '<i class="fa fa-thumbs-down"></i>',
                        cancelButtonAriaLabel: 'Thumbs down'
                    })
                    console.log(response);
                },
                error: function(xhr, status, error) {
                    $('.preloader').fadeOut();
                    // $('.preloader').fadeOut();
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Unable to fetch Map data!',

                    })
                }

            });

        }
        $('.js-example-basic-single').select2({
            width: '350px',
        });



        // Get the checkbox element
        const checkbox = document.getElementById('specific_block');

        // Add an event listener to the checkbox
        checkbox.addEventListener('change', function() {
            if (this.checked) {
                // Checkbox is checked

                $('#specficblock').show();


            } else {
                // Checkbox is not checked
                $('#specficblock').hide();


            }
        });

        $('#start_balloting').submit(function(e) {
            e.preventDefault();
            console.log('hello');

            var form_data = $(this).serialize();
            var pre_condition = $('#pre-condition').val();
            var map_file = $('#map_file').val();


            if (map_file == "") {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Map File is required!',

                })
                return false;
            }

            function updateProgressBar() {

                $.ajax({
                    url: '<?php echo e(route('balloting.progress')); ?>',
                    success: function(data) {
                        // Update progress bar
                        $('.progress-bar').css('width', data.progress + '%').text(data.progress + '%');
                        $('#progress_val').empty();
                        $('#progress_val').text(data.progress);

                        // Check if process is complete
                        if (data.progress == 100) {

                            clearInterval(progressInterval);
                        }
                    }
                });
            }
            var progressInterval = setInterval(updateProgressBar, 2000); // Send a request every 5 seconds





            Swal.fire({
                title: 'Balloting Start',
                html: `  Importing...   <span id='progress_val'></span>%<div class="progress">
                             <div class="progress-bar" role="progressbar" style="width: <?php echo e(session('progress')); ?>%" aria-valuenow="<?php echo e(session('progress')); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e(session('progress')); ?>%</div>
                             </div>`,
                showConfirmButton: false,
                allowOutsideClick: false,
                allowEscapeKey: false,


            });
            //    return false;
            $('.preloader').fadeIn();







            $.ajax({
                url: "<?php echo e(route('balloting.start.store.data')); ?>",
                type: 'POST',
                data: form_data,
                success: function(response) {

                    $('.preloader').fadeOut();

                    if (response.success) {

                        Swal.fire({
                            icon: 'success',
                            title: 'Balloting Completed Successfully',

                            confirmButtonText: 'Ok',

                        }).then((result) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                                <?php echo session()->forget('progress'); ?>

                                window.location.href =
                                    `<?php echo e(route('balloting.map.inventory', ':id')); ?>`.replace(
                                        ':id', response.id);
                            }
                        })
                    }
                },
                error: function(xhr, status, error) {
                    $('.preloader').fadeOut();
                    clearInterval(progressInterval);
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',

                    })
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/balloting/precoditionlist/view.blade.php ENDPATH**/ ?>