

<?php $__env->startSection('title'); ?>
All Open Files 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Open File Packages List</li>
      </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


            <div class="container-fluid">
                <!-- /row -->

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Open Files
                                <div class="pull-right">
                                    <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'issue-openfile')): ?>
                                    <a href="<?php echo e(route('openfile.package')); ?>" class="btn  btn-success">
                                        <i class="fa fa-plus-square"></i>&nbsp;Sell A Package
                                    </a>
                                <?php endif; ?>
                                    
                                </div>
                            </div>
                        <div class="panel-wrapper collapse in" aria-expanded="true">
                                
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                             
                                             <!--/span-->
                                   
                                 <!--/span-->
                                 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
                                 <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Project</label>
                                            <select id="multipro" class="form-control chosen-select" name="multipro_id">
                                                <option value=""><b>None</b></option>
                                                <?php $__currentLoopData = $multi_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    
                                                        <option value="<?php echo e($pro->id); ?>"><?php echo e($pro->name); ?> </option>
                                                    
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            </div>
                                    </div>
                                    <?php endif; ?>

                                    <!--/span-->
                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Dealer</label>
                                            
                                            <select id="dealer" class="form-control chosen-select">
                                                <option  value="0">None</option>
                                                <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?>-<?php echo e($d->code); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select> </div>
                                    </div>
                                    <!--/span-->

                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By status</label>
                                            <select id="status" class="form-control chosen-select">
                                            <option  value="0">None</option>
                                                
                                            
                                            <option  value="<?php echo e(\App\CustomerProperty::pending); ?>">Pending</option>
                                            <option value="<?php echo e(\App\DealerPackage::completed); ?>">Completed</option>

                                            
                                            </select> </div>
                                    </div>
                                    <!--/span-->

                                     <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Package </label>
                                            
                                            <select id="openfilepackage" class="form-control chosen-select">
                                                <option  value="0">None</option>
                                                <?php $__currentLoopData = $openfile_package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($p->id); ?>"><?php echo e($p->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select> </div>
                                                 
                                    </div>
                                    <!--/span-->

                                     <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Issue Date</label>
                                        <input type='date' name='issue_date' id='date' class='form-control'>    
                                        </div>
                                    </div>
                                    <!--/span-->
                                   

                                    <!--/span-->
                                    <div class="col-md-3">
                                        <div class="form-group has-success" style="margin-bottom: 15px">
                                            <label class="control-label">By Package Inventory</label>
                                            <select id="package_inventory" class="form-control chosen-select">
                                            <option  value="">None</option>
                                            <option  value="<?php echo e(\App\DealerPackage::inventory_created); ?>">Created</option>
                                            <option  value="<?php echo e(\App\DealerPackage::inventory_not_created); ?>">Not Created</option>
                                           
                                             
                                            
                                            
                                            </select> </div>
                                    </div>
                                    <!--/span--> 
                                   

                                        

                                    <div class="col-md-3">
                                    <div class="form-actions" style="margin-top: 26px">
                                    <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>

                                    </div>
                                    </div>


                                    </div>
                                                  
                                </div>
                                        
                                    </form>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
                <!--./row-->

                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	
                            <h3 class="box-title">All Open Files (<?php echo e(count($dealer_openfile_package )); ?>)</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th>    
                                            <th>Project</th>                                   
                                            <th>Dealer Name</th>
                                            <th>Dealer Code</th>
                                            <th>Package Name</th>
                                            <th>Paid Amount</th>
                                            
                                            <th>Payment Status</th>
                                            <th>Issue Date</th>
                                            <th>Package Inventory</th>
                                            
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        <?php $__currentLoopData = $dealer_openfile_package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dopf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        

                                        <tr>
                                            <td><?php echo e($count++); ?></td>
                                            <td>
                                             
                                                <?php echo e($dopf->multiProject?$dopf->multiProject->name:'None'); ?>

                                            
                                            </td>
                                            <td><?php echo e($dopf->dealer->name); ?></td>
                                            <td><?php echo e($dopf->dealer->code); ?></td>
                                            <td><?php echo e(($dopf->package)? $dopf->package->name:''); ?></td>
                                            <td>
                                                <?php
                                                 $paid_amount=   $dopf->dealerPackagePaymentReceipt->where('dealerpackage_id',$dopf->id)->where('is_approved',1)->sum('amount');    
                                                ?>
                                                <?php echo e($paid_amount); ?>

                                                
                                                PKR </td>
                                          
                                            <td>
                                                
                                                <?php if($dopf->payment_status == \App\DealerPackage::pending): ?>
                                                <span class="label label-danger">Pending</span>
                                                 <?php elseif($dopf->payment_status == \App\DealerPackage::completed): ?>
                                                 <span class="label label-success">Completed</span>
                                                 <?php endif; ?> 
                                            </td>
                                            <td><?php echo e($dopf->issue_date); ?></td>


                                            <td>
                                                <?php if($dopf->inventory_status == \App\DealerPackage::inventory_not_created): ?>
                                                <span class="label label-danger">Not Created</span>
                                                 <?php elseif($dopf->inventory_status == \App\DealerPackage::inventory_created): ?>
                                                 <span class="label label-success">Created</span>
                                                 <?php endif; ?>
                                                </td>

                                                
                                            <td class="text-nowrap">
                                                <a href="<?php echo e(route('openfile.detail',['id'=>$dopf->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="Inventory List"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        
                                                        <a href="<?php echo e(route('openfile.package.payments',$dopf->id)); ?>"
                                                            data-toggle="tooltip" data-original-title="Payment Receipts"> <i
                                                                class="fa fa-money text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                         
                                                         
                                                      
                                                
                                                        
                                                <a href="<?php echo e(route('openfile.view',['id'=>$dopf->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="Status Pending"> <i
                                                        class="fa-solid fa-pen-field"></i></a>

                                                        

                                                
                                            
                                                 
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                       

                                    </tbody>                                                                                                                    
                                </table>
                                <div style="float: right;"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>


<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'ordering':false,
            'sorting' : false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            
            dealer = $('#dealer').val();
            status = $('#status').val();
            openfilepackage = $('#openfilepackage').val();
            date = $('#date').val();
            package_inventory = $('#package_inventory').val();
            multipro = $('#multipro').val();

            
        if(multipro == 0 &&  dealer == 0 && status== 0 && openfilepackage == 0 && date == null && package_inventory == 0)
        {
            toastr.warning("please select any option.");
            $('.preloader').fadeOut();
            return false;
        }

            var data = {'multipro':multipro,'dealer':dealer,'status':status, 'openfilepackage' : openfilepackage , 'date' : date , 'package_inventory' : package_inventory};
            $.get('/issue/open-file-update-table',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true,
                    'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    



    function openSmsModal(property_id) {

        var data={'property_id':property_id};
        $.get('/update_sms_modal', data, function (data) {
            document.getElementById('exampleModal').innerHTML = data;
            $('#exampleModal').modal();
        });
    }

    function openReminderModal(property_id) {

        var data={'property_id':property_id};
        $.get('/update_reminder_modal', data, function (data) {
            document.getElementById('exampleModal1').innerHTML = data;
            $('#exampleModal1').modal();
        });
    }







    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/openfile/index.blade.php ENDPATH**/ ?>