


<?php $__env->startSection('title'); ?>
    Edit New Price List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'list-inventory')): ?>
            <li><a href="<?php echo e(route('pricelist.index')); ?>">All Price List</a></li>
        <?php endif; ?>
        <li class="active">Edit Price List</li>
    </ol>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
 $size=  '';

if($projectType->id == \App\ProjectType::society){
                                               
      $size=        \App\ProjectType::society_size;
            }
                                               else
                                               { $size=   \App\ProjectType::high_rise_size;}
                                            
?>
    <div class="container-fluid">
           <!--.row-->
              
                <!--./row-->
        <!--.row-->

        <div class="row">

            <div class="col-md-12">
                <?php if($errors->any()): ?>
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            <?php echo implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')); ?>

                        </ul>
                    </div>
                <?php endif; ?>
                   <?php
                      $society = false;
                   $highrise = false;

                if ($projecttype->id == App\ProjectType::society){
                    $society = true;
                }
                
                
              
                if ($projecttype->id == App\ProjectType::high_rise){
                    $highrise = true;
                }
                
                ?>

              
         
                <div class="white-box">

                    <h3 class="box-title m-b-0"><i class="fa fa-info-circle"></i>Edit Price List</h3>
                    <p class="text-muted m-b-30 font-13">Edit Information </p>
                    <p class="text-muted m-b-30 font-12" ><span style='color:red;'>Note:All Open Inventory which are linked with this price list  will also updated . </span></p>
                    <hr>
                    <form class="form-horizontal" action="<?php echo e(route('pricelist.update')); ?>" method="post">
                        <?php echo e(csrf_field()); ?>


                        <input name='pricelist_id' type='hidden' value="<?php echo e($price->id); ?>">
                        <div class="form-group">
                            <?php if($society && $highrise): ?>
                                <label for="address" class="col-sm-2 control-label">Society</label>
                                <div class="col-sm-4">
                                    <div class="input-group">

                                        <input type="radio"
                                            <?= old('project_type') == App\ProjectType::society ? 'checked' : '' ?>
                                            name="project_type" value="<?php echo e(App\ProjectType::society); ?>" style="zoom: 1.6;"
                                            onchange="check_post(this)" checked>
                                        <?php if($errors->has('project_type')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('project_type')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                           
                           

                                <label for="address" class="col-sm-2 control-label">High Rise</label>
                                <div class="col-sm-4">
                                    <div class="input-group">
                                        <input type="radio" name="project_type" value="<?php echo e(App\ProjectType::high_rise); ?>"
                                            <?= old('project_type') == App\ProjectType::high_rise ? 'checked' : '' ?>
                                            style="zoom: 1.6;" onchange="check_post(this)">
                                        <?php if($errors->has('project_type')): ?>
                                            <span class="help-block">
                                                <strong><?php echo e($errors->first('project_type')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php elseif($society): ?>
                            <input type="hidden"
                             
                            name="project_type" value="<?php echo e(App\ProjectType::society); ?>"  >
                            <?php elseif($highrise): ?>
                            <input type="hidden" name="project_type" value="<?php echo e(App\ProjectType::high_rise); ?>"
                            >
                                <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <h3 style='padding-left:2%'>List No:</h3>
                            
                            <div class="col-sm-12">
                                <div class="input-group" style='width: 38%;'>
                                    <div class="input-group-addon"><i class="fa fa-circle-o"></i></div>
                                    <input type="text" class="form-control" name="list_number"
                                        value="<?php echo e($price->l_no); ?>" id="list_number"
                                        placeholder="Enter Plot / Serial Number">
                                    <?php if($errors->has('list_number')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('list_number')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-info">
                                    <div class="panel-heading">Add Detail
                                    </div>
                        <?php if($highrise): ?>

                        <div class="form-group" id="highrise_price" >
                            <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Unit Floor</th>
                                            <th class="text-center">Unit Type</th>
                                    
                                            <th class="text-center">Per/<?php echo e($size); ?> Price (PKR)</th>
                                            




                                        </tr>

                                    </thead>
                                    <tbody id="tbody_data">
                                        <?php for($i =0 ; $i< sizeof($price->pricedetail); $i++) {?>
                                        
                                        <tr height="2px" id="account_tr_<?php echo e($i); ?>"
                                            data-id="<?php echo e($i); ?>">

                                            <td class="pt-3-half account" style="width: 30%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_floor[]">
                                                    <option value="<?php echo e($price->pricedetail[$i]->unitfloor->id); ?>"  selected><?php echo e($price->pricedetail[$i]->unitfloor->name); ?></option>
                                                  
                                                    <?php $__currentLoopData = $h_r_floor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($t->id); ?>">
                                                            <?php echo e($t->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                           
                                            <td class="pt-3-half account" style="width: 30%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option value="<?php echo e($price->pricedetail[$i]->unittype->id); ?>"  selected><?php echo e($price->pricedetail[$i]->unittype->name); ?></option>
                                                  
                                                    <?php $__currentLoopData = $h_r_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($t->id); ?>">
                                                            <?php echo e($t->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                           
                                            

                                            <td class="pt-3-half name" style='width: 30%;'>
                                                <input class="form-control size unit_quantity" data-id="<?php echo e($i); ?>"  id='per_price_<?php echo e($i); ?>' onkeyup="perPriceFunction(this)" onclick="perPriceFunction(this)" type="number" name='per_price[]' value="<?php echo e($price->pricedetail[$i]->per_size_price); ?>">
                                            </td>
                                         

                                            <td class="pt-3-half name">
                                                <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                    data-id="<?php echo e($i); ?>" onclick="addNewRow(this)"><i
                                                        class="fa fa-plus"></i></button>

                                            </td>

                                        </tr>

                                        <tr id="narration_tr_<?php echo e($i); ?>" class="tr_<?php echo e($i); ?>">

                                        </tr>

                                        <?php } ?>



                                     


                                    </tbody>
                                </table>
                            </div>
                        </div>

                         <?php endif; ?>
                         <?php if($society): ?>

                        <div class='society' id='society_data' style="display:<?= old('type') == 1 ? 'none' : '' ?>">

                            <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>

                                            <th class="text-center">Unit Type</th>
                                            <th class="text-center">Size</th>
                                            <th class="text-center">Per/<?php echo e($size); ?> Price pkr</th>
                                            <th class="text-center">Total Price pkr</th>




                                        </tr>

                                    </thead>
                                    <tbody id="tbody_data">
                                        
                                        <?php for($i =0 ; $i< sizeof($price->pricedetail); $i++) {?>
                                        
                                        
                                        
                                        
                                            <tr height="2px" id="account_tr_<?php echo e($i); ?>"
                                            data-id="<?php echo e($i); ?>">

                                            <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                <select class="form-control chosen-select us_acnt"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option value="<?php echo e($price->pricedetail[$i]->unittype ? $price->pricedetail[$i]->unittype->id : ''); ?>"  selected><?php echo e($price->pricedetail[$i]->unittype ? $price->pricedetail[$i]->unittype->name : ''); ?></option>
                                                  
                                                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($t->id); ?>">
                                                            <?php echo e($t->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_size[]" id='unit_size_<?php echo e($i); ?>'  onchange="unitChangeFunction(this)" data-id='<?php echo e($i); ?>'>
                                                    <option value="<?php echo e($price->pricedetail[$i]->unitSize->id); ?>" data-value=<?php echo e($price->pricedetail[$i]->unitSize->name); ?> selected><?php echo e($price->pricedetail[$i]->unitSize->name); ?> <?php echo e($size); ?></option>
                                                  
                                                    <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option style="font-size: 11px;" value="<?php echo e($s->id); ?>" data-value=<?php echo e($s->name); ?>>
                                                            <?php echo e($s->name); ?> <?php echo e($size); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </td>
                                           
                                            

                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" data-id="<?php echo e($i); ?>"  id='per_price_<?php echo e($i); ?>' onkeyup="perPriceFunction(this)" onclick="perPriceFunction(this)" type="number" name='per_price[]' value="<?php echo e($price->pricedetail[$i]->per_size_price); ?>">
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" data-id="<?php echo e($i); ?>"  id='total_price_<?php echo e($i); ?>'  onkeyup="totalPriceFunction(this)" onclick="totalPriceFunction(this)" type="number" name='total_price[]' value="<?php echo e($price->pricedetail[$i]->total_price); ?>">
                                            </td>

                                            <td class="pt-3-half name">
                                                <button type="button" class="btn btn-sm btn-success btn-sm addRowBtn"
                                                    data-id="<?php echo e($i); ?>" onclick="addNewRow(this)"><i
                                                        class="fa fa-plus"></i></button>

                                            </td>

                                        </tr>

                                        <tr id="narration_tr_<?php echo e($i); ?>" class="tr_<?php echo e($i); ?>">

                                        </tr>

                                        <?php } ?>



                                     


                                    </tbody>
                                </table>
                            </div>
                           

                        </div>
                              
                        <?php endif; ?>












                        <div class="form-group">
                            <div class="col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <button type="submit" class="btn btn-info waves-effect waves-light "
                                    style="width: 100%">Save</button>
                            </div>
                        </div>
                                   
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        function check_post(self) {
            if ($(self).val() == <?php echo e(App\ProjectType::high_rise); ?>) {
                $('#highrise_price').show();
                $('#society_data').hide();
            } else {
                $('#society_data').show();
                $('#highrise_price').hide();
            }
        }

        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            // console.log(id);
            $('#account_tr_' + id).remove()
            $('#narration_tr_' + id).remove()
        }

       
        
       
      
 var count = <?php echo e(count($price->pricedetail)); ?>;
        function addNewRow(self) {
            $(".chosen-select").chosen("destroy");
            count = count +1;
            <?php if($highrise): ?>
            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


<select class="form-control chosen-select us_acnt"
    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
    name="unit_floor[]">
    <option  >None</option>
    <?php $__currentLoopData = $h_r_floor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($t->id); ?>">
            <?php echo e($t->name); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
</td>
                                            <td class="pt-3-half account" style="width: 20%" contenteditable="true">


                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    <?php $__currentLoopData = $h_r_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($t->id); ?>">
                                                            <?php echo e($t->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </td>
                                           
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='per_price_`+count+`' data-id="`+ count+`" type="number" name='per_price[]'  >
                                            </td>
                                           
                                             
                                          

                                            <td class="pt-3-half name">

                                                <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                    onclick="removeParentDiv(this)"><i
                                                        class="fa fa-times"></i></button>
                                            </td>
                                           
                                        </tr>
                                             `;
            <?php endif; ?>
            <?php if($society): ?>
            var account_row= `<tr height="2px" id="account_tr_`+count+`"
                                            data-id="`+count+`" >

                                            <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_type[]">
                                                    <option  >None</option>
                                                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($t->id); ?>">
                                                            <?php echo e($t->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="unit_size[]" id='unit_size_`+count+`' onchange="unitChangeFunction(this)" data-id='`+count+`'>
                                                    <option  >None</option>
                                                    <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option style="font-size: 11px;" value="<?php echo e($s->id); ?>" data-value=<?php echo e($s->name); ?>>
                                                            <?php echo e($s->name); ?><?php echo e(env('SIZE')); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='per_price_`+count+`' data-id="`+ count+`" type="number" name='per_price[]' onkeyup="perPriceFunction(this)"  onclick="perPriceFunction(this)" >
                                            </td>
                                            <td class="pt-3-half name" style='width: 20%;'>
                                                <input class="form-control size unit_quantity" id='total_price_`+count+`' data-id="` +count+`" type="number" name='total_price[]' onkeyup="totalPriceFunction(this)" onclick="totalPriceFunction(this)" >
                                            </td>

                                          

                                            <td class="pt-3-half name">

                                                <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                    onclick="removeParentDiv(this)"><i
                                                        class="fa fa-times"></i></button>
                                            </td>

                                        </tr>
                                             `;
                                             <?php endif; ?>

var tr_id = $(self).data("id");
           $('.tr_' + tr_id).after(account_row);
           $('.chosen-select').chosen();
        }

        function perPriceFunction(e){

        count_val = e.getAttribute("data-id");
        unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
        per_price =    $('#per_price_'+ count_val).val();
        if(unit_size != undefined){
         result =   parseFloat(per_price) * parseFloat(unit_size);
         $('#total_price_'+ count_val).val(  result);
        }
        }

        function totalPriceFunction(e){

count_val = e.getAttribute("data-id");
unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
 total_price = $('#total_price_'+ count_val).val();
 console.log(count_val,unit_size,total_price);
if(unit_size != undefined){
 result =    parseFloat(total_price)/parseFloat(unit_size) ;
 $('#per_price_'+ count_val).val(result.toFixed(2));
}

}

function unitChangeFunction(e){
    count_val = e.getAttribute("data-id");
unit_size = $('#unit_size_'+ count_val).find(':selected').attr('data-value');
 total_price = $('#total_price_'+ count_val).val();
 per_price =    $('#per_price_'+ count_val).val();
if(unit_size != undefined){
    if(per_price != 0){
      
        result =   parseFloat(per_price) * parseFloat(unit_size);
        $('#total_price_'+ count_val).val(result);
    }else if(total_price != 0){
        result =    parseFloat(total_price)/parseFloat(unit_size) ;
 $('#per_price_'+ count_val).val(result.toFixed(2));
    }
  
}
}
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views//pricelist/edit.blade.php ENDPATH**/ ?>