

<?php $__env->startSection('title'); ?>
    All Statements
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Statements</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    ?>

    <?php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    ?>


    <div class="container-fluid">
        <!-- /row -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isSuperAdmin')): ?>
            <?php echo $__env->make('partial.multiproject_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!--.row-->
        <div id='updatecontent'>
        <div class="row" style="margin-top: 25px;">
            <div class="col-md-12">
                <div class="panel panel-info">
                    <div class="panel-heading">Search Statements</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">
                                        <!--/span-->

                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit No.</label>

                                                <select id="unit" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $unitNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($p->id); ?>"><?php echo e($p->unit_number); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Customer</label>

                                                <select id="customer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Dealer</label>

                                                <select id="dealer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($d->id); ?>">
                                                            <?php echo e($d->name); ?>-<?php echo e($d->code); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By status</label>
                                                <select id="status" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <option value="<?php echo e(\App\CustomerProperty::approved); ?>">Approved</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::pending); ?>">Pending</option>
                                                    <option value="<?php echo e(\App\CustomerProperty::cancel); ?>">Cancelled</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Size</label>
                                                <select id="unit_size" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <?php $__currentLoopData = $unitSize; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?>

                                                            <?php echo e($size); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Type</label>
                                                <select id="unit_type" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <?php $__currentLoopData = $unitType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->


                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit Block</label>
                                                <select id="unit_block" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    <?php $__currentLoopData = $unitBlock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->



                                        <div class="col-md-3">
                                            <div class="form-actions" style="margin-top: 26px">
                                                <button type="button" class="btn btn-success search-customer"> <i
                                                        class="fa fa-check"></i> Search</button>

                                            </div>
                                        </div>


                                    </div>

                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->

        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Statement (<?php echo e(number_format($statementCount)); ?>)</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Project</th>

                                    <th>Unit #</th>
                                    <th>Size</th>
                                    <th>Member Name</th>
                                    <th>Net Amount</th>

                                    <th>Received Amount</th>

                                    <th>Booking Date</th>
                                    <th>Status</th>
                                    <th style="width: 185px!important;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-membership')): ?>
                                    <?php $view_membership = true; ?>
                                <?php else: ?>
                                    <?php $view_membership = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-schedule')): ?>
                                    <?php $create_schedule = true; ?>
                                <?php else: ?>
                                    <?php $create_schedule = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-membership')): ?>
                                    <?php $edit_membership = true; ?>
                                <?php else: ?>
                                    <?php $edit_membership = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-membership')): ?>
                                    <?php $delete_membership = true; ?>
                                <?php else: ?>
                                    <?php $delete_membership = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'download-membership')): ?>
                                    <?php $download_membership = true; ?>
                                <?php else: ?>
                                    <?php $download_membership = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'reminder-membership')): ?>
                                    <?php $reminder_membership = true; ?>
                                <?php else: ?>
                                    <?php $reminder_membership = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'sms-membership')): ?>
                                    <?php $sms_membership = true; ?>
                                <?php else: ?>
                                    <?php $sms_membership = false; ?>
                                <?php endif; ?>

                                <?php $__currentLoopData = $allStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($count++); ?></td>
                                        <td>
                                            <?php if($statement->inventory): ?>
                                                <?php if($statement->inventory->multiProject): ?>
                                                    <?php echo e($statement->inventory->multiProject->name); ?>

                                                <?php else: ?>
                                                    None
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($statement->inventory ? $statement->inventory->unit_number : ''); ?></td>
                                        <td>
                                            <?php if($statement->inventory): ?>
                                                <?php if($statement->inventory->size): ?>
                                                    <?php echo e($statement->inventory->size->name); ?>


                                                    <?php echo e($size); ?>

                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($statement->customer ? $statement->customer->name : ''); ?><br><b>Dealer:
                                            </b><?php echo e($statement->dealer ? $statement->dealer->name : ''); ?></td>

                                        <td><b><?php echo e(number_format($statement->net_pay)); ?></b></td>




                                        <td><b><?php echo e(number_format($receivedAmt[$statement->id])); ?></b></td>





                                        <td><?php echo e(date('d-m-Y', strtotime($statement->booking_date))); ?></td>



                                        <?php if($statement->status == \App\CustomerProperty::pending): ?>
                                            <td><span class="label label-primary"
                                                    style="background-color:#cd703d;">Pending</span></td>
                                        <?php elseif($statement->status == \App\CustomerProperty::approved): ?>
                                            <td><span class="label label-success">Approved</span></td>
                                        <?php elseif($statement->status == \App\CustomerProperty::cancel): ?>
                                            <td><span class="label label-danger">Canceled</span></td>
                                        <?php elseif($statement->status == \App\CustomerProperty::block): ?>
                                            <td><span class="label label-danger"
                                                    style="background-color:#f80c0c;">Block</span></td>
                                        <?php else: ?>
                                            <td></td>
                                        <?php endif; ?>



                                        <td class="text-nowrap">
                                            <?php if($view_membership): ?>
                                                <a href="<?php echo e(route('statement.detail', ['id' => $statement->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            <?php endif; ?>



                                            <?php if($edit_membership): ?>
                                                <a href="<?php echo e(route('statement.editViewCustomer', ['id' => $statement->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            <?php endif; ?>

                                            <?php if($statement->status != \App\CustomerProperty::approved): ?>
                                                <?php if($delete_membership): ?>
                                                    <a href="<?php echo e(route('statement.delete', ['id' => $statement->id])); ?>"
                                                        data-toggle="confirmation" data-title="Are you sure to delete?">
                                                        <i
                                                            class="fa fa-close text-danger"></i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($download_membership): ?>
                                                <a target="_blank"
                                                    href="<?php echo e(route('membership.download', ['id' => $statement->id])); ?>"
                                                    data-toggle="tooltip" data-original-title="Download"> <i
                                                        class="fa fa-download text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            <?php endif; ?>

                                            <?php if($reminder_membership): ?>

                                                <?php if($statement->reminder_text): ?>
                                                    <?php if($statement->reminder_date): ?>
                                                        <?php if($statement->reminder_date < \Carbon\Carbon::now()): ?>
                                                            <a href="#"
                                                                onclick="openReminderModal(<?php echo e($statement->id); ?>)"
                                                                data-toggle="tooltip"
                                                                data-original-title="Overdue Reminder"
                                                                style="color: red;"> <i
                                                                    class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        <?php else: ?>
                                                            <a href="#"
                                                                onclick="openReminderModal(<?php echo e($statement->id); ?>)"
                                                                data-toggle="tooltip"
                                                                data-original-title="Coming Reminder"
                                                                style="color: green;"> <i
                                                                    class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <a href="#"
                                                            onclick="openReminderModal(<?php echo e($statement->id); ?>)"
                                                            data-toggle="tooltip"
                                                            data-original-title="See Coming Reminder"
                                                            style="color: green;"> <i
                                                                class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="#" onclick="openReminderModal(<?php echo e($statement->id); ?>)"
                                                        data-toggle="tooltip" data-original-title="Reminder"> <i
                                                            class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                <?php endif; ?>

                                            <?php endif; ?>

                                            <?php if($sms_membership): ?>
                                                <a href="#" onclick="openSmsModal(<?php echo e($statement->id); ?>)"><i
                                                        class="fa fa-comment"></i>&nbsp;&nbsp;&nbsp;&nbsp;</a>
                                            <?php endif; ?>

                                            <?php if(!empty($statement->inventory->dealerPackageOpenFileUnit)): ?>
                                                <?php if($statement->status == \App\CustomerProperty::approved): ?>
                                                    <a href="<?php echo e(route('statement.letter', [$statement->id])); ?>"
                                                        data-toggle="tooltip" data-original-title="Registration-Letter"><i
                                                            class="fa fa-envelope" aria-hidden="true"></i>&nbsp;&nbsp;</a>
                                                <?php endif; ?>
                                            <?php endif; ?>



                                        </td>

                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                        <div style="float: right;"><?php echo e($allStatements->links()); ?></div>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>


    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'ordering': false,
                'sorting': false,
                'info': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });

        function callItBack(){
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            status = $('#status').val();
            unit_size = $('#unit_size').val();
            unit_type = $('#unit_type').val();
            unit_block = $('#unit_block').val();
            var multipro_id = "";
            if ($("#multipro").length > 0) {
                if ($("#multipro").val() !== 'search') {
                    multipro_id = $("#multipro").val();
                }
                // Do something with the value
            }



            if (unit == 0 && customer == 0 && status == 0 && dealer == 0 && unit_size == 0 && unit_type == 0 &&
                unit_block == 0 && multipro_id == 0) {
                toastr.warning("please select any option.");
                $('.preloader').fadeOut();
                return false;
            }

            var data = {
                'multipro_id': multipro_id,
                'unit': unit,
                'customer': customer,
                'dealer': dealer,
                'status': status,
                'unit_size': unit_size,
                'unit_type': unit_type,
                'unit_block': unit_block
            };
            $.get('/statement/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });




        function openSmsModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_sms_modal', data, function(data) {
                document.getElementById('exampleModal').innerHTML = data;
                $('#exampleModal').modal();
            });
        }

        function openReminderModal(property_id) {

            var data = {
                'property_id': property_id
            };
            $.get('/update_reminder_modal', data, function(data) {
                document.getElementById('exampleModal1').innerHTML = data;
                $('#exampleModal1').modal();
            });
        }
    }
    callItBack();


        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('<?php echo e(route('statement.all')); ?>', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();

                $('.chosen-select').chosen('destroy');

                document.getElementById('updatecontent').innerHTML = data;
                $('.chosen-select').trigger('chosen:updated');
                callItBack();
                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': false,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views/statement/index.blade.php ENDPATH**/ ?>