

<?php $__env->startSection('title'); ?>
    All NOCs
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <ol class="breadcrumb pull-right">
        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All NOCs</li>
    </ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">
                        <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'create-noc')): ?>
                            <a href="<?php echo e(route('noc_add')); ?>" class="btn  btn-primary">
                                <i class="fa fa-plus-square"></i>&nbsp; Apply for NOC
                            </a>
                        <?php endif; ?>

                    </div>
                    <h3 class="box-title">All NOCs</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Project</th>
                                    <th>NOC No.</th>
                                    <th>Customer Name</th>
                                    <th>Unit No.</th>
                                    <th>Status</th>
                                    <th>NOC Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'view-noc')): ?>
                                    <?php $view_noc = true; ?>
                                <?php else: ?>
                                    <?php $view_noc = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'edit-noc')): ?>
                                    <?php $edit_noc = true; ?>
                                <?php else: ?>
                                    <?php $edit_noc = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'delete-noc')): ?>
                                    <?php $delete_noc = true; ?>
                                <?php else: ?>
                                    <?php $delete_noc = false; ?>
                                <?php endif; ?>

                                <?php if (\Illuminate\Support\Facades\Blade::check('permission', 'download-noc')): ?>
                                    <?php $download_noc = true; ?>
                                <?php else: ?>
                                    <?php $download_noc = false; ?>
                                <?php endif; ?>


                                <?php $__currentLoopData = $allnocs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($count++); ?></td>
                                        <td>
                                            <?php if($t->unitNumber): ?>
                             <?php if($t->unitNumber->multiProject): ?>
                             <?php echo e($t->unitNumber->multiProject->name); ?>

                             <?php else: ?>
                             None
                            <?php endif; ?>
                           
                          <?php endif; ?>
                                        </td>
                                        <td><?php echo e($t->noc_no); ?></td>
                                        <td><?php echo e($t->customer ? $t->customer->name : ''); ?></td>

                                        <td><?php echo e($t->unitNumber ? $t->unitNumber->unit_number : '--'); ?></td>
                                        <?php if($t->status == 0): ?>
                                            <td><span class="label label-primary"
                                                style="background-color:#4871c6;">Pending</span></td>
                                        <?php elseif($t->status == 1): ?>
                                            <td><span class="label label-success">Approved</span></td>
                                        <?php elseif($t->status == 2): ?>
                                            <td><span class="label label-success"
                                                    style="background-color: #DE0D0D">Expired</span></td>
                                                    <?php elseif($t->status == 3): ?>
                                                    <td><span class="label label-success"
                                                        style="background-color:#cd703d;;">Transferred</span></td>
                                                <?php endif; ?>
                                                



                                        <td><?php echo e($t->noc_date); ?></td>

                                        <td class="text-nowrap">
                                            <!-- <?php if($view_noc): ?>
    <a href="#"
                                                            data-toggle="tooltip" data-original-title="View"> <i
                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
    <?php endif; ?> -->


                                            <?php if($edit_noc): ?>
                                                <a href="<?php echo e(route('noc.edit', [$t->id])); ?>" data-toggle="tooltip"
                                                    datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            <?php endif; ?>


                                            <?php if($delete_noc): ?>
                                                <form action="<?php echo e(route('noc.delete', [$t->id])); ?>" method="post"
                                                    style='display: inline;'>
                                                    <?php echo method_field('delete'); ?>

                                                    <?php echo csrf_field(); ?>



                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="delete" data-toggle="confirmation"
                                                        data-title="Are you sure to delete?">
                                                        <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>


                                            <?php if($download_noc): ?>
                                                <?php if($t->status != 2): ?>
                                                    <a target="_blank" href="<?php echo e(route('noc.download', [$t->id])); ?>"
                                                        data-toggle="tooltip" data-original-title="Issue NOC">
                                                        <i class="fa fa-download text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($download_noc): ?>
                                                <?php if($t->status == 1): ?>
                                                    <a target="_blank" href="<?php echo e(route('noc.approvedownload', [$t->id])); ?>"
                                                        data-toggle="tooltip" data-original-title="Approved NOC">
                                                        <i class="fa fa-arrow-circle-down"
                                                            aria-hidden="true"></i>&nbsp;&nbsp;</a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        $(function() {
            $('#myTable').DataTable();

            var table = $('#example').DataTable({
                "columnDefs": [{
                    "visible": false,
                    "targets": 2
                }],
                "order": [
                    [2, 'asc']
                ],
                "displayLength": 25,
                "drawCallback": function(settings) {
                    var api = this.api();
                    var rows = api.rows({
                        page: 'current'
                    }).nodes();
                    var last = null;
                    api.column(2, {
                        page: 'current'
                    }).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before(
                                '<tr class="group"><td colspan="5">' + group +
                                '</td></tr>');
                            last = group;
                        }
                    });
                }
            });
            // Order by the grouping
            $('#example tbody').on('click', 'tr.group', function() {
                var currentOrder = table.order()[0];
                if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                    table.order([2, 'desc']).draw();
                } else {
                    table.order([2, 'asc']).draw();
                }
            });
        });
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\erpv7\resources\views//noc/index.blade.php ENDPATH**/ ?>